/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.tilecodec;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import com.sun.image.codec.jpeg.JPEGQTable;
import com.sun.media.jai.tilecodec.JaiI18N;
import com.sun.media.jai.tilecodec.TileCodecUtils;
import java.awt.Point;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import javax.media.jai.ParameterListDescriptor;
import javax.media.jai.tilecodec.TileCodecDescriptor;
import javax.media.jai.tilecodec.TileCodecParameterList;
import javax.media.jai.tilecodec.TileEncoderImpl;
import sun.awt.image.codec.JPEGParam;

public class JPEGTileEncoder
extends TileEncoderImpl {
    private TileCodecDescriptor tcd = TileCodecUtils.getTileCodecDescriptor("tileEncoder", "jpeg");

    public JPEGTileEncoder(OutputStream outputStream, TileCodecParameterList tileCodecParameterList) {
        super("jpeg", outputStream, tileCodecParameterList);
    }

    public void encode(Raster raster) throws IOException {
        if (raster == null) {
            throw new IllegalArgumentException(JaiI18N.getString("TileEncoder1"));
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        SampleModel sampleModel = raster.getSampleModel();
        JPEGEncodeParam jPEGEncodeParam = this.convertToJ2DJPEGEncodeParam(this.paramList, sampleModel);
        ((JPEGParam)jPEGEncodeParam).setWidth(raster.getWidth());
        ((JPEGParam)jPEGEncodeParam).setHeight(raster.getHeight());
        JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)byteArrayOutputStream, (JPEGEncodeParam)jPEGEncodeParam);
        jPEGImageEncoder.encode(raster);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.outputStream);
        objectOutputStream.writeFloat(this.paramList.getFloatParameter("quality"));
        objectOutputStream.writeBoolean(this.paramList.getBooleanParameter("qualitySet"));
        objectOutputStream.writeObject(TileCodecUtils.serializeSampleModel(sampleModel));
        Point point = new Point(raster.getMinX(), raster.getMinY());
        objectOutputStream.writeObject(point);
        objectOutputStream.writeObject(byArray);
        objectOutputStream.close();
    }

    private JPEGEncodeParam convertToJ2DJPEGEncodeParam(TileCodecParameterList tileCodecParameterList, SampleModel sampleModel) {
        int n;
        if (sampleModel == null) {
            return null;
        }
        int n2 = sampleModel.getNumBands();
        JPEGParam jPEGParam = this.createDefaultJ2DJPEGEncodeParam(n2);
        int[] nArray = (int[])tileCodecParameterList.getObjectParameter("horizontalSubsampling");
        int[] nArray2 = (int[])tileCodecParameterList.getObjectParameter("verticalSubsampling");
        int[] nArray3 = (int[])tileCodecParameterList.getObjectParameter("quantizationTableMapping");
        for (n = 0; n < n2; ++n) {
            jPEGParam.setHorizontalSubsampling(n, nArray[n]);
            jPEGParam.setVerticalSubsampling(n, nArray2[n]);
            int[] nArray4 = (int[])tileCodecParameterList.getObjectParameter("quantizationTable" + n);
            if (nArray4 == null || !nArray4.equals(ParameterListDescriptor.NO_PARAMETER_DEFAULT)) continue;
            jPEGParam.setQTableComponentMapping(n, nArray3[n]);
            jPEGParam.setQTable(nArray3[n], new JPEGQTable(nArray4));
        }
        if (tileCodecParameterList.getBooleanParameter("qualitySet")) {
            float f = tileCodecParameterList.getFloatParameter("quality");
            jPEGParam.setQuality(f, true);
        }
        n = tileCodecParameterList.getIntParameter("restartInterval");
        jPEGParam.setRestartInterval(n);
        jPEGParam.setImageInfoValid(tileCodecParameterList.getBooleanParameter("writeImageInfo"));
        jPEGParam.setTableInfoValid(tileCodecParameterList.getBooleanParameter("writeTableInfo"));
        if (tileCodecParameterList.getBooleanParameter("writeJFIFHeader")) {
            jPEGParam.setMarkerData(224, (byte[][])null);
        }
        return jPEGParam;
    }

    private JPEGParam createDefaultJ2DJPEGEncodeParam(int n) {
        if (n == 1) {
            return new JPEGParam(1, 1);
        }
        if (n == 3) {
            return new JPEGParam(3, 3);
        }
        if (n == 4) {
            return new JPEGParam(4, 4);
        }
        return null;
    }
}

