/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jackson;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.cfg.AnnotationBundleKey;
import com.fasterxml.jackson.jaxrs.cfg.EndpointConfigBase;
import com.fasterxml.jackson.jaxrs.cfg.ObjectWriterInjector;
import com.fasterxml.jackson.jaxrs.cfg.ObjectWriterModifier;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import com.fasterxml.jackson.jaxrs.json.JsonEndpointConfig;
import com.fasterxml.jackson.jaxrs.util.ClassKey;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.annotations.providers.NoJackson;
import org.jboss.resteasy.annotations.providers.jackson.Formatted;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.util.DelegatingOutputStream;
import org.jboss.resteasy.util.FindAnnotation;

@Provider
@Consumes(value={"application/json", "application/*+json", "text/json"})
@Produces(value={"application/json", "application/*+json", "text/json"})
public class ResteasyJackson2Provider
extends JacksonJaxbJsonProvider {
    protected final ConcurrentHashMap<ClassAnnotationKey, JsonEndpointConfig> _readers = new ConcurrentHashMap();
    protected final ConcurrentHashMap<ClassAnnotationKey, JsonEndpointConfig> _writers = new ConcurrentHashMap();

    public boolean isReadable(Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        if (FindAnnotation.findAnnotation(aClass, (Annotation[])annotations, NoJackson.class) != null) {
            return false;
        }
        return super.isReadable(aClass, type, annotations, mediaType);
    }

    public boolean isWriteable(Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        if (FindAnnotation.findAnnotation(aClass, (Annotation[])annotations, NoJackson.class) != null) {
            return false;
        }
        return super.isWriteable(aClass, type, annotations, mediaType);
    }

    public Object readFrom(Class<Object> type, final Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        ObjectReader reader;
        JsonParser jp;
        LogMessages.LOGGER.debugf("Provider : %s,  Method : readFrom", (Object)((Object)((Object)this)).getClass().getName());
        ClassAnnotationKey key = new ClassAnnotationKey(type, annotations);
        JsonEndpointConfig endpoint = this._readers.get(key);
        if (endpoint == null) {
            ObjectMapper mapper = this.locateMapper(type, mediaType);
            endpoint = (JsonEndpointConfig)this._configForReading(mapper, annotations, null);
            this._readers.put(key, endpoint);
        }
        if ((jp = this._createParser(reader = endpoint.getReader(), entityStream)) == null || jp.nextToken() == null) {
            return null;
        }
        if (type == JsonParser.class) {
            return jp;
        }
        Object result = null;
        try {
            result = System.getSecurityManager() == null ? reader.withType(genericType).readValue(jp) : AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return reader.withType(genericType).readValue(jp);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new IOException(pae);
        }
        return result;
    }

    public void writeTo(Object value, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        LogMessages.LOGGER.debugf("Provider : %s,  Method : writeTo", (Object)((Object)((Object)this)).getClass().getName());
        entityStream = new DelegatingOutputStream(entityStream){

            public void flush() throws IOException {
            }
        };
        ClassAnnotationKey key = new ClassAnnotationKey(type, annotations);
        JsonEndpointConfig endpoint = this._writers.get(key);
        if (endpoint == null) {
            ObjectMapper mapper = this.locateMapper(type, mediaType);
            endpoint = (JsonEndpointConfig)this._configForWriting(mapper, annotations, null);
            this._writers.put(key, endpoint);
        }
        ObjectWriter writer = endpoint.getWriter();
        boolean withIndentOutput = false;
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                if (!annotation.annotationType().equals(Formatted.class)) continue;
                withIndentOutput = true;
                break;
            }
        }
        JsonEncoding enc = this.findEncoding(mediaType, httpHeaders);
        final JsonGenerator jg = writer.getFactory().createGenerator(entityStream, enc);
        jg.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        try {
            if (writer.isEnabled(SerializationFeature.INDENT_OUTPUT) || withIndentOutput) {
                jg.useDefaultPrettyPrinter();
            }
            JavaType rootType = null;
            if (genericType != null && value != null && genericType.getClass() != Class.class && (rootType = writer.getTypeFactory().constructType(genericType)).getRawClass() == Object.class) {
                rootType = null;
            }
            if (rootType != null) {
                writer = writer.withType(rootType);
            }
            value = endpoint.modifyBeforeWrite(value);
            ObjectWriterModifier mod = ObjectWriterInjector.getAndClear();
            if (mod != null) {
                writer = mod.modify((EndpointConfigBase)endpoint, httpHeaders, value, writer, jg);
            }
            if (System.getSecurityManager() == null) {
                writer.writeValue(jg, value);
            } else {
                final ObjectWriter smWriter = writer;
                final Object smValue = value;
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        smWriter.writeValue(jg, smValue);
                        return null;
                    }
                });
            }
        }
        catch (PrivilegedActionException pae) {
            throw new IOException(pae);
        }
        finally {
            jg.close();
        }
    }

    private static class ClassAnnotationKey {
        private AnnotationBundleKey annotations;
        private ClassKey classKey;
        private int hash;

        private ClassAnnotationKey(Class<?> clazz, Annotation[] annotations) {
            this.annotations = new AnnotationBundleKey(annotations, AnnotationBundleKey.class);
            this.classKey = new ClassKey(clazz);
            this.hash = this.annotations.hashCode();
            this.hash = 31 * this.hash + this.classKey.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassAnnotationKey that = (ClassAnnotationKey)o;
            if (!this.annotations.equals((Object)that.annotations)) {
                return false;
            }
            return this.classKey.equals((Object)that.classKey);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

