/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.common;

import java.awt.color.ColorSpace;

public final class InvertedCMYKColorSpace
extends ColorSpace {
    private static ColorSpace theInstance = null;
    private ColorSpace csRGB = ColorSpace.getInstance(1004);
    private static final double power1 = 0.4166666666666667;

    public static final synchronized ColorSpace getInstance() {
        if (theInstance == null) {
            theInstance = new InvertedCMYKColorSpace();
        }
        return theInstance;
    }

    private InvertedCMYKColorSpace() {
        super(9, 4);
    }

    public boolean equals(Object object) {
        return object != null && object instanceof InvertedCMYKColorSpace;
    }

    @Override
    public float[] toRGB(float[] fArray) {
        float f2 = fArray[0];
        float f3 = fArray[1];
        float f4 = fArray[2];
        float f5 = fArray[3];
        float[] fArray2 = new float[]{f5 * f2, f5 * f3, f5 * f4};
        for (int i = 0; i < 3; ++i) {
            float f6 = fArray2[i];
            if (f6 < 0.0f) {
                f6 = 0.0f;
            }
            if (f6 < 0.0031308f) {
                fArray2[i] = 12.92f * f6;
                continue;
            }
            if (f6 > 1.0f) {
                f6 = 1.0f;
            }
            fArray2[i] = (float)(1.055 * Math.pow(f6, 0.4166666666666667) - 0.055);
        }
        return fArray2;
    }

    @Override
    public float[] fromRGB(float[] fArray) {
        for (int i = 0; i < 3; ++i) {
            if (fArray[i] < 0.040449936f) {
                int n = i;
                fArray[n] = fArray[n] / 12.92f;
                continue;
            }
            fArray[i] = (float)Math.pow(((double)fArray[i] + 0.055) / 1.055, 2.4);
        }
        float f2 = fArray[0];
        float f3 = fArray[1];
        float f4 = fArray[2];
        float f5 = Math.max(f2, Math.max(f3, f4));
        if (f5 != 0.0f) {
            f2 /= f5;
            f3 /= f5;
            f4 /= f5;
        } else {
            f4 = 1.0f;
            f3 = 1.0f;
            f2 = 1.0f;
        }
        return new float[]{f2, f3, f4, f5};
    }

    @Override
    public float[] toCIEXYZ(float[] fArray) {
        return this.csRGB.toCIEXYZ(this.toRGB(fArray));
    }

    @Override
    public float[] fromCIEXYZ(float[] fArray) {
        return this.fromRGB(this.csRGB.fromCIEXYZ(fArray));
    }
}

