/*!
 * FSI Image Flow
 * Build: 18.05.17.1
 * 
 * Copyright (c) 2018 NeptuneLabs GmbH - All rights reserved.
 *
 * info@neptunelabs.com
 * www.neptunelabs.com
 * 
 * IMPORTANT NOTE
 * ------------------------------------------------------
 * Usage limited to the terms of the NeptuneLabs Software 
 * END-USER LICENSE AGREEMENT.
 * ------------------------------------------------------
 *
 */

"use strict";
(function($FSI,undefined){if($FSI.defined!=undefined){return}$FSI.defined=true;if(typeof(console.error)!="function"){$FSI.console={};$FSI.console.log=$FSI.fnDoNothing;$FSI.console.warn=$FSI.fnDoNothing;$FSI.console.error=$FSI.fnDoNothing;$FSI.console.dir=$FSI.fnDoNothing;$FSI.console.info=$FSI.fnDoNothing}else{$FSI.console=console}$FSI.oSupportedViewers={};try{if(typeof(top.window.alert)=="function"){$FSI.topWindow=top.window}else{$FSI.topWindow=window}}catch(e){$FSI.console.warn("FSI: top.window is not accessible. This is likely due to cross domain security restrictions. Viewer functionality might be limited.");$FSI.topWindow=window}$FSI.oInstanceCreated={};$FSI.ClassDef=function(instance,strClassName,oOptions){var version=oOptions.strVersion;var build=oOptions.strBuild;var self=this;this.instance=instance;this.strClassName=strClassName;this.strConfigSection=oOptions.strConfigSection;this.version=version;this.build=build;this.traceConfigValue=function(strParam){var parameters=(typeof(instance.getParameters)==="function")?instance.getParameters():undefined;var tmpCfg=new $FSI.Config(null,null,{strSection:self.strConfigSection});return tmpCfg.traceConfigValue(strParam,parameters)};instance.traceConfigValue=this.traceConfigValue;this.printAPI=function(){if(!self.oAPI){return}var line="------------------------------";line+=line+line;line="\r\n"+line+"\r\n";var toArray=function(obj){var ret=[];if(obj){for(var o in obj){var itm=obj[o];if(typeof(itm)!=="object"){itm={val:itm}}itm.nam=o;ret.push(itm)}}return ret};var outputData=function(obj,strTitle,strReturn,bArgs,objCompare){var i,arOut,strResult,strType,itm;var out="";var nNotAvailable=0;var args="";if(!obj){return}var ar=toArray(obj);if(ar.length>0){arOut=[];if(fnGroup){fnGroupCollapsed(strTitle.replace(/^API /,""))}else{out+="\r\n"+strTitle+" of "+strVersionString+line}for(i=0;i<ar.length;i++){if(bArgs){if(ar[i].a==undefined){ar[i].a="void"}args="( "+ar[i].a+" )"}strResult=(ar[i].r==undefined)?"":strReturn+ar[i].r;strType=(ar[i].t==undefined)?"":" ("+ar[i].t+")";itm=ar[i].nam+args+strResult+strType;if(objCompare&&objCompare[ar[i].nam]==undefined){nNotAvailable++;itm+=" [x]"}arOut.push(itm)}out+=arOut.join("\r\n");if(nNotAvailable>0){out+="\r\n\r\nPLEASE NOTE: items marked with [x] are not available with the current configuration options"}$FSI.console.log(out);if(fnGroup!=undefined){console.groupEnd()}}};var fnGroup,fnGroupCollapsed;if(!$FSI.isInternetExplorer&&typeof(console.group)=="function"){fnGroup=console.group;if(typeof(console.groupCollapsed)=="function"){fnGroupCollapsed=console.groupCollapsed}else{console.groupCollapsed=fnGroup}}if(fnGroup!=undefined){fnGroup("API of "+strVersionString)}outputData(self.oAPI.oMethods,"API Methods"," // RETURNS: ",true);outputData(self.oAPI.oProperties,"API Properties","","");outputData(self.oAPI.oCallbacks,"API Listeners"," // RETURN: ",true);var oActiveButtons=(typeof(self.oAPI.getActiveMenuButtons)=="function")?self.oAPI.getActiveMenuButtons():undefined;outputData(self.oAPI.oMenuCommands,"Button IDs","",false,oActiveButtons);if(fnGroup!=undefined){console.groupEnd()}};instance.printAPI=this.printAPI;this.testAPIListenersStart=function(){if(!instance.addListener||instance._TestAPIListeners){return}var strInstance=instance.getInstanceName();instance._TestAPIListeners={};for(var listenerName in self.oAPI.oCallbacks){instance._TestAPIListeners[listenerName]={};instance._TestAPIListeners[listenerName].listenerName=listenerName;instance._TestAPIListeners[listenerName].fn=function(){$FSI.console.log(strInstance+" called listener ["+this.listenerName+"]",arguments)};instance.addListener(listenerName,instance._TestAPIListeners[listenerName].fn,instance._TestAPIListeners[listenerName])}};this.testAPIListenersStop=function(){if(!instance.removeListener||!instance._TestAPIListeners){return}for(var listenerName in self.oAPI.oCallbacks){instance.removeListener(listenerName,instance._TestAPIListeners[listenerName].fn)}instance._TestAPIListeners=undefined;delete instance._TestAPIListeners};if(oOptions.bHasListeners){instance.testAPIListenersStart=this.testAPIListenersStart;instance.testAPIListenersStop=this.testAPIListenersStop}var strVersionString=strClassName+" "+version+" build "+build;var getVersion=function(){return strVersionString};var getBuild=function(){return build};instance.getVersion=getVersion;instance.getBuild=getBuild;if(!$FSI.oInstanceCreated[strClassName]){$FSI.oInstanceCreated[strClassName]=true;if(instance.getBuild()!=$FSI.getBuild()){$FSI.console.error("FSI version mismatch: "+getVersion()+" and "+$FSI.getVersion())}}};var oClassOptions={strVersion:"2018",strBuild:"18.05.17.1"};var classDef=new $FSI.ClassDef($FSI,"FSI Core",oClassOptions);$FSI.SVGNameSpaceURL="http://www.w3.org/2000/svg";$FSI.regexPlusToSpace=/\+/g;$FSI.regExServerRenderer=/([?&])(renderer|profile)=([^&]*)/i;$FSI.nViewerInstanceID=0;$FSI.bHTTPS=(document.location.protocol=="https:");$FSI.getViewerInstanceID=function(){return ++$FSI.nViewerInstanceID};$FSI.BoolTable={"0":false,"false":false,"1":true,"true":true};$FSI.makeBool=function(value,def){var ret;var t=typeof(value);if(t==="boolean"){ret=value}else{if(t==="string"){value=value.toLowerCase()}ret=$FSI.BoolTable[value];if(ret==undefined){ret=def}}return ret};$FSI.changeRendererInURL=function(url,strRenderer){url=url.replace($FSI.regExServerRenderer,"$1renderer="+strRenderer);return url};$FSI.loadSkinCSS=function(skinName,scope,fnReady,nPriority,arDependencies){if(typeof($FSI.iLoaderCSSSkin)!=="object"){if(typeof($FSI.LoaderCSSSkin)!=="function"){$FSI.console.error("Class $FSI.LoaderCSSSkin missing.");fnReady.call(scope,false);return}$FSI.iLoaderCSSSkin=new $FSI.LoaderCSSSkin()}return $FSI.iLoaderCSSSkin.load(skinName,scope,fnReady,nPriority,arDependencies)};$FSI.addedCSSBlocks={};$FSI.cssClassExists=function(cssID){return(typeof($FSI.addedCSSBlocks[cssID])!="undefined")};$FSI.addCSSClass=function(cssID,strCode){if($FSI.cssClassExists(cssID)){return false}var node=$FSI.addCSSNode(cssID);if(node){try{node.innerHTML=strCode;$FSI.addedCSSBlocks[cssID]=node}catch(e){$FSI.console.error("FSI: addCSSClass failed")}}};$FSI.addCSSNode=function(cssID){var node=null;try{node=document.createElement("style");node.setAttribute("x-generated-by","FSI");node.setAttribute("x-generated-for",cssID);node.setAttribute("x-fsi-priority","0");node.appendChild(document.createTextNode(""));if(document.head.firstChild){document.head.insertBefore(node,document.head.firstChild)}else{document.head.appendChild(node)}}catch(e){$FSI.console.error("FSI: FAILED to create style node for "+cssID);$FSI.console.error(e.message)}return node};$FSI.deleteInstanceCSSRules=function(iInstance){var ar=iInstance._arCSSLayoutSelectors;if(ar!=undefined&&ar.length>0){for(var i=0;i<ar.length;i++){$FSI.deleteCSSRule(ar[i])}iInstance._arCSSLayoutSelectors=[]}};$FSI.addInstanceCSSRule=function(iInstance,strSelector,strRule){if(iInstance._arCSSLayoutSelectors==undefined){iInstance._arCSSLayoutSelectors=[]}iInstance._arCSSLayoutSelectors.push(strSelector);$FSI.addCSSRule(strSelector,strRule,0)};$FSI.addCSSRule=function(selector,rules,index){if($FSI.oInsertedCSS==undefined){$FSI.oInsertedCSS=$FSI.addCSSNode("FSI.Core")}if($FSI.oInsertedCSS!=undefined){try{if($FSI.oInsertedCSS&&$FSI.oInsertedCSS.sheet){if("insertRule" in $FSI.oInsertedCSS.sheet){$FSI.oInsertedCSS.sheet.insertRule(selector+"{"+rules+"}",index)}else{if("addRule" in $FSI.oInsertedCSS.sheet){$FSI.oInsertedCSS.sheet.addRule(selector,rules,index)}}}}catch(e){$FSI.console.error("FSI: FAILED to add css rule for "+selector);$FSI.console.error(e.message)}}};$FSI.deleteCSSRule=function(selector){var ret=false;if($FSI.oInsertedCSS!=undefined){try{var arDelete=[];var ar=$FSI.oInsertedCSS.sheet.cssRules;for(var i=0;i<ar.length;i++){var rule=ar[i];if(rule.selectorText==selector){arDelete.push(i)}}if(arDelete.length>0){for(var i=arDelete.length-1;i>-1;i--){$FSI.oInsertedCSS.sheet.deleteRule(arDelete[i])}ret=true}}catch(e){console.error(e.message);ret=false}}return ret};$FSI.setStyleAttr=function(el,strStyle){
/*@cc_on
		 @if (@_jscript_version < 9)
		 el.style.setAttribute('cssText', strStyle);
		 @else @*/
el.setAttribute("style",strStyle);
/*@end
		 @*/
};$FSI.rgbaHexToDecimal=function(str){var ret={};if(typeof(str)!=="string"){str=""}str=str.toLowerCase();str=str.replace(/[^0-9-a-f]/g,"F");if(str.length>8){str=str.substr(0,8)}else{var def="FFFFFFFF";str+=def.substr(0,8-str.length)}ret.hex=str;ret.redHex=str.substr(0,2);ret.greenHex=str.substr(2,2);ret.blueHex=str.substr(4,2);ret.alphaHex=str.substr(6,2);ret.red=parseInt(ret.redHex,16);ret.green=parseInt(ret.greenHex,16);ret.blue=parseInt(ret.blueHex,16);ret.alpha=parseInt(ret.alphaHex,16)/255;ret.strRGBA=ret.red+","+ret.green+","+ret.blue+","+ret.alpha;return ret};$FSI.documentDomain=document.location.hostname;$FSI.regCors=new RegExp("//"+$FSI.documentDomain+"[:/]");$FSI.isCrossDomain=function(url){if(!url||url.indexOf("http")!==0){return false}return url.match($FSI.regCors)==null};$FSI.loadImageCors=function(img,url){if($FSI.isCrossDomain(url)){img.crossOrigin="";img.src=url}else{img.src=url}};$FSI.getSVGID=function(){return"$FSI.SVGID_"+$FSI.SVGID++};$FSI.BrowserSupports={};$FSI.BrowserSupports[false]=function(){return false};$FSI.BrowserSupports[true]=function(){return true};$FSI.osVersion=[0,0,0];$FSI.SVGID=0;$FSI.initialWindowWidth=window.innerWidth;$FSI.bElementPosRespectsScroll=true;$FSI.oSupportedEvents={};$FSI.isEventSupported=function(eventName){if($FSI.oSupportedEvents[eventName]!=undefined){return $FSI.oSupportedEvents[eventName]}var el=document.createElement("div");var eventNameOn="on"+eventName;var isSupported=(eventNameOn in el);if(!isSupported){el.setAttribute(eventNameOn,"return;");isSupported=typeof el[eventNameOn]==="function"}el=null;$FSI.oSupportedEvents[eventName]=isSupported;return isSupported};var lastTime=0;var vendors=["ms","moz","webkit","o"];for(var x=0;x<vendors.length&&!window.requestAnimationFrame;++x){window.requestAnimationFrame=window[vendors[x]+"RequestAnimationFrame"];window.cancelAnimationFrame=window[vendors[x]+"CancelAnimationFrame"]||window[vendors[x]+"CancelRequestAnimationFrame"]}if(!window.requestAnimationFrame||!window.cancelAnimationFrame){window.requestAnimationFrame=function(callback,element){var currTime=new Date().getTime();var timeToCall=Math.max(0,16-(currTime-lastTime));var id=window.setTimeout(function(){callback(currTime+timeToCall)},timeToCall);lastTime=currTime+timeToCall;return id};window.cancelAnimationFrame=function(id){clearTimeout(id)}}$FSI.userAgent=navigator.userAgent.toLowerCase();var uagent=$FSI.userAgent;var result,t,i;if(uagent.search(/iphone|ipad|ipod|android|symbian|mobile|phone|windows ce|opera mini|opera mobi/i)>-1){result=true;if(uagent.search("android")>-1){$FSI.mobileOS="android";$FSI.isTouch=true;$FSI.noMouse=true;t=uagent.match(/android (\S*)/);if(t&&t.length>1){t=t[1].split(".");for(i=0;i<t.length;i++){t[i]=parseInt(t[i])}$FSI.osVersion=[].concat(t)}}else{if(uagent.indexOf("mac os")!==-1){$FSI.mobileOS="ios";$FSI.isTouch=true;$FSI.noMouse=true;t=uagent.match(/ os (\S*)/);if(t&&t.length>1){t=t[1].split("_");for(i=0;i<t.length;i++){t[i]=parseInt(t[i])}$FSI.osVersion=[].concat(t)}}}}else{result=false}$FSI.isMobileDevice=result;$FSI.isSmallMobileDevice=(uagent.search(/iphone|ipod|phone|mobile safari|iemobile|opera mini|opera mobi/i)>-1);$FSI.isInternetExplorer=false;$FSI.versionInternetExplorer=0;$FSI.isIETouch=false;if(uagent.search("msie")>-1){$FSI.isInternetExplorer=true;var t=uagent.match(/msie ([^;]*)/);if(t&&t.length>1){$FSI.versionInternetExplorer=parseFloat(t[1])}}else{if(navigator.userAgent.match(/Trident.*rv:(\d+\.)/gi)){$FSI.isInternetExplorer=true;$FSI.versionInternetExplorer=parseFloat(RegExp.$1)}else{$FSI.isInternetExplorer=(typeof(window.onmsgestureend)!=="undefined");$FSI.versionInternetExplorer=12}}if(window.navigator.msPointerEnabled){$FSI.isIETouch=(window.navigator.msMaxTouchPoints>1)}if($FSI.isIETouch){$FSI.bElementPosRespectsScroll=false}if(!$FSI.isTouch){$FSI.isTouch=(window.navigator.maxTouchPoints>1||window.navigator.msMaxTouchPoints>1)}if(uagent.search("chrome")!==-1&&uagent.search("edge")===-1){$FSI.isChrome=true}else{if(uagent.search("safari")!==-1){$FSI.isSafari=true}else{if(uagent.search("firefox")!==-1){$FSI.isFirefox=true}else{if(uagent.search("opera")!==-1){$FSI.isOpera=true}}}}if(uagent.search("mac os")>-1){$FSI.isMac=true}if(typeof(window.pageYOffset)==="number"){$FSI.getDocumentScroll=function(wnd){return{x:wnd.pageXOffset,y:wnd.pageYOffset}}}else{if(document.body&&(document.body.scrollLeft||document.body.scrollTop)){$FSI.getDocumentScroll=function(wnd){return{x:wnd.document.body.scrollLeft,y:wnd.document.body.scrollTop}}}else{if(document.documentElement&&(document.documentElement.scrollLeft||document.documentElement.scrollTop)){$FSI.getDocumentScroll=function(wnd){return{x:wnd.document.documentElement.scrollLeft,y:wnd.document.documentElement.scrollTop}}}}}$FSI.getDocumentScaleNone=function(){return 1};$FSI.__getMediaMinScreenWidthCount=0;$FSI.__getMediaMinScreenWidthLoopCount=0;$FSI.oMatchMedia=$FSI.topWindow.matchMedia||$FSI.topWindow.msMatchMedia;$FSI.getMediaMinScreenWidth=function(nam,unit){var init=$FSI.topWindow.document.documentElement.clientWidth;if($FSI.__LastGetMediaMinScreenWidth==$FSI.topWindow.document.documentElement.clientWidth){return $FSI.__LastGetMediaMinScreenWidthResult}$FSI.__LastGetMediaMinScreenWidth=$FSI.topWindow.document.documentElement.clientWidth;$FSI.__getMediaMinScreenWidthCount++;var step=10;var pre="("+nam+":";var suf=unit+")";while($FSI.oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){$FSI.__getMediaMinScreenWidthLoopCount++}init-=step;step=5;while($FSI.oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){$FSI.__getMediaMinScreenWidthLoopCount++}init-=step;step=1;while($FSI.oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){$FSI.__getMediaMinScreenWidthLoopCount++}$FSI.__LastGetMediaMinScreenWidthResult=$FSI.__getDocumentScaleReferenceWidth=init-step;return $FSI.__LastGetMediaMinScreenWidthResult};$FSI.getDocumentScaleInit=function(){$FSI.getDocumentScale=$FSI.getDocumentScaleNone;if($FSI.BrowserSupports.visualViewportAPI()){$FSI.documentScaleMethod="visualViewport API";$FSI.getDocumentScale=function(){return window.visualViewport.scale};return $FSI.getDocumentScale()}if($FSI.topWindow.innerWidth==undefined){$FSI.documentScaleMethod="none";return $FSI.getDocumentScale()}if($FSI.isInternetExplorer&&$FSI.isMobileDevice){$FSI.documentScaleMethod="window.outerWidth / window.innerWidth windows mobile";$FSI.getDocumentScale=function(){if(screen.width!=$FSI.topWindow.outerWidth){return($FSI.topWindow.outerWidth-192)/$FSI.topWindow.innerWidth}return($FSI.topWindow.outerWidth-83)/$FSI.topWindow.innerWidth};return $FSI.getDocumentScale()}if(window.orientation!=undefined){if(!window.outerWidth){$FSI.documentScaleMethod="screen.width / window.innerWidth iOS";$FSI.getDocumentScale=function(){$FSI.__getDocumentScaleReferenceWidth=(window.orientation%180===0)?screen.width:screen.height;return $FSI.__getDocumentScaleReferenceWidth/window.innerWidth};return $FSI.getDocumentScale()}$FSI.documentScaleMethod="window.outerWidth / window.innerWidth";$FSI.getDocumentScale=function(){return window.outerWidth/window.innerWidth};return $FSI.getDocumentScale()}if($FSI.oMatchMedia&&$FSI.topWindow.document.documentElement.clientWidth>0){var w=$FSI.getMediaMinScreenWidth("min-width","px");if(!isNaN(w)){$FSI.documentScaleMethod="CSS Media Query";$FSI.getDocumentScale=function(){var res=$FSI.getMediaMinScreenWidth("min-width","px")/$FSI.topWindow.innerWidth;if(isNaN(res)){res=1}return res};return $FSI.getDocumentScale()}}$FSI.documentScaleMethod="fallback";$FSI.getDocumentScale=function(){return $FSI.topWindow.outerWidth/$FSI.topWindow.innerWidth};return $FSI.getDocumentScale()};$FSI.getDocumentScale=$FSI.getDocumentScaleInit;if(typeof(window.devicePixelRatio)!=="undefined"){$FSI.getDevicePixelRatio=function(){return window.devicePixelRatio||1}}else{$FSI.getDevicePixelRatio=function(){return 1}}$FSI.getDocumentScaleWithPixelRatio=function(){return $FSI.getDocumentScale()*$FSI.getDevicePixelRatio()};$FSI.fnDoNothing=function(){};$FSI.preventDefaultEvent=function(evt){if(evt.preventDefault){evt.preventDefault()}evt.returnValue=false;return false};$FSI.getVisualViewportSize=function(){var ret={};if(window.visualViewport){ret.width=window.visualViewport.width;ret.height=window.visualViewport.height}else{ret.width=window.innerWidth;ret.height=window.innerHeight}return ret};$FSI.getElementDimension=function(elem){return{width:elem.offsetWidth,height:elem.offsetHeight}};$FSI.getElementInnerDimension=function(elem){var ret={width:elem.clientWidth,height:elem.clientHeight};var padding=$FSI.getElementPaddings(elem);ret.width-=padding.left+padding.right;ret.height-=padding.top+padding.bottom;return ret};$FSI.getViewportSize=function(wnd){var ret;if($FSI.BrowserSupports.visualViewportAPI()){ret={width:wnd.visualViewport.width,height:wnd.visualViewport.height}}else{ret={width:wnd.innerWidth,height:wnd.innerHeight}}return ret};$FSI.mergeObjects=function(o1,o2){for(var o in o2){o1[o]=o2[o]}return o1};$FSI.cloneArray=function(ar){if(ar==undefined||ar.length==undefined){return[]}return ar.concat([])};$FSI.cloneArrayRecursive=function(ar){if(ar==undefined||ar.length==undefined){return[]}var ret=ar.concat([]);for(var i=0;i<ar.length;i++){ar[i]=$FSI.cloneValue(ar[i])}return ret};$FSI.cloneValue=function(val){var ret;switch(typeof(val)){case"object":if(val!=null&&typeof(val.cloneNode)==="function"){ret=val}else{if(val!=null&&typeof(val.push)==="function"){ret=$FSI.cloneArrayRecursive(val)}else{ret=$FSI.cloneObject(val)}}break;default:ret=val}return ret};$FSI.cloneObject=function(obj){if(obj==null){return null}var ret={};if(typeof(obj)=="object"&&typeof(obj.push)==="function"){ret=$FSI.cloneArrayRecursive(obj)}else{for(var o in obj){ret[o]=$FSI.cloneValue(obj[o])}}return ret};$FSI.cloneParameters=function(parameters){return $FSI.cloneObject(parameters)};$FSI.replaceChild=function(parent,existingChild,newChild){try{var elNext=existingChild.nextSibling;if(elNext){parent.removeChild(existingChild);parent.insertBefore(newChild,elNext)}else{parent.appendChild(newChild)}}catch(e){$FSI.console.error(e.message);$FSI.console.log(parent);$FSI.console.log(existingChild);$FSI.console.log(newChild)}};$FSI.removeChild=function(parent,child){try{parent.removeChild(child)}catch(e){$FSI.console.error(e.message);$FSI.console.log(parent);$FSI.console.log(child)}};$FSI.callbackFunctionID=0;$FSI.oCustomEventListenerClasses={};$FSI.oCustomEventListenerInstances={};$FSI.oCustomEventListeners={};$FSI.nCustomEventListeners=0;$FSI.nCustomEventListenerID=0;$FSI.addCustomEvent=function(myObj,myEvent,myFunc,bCapturingPhase){var obj,listenerID;var listener=$FSI.oCustomEventListenerInstances[myEvent];if(!listener){if(typeof($FSI.oCustomEventListenerClasses[myEvent])==="undefined"){$FSI.console.error("$FSI.oCustomEventListenerClass for '"+myEvent+"' is undefined.");return false}listener=$FSI.oCustomEventListenerInstances[myEvent]=new $FSI.oCustomEventListenerClasses[myEvent](myObj,myFunc)}obj=listener.addListener(myObj,myFunc);if(obj!=undefined){listenerID=obj.nCustomEventListenerID=$FSI.nCustomEventListenerID++;$FSI.oCustomEventListeners[obj.nCustomEventListenerID]=obj;$FSI.nCustomEventListeners++}else{$FSI.console.error("Failed to add custom event listener: "+myEvent)}return listenerID};$FSI.removeCustomEvent=function(myObj,myEvent,myFunc,bCapturingPhase){var listener=$FSI.oCustomEventListenerInstances[myEvent];if(!listener){return false}var obj=listener.removeListener(myObj,myFunc);if(obj&&$FSI.oCustomEventListeners[obj.nCustomEventListenerID]!=undefined){delete $FSI.oCustomEventListeners[obj.nCustomEventListenerID];$FSI.nCustomEventListeners--}else{$FSI.console.error("Failed to remove custom event listener")}};$FSI.setCustomEventListenerProperty=function(listenerID,nam,val){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.setListenerProps.call(obj.instanceListener,obj.uniqueID,nam,val)};$FSI.enableCustomEventListener=function(listenerID,bEnable){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.enableListener.call(obj.instanceListener,obj.uniqueID,bEnable)};$FSI.pauseCustomEventListener=function(listenerID,bPause){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.pauseListener.call(obj.instanceListener,obj.uniqueID,bPause)};$FSI.triggerCustomEvent=function(listenerID){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.triggerEvent.call(obj.instanceListener,obj.uniqueID)};$FSI.removeEvent=function(myObj,myEvent,myFunc,bCapturingPhase){if(window.removeEventListener&&myObj){if(bCapturingPhase==undefined){bCapturingPhase=true}myObj.removeEventListener(myEvent,myFunc,bCapturingPhase)}else{if(window.detachEvent&&myObj){myObj.detachEvent("on"+myEvent,myFunc)}}};$FSI.addEvent=function(myObj,myEvent,myFunc,bCapturingPhase){if(window.addEventListener&&myObj){if(bCapturingPhase==undefined){bCapturingPhase=true}myObj.addEventListener(myEvent,myFunc,bCapturingPhase)}else{if(window.attachEvent&&myObj){myObj.attachEvent("on"+myEvent,myFunc)}}};$FSI.getScriptTagByFileName=function(strScriptName){var tag,strSelector;if(typeof(document.querySelector)==="function"){strSelector="script[src$='"+strScriptName+"']";tag=document.querySelector(strSelector);if(!tag){strSelector="script[src*='"+strScriptName+"']";tag=document.querySelector(strSelector)}}if(!tag){var tmp=$FSI.escapeRegEx(strScriptName);var regEx=new RegExp("(^|/)"+tmp+"(\\s*|\\?.*)$");var scripts=document.getElementsByTagName("script");for(var i=0;i<scripts.length;i++){var src=scripts[i].src;if(src.match(regEx)){tag=scripts[i];break}}}return tag};$FSI.getScriptPath=function(strScriptName,depth){var src;depth++;var ret="";var tag=$FSI.getScriptTagByFileName(strScriptName);if(tag){src=tag.src.split("/");src.splice(src.length-depth,depth);ret=src.join("/")}return ret};$FSI.guessFSIViewerLocation=function(strScriptName,depth){if($FSI._FSIViewerLocation!=undefined){return $FSI._FSIViewerLocation}var ret=$FSI.getScriptPath(strScriptName,depth);if(ret){$FSI._FSIViewerLocation=ret}return ret};$FSI.createJavascriptLoader=function(){if(typeof($FSI.iLoaderJavascript)!=="object"){if(typeof($FSI.LoaderJavascript)!=="function"){$FSI.console.error("Class $FSI.LoaderJavascript missing.");return false}$FSI.iLoaderJavascript=new $FSI.LoaderJavascript()}return true};$FSI.loadJavascript=function(strScriptPath,idInstance,argScope,fnOnLoad,oPassThrough){if(!$FSI.createJavascriptLoader()){return false}return $FSI.iLoaderJavascript.load(strScriptPath,idInstance,argScope,fnOnLoad,oPassThrough)};$FSI.releaseLoadJavascript=function(strScriptPath,idInstance){if(!$FSI.createJavascriptLoader()){return false}return $FSI.iLoaderJavascript.release(strScriptPath,idInstance)};$FSI.customTags={};$FSI.bCustomTagsAdded=false;$FSI.customTagDimFromAttributes=function(el){var rpl=function(nam){var tmp=el.getAttribute(nam);if(typeof(tmp)==="string"&&tmp.length>0){if(!tmp.match(/[^0-9\s]/)){tmp+="px"}el.style[nam]=tmp}};rpl("width");rpl("height")};$FSI.setParameters=function(node,parameters){if(!node||typeof(node.tagName)!=="string"){return false}var t=typeof(parameters);if(t!=="object"&&t!=="function"){return false}node._fsi_parameters=parameters};$FSI.getParameters=function(node){if(!node||typeof(node.tagName)!=="string"){return false}return node._fsi_parameters};$FSI.initCustomNode=function(node){if($FSI.BrowserSupports.registerElement()){return true}if(!node||typeof(node.tagName)!=="string"){return false}var strTagName=node.tagName.toLowerCase();var oCustomTag=$FSI.customTags[strTagName];if(!oCustomTag||typeof(oCustomTag.replaceTag)!=="function"){return false}if(oCustomTag.replaceTagInit){oCustomTag.replaceTagInit();delete oCustomTag.replaceTagInit}oCustomTag.replaceTag(node);return true};$FSI.initCustomTags=function(){if($FSI.BrowserSupports.registerElement()){return}for(var o in $FSI.customTags){$FSI.initCustomTag(o)}};$FSI.initCustomTag=function(strTagName){if($FSI.BrowserSupports.registerElement()){return}var oCustomTag=$FSI.customTags[strTagName];if(!oCustomTag||typeof(oCustomTag.replaceTag)!=="function"){return false}var ar=document.getElementsByTagName(strTagName);if(ar&&ar.length>0){if(oCustomTag.replaceTagInit){oCustomTag.replaceTagInit();delete oCustomTag.replaceTagInit}for(var i=0;i<ar.length;i++){oCustomTag.replaceTag(ar[i])}}};$FSI.registerCustomTag=function(strTagName,oFunctions){var oCustomTag=$FSI.customTags[strTagName];if(oCustomTag){return false}oCustomTag=$FSI.customTags[strTagName]={};if($FSI.BrowserSupports.registerElement()){oCustomTag.bRegistered=true;oFunctions.registerElement()}else{oCustomTag.bRegistered=false;oCustomTag.replaceTag=oFunctions.replaceTag;if(typeof(oFunctions.replaceTagInit)==="function"){oCustomTag.replaceTagInit=oFunctions.replaceTagInit}if(!$FSI.bCustomTagsAdded){$FSI.bCustomTagsAdded=true;$FSI.addEvent(window,"DOMContentLoaded",$FSI.initCustomTags)}}return true};$FSI.attributes2parameters=function(node){var ret={};if(!node||typeof(node.attributes)!=="object"){return ret}var attr;var attrs=node.attributes;for(var i=0;i<attrs.length;i++){attr=attrs[i];ret[attr.name]=attr.value}return ret};$FSI.oViewerClassCSSRules={};$FSI.addViewerClassCSSRule=function(strClass,strRule){if(typeof(strClass)!=="string"||strClass.length<1){return}if(typeof(strRule)!=="string"||strRule.length<1){return}var res=$FSI.oViewerClassCSSRules[strClass];if(res==strRule){return}$FSI.addCSSRule(strClass,strRule,0);$FSI.oViewerClassCSSRules[strClass]=strRule};$FSI.now=(typeof(Date.now)==="function")?Date.now:function(){return new Date().getTime()};$FSI.getWindowOffset=function(el){var ofsX=0;var ofsY=0;try{if(el.frameElement){var w=el;while(w.frameElement){var node=w.frameElement;var nodePos=$FSI.getElementPosition(node);ofsX+=nodePos.left;ofsY+=nodePos.top;w=w.parent}}}catch(e){}return{x:ofsX,y:ofsY}};$FSI.getElementPaddings=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.paddingLeft);ret.top=parseFloat(style.paddingTop);ret.right=parseFloat(style.paddingRight);ret.bottom=parseFloat(style.paddingBottom)}catch(e){}return ret};$FSI.getElementMargins=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.marginLeft);ret.top=parseFloat(style.marginTop);ret.right=parseFloat(style.marginRight);ret.bottom=parseFloat(style.marginBottom)}catch(e){}return ret};$FSI.getElementBorders=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.borderLeftWidth);ret.top=parseFloat(style.borderTopWidth);ret.right=parseFloat(style.borderRightWidth);ret.bottom=parseFloat(style.borderBottomWidth)}catch(e){}return ret};$FSI.getBoundingClientRect=function(el){var ret;try{ret=el.getBoundingClientRect()}catch(e){ret={top:0,left:0,right:0,bottom:0,width:0,height:0}}return ret};$FSI.getElementClientDim=function(element){var rc=$FSI.getBoundingClientRect(element);return{width:(rc.right-rc.left),height:(rc.bottom-rc.top)}};$FSI.getElementClientPos=function(element){return $FSI.getBoundingClientRect(element)};$FSI.getElementPosition=function(element){var rc=$FSI.getBoundingClientRect(element);var bl=element.clientLeft;var bt=element.clientTop;var br=0;var bb=0;var pl=0;var pr=0;var pt=0;var pb=0;try{var style=window.getComputedStyle(element,null);pl=parseFloat(style.paddingLeft);pr=parseFloat(style.paddingRight);pt=parseFloat(style.paddingTop);pb=parseFloat(style.paddingBottom);bl=parseFloat(style.borderLeftWidth);br=parseFloat(style.borderRightWidth);bt=parseFloat(style.borderTopWidth);bb=parseFloat(style.borderBottomWidth)}catch(e){}var x1=rc.left+bl+pl;var y1=rc.top+bt+pt;var x2=rc.right-br-pr;var y2=rc.bottom-bb-pb;return{left:x1,top:y1,right:x2,bottom:y2}};$FSI.trim=function(s){if(!s||typeof(s)!=="string"||s.length<1){return s}return s.replace(/(^\s+)|(\s+$)/g,"")};$FSI.escapeRegEx=function(s){return s.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")};$FSI.addClass=function(el,strClass){if(!el||typeof(el.className)!=="string"){return}if(typeof(strClass)!=="string"){return}strClass=$FSI.trim(strClass);if(strClass.length<1){return}strClass=strClass.replace(/\s+/," ");var needle=$FSI.escapeRegEx(strClass);var regex=new RegExp("(^|\\s+)"+needle+"(\\s+|$)");var strCurrent=$FSI.trim(el.className);var bFound=strCurrent.match(regex);if(!bFound){if(strCurrent.length>0){strCurrent+=" "+strClass}else{strCurrent+=strClass}el.className=strCurrent}};$FSI.removeClass=function(el,strClass){if(!el||typeof(el.className)!=="string"){return}if(typeof(strClass)!=="string"){return}strClass=$FSI.trim(strClass);if(strClass.length<1){return}strClass=strClass.replace(/\s+/," ");var needle=$FSI.escapeRegEx(strClass);var regex=new RegExp("(^|\\s+)"+needle+"(\\s+|$)","g");var str=$FSI.trim(el.className.replace(regex," "));if(str.length>0){el.className=str}else{el.removeAttribute("class")}};$FSI.hasClass=function(el,strClass){if(typeof(strClass)!=="string"){return false}strClass=$FSI.trim(strClass);if(strClass.length<1){return false}var str=el.className;if(typeof(str)!=="string"||str.length<1){return false}strClass=strClass.replace(/\s+/," ");var needle=$FSI.escapeRegEx(strClass);var regex=new RegExp("(^|\\s+)"+needle+"(\\s+|$)","g");return(str.match(regex)!=null)};$FSI.urlDecode=function(str){if(!str){return str}var ret=str.replace($FSI.regexPlusToSpace," ");try{ret=decodeURIComponent(ret)}catch(e){$FSI.console.error("Malformed URI: "+ret)}return ret};$FSI.getCSSTransformStyleName=function(){if($FSI._CSSTransformStyleName!=undefined){return $FSI._CSSTransformStyleName}var ret="transform";var ar=["transform","webkitTransform","msTransform","MozTransform","OTransform"];var div=document.createElement("DIV");for(var i=0;i<ar.length;i++){div.style[ar[i]]="translate( 0 , 0)";if(div.style[ar[i]]!="translate( 0 , 0)"){ret=ar[i];break}}div=null;$FSI._CSSTransformStyleName=ret;return ret};$FSI.regExEffects=/((\?)|&)effects=([^&]*)/ig;$FSI.regExPadEffect=/[=,]+Pad\([^)]*/ig;$FSI.expandSourceDimensionForPadEffect=function(o,w,h){var dimOrg;if(typeof(o)!=="object"||typeof(o.src)!=="string"){return}var res=o.src.match($FSI.regExEffects);if(res&&typeof(res)==="object"&&typeof(res[0])==="string"){o.bHasEffects=true;res[0]=decodeURIComponent(res[0]);if(res[0].match($FSI.regExPadEffect)){o.bHasPadEffect=true;var rectWidth=(o.rectWidth!==undefined)?o.rectWidth:1;var rectHeight=(o.rectHeight!==undefined)?o.rectHeight:1;if(rectWidth>0&&rectHeight>0){var sourceWidth=rectWidth*o.sourceWidth;var sourceHeight=rectHeight*o.sourceHeight;if(sourceWidth/w>sourceHeight/h){dimOrg=sourceHeight/sourceWidth*w;o.sourceHeight=Math.round(h/dimOrg*sourceHeight)/rectHeight}else{dimOrg=sourceWidth/sourceHeight*h;o.sourceWidth=Math.round(w/dimOrg*sourceWidth)/rectWidth}}}}};$FSI.getFSIServerImageDim=function(wSource,hSource,wTarget,hTarget,range,keepAspectRatio){var sourceDim={width:wSource,height:hSource};var targetDim={width:wTarget,height:hTarget};$FSI.calcFSIServerImageDim(sourceDim,targetDim,range,keepAspectRatio);return targetDim};$FSI.calcFSIServerImageDim=function(sourceDimension,targetDimension,range,keepAspectRatio){if(typeof(range)!=="object"){range={left:0,top:0,width:1,height:1}}else{range.left=range.left<0?0:range.left>1?1:range.left;range.top=range.top<0?0:range.top>1?1:range.top;range.width=range.width<0?1-range.left:range.width+range.left>1?1-range.left:range.width;range.height=range.height<0?1-range.top:range.height+range.top>1?1-range.top:range.height}targetDimension.width=targetDimension.width<=0||targetDimension.width===undefined?-1:targetDimension.width;targetDimension.height=targetDimension.height<=0||targetDimension.height===undefined?-1:targetDimension.height;var scale={};if(targetDimension.width!=-1&&targetDimension.height!=-1){scale.x=targetDimension.width/(sourceDimension.width*range.width);scale.y=targetDimension.height/(sourceDimension.height*range.height)}else{if(targetDimension.height==-1){scale.x=scale.y=targetDimension.width/(sourceDimension.width*range.width)}else{scale.x=scale.y=targetDimension.height/(sourceDimension.height*range.height)}}if(targetDimension.width==-1||targetDimension.height==-1){var scaleFactor=Math.min(scale.x,scale.y);if(targetDimension.width==-1){targetDimension.width=Math.round(sourceDimension.width*range.width*scaleFactor)}else{if(targetDimension.height==-1){targetDimension.height=Math.round(sourceDimension.height*range.height*scaleFactor)}}scale.x=scaleFactor;scale.y=scaleFactor}if(keepAspectRatio&&Math.abs(scale.x-scale.y)>1e-7){if(scale.x>scale.y){var preciseTargetWidth=targetDimension.height*sourceDimension.width*range.width/(sourceDimension.height*range.height);scale.x=preciseTargetWidth/sourceDimension.width;targetDimension.width=Math.round(preciseTargetWidth)}else{var preciseTargetHeight=targetDimension.width*sourceDimension.height*range.height/(sourceDimension.width*range.width);scale.y=preciseTargetHeight/sourceDimension.height;targetDimension.height=Math.round(preciseTargetHeight)}}targetDimension.width=targetDimension.width==0?1:targetDimension.width;targetDimension.height=targetDimension.height==0?1:targetDimension.height;return scale};if(typeof(window.JSON)==="undefined"){$FSI.JSON={};$FSI.JSON._emulated=true}else{$FSI.JSON=JSON}(function(){function f(n){return n<10?"0"+n:n}if(typeof Date.prototype.toJSON!=="function"){Date.prototype.toJSON=function(key){return isFinite(this.valueOf())?this.getUTCFullYear()+"-"+f(this.getUTCMonth()+1)+"-"+f(this.getUTCDate())+"T"+f(this.getUTCHours())+":"+f(this.getUTCMinutes())+":"+f(this.getUTCSeconds())+"Z":null};String.prototype.toJSON=Number.prototype.toJSON=Boolean.prototype.toJSON=function(key){return this.valueOf()}}var cx=/[\u0000\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,escapable=/[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,gap,indent,meta={"\b":"\\b","\t":"\\t","\n":"\\n","\f":"\\f","\r":"\\r",'"':'\\"',"\\":"\\\\"},rep;function quote(string){escapable.lastIndex=0;return escapable.test(string)?'"'+string.replace(escapable,function(a){var c=meta[a];return typeof c==="string"?c:"\\u"+("0000"+a.charCodeAt(0).toString(16)).slice(-4)})+'"':'"'+string+'"'}function str(key,holder){var i,k,v,length,mind=gap,partial,value=holder[key];if(value&&typeof value==="object"&&typeof value.toJSON==="function"){value=value.toJSON(key)}if(typeof rep==="function"){value=rep.call(holder,key,value)}switch(typeof value){case"string":return quote(value);case"number":return isFinite(value)?String(value):"null";case"boolean":case"null":return String(value);case"object":if(!value){return"null"}gap+=indent;partial=[];if(Object.prototype.toString.apply(value)==="[object Array]"){length=value.length;for(i=0;i<length;i+=1){partial[i]=str(i,value)||"null"}v=partial.length===0?"[]":gap?"[\n"+gap+partial.join(",\n"+gap)+"\n"+mind+"]":"["+partial.join(",")+"]";gap=mind;return v}if(rep&&typeof rep==="object"){length=rep.length;for(i=0;i<length;i+=1){if(typeof rep[i]==="string"){k=rep[i];v=str(k,value);if(v){partial.push(quote(k)+(gap?": ":":")+v)}}}}else{for(k in value){if(Object.prototype.hasOwnProperty.call(value,k)){v=str(k,value);if(v){partial.push(quote(k)+(gap?": ":":")+v)}}}}v=partial.length===0?"{}":gap?"{\n"+gap+partial.join(",\n"+gap)+"\n"+mind+"}":"{"+partial.join(",")+"}";gap=mind;return v}}if(typeof $FSI.JSON.stringify!=="function"){$FSI.JSON.stringify=function(value,replacer,space){var i;gap="";indent="";if(typeof space==="number"){for(i=0;i<space;i+=1){indent+=" "}}else{if(typeof space==="string"){indent=space}}rep=replacer;if(replacer&&typeof replacer!=="function"&&(typeof replacer!=="object"||typeof replacer.length!=="number")){throw new Error("JSON.stringify")}return str("",{"":value})}}if(typeof $FSI.JSON.parse!=="function"){$FSI.JSON.parse=function(text,reviver){var j;function walk(holder,key){var k,v,value=holder[key];if(value&&typeof value==="object"){for(k in value){if(Object.prototype.hasOwnProperty.call(value,k)){v=walk(value,k);if(v!==undefined){value[k]=v}else{delete value[k]}}}}return reviver.call(holder,key,value)}text=String(text);cx.lastIndex=0;if(cx.test(text)){text=text.replace(cx,function(a){return"\\u"+("0000"+a.charCodeAt(0).toString(16)).slice(-4)})}if(/^[\],:{}\s]*$/.test(text.replace(/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g,"@").replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g,"]").replace(/(?:^|:|,)(?:\s*\[)+/g,""))){j=eval("("+text+")");return typeof reviver==="function"?walk({"":j},""):j}throw new SyntaxError("JSON.parse")}}}());$FSI.BrowserSupports.visualViewportAPI=function(){var res=false;try{if(typeof(window.visualViewport)!="undefined"){res=true}}catch(e){}$FSI.BrowserSupports.visualViewportAPI=$FSI.BrowserSupports[res];return res};$FSI.BrowserSupports.registerElement=function(){var res=false;try{if(typeof(document.registerElement)=="function"){res=true}}catch(e){}$FSI.BrowserSupports.registerElement=$FSI.BrowserSupports[res];return res};$FSI.BrowserSupports.canvas=function(){var res=false;try{var cv=document.createElement("canvas");var ctx=cv.getContext("2d");if(ctx&&ctx.clearRect!=undefined){res=true}}catch(e){}$FSI.BrowserSupports.canvas=$FSI.BrowserSupports[res];return res};$FSI.BrowserSupports.cssTouchAction=function(){var res=false;try{if($FSI.isTouch){if(typeof(window.getComputedStyle)==="function"){var stl=window.getComputedStyle(document.body);res=(typeof(stl.touchAction)==="string")}}}catch(e){}$FSI.BrowserSupports.cssTouchAction=$FSI.BrowserSupports[res];return res};var ret=($FSI.isMobileDevice||$FSI.isIETouch||$FSI.isTouch||($FSI.isMac&&$FSI.isSafari))?true:false;$FSI.BrowserSupports.documentZoom=$FSI.BrowserSupports[ret]}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Debugger!=b){return}a.EmptyDebugger=function(){this.log=this.error=this.warn=this.dir=this.group=this.groupCollapsed=this.groupEnd=this.info=this.setPrefix=function(){};this.on=false};a.Debugger=function(){var c=this;var f="FSI";this.on=true;var e=console||{};var d=0;var h=function(j,i){if(d<1){i=Array.prototype.slice.call(i);i.unshift(f)}e[j].apply(e,i)};var g=function(i,j){if(typeof(e[i])=="function"){c[i]=function(){h(i,arguments)}}else{c[i]=j}};g("log",a.fnDoNothing);g("warn",this.log);g("error",this.log);g("info",this.log);if(typeof(e.dir)=="function"){this.dir=e.dir}else{this.dir=this.log}if(!a.isInternetExplorer&&typeof(e.group)=="function"){this.group=function(i){d++;e.group.call(e,f+i)}}else{this.group=this.log}if(!a.isInternetExplorer&&typeof(e.groupCollapsed)=="function"){this.groupCollapsed=function(i){d++;e.groupCollapsed.call(e,f+i)}}else{this.groupCollapsed=this.group}if(typeof(e.groupEnd)=="function"){this.groupEnd=function(){d--;e.groupEnd.apply(e,arguments)}}else{this.groupEnd=a.fnDoNothing}this.setPrefix=function(i){f=i+"> "}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Config!=b){return}a.Config=function(Z,z,g){if(typeof(g)!=="object"){g={}}if(!z||typeof(z)!=="object"){z={}}var p=this;this.parameters=(Z&&typeof(Z)==="object")?Z:{};this.queryParameters=b;try{this.XMLSerializer=(XMLSerializer)?new XMLSerializer():b}catch(ab){}this.plugins={};this.arPlugins=[];this.nPluginToInit=-1;this.arUnrecognizedConfigNodes=[];this.arConditions=[];this.locales={};this.locales.tips={};var R=false;this.strListFilePrefix="";this.strListFileSuffix="";var J={};var B=0;var t;var V={};var d="FSI> ";var E=p.debug=new a.EmptyDebugger();var C=false;var A={};var af=false;var M={stickynotes:"bookmarks"};var h;var Q=false;var v;var G;var W;var c;var o;var x="token";var y;this.strConfigFileExtension=".xml";p.strTemplateSuffix=".json";var r;var i=null;if(a.isInternetExplorer&&a.versionInternetExplorer<10){r=function(ag){var e;if(!a.isCrossDomain(ag)){af=false;e=new XMLHttpRequest()}else{af=true;e=new XDomainRequest()}return e}}else{if(typeof XMLHttpRequest!="undefined"){r=function(){return new XMLHttpRequest()}}}if(!r){try{i=new ActiveXObject("Msxml2.XMLHTTP");r=function(){return new ActiveXObject("Msxml2.XMLHTTP")}}catch(ab){try{i=new ActiveXObject("Microsoft.XMLHTTP");r=function(){return new ActiveXObject("Microsoft.XMLHTTP")}}catch(ab){i=null;r=function(){return null}}}}this.bForceVersion5=false;this.pluginDefaultParameters={};this.pluginDefaultParameters.pages={};this.cfgAliasNames={imagesrc:"fpxsrc",imagesources:"fpxsources",imageheight:"fpxheight",imagewidth:"fpxwidth",imageservertemplate:"fpxservertemplate",profile:"fpxservertemplate",renderer:"fpxservertemplate",imageinfotemplate:"fpxinfotemplate",imageservertype:"fpxservertype",imagetilepaddingx:"fpxtilepaddingx",imagetilepaddingy:"fpxtilepaddingy",imagetilewidth:"fpxtilewidth",imagetileheight:"fpxtileheight",imagetilesx:"fpxtilesx",imagetilesy:"fpxtilesy",imageserver:"fpxserver",imagepath:"fpxpath",imagetransparency:"fpxtransparency"};this.cfg=this.cfgDefaults={defaultcfg:"_default",headers:"cors",fsibase:"config/",fpxservertemplate:"jpeg",listtemplate:"image_list"};this.init=function(ai){p.reset();v=(typeof(g.strSection)==="string")?g.strSection:"";G=v.toLowerCase();if(typeof(g.strTraceParam)==="string"){var ag=g.strTraceParam.toLowerCase();c={};c[ag]=true;if(ag.indexOf("_")>0&&ag.indexOf("pages")===0){ag=ag.split("_");ag.shift();ag=ag.join("_");c[ag]=true}var ah=p.getParameterAlias(ag);if(ah){c[ah]=true}}else{c=false}if(ai){if(p.parameters){p.parameters=a.mergeObjects(p.parameters,ai)}else{p.parameters=ai}}Y(p.parameters);p.getQueryParameters();p.cloneParameters(p.cfgDefaults,p.cfg);p.cloneParameters(p.queryParameters,p.cfg);p.elevateToHTTPS();f();p.BaseURL=p.getBaseURL();if(p.bForceVersion5==true){}var e=p.queryParameters.fsiviewerversion;if(p.bForceVersion5==true){e="5"}if(e!=b){if(parseInt(e)<6){p.strConfigFileExtension=".fsi"}}var aj=p.queryParameters.fsiserverversion;if(p.bForceVersion5==true){aj="2"}if(aj!=b){if(parseInt(aj)<3){p.strTemplateSuffix="_json"}}p.locationFSIViewer="";if(p.queryParameters.fsiviewerlocation!=b){p.locationFSIViewer=p.queryParameters.fsiviewerlocation}else{if(a!=b&&a._FSIViewerLocation!=b){E.log("FSI Viewer location guessed based on script location: "+a._FSIViewerLocation);p.locationFSIViewer=a._FSIViewerLocation}else{p.locationFSIViewer=p.BaseURL.split("/");if(p.locationFSIViewer.length>4){p.locationFSIViewer.splice(p.locationFSIViewer.length-3,2);p.locationFSIViewer=p.locationFSIViewer.join("/")}}}if(p.locationFSIViewer.charAt(p.locationFSIViewer.length-1)!="/"){p.locationFSIViewer+="/"}p.nextConfigURL=p.getReloadPath(p.locationFSIViewer,p.expandFSIPath(p.cfg.defaultcfg));p.checkDebug(false)};var Y=this.makeObjectPropertiesLowerCase=function(e){for(var ag in e){var ah=ag.toLowerCase();if(ag!=ah){if(e[ah]==b){e[ah]=e[ag]}delete e[ag]}}};this.getClassParameters=function(){return W};this.setAccessToken=function(e){y=e};this.getParameterAlias=function(ah){var e;if(p.cfgAliasNames[ah]){e=p.cfgAliasNames[ah]}else{for(var ag in p.cfgAliasNames){if(p.cfgAliasNames[ag]===ah){e=ag;break}}}return e};var f=function(){R=p.makeBool(p.cfg.usenc,false);if(p.cfg.usencquery!=b&&p.cfg.usencquery.length>0){C=p.cfg.usencquery;R=true;p.queryToObject("?"+C,A)}};this.stopPendingRequests=function(){for(var ag in J){var e=J[ag];if(e){e.FSIaborted=true;if(e.abort){e.abort()}}}};this.destroy=function(){p.stopPendingRequests()};this.getBaseURL=function(){var ah;var ag=document.getElementsByTagName("base");if(ag&&ag.length>0){ah=ag[ag.length-1].href;if(ah&&ah.charAt(ah.length-1)!="/"){ah+="/"}}else{ah=document.location.href;var e=ah.indexOf("?");if(e!=-1){ah=ah.slice(0,e)}e=ah.indexOf("#");if(e!=-1){ah=ah.substring(0,e)}e=ah.lastIndexOf("/");if(e!=-1){ah=ah.slice(0,e+1)}}return ah};this.reset=function(){W={};p.parameters={};E=p.debug=new a.EmptyDebugger();p.stopPendingRequests();t=Math.random();p.nIncludedConfigs=0;p.completedConfigs={};p.plugins={};p.cfg={};p.queryParameters=b;p.arUnrecognizedConfigNodes=[];aa=0;p.arConditions=[];V={}};this.getQueryParameters=function(){if(p.queryParameters!=b){return}p.queryParameters={};p.cloneParameters(p.parameters,p.queryParameters)};this.makeBool=function(ai,e){if(typeof(e)!="boolean"){e=false}var ag=e;switch(typeof(ai)){case"string":var ah=a.makeBool(ai);if(ah!=b){ag=ah}break;case"number":ag=Boolean(ai);break;case"boolean":ag=ai;break}return ag};this.parsePositionParameter=function(ag){if(typeof(ag)!="string"||ag.length<3){return b}ag=ag.split(",");if(ag.length<3){return b}for(var e=0;e<3;e++){ag[e]=parseFloat(ag[e]);if(isNaN(ag[e])){ag[e]=0}}return{x:ag[0],y:ag[1],z:ag[2]}};this.logLoadFileFailed=function(e){if(!E.on){return}if(e&&e.status!=b){var ah="HTTP "+e.status;if(e&&e.statusText){ah+=", "+e.statusText}var ag=(e._url)?e._url:"";E.error("Failed to load "+ag+" ("+ah+")")}else{E.error("Failed loading a file");if(e&&e._url){E.error(e._url)}}};this.logXMLResponseOK=function(e){};this.parseLanguage=function(aj){if(!aj||!aj.firstChild){return false}var e=aj.firstChild.childNodes;var ak,ah,ai;for(var ag=0;ag<e.length;ag++){ah=e[ag];ak=p.getAttributeValue(ah,"id");if(ak==b){continue}ak=ak.toLowerCase();if(ah.childNodes.length>0){ai=p.XMLChildNodesToString(ah)}else{ai=p.getAttributeValue(ah,"txt")}p.locales.tips[ak]=ai}return true};this.getAttributeValue=function(ag,e){if(!ag){return}return ag.getAttribute(e)};this.onLanguageLoaded=function(ag,e){E.log("Language loaded");if(ag){p.parseLanguage(e.responseXML)}if(z.onConfigReady){z.onConfigReady()}};this.onConfigReadyDone=function(){if(!p.readCustomPageNumbers()){p.loadImageList()}};this.swapParameters=function(ah,e){ah=ah.toLowerCase();e=e.toLowerCase();var ag=p.plugins.pages.parameters;if(ag==b){return}p.swapValues(ag,ah,e);p.swapValues(p.cfg,"pages_"+ah,"pages_"+e)};this.swapValues=function(ai,ah,ag){var e=ai[ah];ai[ah]=ai[ag];ai[ag]=e};this.getTranslation=function(ag){var e=p.locales.tips[ag.toLowerCase()];if(e==b){e=ag}return e};this.getImageURL=function(ah,e){if(ah==b){return""}if(e===b){e={}}if(e.type===b){e.type="image"}if(e.renderer===b){e.renderer="jpeg"}if(y){e[x]=y}e.source=ah;for(var ag in V){if(V[ag]!==b&&e[ag]===b){e[ag]=V[ag]}}for(var ag in T){if(e[ag]){if(T[ag]!==ag){if(!e[T[ag]]){e[T[ag]]=e[ag]}e[ag]=null}}}return p.requestBase+"?"+p.objectToQuery(e)};this.getImageInfoURL=function(ag,e){if(ag==b){return""}if(e==b){e={}}if(e.type==b){e.type="info"}if(e.tpl==b){if(p.cfg.fpxinfotemplate!=b){e.tpl=p.cfg.fpxinfotemplate}else{e.tpl="info.json"}}if(p.cfg.headers&&p.cfg.headers.length>0){e.headers=p.cfg.headers}if(!e.tpl.match(/.json$/)){e.tpl+=".json"}e.source=ag;if(y){e[x]=y}return p.requestBase+"?"+p.objectToQuery(e)};this.queryToObject=function(aj,ah){if(ah==b){ah={}}var ai,al,ak,e,ag;ai=aj.indexOf("?");if(ai!=-1){ag=aj.slice(ai+1)}else{ag=""}ai=ag.indexOf("#");if(ai!=-1){ag=ag.substring(0,ai)}ag=ag.split("&");for(ai=0;ai<ag.length;ai++){al=ag[ai].split("=");ak=a.urlDecode(al[0]).toLowerCase();if(ak.length>0){e=a.urlDecode(al[1]);ah[ak]=e}}return ah};this.parseSceneSets=function(e,aj){var aq={};if(aj==b){aj=true}var aw=[];var au=0;var ar=0;var ah;var al,ak,ai,ap,an,av;var am,ao,at;var ag=p.cfg.scenesets;if(e>1&&ag!=b&&typeof(ag)=="string"){ao=ag.split(";");for(al=0;al<ao.length;al++){at=[];am=ao[al].split(",");ar=0;for(ak=0;ak<am.length;ak++){av=am[ak].split("-");ap=an=0;if(av.length==1){ap=parseInt(av[0])}else{ap=parseInt(av[0]);if(isNaN(ap)){ap=1}ah=false;if(av[1].charAt(0)==">"){av[1]=av[1].substr(1);if(!isNaN(parseInt(av[1]))){ah=true}}an=parseInt(av[1]);if(isNaN(an)){an=e}if(ap>0&&an>0&&ap<=e&&an<=e){if(ah==true||ap!=an){if(ah!=true){if(an<ap){for(ai=ap;ai>=an;ai--){at[ar]=ai;ar++}}else{for(ai=ap;ai<=an;ai++){at[ar]=ai;ar++}}}else{for(ai=ap;ai<=e;ai++){at[ar]=ai;ar++}for(ai=1;ai<=an;ai++){at[ar]=ai;ar++}}}}}if(ap>0&&ap<=e&&(an==0||an==ap)){at[ar]=ap;ar++}}if(ar>0){aw[au]={};aw[au].arScenes=[];aw[au].arScenes=aw[au].arScenes.concat(at);au++}}}if(au==0){aq.bDefault=true;if(aj){aw[0]={};aw[0].arScenes=[];for(al=0;al<e;al++){aw[0][al]=al}}}aq.nSceneSets=au;aq.bHasMultipleSets=(aq.nSceneSets>1);aq.arSets=aw;aq.nCurrent=1;return aq};this.objectToQuery=function(ag){var e=[];var ai,ah;if(R&&C!==false){for(ai in A){ag[ai]=A[ai]}}for(ai in ag){ah=ag[ai];if(ah!==null){ah=encodeURIComponent(ah);e.push(encodeURIComponent(ai)+"="+ah)}}return e.join("&")};this.loadConfigs=function(){W=(v.length>0)?{}:false;h=true;p.loadNextConfig(true)};this.loadImageInfo=function(ai,e,ah){var ag=p.getImageInfoURL(ai);p.loadFile(ag,e,b,ah)};this.loadFile=function(aj,ai,ah,an,am,ag,ak){if(!aj||aj.length<0){if(ai){setTimeout(function(){ai(null,"",an)},0)}return}if(am==b){am="GET"}if(ag==b){ag=null}else{if(typeof(ag)=="object"){ag=p.objectToQuery(ag)}}if(ah==b){ah="application/json"}var al=r(aj);if(!al){return}if(ah&&al.overrideMimeType){al.overrideMimeType(ah)}al._url=aj;var e=B;J[B]=al;B++;if(af){al.onerror=function(){delete J[e];if(ai==b||this.FSIaborted){return}p.logLoadFileFailed(this)};al.onload=function(){delete J[e];if(ai==b||this.FSIaborted){return}var ao=this.responseText;switch(this.contentType){case"application/xml":case"text/xml":try{var ap=new ActiveXObject("Microsoft.XMLDOM");ap.async=false;ap.loadXML(ao);ao=this.responseXML=ap}catch(aq){E.log("Failed parsing XML using Microsoft.XMLDOM");E.log(aj)}break;case"application/json":ao={};try{ao=a.JSON.parse(this.responseText)}catch(aq){E.error("Failed parsing JSON from URL: "+aj+" ("+aq.message+")")}break;default:ao=this.responseText}ai(this,ao,an)}}else{al.onreadystatechange=function(ao){var ap;if(al.readyState!=4){return}delete J[e];if(ai==b||this.FSIaborted){return}if(this.status>299){p.logLoadFileFailed(this)}switch(ah){case"application/xml":case"text/xml":ap=this.responseXML;break;case"application/json":ap={};try{ap=a.JSON.parse(this.responseText)}catch(aq){E.error("Failed parsing JSON from URL: "+aj+" ("+aq.message+")")}break;default:ap=this.responseText}ai(this,ap,an)}}al.open(am,aj,true);if(ak&&y){al.setRequestHeader("x-token",y)}if(ag){al.setRequestHeader("Content-type","application/x-www-form-urlencoded");al.send(ag)}else{al.send()}return al};this.onConfigXMLLoaded=function(e,ag){p.logXMLResponseOK(e.response);p.onConfigLoaded(e.responseXML)};this.loadNextConfig=function(ag){if(p.nextConfigURL==b){p.finalCheck();return}var ah={};if(g.bPreventCaching||p.makeBool(p.cfg.debug)||(!ag&&!p.makeBool(p.cfg.configcaching,true)&&p.makeBool(p.cfg.enableconfigcachingparameter))){p.addNoCacheParams(ah)}p.finishRequestParams(ah);var e=p.addURLParameters(p.nextConfigURL,ah);E.log("Loading config file: "+e);p.loadFile(e,p.onConfigXMLLoaded,"application/xml")};this.parseFloatPercentDef=function(ai,ah,ag,e){if(ai==b||ai.length<1){return ag}return Math.max(e,p.parseFloatPercent(ai,ah))};this.parsePercentDef=function(ah,e){if(ah==b||ah.length<1){return e}var ag=parseFloat(ah);if(isNaN(ag)){ag=0}else{if(ah.indexOf("%")!=-1){ag/=100}}return ag};this.parseFloatPercent=function(ah,ag){var e=parseFloat(ah);if(isNaN(e)||e<0){e=0}else{if(ah.indexOf("%")!=-1){e=Math.round(e*ag/100)}else{e=Math.ceil(e)}}return e};this.setDebugPrefix=function(e){d=e+"> "};this.setDebugger=function(e){E=p.debug=e};this.checkDebug=function(ah){if(g.bNoDebug){return}var ag;var e;if(p.parameters.debug!=b){e=p.makeBool(p.parameters.debug)}else{e=p.makeBool(p.cfg.debug)}if(e){if(!E||!E.on){E=p.debug=new a.Debugger();if(z.onDebuggerChange){ag=z.onDebuggerChange(E,ah)}}}else{if(!E||E.on===true){E=p.debug=new a.EmptyDebugger();if(z.onDebuggerChange){ag=z.onDebuggerChange(E,ah)}}}return ag};this.onConfigLoaded=function(ag){o=p.nextConfigURL;p.parseConfig(ag);o=b;p.elevateToHTTPS();if(p.checkDebug(true)==true){return}f();if(h&&g.bCaptureDefaultCfg){h=false;p.cfgFromDefaultConfig=a.cloneValue(p.cfg)}var e;if(p.cfg.includeconfig!=b&&p.nIncludedConfigs<10){e=p.getFSIPath(p.locationFSIViewer,p.expandFSIPath(p.cfg.includeconfig));p.nIncludedConfigs++;p.cfg["_includeconfig("+p.nIncludedConfigs+")"]=p.cfg.includeconfig;p.cfg.includeconfig=b}else{if(p.cfg.cfg!=b){e=p.getFSIPath(p.locationFSIViewer,p.expandFSIPath(p.cfg.cfg))}}if(e!=b&&!p.completedConfigs[e]){p.completedConfigs[e]=true;p.nextConfigURL=e;p.loadNextConfig()}else{p.evaluateQuery(p.queryParameters,p.cfg);p.finalCheck()}};this.elevateToHTTPS=function(){if(!a.bHTTPS){return}if(!p.makeBool(p.cfg.autoelevatetohttps,true)){return}k("fpxbase");k("fpxserver")};var k=function(e){if(p.cfg[e]!=b&&p.cfg[e].length>0&&p.cfg[e].indexOf("http://")==0){p.cfg[e]="https"+p.cfg[e].substr(4)}};this.evaluateQuery=function(ag,e){for(var ah in ag){p.setConfigParamByValue(e,ah.toLowerCase(),ag[ah])}};this.parseConfig=function(ag,ah){var aq="";var ak;var am=false;if(ag!=b){if(ah===b){ah=ag.firstChild}if(ah&&ah.nodeName=="xml"){ah=ah.nextSibling}var ap=ah.childNodes;for(var al=0;al<ap.length;al++){var aj=ap[al];if(aj.nodeType!=1){continue}var an;if(aj._myTagName!==b){an=aj._myTagName}else{an=aj.nodeName.toLowerCase()}aq=an;var ai=aj.childNodes;am=false;switch(an){case"licence":break;case"if":p.arConditions.push(aj);break;case"plugins":for(ak=0;ak<ai.length;ak++){p.parsePluginNode(ai[ak])}break;case G:am=true;case"info":case"options":aq=b;case"fpx":case"image":case"video":case"virtualspace":case"camera":case"include":for(ak=0;ak<ai.length;ak++){var ao=ai[ak];if(ao.nodeType!=1){continue}if(ao.tagName==="if"){ao._myTagName=an;p.arConditions.push(ao)}else{var e=p.getValueFromXMLNode(ao,aq);if(aq===b&&W){if(am){p.setConfigParam(W,e,null,true);p.setConfigParam(p.cfg,e,ao)}else{if(W[e.name]===b){p.setConfigParam(p.cfg,e,ao)}}}else{p.setConfigParam(p.cfg,e,ao)}}}break;default:p.arUnrecognizedConfigNodes.push(aj)}}}};this.getData=function(){var e={};e.cfg={};for(var ag in p.cfg){e.cfg[ag]=p.cfg[ag]}return e};this.setData=function(e){if(!e||!e.cfg){return}p.cfg={};this.setCfgValues(e.cfg)};this.setCfgValues=function(e){for(var ag in e){p.cfg[ag]=e[ag]}P()};this.getImagesNodeList=function(ah){var e=[];if(ah==b){ah=p.getUnrecognizedConfigNode("images")}if(ah){var ai=ah.firstChild;while(ai){if(ai.nodeType==1){var ag={};ag.attributes={};I(ai,ag.attributes);ag.cfg={};p.parseConfigFragment(ai,ag.cfg);e.push(ag)}ai=ai.nextSibling}}return e};this.removeUnrecognizedConfigNodes=function(){p.arUnrecognizedConfigNodes=[]};this.getUnrecognizedConfigNode=function(ai){var e;ai=ai.toLowerCase();for(var ag=p.arUnrecognizedConfigNodes.length-1;ag>-1;ag--){var ah=p.arUnrecognizedConfigNodes[ag];if(ah&&ah.nodeName.toLowerCase()==ai){e=ah;break}}return e};this.parseConfigFragment=function(ag,am,al){var aq="";if(ag!=b&&am!=b){if(al==b){al=[]}var ap=ag.childNodes;for(var ak=0;ak<ap.length;ak++){var ai=ap[ak];if(ai.nodeType!=1){continue}var an=ai.nodeName.toLowerCase();aq=an;var ah=ai.childNodes;switch(an){case"info":case"options":aq=b;case"fpx":case"image":case"include":for(var aj=0;aj<ah.length;aj++){var ao=ah[aj];if(ao.nodeType!=1){continue}var e=p.getValueFromXMLNode(ao,aq);p.setConfigParam(am,e,ao)}break;default:al.push(ai)}}}};this.findXMLNode=function(ag,e){if(ag==b||ag.nodeType==b){return b}while(ag){if(ag.nodeName.toLowerCase()==e){break}if(ag.firstChild!=b){ag=ag.firstChild}else{if(ag.nextSibling!=b){ag=ag.nextSibling}else{ag=ag.parentNode.nextSibling}}}return ag};this.getValueFromXMLNode=function(ah,e){if(!ah||ah.nodeType!=1){return}var ag={};var ai=(e)?e:"";ag.name=ai+ah.nodeName.toLowerCase();var aj=ah.getAttribute("value");if(aj){ag.value=aj;return ag}ag.value=p.XMLChildNodesToString(ah);ag.node=ah;return ag};this.getXMLNodeAttribute=function(ai,ah,e){if(!ai||ai.nodeType!=1||!ai.getAttribute){return e}var ag=ai.getAttribute(ah);if(ag==b||ag==null){ag=e}return ag};this.XMLChildNodesToString=function(ah,ag){if(!ah||!ah.firstChild){return""}var e="";if(ah.childNodes.length===1&&ah.firstChild.nodeType==3){e=ah.firstChild.nodeValue}else{e=p._XMLChildNodesToString(ah)}if(ag!==b){e=e.replace(/[\x00-\x1f]/g,ag)}return e};this.hasPlugin=function(e){return(p.plugins&&p.plugins[e]!=b)};this.getPluginParameter=function(al,ag,e,ak,am){al=al.toLowerCase();ag=ag.toLowerCase();if(p.plugins[al]==b){E.error("CANNOT GET PLUGIN PARAMETER, because plugin is not defined: "+al+"."+ag);return e}var aj;var ai=al+"_"+ag;if(am&&p.cfg[ai]==b){ai=ag}if(p.cfg[ai]!=b){aj=p.cfg[ai]}else{if(W&&W[ag]!==b&&G==="pages"){aj=W[ag]}else{var ah=p.plugins[al].parameters;if(ah!=b&&ah[ag]!=b){aj=ah[ag]}}}if(aj==b){aj=e}if(ak){aj=p.makeBool(aj,e)}return aj};var L=this.getAllPluginParameters=function(ag){ag=ag.toLowerCase();var ah=a.cloneObject(p.plugins[ag].parameters);var aj=ag+"_";var e=aj.length;for(var ak in p.cfg){if(ak.toLowerCase().indexOf(aj)==0){var ai=ak.substr(e);ah[ai]=p.cfg[ak]}}return ah};this.getIntParameterMinMax=function(ag,ah,e,ai){return Math.min(ai,Math.max(e,p.getIntParameter(ag,ah)))};this.getIntParameter=function(ag,ah){var e=parseInt(p.cfg[ag.toLowerCase()]);if(isNaN(e)){e=ah}return e};this.getStringParameter=function(ag,ah){var e=p.cfg[ag.toLowerCase()];if(e==b){e=ah}return e};this.getFloatParameter=function(ag,ah){var e=parseFloat(p.cfg[ag.toLowerCase()]);if(isNaN(e)){e=ah}return e};this.getRGBAValue=function(ag){var e={};if(ag==b){ag=""}if(ag.charAt(0)=="#"){ag=ag.substr(1)}if(ag.length>8){ag=ag.substr(0,8)}if(ag.length>5){e.webColor="#"+ag.substr(0,6);e.red=parseInt(ag.substr(0,2),16);e.green=parseInt(ag.substr(2,2),16);e.blue=parseInt(ag.substr(4,2),16);if(ag.length<7){e.alpha=255}else{e.alpha=parseInt(ag.substr(6,2),16)}}else{e.alpha=255;e.webColor="#000000";e.red=e.green=e.blue=0}e.webAlpha=e.alpha/255;return e};var I=function(ak,ag){if(!ak||!ak.attributes||!ak.attributes.length||!ag){return false}var ah=ak.attributes;for(var aj=0;aj<ah.length;aj++){var e=ah[aj];var ai=e.nodeName.toLowerCase();ag[ai]=e.value}return true};this.parsePluginNode=function(ah){if(ah.nodeType!=1){return}var aj={};I(ah,aj);var ai=ah.childNodes;for(var e=0;e<ai.length;e++){var ak=ai[e];if(ak.nodeType!=1){continue}var ag=p.getValueFromXMLNode(ak);if(ag.value!=b){aj[ag.name]=ag.value;if(ag.node!=b){aj[ag.name+".node"]=ag.node}}}this.addPluginFromString(aj.src,aj)};this.trimString=function(e){return e.replace(/^\s\s*/,"").replace(/\s\s*$/,"")};this.clone=function(){var e=new a.Config(Z,z,g);e.init();e.cfg=a.cloneObject(p.cfg);e.plugins=a.cloneObject(p.plugins);e.arPlugins=a.cloneArray(e.arPlugins);e.arUnrecognizedConfigNodes=a.cloneArray(e.arUnrecognizedConfigNodes);e.setImageQueryParameters(V);e.locales=a.cloneObject(p.locales);e.arConditions=a.cloneArray(p.arConditions);e.hasImageParameterConditions=p.hasImageParameterConditions;return e};this.setImageQueryParameters=function(e){V=a.cloneObject(e)};this.addPluginsFromString=function(ah){if(ah==b||ah.split==b||ah.length<1){return}var e=ah.split(",");for(var ag=0;ag<e.length;ag++){var ai=p.trimString(e[ag]);p.addPluginFromString(ai)}};this.addPluginFromString=function(ai,aj){if(ai==b||ai.length<1){E.error("PLUGIN without src parameter:");return}ai=ai.toLowerCase();if(M[ai]!=b){ai=M[ai]}if(aj==b){aj={}}var ag=p.plugins[ai]={};ag.name=ai;if(aj.src===b){aj.src=ai}if(p.pluginDefaultParameters[ai]!=b){ag.parameters={};p.cloneParameters(p.pluginDefaultParameters[ai],ag.parameters);p.cloneParameters(aj,ag.parameters)}else{ag.parameters=aj}if(c){for(var ak in c){if(ak.indexOf(ai+"_")===0){var ah=ai+"_";var e=ak.substr(ah.length);if(typeof(ag.parameters[e])!=="undefined"){p.iTraceParameterDebug.group(o);p.iTraceParameterDebug.log('<Plugin src="'+ai+'">');p.iTraceParameterDebug.log(ag.parameters[e]);p.iTraceParameterDebug.log("");p.iTraceParameterDebug.groupEnd()}}else{if(ak===ai){p.iTraceParameterDebug.group(o);p.iTraceParameterDebug.log('<Plugin src="'+ai+'">');p.iTraceParameterDebug.log("(enabled)");p.iTraceParameterDebug.log("");p.iTraceParameterDebug.groupEnd()}}}}};this.setConfigParamByValue=function(ag,ah,e){p.setConfigParam(ag,{name:ah.toLowerCase(),value:e})};var O=function(ag){if(ag.nodeType!==1){return"<unknown>"}var e=p.XMLSerializer.serializeToString(ag.cloneNode(false));e=e.replace(/\/>$/gi,">");return e};this.setConfigParam=function(ai,e,aj,ak){var am=e.name;var ao=e.value;if(am==b){return}if(c){for(var an in c){if(an===am&&!ak){if(typeof(aj)==="object"&&typeof(aj.tagName)==="string"){var al;if(o){al=o}var ah=aj.parentNode;var ag=[];while(ah){if(ah.tagName==="if"){al="Matched Condition"}ag.unshift(O(ah));ah=ah.parentNode}ag.shift();ag.shift();p.iTraceParameterDebug.group(al);p.iTraceParameterDebug.log(ag.join(" "));p.iTraceParameterDebug.log(aj);p.iTraceParameterDebug.log("");p.iTraceParameterDebug.groupEnd()}else{p.iTraceParameterDebug.group("By Parameter/Attribute:");p.iTraceParameterDebug.log(ao);p.iTraceParameterDebug.log("");p.iTraceParameterDebug.groupEnd()}}}}if(p.cfgAliasNames[am]!=b){am=p.cfgAliasNames[am]}if(ai[am]!=b&&(typeof(ao)=="string"&&a.BoolTable[ao.toLowerCase()]==false)&&a.BoolTable[ai[am]]==b){delete ai[am]}else{switch(am){case"effects":case"righteffects":case"lefteffects":case"tileeffects":case"sceneeffects":case"naveffects":case"thumbeffects":if(ai[am]!=b&&ai[am].length>0&&ai[am].indexOf(ao)==-1){ai[am]+=","+ao}else{ai[am]=ao}break;case"plugins":p.addPluginsFromString(ao);break;case"fpxpath":ai[am]=ao;ai.fpxsrc=encodeURIComponent(ao);break;default:ai[am]=ao;if(e.node!=b){ai[am+".node"]=e.node}}}};var n={};n["="]=function(ag,e){return(ag.toLowerCase()==e.toLowerCase())};n["=="]=function(ag,e){return(ag==e)};n["!="]=function(ag,e){return(ag.toLowerCase()!=e.toLowerCase())};n["!=="]=function(ag,e){return(ag!=e)};n["<"]=function(ag,e){return(ag<e)};n["<="]=function(ag,e){return(ag<=e)};n[">"]=function(ag,e){return(ag>e)};n[">="]=function(ag,e){return(ag>=e)};n.match=function(ah,ag){var ai=false;var ak="g";if(ag.charAt(0)==="/"&&ag.lastIndexOf("/")>0){var aj=ag.split("/");aj.shift();ak=aj.pop();ag=aj.join("/")}try{var al=new RegExp(ag,ak);ai=(ah.match(al)!==null)}catch(am){E.error("Invalid regex in condition: "+ag)}return ai};n.notmatch=function(ag,e){return !n.match(ag,e)};var u={lessthan:"<",lt:"<",lessthanequal:"<=",lte:"<=",greaterthan:">",gt:">",greaterthanequal:">=",gte:">=",eq:"=",not:"!="};var w=function(ag,ah){if(p.cfgAliasNames[ah]){ah=p.cfgAliasNames[ah]}var e=p.cfg[ah];if(e==b){e=""}if(!p.hasImageParameterConditions){p.hasImageParameterConditions=(T[ah]!==b)}return D(ag,ah,e)};var H=function(ai,aj){var e=false;var ah;var ag=ai.getAttribute("value");switch(aj){case"@mobile":ag=p.makeBool(ag,true);ah=a.isMobileDevice;break;case"@devicepixelratio":ah=a.getDevicePixelRatio();break;case"@navigatoruseragent":ah=navigator.userAgent;break;case"@navigatorlanguage":ah=navigator.language;break;case"@navigatorplatform":ah=navigator.platform;break}if(ah!==b){if(typeof(ag)!=="string"){ag=""+ag}if(typeof(ah)!=="string"){ah=""+ah}e=D(ai,aj,ah,ag)}return e};var D=function(ai,ah,ak,aj){var am;var ag=ai.getAttribute("operator");if(typeof(ag)!=="string"){ag="="}ag=ag.toLowerCase();if(u[ag]){ag=u[ag]}if(n[ag]===b){ag="="}if(aj===b){aj=ai.getAttribute("value")}if(aj===null){aj=""}var e=n[ag];if(ag.match(/[<,>]+/)){var an=function(ao){ao=parseFloat(ao);if(isNaN(ao)){am=false}return ao};ak=an(ak);aj=an(aj)}else{ak=decodeURIComponent(ak)}if(am===b){am=e(ak,aj)}if(E.on){E.log("Evaluating condition: "+ah+": "+ak+" "+ag+" "+aj+" => "+am)}if(am===true){if(ai._myTagName!==b){var al={};al.nodeType=1;al.tagName=ai._myTagName;al.childNodes=[ai];ai=al}p.parseConfig(ai,ai)}return am};var T={fpxsrc:"source",headers:"headers",croprect:"rect",fpxservertemplate:"renderer",quality:"quality",effects:"effects",imageformat:"format",imagecolorspace:"colorspace",imageencoding:"encoding",imagemaxcolors:"maxcolors",imagebackgroundcolor:"backgroundcolor",imageditherer:"ditherer",imagequantizer:"quantizer",referencewidth:"referencewidth",referenceheight:"referenceheight",pixelrange:"pixelrange",imagedpi:"dpi"};var U={headers:"headers",fpxservertemplate:"renderer",quality:"quality",effects:"effects",imageformat:"format",imagecolorspace:"colorspace",imageencoding:"encoding",imagemaxcolors:"maxcolors",imagebackgroundcolor:"backgroundcolor",imageditherer:"ditherer",imagequantizer:"quantizer",imagedpi:"dpi"};var S;var N=function(){if(S===b){S={};for(var e in T){S[T[e]]=e}}return S};var s=function(aj,ai,ah){if(ah===b){ah=""}var al=ah+"left";if(aj[al]===b){return}var ak=ah+"top";var ag=ah+"right";var e=ah+"bottom";if(ai==="pixelrange"){aj[ag]=aj[ag]-aj[al];aj[e]=aj[e]-aj[ak]}aj[ai]=aj[al]+","+aj[ak]+","+aj[ag]+","+aj[e];if(aj[al]){delete aj[al]}if(aj[ak]){delete aj[ak]}if(aj[ag]){delete aj[ag]}if(aj[e]){delete aj[e]}};var ad=this.mapImageParametersToViewer=function(e){s(e,"rect");s(e,"pixelrange","pixel");var ag=N();e=X(e,N())};var ac=this.mapImageParametersToServer=function(e){X(e,T)};var X=function(ag,e){for(var ah in ag){if(e[ah]&&ah!==e[ah]){ag[e[ah]]=ag[ah];delete ag[ah]}}};this.reWriteImageURLByConditions=function(am){if(p.arConditions.length<1){return am}if(typeof(am)!=="string"||am.length<1){return am}var ah=am.indexOf("?");if(ah===-1){return am}var ag=p.clone();var aj={};p.parseQuery(am,aj);ad(aj);p.evaluateQuery(aj,ag.cfg);var e=ag.evaluateConditions();if(!e){return am}var al;for(al in aj){if(ag.cfg[al]!==b){aj[al]=decodeURIComponent(ag.cfg[al])}}for(al in U){if(ag.cfg[al]!==b){aj[al]=decodeURIComponent(ag.cfg[al])}}ac(aj);var ai=am.substr(0,ah);var ak=ai+"?"+p.objectToQuery(aj);return ak};var q=this.applyConditions=function(){if(p.arConditions.length<1){return}if(p.cfgBeforeConditions===b){p.cfgBeforeConditions=a.cloneObject(p.cfg)}p.cfg=p.cfgBeforeConditions;return j()};var aa=0;var j=this.evaluateConditions=function(){if(p.arConditions.length<1){return false}var ag=false;for(var ah=aa;ah<p.arConditions.length;ah++){var ai=p.arConditions[ah];if(ai.fsiConfigEvaluated){continue}aa++;var aj=ai.getAttribute("parameter");if(typeof(aj)==="string"){aj=aj.toLowerCase();var e;if(aj.charAt(0)==="@"){e=H(ai,aj)}else{e=w(ai,aj)}if(!ag&&e){ag=e}}}return ag};var P=function(){q();p.serverProfile=p.cfg.fpxservertemplate;p.serverProfileDoublePage=p.cfg.fpxservertemplatedoublepage;if(p.serverProfileDoublePage==b){p.serverProfileDoublePage="doublepage"}p.serverBase=p.cfg.fpxserver;if(p.serverBase==b){E.warn("PLEASE NOTE: Parameter 'imageserver' undefined, deriving server location from viewer location ("+p.locationFSIViewer+")");var ag;ag=p.locationFSIViewer.indexOf("/users/");if(ag!=-1){p.serverBase=p.locationFSIViewer.substring(0,ag)+"/server"}else{ag=p.locationFSIViewer.indexOf("/viewer/");p.serverBase=p.locationFSIViewer.substring(0,ag)+"/server"}E.log("Derived server location is: ["+p.serverBase+"]")}p.requestBase=p.serverBase;V={};var e=p.cfg;for(var ah in U){if(e[ah]!==b){V[ah]=e[ah]}}if(V.fpxsrc!==b){V.fpxsrc=decodeURIComponent(V.fpxsrc)}e=p.cfg.effects;if(e!=b){p.cfg.effectsUnFiltered=e;p.cfg.effects=e=m(e)}if(e!=b){V.effects=e}e=p.cfg.lefteffects;if(e!=b){V.lefteffects=e}e=p.cfg.righteffects;if(e!=b){V.righteffects=e}};this.getAreaEffects=function(){return"BLUR,DISTORT,EMBOSS,FLIP,GLOW,GRADIENTMAP,LINEARGRADIENT,PAD,PIXELIZE,SHARPEN"};this.setEffectsFilterArea=function(){p.setEffectsFilter(p.getAreaEffects())};this.setEffectsFilter=function(ai){if(typeof(ai)!=="string"||ai.length<1){Q=false;return}ai=a.trim(ai);var ag=ai.split(",");for(var ah=0;ah<ag.length;ah++){ag[ah]=a.escapeRegEx(ag[ah])}var e="(^|[=,]+)("+ag.join("|")+")\\([^)]*\\)";Q=new RegExp(e,"ig")};var m=function(e){if(Q===false){return e}return e.replace(Q,"")};var l=function(){for(var ag in p.plugins){var ah=ag.toLowerCase();var e=p.makeBool(p.cfg[ah],true);if(!e){p.plugins[ag]=b}}};this.finalCheck=function(){p.elevateToHTTPS();l();P();p.dumpConfig();if(z.onConfigsReady){z.onConfigsReady()}};this.dumpConfig=function(ah){if(!ah){ah=E}if(ah.on){if(p.cfg.fpxsrc!==b){p.cfg["fpxsrc (decoded)"]=decodeURIComponent(p.cfg.fpxsrc)}ah.info("Evaluated Configuration:",K(p.cfg));if(p.queryParameters){ah.info("Parameters:",K(p.queryParameters))}if(W){ah.info("Class <"+v+"> Configuration:",K(W))}var ag=p.getPluginsAndParameters();var e=ag.data;if(ag.count===0){e="No active plugins."}ah.info("Plugin Configuration:",K(e))}};var K=function(ah){var e="--- none ---";if(typeof(ah)!=="object"){return e}for(var ag in ah){e=ah;break}return e};this.getPluginsAndParameters=function(){var e={};var ah=0;for(var ag in p.plugins){if(p.hasPlugin(ag)){e[ag]=L(ag);ah++}}return{count:ah,data:e}};var F=this.addQueryParameterToURL=function(ai,e,ah){var ag=ai.lastIndexOf("?");if(ag===-1){ai+="?"}else{if(ag!==ai.length-1){ai+="&"}}return ai+encodeURIComponent(e)+"="+encodeURIComponent(ah)};var ae=p.finishURL=function(e){if(y){e=F(e,x,y)}if(!R||e==b){return e}var ag;if(C===false){ag="cache=0&cachernd="+t;if(e.indexOf("?")==-1){e+="?"+ag}else{e+="&"+ag}}else{ag=C;if(e.indexOf("?")==-1){e+="?"+ag}else{e+=ag}}return e};this.addURLParameters=function(ag,ah){if(!ag||!ah){return ag}var e=[];for(var ai in ah){e.push(encodeURIComponent(ai)+"="+encodeURIComponent(ah[ai]))}if(e.length>0){if(ag.indexOf("?")==-1){ag+="?"}else{ag+="&"}ag+=e.join("&")}return ag};this.finishRequestParams=function(ag){if(R){if(C===false){ag.cache=0;ag.cachernd=t}else{for(var e in A){ag[e]=A[e]}}}};this.addNoCacheParams=function(e){e.cache=0;e.cachernd=t};this.parseQuery=function(ag,e){if(e==b||ag==b||ag.length<1){return}p.queryToObject(ag,e);if(e.ignorequeryparameters!=b){delete e.ignorequeryparameters}if(e.enableconfigcachingparameter!=b){delete e.enableconfigcachingparameter}};this.cloneParameters=function(e,ag){if(e==b||ag==b){E.error("Cloning object failed: "+e+" / "+ag)}for(var ah in e){ag[ah]=e[ah]}};this.getFSIPath=function(e,ag){if(ag.indexOf("//")!=-1){return ag}if(p.cfg.fsibase!=b){ag=p.cfg.fsibase+ag}return p.getReloadPath(e,ag)};this.expandFSIPath=function(ag){if(ag==b){return ag}var e=a.urlDecode(ag);if(e.indexOf("?")!=-1||e.indexOf(p.strConfigFileExtension)==(e.length-4)){return ag}return ag+p.strConfigFileExtension};this.getReloadPath=function(ai,ak){var ag,al,e,aj;if(ai==b){ai=p.locationFSIViewer}if(ak==b){ak=""}var ah="/";if(ak.indexOf("//")!=-1){return ak}ag=ai;aj=ag.lastIndexOf("?");if(aj==-1){aj=ag.length}al=ag.lastIndexOf("\\",aj);e=ag.lastIndexOf("/",aj);al=Math.max(al,e);if(al==-1){al=ag.length-1}ag=ag.slice(0,al);if(ag.length>0&&ak.indexOf(ah)!=0){ag+=ah}return ag+ak};this.cloneValueObject=function(ag){var e={};for(var ah in ag){e[ah]=ag[ah]}return e};this._getXMLConfigValue=function(e){var ag;if(!e){return}if(e.childNodes.length>0){ag=p._XMLChildNodesToString(e)}else{ag=e.getAttribute("value")}return ag};this._XMLChildNodesToString=function(ai){if(!ai||!ai.firstChild){return""}var ag="";var ah;try{if(ai.xml!=b){for(ah=0;ah<ai.childNodes.length;ah++){ag+=ai.childNodes[ah].xml}}else{for(ah=0;ah<ai.childNodes.length;ah++){ag+=p.XMLSerializer.serializeToString(ai.childNodes[ah])}}}catch(aj){}return ag};this._findFirstXMLNode=function(ah,ai){var ag,e;while(ah){if(ah.nodeName==ai){e=ah;break}ag=ah.firstChild;if(!ag){ag=ah.nextSibling}if(!ag&&ah.parentNode){ag=ah.parentNode.nextSibling}ah=ag}return e};this._parseXMLImageList=function(ag){var e=p._findFirstXMLNode(ag,"images");if(!e){e=p._findFirstXMLNode(ag,"images3d")}return p.parseXMLImageListNode(e)};this._parseXMLImageListNode=function(aj){var am={};var e=am.arImages=[];var ai="";var ak="";var ah;if(!aj){return am}var ag;ag=p.getAttributeValue(aj,"prefix");if(typeof(ag)=="string"){ai=ag}ag=p.getAttributeValue(aj,"suffix");if(typeof(ag)=="string"){ak=ag}aj=p._findFirstXMLNode(aj,"image");if(!aj){return am}while(aj){if(aj.nodeType==1){ah=p._findFirstXMLNode(aj,"path");var al=p._getXMLConfigValue(ah);if(!al){al=a.urlDecode(p.getAttributeValue(aj,"src"))}if(!al){al=a.urlDecode(p.getAttributeValue(aj,"file"))}if(al!=b){e.push(ai+al+ak)}if(am.width==b){ah=p._findFirstXMLNode(aj,"width");ah=p._getXMLConfigValue(ah);if(ah!=b){am.width=parseInt(ah)}ah=p._findFirstXMLNode(aj,"height");ah=p._getXMLConfigValue(ah);if(ah!=b){am.height=parseInt(ah)}}}aj=aj.nextSibling}return am};this.getImageList=function(){var e,ai;if(p.cfg&&p.cfg.fpxsources!=b){var ah=p.cfg.fpxsources;if(typeof(ah)=="string"||(typeof(ah)=="object")&&typeof(ah.push)=="function"){e={};e.oXML=null;if(typeof(ah)=="string"){e.arImages=ah.split(",");for(ai=0;ai<e.arImages.length;ai++){e.arImages[ai]=a.urlDecode(e.arImages[ai])}}else{e.arImages=ah}return e}}if(p.arUnrecognizedConfigNodes&&p.arUnrecognizedConfigNodes.length>0){var ag=p.arUnrecognizedConfigNodes;for(ai=0;ai<ag.length;ai++){var aj=ag[ai];if(typeof(aj.nodeName)=="string"){var ak=aj.nodeName.toLowerCase();if(ak=="images"||ak=="images3d"){if(E.on){E.log("Reading image list from XML node: <"+aj.nodeName+">")}e=p._parseXMLImageListNode(aj);e.oXML=aj;break}}}}if(p.cfg&&p.cfg.fpxsrc!=b){e={};e.oXML=null;e.arImages=[];e.arImages.push(a.urlDecode(p.cfg.fpxsrc));return e}return e};this.getServerBase=function(){return p.serverBase};this.loadImageList=function(ai,aj,al,ak){if(!p.serverBase||!ai){aj([],b,ak);return false}var ah=p.serverBase+"?type=list";if(ai.indexOf("tpl")==-1){var ag=p.cfg.listtemplate;if(ag&&ag.length>0&&ag.indexOf(".json")==-1&&ag.indexOf(".xml")==-1){ag+=".json"}ah+="&tpl="+ag}if(p.cfg.headers&&p.cfg.headers.length>0&&A.headers==b){ah+="&headers="+p.cfg.headers}ah+="&source="+encodeURIComponent(ai);if(al!=b){ah+=al}ah=ae(ah);var e=p.loadFile(ah,function(am,ap){if(typeof(ap)=="object"&&typeof(ap.images)=="object"){ap.images.pop();var aq="";if(ap&&ap.imagesattributes&&ap.imagesattributes.dir){aq=ap.imagesattributes.dir}var an=new Array(ap.images.length);for(var ao=0;ao<ap.images.length;ao++){an[ao]=aq+ap.images[ao].src}aj(an,ap,ak)}else{aj([],ap,ak)}},"application/json",ak);return e};this.traceConfigValue=function(e,ai){if(typeof(e)!=="string"){return false}e=a.trim(e);if(e.length<1){return false}var ag=e.toLowerCase();if(ag.indexOf(".")!==-1){ag=ag.split(".").join("")}if(ag.indexOf("/")!==-1){ag=ag.split("/").join("")}if(ag.indexOf(" ")!==-1){ag=ag.split(" ").join("")}var ah=new a.Debugger();ah.setPrefix("");ah.group('Tracing parameter "'+e+'"');var aj=function(){var ak=e;var ap=p.getParameterAlias(ag);if(typeof(ap)==="string"){ak+=" (alias: "+ap+")";if(typeof(p.cfgAliasNames[ag])==="string"){ag=p.cfgAliasNames[ag]}}var al=p.cfg[ag];var ao=true;if(ag.indexOf("_")!==-1){var an=ag.split("_");var am=an.shift();var aq=an.join("_");if(p.hasPlugin(am)){al=p.getPluginParameter(am,aq)}}else{if(p.hasPlugin(ag)){ao=false;al="is enabled."}}if(al===b){ao=false;al="is undefined (default value applies)"}if(ao){al='= "'+al+'"'}ah.group("RESULT:");ah.log(ak+" "+al);ah.groupEnd();ah.groupEnd()};z={onConfigsReady:aj};g.strTraceParam=ag;g.bNoDebug=true;p.iTraceParameterDebug=ah;p.init(ai);p.loadConfigs();return""};this.loadLanguageFile=function(e,aq,aj,ah){var ak=arguments;var al,ao;if(typeof(aq)!=="string"||p.makeBool(aq,true)==false){return aj.call(p,{},"")}var ap=function(ar){try{a.oLanguageMap=JSON.parse(ar.responseText)}catch(at){a.oLanguageMap={"default":"english"}}p.loadLanguageFile.apply(this,ak)};var am=function(ar,av){e.urlLanguageCurrentLoaded=al;var au=e.oLanguageData={};if(av){var at=p.findXMLNode(av,"data");if(at){at=p.findXMLNode(at,"tip")}while(at){if(at.nodeType===1){var aw=at.getAttribute("id");au[aw]=p.XMLChildNodesToString(at)}at=at.nextSibling}}aj.call(p,e.oLanguageData,ao)};if(aq.toLowerCase()==="auto"){if(!a.oLanguageMap){p.loadFile(a._FSIViewerLocation+"/languages/mapping.json",ap,"application/json");return}if(a.oLanguageMap._current!==b){aq=a.oLanguageMap._current}else{aq=a.oLanguageMap["default"];var ai=navigator.language;if(typeof(ai)==="string"){ai=ai.toLowerCase()}if(a.oLanguageMap[ai]!=b){aq=a.oLanguageMap[ai]}else{if(ai.indexOf("-")!=-1){ai=ai.split("-")[0];if(a.oLanguageMap[ai]!=b){aq=a.oLanguageMap[ai]}}}}if(aq==b){return aj.call(p,{},"")}if(ah){ah.log('Automatically choosing language "'+aq+'" from navigator.language "'+navigator.language+'"')}a.oLanguageMap._current=aq}var an=aq+".xml";var ag=a._FSIViewerLocation+"/languages/"+an;if(ag!==e.urlLanguageCurrentLoaded){ao=aq;al=ag;if(ah){ah.log("Loading language file: "+ag)}p.loadFile(ag,am,"application/xml")}else{aj.call(p,e.oLanguageData,ao)}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomEventListener!=b){return}a.CustomEventListener=function(j){var l=this;var d=[];var g={};var h={};var i=0;l._strClassName="$FSI.CustomEventListener";var k=function(){if(a.eventFunctionID==b){a.eventFunctionID=0}if(a.eventElementID==b){a.eventElementID=0}};this.destroy=function(){for(var m=0;m<d.length;m++){var n=d[m];f(n.element,n.fn)}d=[];g={};h={};l.onDestroy()};this.fireEvent=function(m,n){if(!m||!m.enabled){return false}if(typeof(n)!="object"){n={}}if(m.paused){n.FSI_paused=true}n.FSI_custom_event=true;n.FSI_type=j;n.FSI_target=m.element;return m.fn.call(m.element,n)};this.fireEvents=function(n){if(typeof(n)!="object"){n={}}n.FSI_custom_event=true;n.FSI_type=j;for(var o=0;o<d.length;o++){var m=d[o];if(m.enabled){if(m.paused){n.FSI_paused=true}else{if(n.FSI_paused){delete n.FSI_paused}}n.FSI_target=m.element;m.fn.call(m.element,n)}}};var c=this.addListener=function(q,p){if(typeof(q)!="object"||typeof(p)!="function"){a.console.error(l._strClassName+": Invalid parameters for addListener");return}if(q.__FSI==b){q.__FSI={}}if(q.__FSI.eventElementID==b){q.__FSI.eventElementListenerCount=1;q.__FSI.eventElementID=a.eventElementID++}else{q.__FSI.eventElementListenerCount++}if(p.__FSIEventFunctionID==b){p.__FSIEventFunctionListenerCount=1;p.__FSIEventFunctionID=a.eventFunctionID++}else{p.__FSIEventFunctionListenerCount++}var n=q.__FSI.eventElementID;var o=p.__FSIEventFunctionID;if(g[n]==b){var m=g[n]={};m.nFunction=0;m.oFunctions={}}if(g[n].oFunctions[o]==b){g[n].nFunction++;g[n].oFunctions[o]=[]}else{a.console.warn(l._strClassName+": There is already a listener for this exact element and function");a.console.log(q);a.console.log(p)}var r={};r.element=q;r.elementID=n;r.fn=p;r.fnID=o;r.instanceListener=l;r.enabled=true;r.paused=false;r.uniqueID=i++;g[n].oFunctions[o].push(r);d.push(r);h[r.uniqueID]=r;l._onListenerAdd(r);l._onListenerCountChange(d.length);return r};this.setListenerProps=function(p,n,o){var m=h[p];if(!m){return false}if(m.props==b){m.props={}}m.props[n]=o;return true};this.enableListener=function(o,n){var m=h[o];if(m==b||m.enabled==n){return}m.enabled=n};this.pauseListener=function(o,n){var m=h[o];if(m==b||m.paused==n){return}m.paused=n};var f=this.removeListener=function(q,p){if(typeof(q)!="object"||typeof(p)!="function"){a.console.error(l._strClassName+": Invalid parameters for removeListener");return}if(q.__FSI==b||q.__FSI.eventElementID==b||p.__FSIEventFunctionID==b){if(p.__FSIEventFunctionID==b){a.console.error(l._strClassName+": Function not registered for listener in removeListener")}else{a.console.error(l._strClassName+": Element not registered for listener in removeListener")}return}var m=q.__FSI.eventElementID;var o=p.__FSIEventFunctionID;if(!g[m]){a.console.error(l._strClassName+": No registered listener for this element in removeListener");return}var n=g[m].oFunctions[o];if(n==b||typeof(n.pop)!="function"){a.console.error(l._strClassName+": No registered listener for this function in removeListener");return}var r=n.pop();r.fn.__FSIEventFunctionListenerCount--;r.element.__FSI.eventElementListenerCount--;if(r.element.__FSI.eventElementListenerCount==0){delete r.element.__FSI.eventElementListenerCount;delete r.element.__FSI.eventElementID}if(r.fn.__FSIEventFunctionListenerCount==0){delete r.fn.__FSIEventFunctionListenerCount;delete r.fn.__FSIEventFunctionID}if(n.length==0){delete g[m].oFunctions[o];g[m].nFunction--;if(g[m].nFunction==0){delete g[m]}}delete h[r.uniqueID];e();l._onListenerRemove(r);l._onListenerCountChange(d.length);return r};this.getEventListenerByID=function(m){return h[m]};this.getListenerObjectByID=function(m){return h[m]};this.getListenersArray=function(){return d};this.getListenerCount=function(){return d.length};var e=function(){d=[];for(var n in g){var p=g[n].oFunctions;for(var o in p){var m=p[o];d=d.concat(m)}}};this.dump=function(){a.console.dir(g);a.console.dir(d)};this._onListenerCountChange=function(m){};this._onListenerAdd=function(n,m){};this._onListenerRemove=function(n,m){};this.triggerEvent=function(m){};this.triggerEvents=function(){};this.setListenerProps=function(o,m,n){};this.onDestroy=function(){};k()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomEventListenerElementDimension!=b){return}a.CustomEventListenerElementDimension=a.oCustomEventListenerClasses.FSIElementDimension=function(){var o=this;var k=25;var e;var d=0;var f={};f[0]=25;f[25]=50;f[50]=100;f[75]=250;var l=76;var g;var j=typeof(ResizeObserver)=="function";a.CustomEventListener.prototype.constructor.call(o,"FSIElementDimension");o._strClassName="$FSI.CustomEventListenerElementDimension";this._onListenerCountChange=function(p){if(j){return}if(p<1){clearInterval(e);e=b}else{if(e==b){e=setInterval(n,f[0])}}};var c=function(r,q){for(var p=0;p<r.length;p++){i(r[p])}};var i=function(q){var p=o.getEventListenerByID(q.target.__FSI.idListener);if(p.__elementWidth!=p.element.offsetWidth||p.__elementHeight!=p.element.offsetHeight){m(p,false);if(p.tresholdEnd>0){if(p.timeoutTreshold!=b){clearTimeout(p.timeoutTreshold)}if(p.skiptreshold){p.treshold=p.tresholdEnd;p.skiptreshold=false;m(p,true)}else{p.timeoutTreshold=setTimeout(function(){p.treshold=p.tresholdEnd;p.timeoutTreshold=b;m(p,true)},p.tresholdEnd)}}}};this._onListenerRemove=function(p){if(g){g.unobserve(p.element)}if(p.timeoutTreshold!=b){clearTimeout(p.timeoutTreshold)}};this._onListenerAdd=function(p){p.__elementWidth=p.element.offsetWidth;p.__elementHeight=p.element.offsetHeight;if(j){if(g==b){g=new ResizeObserver(c)}p.element.__FSI.idListener=p.uniqueID;g.observe(p.element)}};this.setListenerProps=function(s,q,r){if(typeof(q)!="string"){return false}var p=o.getListenerObjectByID(s);if(!p){return false}switch(q){case"treshold":if(r&&r>0){p.tresholdEnd=r}break;case"skiptreshold":p.skiptreshold=r;h(15);break;case"fireTresholdEventOnly":p.fireTresholdEventOnly=r;break}};var n=function(){var r=o.getListenersArray();var v=false;var q=false;for(var u=0;u<r.length;u++){var p=r[u];if(p.__elementWidth!=p.element.offsetWidth||p.__elementHeight!=p.element.offsetHeight){v=true;if(p.tresholdEnd){p.treshold=k}m(p,false)}else{if(p.treshold>0){p.treshold+=k;if(p.skiptreshold){q=true;p.treshold=p.tresholdEnd}if(p.treshold>=p.tresholdEnd){p.skiptreshold=false;m(p,true);p.treshold=0}}}}if(!q){if(v){d=0;h(f[0])}else{if(d<l){d++;var s=f[d];if(s!=b){h(s)}}}}};var h=function(p){if(p==k||e==b){return}k=p;clearInterval(e);e=setInterval(n,k)};var m=function(p,r){var q={};if(r){q.FSI_after_treshold=p.treshold}q.FSI_target=p.element;q.FSI_dimension_old={width:p.__elementWidth,height:p.__elementHeight};p.__elementWidth=p.element.offsetWidth;p.__elementHeight=p.element.offsetHeight;q.FSI_dimension={width:p.__elementWidth,height:p.__elementHeight};if(r||!p.fireTresholdEventOnly){o.fireEvent(p,q)}};this.triggerEvent=function(q){var p=o.getEventListenerByID(q);if(!p){return}if(p.tresholdEnd){p.treshold=1}m(p)};this.triggerEvents=function(){var p=o.getListenersArray();for(var q=0;q<p.length;q++){if(p[q].tresholdEnd){p[q].treshold=1}m(p[q])}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Easing!=b){return}a.Easing={easeInQuad:function(f,g,e,h){return h*(f/=g)*f+e},easeOutQuad:function(f,g,e,h){return -h*(f/=g)*(f-2)+e},easeInOutQuad:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f+e}return -h/2*((--f)*(f-2)-1)+e},easeInCubic:function(f,g,e,h){return h*(f/=g)*f*f+e},easeOutCubic:function(f,g,e,h){return h*((f=f/g-1)*f*f+1)+e},easeInOutCubic:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f+e}return h/2*((f-=2)*f*f+2)+e},easeInQuart:function(f,g,e,h){return h*(f/=g)*f*f*f+e},easeOutQuart:function(f,g,e,h){return -h*((f=f/g-1)*f*f*f-1)+e},easeInOutQuart:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f*f+e}return -h/2*((f-=2)*f*f*f-2)+e},easeInQuint:function(f,g,e,h){return h*(f/=g)*f*f*f*f+e},easeOutQuint:function(f,g,e,h){return h*((f=f/g-1)*f*f*f*f+1)+e},easeInOutQuint:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f*f*f+e}return h/2*((f-=2)*f*f*f*f+2)+e},easeInSine:function(f,g,e,h){return -h*Math.cos(f/g*(Math.PI/2))+h+e},easeOutSine:function(f,g,e,h){return h*Math.sin(f/g*(Math.PI/2))+e},easeInOutSine:function(f,g,e,h){return -h/2*(Math.cos(Math.PI*f/g)-1)+e},easeInExpo:function(f,g,e,h){return(f==0)?e:h*Math.pow(2,10*(f/g-1))+e},easeOutExpo:function(f,g,e,h){return(f==g)?e+h:h*(-Math.pow(2,-10*f/g)+1)+e},easeInOutExpo:function(f,g,e,h){if(f==0){return e}if(f==g){return e+h}if((f/=g/2)<1){return h/2*Math.pow(2,10*(f-1))+e}return h/2*(-Math.pow(2,-10*--f)+2)+e},easeInCirc:function(f,g,e,h){return -h*(Math.sqrt(1-(f/=g)*f)-1)+e},easeOutCirc:function(f,g,e,h){return h*Math.sqrt(1-(f=f/g-1)*f)+e},easeInOutCirc:function(f,g,e,h){if((f/=g/2)<1){return -h/2*(Math.sqrt(1-f*f)-1)+e}return h/2*(Math.sqrt(1-(f-=2)*f)+1)+e},easeInElastic:function(g,j,e,k){var h=1.70158;var i=0;var f=k;if(g==0){return e}if((g/=j)==1){return e+k}if(!i){i=j*0.3}if(f<Math.abs(k)){f=k;var h=i/4}else{var h=i/(2*Math.PI)*Math.asin(k/f)}return -(f*Math.pow(2,10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i))+e},easeOutElastic:function(g,j,e,k){var h=1.70158;var i=0;var f=k;if(g==0){return e}if((g/=j)==1){return e+k}if(!i){i=j*0.3}if(f<Math.abs(k)){f=k;var h=i/4}else{var h=i/(2*Math.PI)*Math.asin(k/f)}return f*Math.pow(2,-10*g)*Math.sin((g*j-h)*(2*Math.PI)/i)+k+e},easeInOutElastic:function(g,j,e,k){var h=1.70158;var i=0;var f=k;if(g==0){return e}if((g/=j/2)==2){return e+k}if(!i){i=j*(0.3*1.5)}if(f<Math.abs(k)){f=k;var h=i/4}else{var h=i/(2*Math.PI)*Math.asin(k/f)}if(g<1){return -0.5*(f*Math.pow(2,10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i))+e}return f*Math.pow(2,-10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i)*0.5+k+e},easeInBack:function(f,h,e,i,g){if(g==b){g=1.70158}return i*(f/=h)*f*((g+1)*f-g)+e},easeOutBack:function(f,h,e,i,g){if(g==b){g=1.70158}return i*((f=f/h-1)*f*((g+1)*f+g)+1)+e},easeInOutBack:function(f,h,e,i,g){if(g==b){g=1.70158}if((f/=h/2)<1){return i/2*(f*f*(((g*=(1.525))+1)*f-g))+e}return i/2*((f-=2)*f*(((g*=(1.525))+1)*f+g)+2)+e},easeOutBounce:function(f,g,e,h){if((f/=g)<(1/2.75)){return h*(7.5625*f*f)+e}else{if(f<(2/2.75)){return h*(7.5625*(f-=(1.5/2.75))*f+0.75)+e}else{if(f<(2.5/2.75)){return h*(7.5625*(f-=(2.25/2.75))*f+0.9375)+e}else{return h*(7.5625*(f-=(2.625/2.75))*f+0.984375)+e}}}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.TouchHandler!=b){return}a.TouchHandler=function(n,aY,am,e,aO){var aF=this;var aM=false;var al=true;var p=false;var aU=false;var aL=false;var aC,F,j,ae;var aD,Z,aJ;var h=false;var af;var s;var a1={};var ar=[];var ad=0;var J=window;var aW;var t;var aV;var d;var a0=[];var aS={x:0,y:0};var w={x:0,y:0};var at=40;var o={};o.enabled=false;o.factor=5;o.fEndDiff=1;var az={};az.enabled=false;az.minFrames=14;az.factorAmount=23;az.factorAmountQuad=0;az.factorFrames=2.6;az.offsetFrames=5;var ac;var aA;var aI,x,l;var G;var au={};var Y;var aN=false;var A=false;var an={};an.name="none";var O;var X;var aP;var f=false;var aa={};if(!aY||typeof(aY)!="object"){aY={}}var ao=function(){var a7;if(aM){aF.destroy()}aV=B;t=b;if(a.topWindow!=window){t=a.topWindow;try{var a6=a.getWindowOffset(window);if(a6.x!=b&&a6.y!=b){aV=aq}}catch(a5){aV=B;t=b}}else{t=b}G=aY.oPassTrough;aX(aY.panDirectionAllowed,true);if(aY.getPageCoords){s=aG}else{s=N}if(aY.afterTouch){for(a7 in aY.afterTouch){az[a7]=aY.afterTouch[a7]}}if(az.minDelta==b){az.minDelta=15}if(aY.nClickRadius){ac=aY.nClickRadius}else{ac=10}if(az.fnStartStopAfterTouch&&typeof(az.fnStartStopAfterTouch)!="function"){az.fnStartStopAfterTouch=b}if(az.fnStartStopAfterTouch){az.useAnimationFrame=b}if(typeof(az.modifyTarget)!="function"){az.modifyTarget=b}if(typeof(az.fnGetAfterTouchEnabled)=="function"){aA=az.fnGetAfterTouchEnabled}else{aA=b}if(aY.smoothing){for(a7 in aY.smoothing){o[a7]=aY.smoothing[a7]}}if(aY.detectClick==true){Y=true}if(aY.preventSelection!==false){aY.preventSelection=true}if(!n){return}if(typeof(n.join)!="function"){n=[n]}if(typeof(am)!="function"){am=B}if(typeof(e)!="function"){e=B}if(typeof(aO)!="function"){aO=B}if(typeof(aY.onPinchChange)=="function"){O=aY.onPinchChange}else{O=b}aN=aY.detectGestures;a0=[];ay(true,aN);for(var a4=0;a4<n.length;a4++){var a3=n[a4];if(a3&&typeof(a3.nodeName)!="undefined"){a7={};a7.element=a3;a0.push(a7);ap(a3,S);if(a.isTouch){try{if(a3.style!=b){if(a.BrowserSupports.cssTouchAction()){if(au.cssTouchAction!=b){r(a3,au.cssTouchAction)}}}}catch(a5){}}}}if(a.mobileOS=="ios"&&a.isEventSupported("touchforcechange")){a.addEvent(window,"touchforcechange",aE,false)}};var aX=this.setAllowedPanDirection=function(a4,a3){if(typeof(a4)=="string"){if(a4=="pan-x"||a4=="pan-y"||a4=="pan-x pan-y"){aW=a4+" "}else{aW=""}}else{aW=""}if(!a3){au.nCheck=b;ai(au.captureScroll,au.capturePinch)}};this.enable=function(a3){if(al==a3){return}if(!a3){R();ai(false,false)}else{ai(au.captureScrollUser,au.capturePinchUser)}al=a3};this.getEnabled=function(){return al};this.cancel=function(){Q();ah();aK();R()};var aK=function(){if(o.enabled){i()}C()};this.cancelAfterTouch=function(){C()};this.getInitialDownEvent=function(){return X};var R=function(){if(!p){return}aK();p=false;X=b;A=false;if(ad==0){aQ()}};var aQ=function(){f=false;c()};this.destroy=function(){if(a.mobileOS=="ios"&&a.isEventSupported("touchforcechange")){a.removeEvent(window,"touchforcechange",aE,false)}if(aP){clearTimeout(aP)}aF.cancel();var a3;for(var a4=0;a4<a0.length;a4++){var a5=a0[a4];a3=a5.element;y(a3,S)}au={}};var r=function(a3,a4){if(!a.BrowserSupports.cssTouchAction()||!a3||!a3.style){return}a3.style.touchAction=a3.style.msTouchAction=a4};var U=function(a3){if(a3.preventDefault){a3.preventDefault()}};var m=function(a3){U(a3);return false};var ap=function(a4,a3){a.addEvent(a4,"dragstart",m);if(aY.bMouseOnly){if(a.isEventSupported("pointerdown")){a.addEvent(a4,"pointerdown",a3)}else{a.addEvent(a4,"mousedown",a3)}return}if(a.isEventSupported("touchstart")&&!a.isInternetExplorer){a.addEvent(a4,"touchstart",a3);a.addEvent(a4,"mousedown",a3)}else{if(a.isEventSupported("pointerdown")){a.addEvent(a4,"pointerdown",a3)}else{if(a.isEventSupported("MSPointerDown")){a.addEvent(a4,"MSPointerDown",a3)}a.addEvent(a4,"mousedown",a3)}}if(a.isEventSupported("MSHoldVisual")){a.addEvent(a4,"MSHoldVisual",a.preventDefaultEvent)}};var y=function(a4,a3){a.removeEvent(a4,"dragstart",m);if(aY.bMouseOnly){if(a.isEventSupported("pointerdown")){a.removeEvent(a4,"pointerdown",a3)}else{a.removeEvent(a4,"mousedown",a3)}return}if(a.isEventSupported("touchstart")&&!a.isInternetExplorer){a.removeEvent(a4,"touchstart",a3);a.removeEvent(a4,"mousedown",a3)}else{if(a.isEventSupported("pointerdown")){a.removeEvent(a4,"pointerdown",a3)}else{if(a.isEventSupported("MSPointerDown")){a.removeEvent(a4,"MSPointerDown",a3)}a.removeEvent(a4,"mousedown",a3)}}if(a.isEventSupported("MSHoldVisual")){a.removeEvent(a4,"MSHoldVisual",a.preventDefaultEvent)}};var B=function(){return true};var aR=function(a3){if(aL){W(a3,a3.pointerId)}else{var a4=a3.changedTouches;for(var a5=0;a5<a4.length;a5++){W(a4[a5],a4[a5].identifier)}}};var W=function(a3,a5){if(a5==b||a1[a5]!=b){if(aY.debug){if(a5==b){a.console.error("doRegisterPointer: no pointerId")}if(a1[a5]!=b){a.console.error("doRegisterPointer: pointerId already registered: "+a5)}}return}ad++;var a4=a1[a5]={};a4.identifier=a5;s(a4,a3);ar.push(a4)};var ak=function(a3){var a5=false;if(aL){a5=L(a3.pointerId)}else{var a4=a3.changedTouches;if(a4){for(var a6=0;a6<a4.length;a6++){a5=L(a4[a6].identifier)}}}if(a5){ar=new Array(ad);var a8=0;for(var a7 in a1){ar[a8++]=a1[a7]}}};var L=function(a3){if(a3==b||a1[a3]==b){if(aY.debug){if(a3==b){a.console.error("doUnregisterPointer: no pointerId")}if(a1[a3]==b){a.console.error("doUnregisterPointer: pointerId not registered: "+a3)}}return false}delete a1[a3];ad--;return true};var I=function(){ad=0;a1={};ar=[]};var N=function(a4,a3){a4.x=a3.clientX;a4.y=a3.clientY};var aG=function(a4,a3){a4.x=a3.pageX;a4.y=a3.pageY};var v=function(a3){var a4=a3.changedTouches;if(a4){for(var a6=0;a6<a4.length;a6++){var a5=a1[a4[a6].identifier];if(a5){s(a5,a4[a6])}}}if(ar.length>0){aS.x=ar[0].x;aS.y=ar[0].y}};var ax=function(a3){var a4=a1[a3.pointerId];if(a4){s(a4,a3)}if(ar.length>0){aS.x=ar[0].x;aS.y=ar[0].y;aV(a3,aS)}};var V=function(a3){s(aS,a3);aV(a3,aS)};this.getMousePositionFromMouseEvent=function(a3){V(a3);return aS};this.getMousePositionPage=function(a4){var a3={};aG(a3,a4);aV(a4,a3);return a3};this.getMousePositionClient=function(a4){var a3={};N(a3,a4);aV(a4,a3);return a3};var u=function(a3,a4){if(window!=a3.view){var a5=a.getWindowOffset(window);a4.x-=a5.x;a4.y-=a5.y}};var aq=function(a3){try{u(a3);aV=u}catch(a4){aV=B}};var aB=function(a3){if(!al){return}var a5=ad;if(A&&a5==0){A=false}var a6=a3.type;if(p||an.started){if(a6!=aC){if(an.started){Q();ah()}else{a3._FSI_Canceled=true;a2(a3,true)}}}aC=a6;d=false;var a4=true;switch(a6){case"touchstart":aU=true;aL=false;af=v;j="touchmove";F="touchend";ae="touchcancel";aI=false;break;case"MSPointerDown":af=ax;aU=true;aL=true;j="MSPointerDown";F="MSPointerUp";ae="MSPointerCancel";aI=false;d=true;break;case"pointerdown":af=ax;aU=true;aL=true;j="pointermove";F="pointerup";ae="pointercancel";aI=true;d=true;break;default:if(ad>0){I()}aU=false;aL=false;aI=(aY.preventSelection);a4=false;af=V;j="mousemove";F="mouseup";ae=b;d=true}if(aU&&a4){aR(a3)}af(a3);if(!aY.bAllowMouseDown&&aI){U(a3)}if(ad>1){aa.bClick=false}x=false;if(a4&&aj(a3)){if(a5==0){C();E()}return false}return true};this.isPointerDown=function(){return f};this.getPointerCount=function(){return ad};var S=function(a3){if(aY.bMouseOnly&&a3.type==="pointerdown"&&a3.pointerType!=="mouse"){return true}if(!aB(a3)){return}if(p||a3.which>1){return}g(a3)};this.getCurrentPos=function(){return w};var g=function(a3){aK();if(p){return}az.evtMove=b;if(o.enabled){w={x:aS.x,y:aS.y}}else{w=aS}aa.x=aS.x;aa.y=aS.y;var a4=X;X=a3;if(!am.call(J,a3,w,G)){X=a4;return false}p=f=true;if(Y&&!A){aa.bClick=true;aa.clickRadiusX=aa.clickRadiusY=0}else{aa.bClick=false}E();if(az.enabled){az.x=az.y=0;az.lastX=aS.x;az.lastY=aS.y;if(az.nInterval){clearInterval(az.nInterval)}az.nInterval=setInterval(ab,30)}return true};var c=function(){if(h&&Z!=b){var a3={passive:false,capture:false};var a5=(t==b)?a3:b;h=false;a.removeEvent(window,Z,ag,a5);a.removeEvent(window,aD,a2,a5);if(d&&t){try{a.removeEvent(t,Z,ag,a3);a.removeEvent(t,aD,a2,a3)}catch(a4){}}if(aJ!=b){a.removeEvent(window,aJ,av,a5)}Z=aD=aJ=b}};var aE=function(a3){};var E=function(){if(h){c()}h=true;var a3={passive:false,capture:false};var a5=(t==b)?a3:b;Z=j;aD=F;aJ=ae;a.addEvent(window,Z,ag,a5);a.addEvent(window,aD,a2,a5);if(d&&t){try{a.addEvent(t,Z,ag,a3);a.addEvent(t,aD,a2,a3)}catch(a4){}}if(ae!=b){a.addEvent(window,aJ,av,a5)}};var ag=function(a3){af(a3);a3.FSI_start_x=aa.x;a3.FSI_start_y=aa.y;if(az.enabled&&az.evtMove==b){az.evtMove=a3}if(p){if(aa.bClick){aa.clickRadiusX=Math.max(aa.clickRadiusX,Math.abs(aS.x-aa.x));if(aa.clickRadiusX>ac){aa.bClick=false}else{aa.clickRadiusY=Math.max(aa.clickRadiusY,Math.abs(aS.y-aa.y));if(aa.clickRadiusY>ac){aa.bClick=false}}}if(o.enabled){o.evt=a3;aZ()}else{e.call(J,a3,w,G)}}else{if(an.started){if(an.nType==1){aw(a3)}}}if(x&&!a3.FSI_allowEventDefault){U(a3)}};var aw=function(a3){var a4=k();if(!O){return}a3._FSI_PinchDeltaStart=an.nPinchDistance-an.pinchDistanceStart;a3._FSI_PinchDeltaRelative=an.nPinchDistance-an.pinchDistanceLast;a3._FSI_PinchScale=Math.max(at,an.pinchDistanceLast)/an.pinchDistanceStartMaxed;an.pinchDistanceLast=an.nPinchDistance;a3._FSI_PinchDistance=a4;O.call(J,a3,aS,G)};var av=function(a3){if(aU){ak(a3);if(ad<1){if(p){a3._FSI_Canceled=true;a2(a3,true);return}else{R();return}}}af(a3);aj(a3)};var a2=function(a4,a5){var a3=aa.bClick;aa.bClick=false;if(a5){a4._FSI_Canceled=true}if(aU){ak(a4)}if(ad==0){aQ()}af(a4);if(!a5&&aj(a4)){return}aK();if(!a5){if(!p||ad>0){return}}a4.FSI_start_x=aa.x;a4.FSI_start_y=aa.y;var a6=false;if(!a5&&az.enabled){if(aA==b||aA()){a6=T(a4)}}if(a6){R();z(a4)}else{if(Y){a4._FSI_Click=a3}aO.call(J,a4,w,G);if(a4.type=="touchend"){aP=setTimeout(q,1)}R()}U(a4)};var q=function(){R();I();aP=b};var H=function(a3){return ar};var aZ=function(){if(o.animationFrame!=b){return}aT()};var i=function(){if(o.animationFrame==b){return}cancelAnimationFrame(o.animationFrame);o.animationFrame=b};var aT=function(){var a3=Math.abs(w.x-aS.x)+Math.abs(w.y-aS.y);if(a3>o.fEndDiff){w.x+=(aS.x-w.x)/o.factor;w.y+=(aS.y-w.y)/o.factor;o.animationFrame=requestAnimationFrame(aT)}else{w.x=aS.x;w.y=aS.y;o.animationFrame=b}e.call(J,o.evt,w,G)};var T=function(a3){var a4;if(!az.enabled){return false}if(az.running){C()}az.pos=0;var a6=(a3.touches!=b)?1.8:1;if(az.factorAmountQuad){a4=(az.x>0)?1:-1;az.x=az.x+a4*az.x*az.x/az.factorAmountQuad;a4=(az.y>0)?1:-1;az.y=az.y+a4*az.y*az.y/az.factorAmountQuad}var a8=a6*az.factorAmount;az.startX=w.x;az.startY=w.y;var a7={};a7.x=az.startX+a8*az.x;a7.y=az.startY+a8*az.y;if(az.roundTargetPos){a7.x=Math.round(a7.x);a7.y=Math.round(a7.y)}if(az.modifyTarget){a7=az.modifyTarget.call(J,a7,G);if(a7===false){return false}}az.amountX=a7.x-az.startX;az.amountY=a7.y-az.startY;az.amountXABS=Math.abs(az.amountX);az.amountYABS=Math.abs(az.amountY);var a5=(az.amountXABS>az.minDelta||az.amountYABS>az.minDelta);if(a5){a8=az.factorFrames/100;az.frames=az.offsetFrames+Math.round(a8*az.amountXABS+a8*az.amountYABS)}else{if(typeof(aY.onAfterTouchCancel)=="function"){aY.onAfterTouchCancel.call(J,a3,w,G)}}return a5};this.isAfterTouchRunning=function(){return az.running};var z=function(a3){if(typeof(aY.onAfterTouchStart)=="function"){aY.onAfterTouchStart.call(J,a3,w,G)}az.running=true;az.evtUp=a3;if(az.fnStartStopAfterTouch){az.fnStartStopAfterTouch.call(J,true,az.evtMove,G)}else{if(az.useAnimationFrame){az.animationFrameRun=requestAnimationFrame(K)}else{az.intervalRun=setInterval(K,16)}}return true};var aH=function(a4,a3,a6,a5){return a6*((a4=a4/a5-1)*a4*a4+1)+a3};var K=this.runAfterTouch=function(){var a3=false;az.pos++;w.x=aH(az.pos,az.startX,az.amountX,az.frames);w.y=aH(az.pos,az.startY,az.amountY,az.frames);e.call(J,az.evtMove,w,G);if(az.pos===az.frames){C(true)}else{if(az.useAnimationFrame){az.animationFrameRun=requestAnimationFrame(K)}a3=true}return a3};this.enableAfterTouch=function(a3){if(az.enabled==a3){return}if(!a3){C()}az.enabled=a3};var C=function(a3){if(!az.running){return}if(az.fnStartStopAfterTouch){az.fnStartStopAfterTouch.call(J,false,az.evtMove,G)}else{if(az.useAnimationFrame){if(az.animationFrameRun){cancelAnimationFrame(az.animationFrameRun)}}else{if(az.intervalRun){clearInterval(az.intervalRun);az.intervalRun=b}}}if(typeof(aY.onAfterTouchEnd)=="function"){aY.onAfterTouchEnd.call(J,az.evtMove,G)}az.evtMove=b;az.running=false;az.evtUp._FSI_Canceled=(a3!==true);az.evtUp._FSI_fromAfterTouch=true;aO.call(J,az.evtUp,w,G)};var ab=function(){az.x=(2*az.x+aS.x-az.lastX)/5;az.y=(2*az.y+aS.y-az.lastY)/5;az.lastX=aS.x;az.lastY=aS.y};var ay=this.setCapture=function(a3,a5){var a4=ai(a3,a5);if(a4){au.captureScrollUser=a3;au.capturePinchUser=a5}return a4};var ai=function(a3,a5){var a4=0;if(a3){a4+=2}if(a5){a4+=4}if(a4==au.nCheck){return}au.nCheck=a4;au.captureScroll=a3;au.capturePinch=a5;if(a.BrowserSupports.cssTouchAction()){P(a3,a5)}return true};var P=function(a3,a7){if(aY.bMouseOnly){return}var a6;switch(au.nCheck){case 0:a6="auto";break;case 2:a6=aW+"pinch-zoom";break;case 4:a6="pan-x pan-y";break;default:a6=(aW.length>0)?aW:"none"}au.cssTouchAction=a6;for(var a5=0;a5<n.length;a5++){var a4=n[a5];r(a4,au.cssTouchAction)}};var k=function(){if(ar.length<1){return 0}var a4=Math.abs(ar[1].x-ar[0].x);var a3=Math.abs(ar[1].y-ar[0].y);return an.nPinchDistance=Math.sqrt(a4*a4+a3*a3)};var aj=function(a3){x=false;if(!al){return}var a4=ar.length;if(!aN){x=(a4==1&&au.captureScroll);return}if(an.pointerCount!=a4){Q(a3);if(a4>1){ah();an.nPointers=a4;switch(a4){case 2:an.started=true;an.name="pinch";an.nType=1;if(typeof(aY.onPinchStart)=="function"){M(a3);an.nPinchDistance=0;an.nPinchDistance=k();an.pinchDistanceStart=an.pinchDistanceLast=an.nPinchDistance;an.pinchDistanceStartMaxed=Math.max(at,an.pinchDistanceStart);a3._FSI_PinchDistance=an.nPinchDistance;aY.onPinchStart.call(J,a3,aS,G)}break;default:an.started=true;an.name="unknown";an.nType=-1}if(an.started){A=true;if(p){aK();p=false;a3._FSI_Canceled=true;aO.call(J,a3,w,G)}if(typeof(aY.onGestureStart)=="function"){M(a3);aY.onGestureStart.call(J,a3,aS,G)}}}else{if(a4<1){ah()}}an.pointerCount=a4;x=false;if(a4==1){if(au.captureScroll){x=true}}else{if(au.capturePinch&&an.nType==1){x=true}}}return an.started};var ah=function(){if(!an.timeoutRestartDown){return}clearTimeout(an.timeoutRestartDown);an.timeoutRestartDown=b};var D=function(){if(ad!=1){return}g(X);ah()};var M=function(a3){a3._FSI_Gesture=an.name;a3._FSI_GestureType=an.nType;a3._FSI_PointerCount=an.nPointers};var Q=function(a3){if(!an.started){return}an.started=false;if(!a3){a3={}}if(an.nType==1&&typeof(aY.onPinchEnd)=="function"){M(a3);a3._FSI_PinchDistance=an.nPinchDistance;aY.onPinchEnd.call(J,a3,aS,G)}if(typeof(aY.onGestureEnd)=="function"){M(a3);aY.onGestureEnd.call(J,a3,aS,G)}an.name="none";an.nType=0;if(a3&&ad==1){ah();an.timeoutRestartDown=setTimeout(D,20)}};ao()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Callbacks!=b){return}a.Callbacks=function(o,g,d){if(g==b){g={cfg:{}}}if(typeof(d)!="object"){d={}}var p=this;var f={};var n={};var l=0;var k={count:0};var e=new a.EmptyDebugger();var j={};this.destroy=function(){if(e.on){this.removeConfigListeners();if(k.count>0){e.error("WARNING: "+k.count+" listener(s) have not been removed:");for(var q in k){if(q!="count"){e.error("- "+q+" ("+k[q].count+" listener)")}}}}};this.removeConfigListeners=function(){for(var q in n){var r=n[q];if(r!==false){i(r.evt,r.fn)}}n={}};this.setDebug=function(q){e=q};this.setConfig=function(q){p.removeConfigListeners();g=q};var m=function(s){if(n[s]!=b){return f[s]}var r=false;var q=s.toLowerCase();if(typeof(g.cfg[q])=="string"&&typeof(window[g.cfg[q]])=="function"){r=window[g.cfg[q]]}else{if(typeof(g.cfg[q])=="function"){r=g.cfg[q]}}if(r!=false&&c(s,r,o)){n[s]={evt:s,fn:r}}else{n[s]=false}return f[s]};var c=this.addListener=function(s,q,r){if(typeof(q)!="function"){e.error("Failed to add listener for "+s+". The function argument is not a function.");return false}if(r==b){r=o}if(q.__FSICallbackFunctionID==b){q.__FSICallbackFunctionID=a.callbackFunctionID++}if(k[s]==b){k[s]={count:0}}if(k[s][q.__FSICallbackFunctionID]==b){k[s][q.__FSICallbackFunctionID]=[]}k.count++;k[s].count++;k[s][q.__FSICallbackFunctionID].push(l);if(e.on){var w=k[s][q.__FSICallbackFunctionID].length;if(w>1){var v="";try{v=" "+q.name+"()"}catch(t){}e.error(w+" listeners for "+s+" have been added for the same function"+v+". Did you forget to remove a listener?")}if(k[s].count>20){e.error(w+" listeners for "+s+" have been added for this instance. Did you forget to remove a listener?")}}var u=f[s];if(u==b){u=f[s]={};u.reg={};u.nam=s}u.reg[l]={fn:q,scope:r};u.bNeedsArrayRebuild=true;if(typeof(d[s])=="function"){u.handleCallbackResult=d[s]}if(j[s]!==b){q.apply(r,j[s][0])}l++;return true};var i=this.removeListener=function(s,r){if(k[s]==b||typeof(r)!="function"||r.__FSICallbackFunctionID==b){e.error("Unable to remove listener: no callback for "+s+" registered");return false}var q=k[s][r.__FSICallbackFunctionID];if(q==b){if(e.on){var w="this function";try{w="the function "+r.name}catch(t){}e.error("Unable to remove listener: no callback for "+s+" registered for "+w)}return false}var v=q.pop();k.count--;k[s].count--;if(q.length==0){k[s][r.__FSICallbackFunctionID]=b;delete k[s][r.__FSICallbackFunctionID]}if(k[s].count<1){k[s]=b;delete k[s]}var u=f[s];if(u!=b){u.bNeedsArrayRebuild=true;u.reg[v]=b;delete u.reg[v]}return true};var h=function(q){q.ar=[];for(var r in q.reg){if(typeof(q.reg[r].fn)=="function"){q.ar.push(q.reg[r])}}q.bNeedsArrayRebuild=false};this.isset=function(q){return(m(q)!=b)};this.runPersistent=function(r,q){p.run(r,q);j[r]=[q]};this.run=function(v,s){var r;var x=m(v);if(x!==b){if(x.bNeedsArrayRebuild){h(x)}var q=x.ar;for(var u=0;u<q.length;u++){var w=q[u];var t=w.fn.apply(w.scope,s);if(t!=b){r=t;if(x.handleCallbackResult){r=x.handleCallbackResult(r,s)}}}}return r}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a._API_ImageFlow!==b){return}a._API_ImageFlow=function(d,e){var c=this;c.scriptMainFile="FSI.ImageFlow.js";c.oMethodAndPropertyExclusions={devParseAPI:true,attachedCallback:true,createdCallback:true,destroyOnDetach:true,detachedCallback:true,align:true};c.oMethods={addListener:{a:"strListenerName, fn, iScope",r:"bSuccess"},assignFSIViewer:{a:"iFSIViewerInstance"},closeZoom:{a:"evt, bImmediate"},destroy:{},focusImage:{a:"nImage"},getBuild:{r:"strBuild"},getConfigValue:{a:"strName",r:"mixed"},getInitDone:{r:"bDone"},getInstanceID:{r:"nInstanceID"},getInstanceName:{r:"strInstanceName"},getParameters:{r:"oParameters"},getVersion:{r:"strVersion"},init:{a:"elementID, oParameters, bDebug"},printAPI:{},removeListener:{a:"strListenerName, fn",r:"bSuccess"},testAPIListenersStart:{},testAPIListenersStop:{},traceConfigValue:{a:"strName"},zoomImage:{a:"nImage"}};c.oCallbacks={onClick:{a:"nImageIndex, strImagePath"},onConfigsReady:{a:"oConfigValues"},onDestroy:{},onFocus:{a:"nImageIndex, strImagePath"},onInit:{a:"oParameters)"},onStart:{a:"strDirectory, nImages, arImagePaths"},onZoomEnd:{},onZoomStart:{a:"nImageIndex, strImageURL"}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.ImageFlow!==b){return}a.ImageFlow=function(d){var aZ={};var bF={strVersion:"2018",strBuild:"18.05.17.1",strConfigSection:"ImageFlow",bHasListeners:true};var bD=new a.ClassDef(this,"FSI ImageFlow",bF);bD.oAPI=new a._API_ImageFlow(this,aZ);var aM=bD.instance;a.guessFSIViewerLocation("fsiimageflow.js",3);var be=a.getViewerInstanceID();this.getInstanceID=function(){return be};this.getInstanceName=function(){return bD.strClassName+" ["+aB+"]"};var a6=(d)?a.cloneParameters(d):{};var at;var aB;var ao;var bP=false;var bg;var w;var bQ=[];var cp;var aN;var a7;var W=0;var by={};var bw;var am,aU;var bM;var bv;var aQ={};var a3=false;var B;var bx;var b0;var U;var aI;var bj;var bT;var aH;var bY;var c=4;var aK;var bO=false;var aS=false;var bI;var z;var aJ;var K=false;var cf;var l;var bb;var bL;var aR;var bk;var cj;var aF,aP,y;var P=0;var bV=0;var q;var b1;var ae;var a9;var bC;var aj;var bs;var ba,bB;var V=[];var ac={};var a2;var bd;var p={};var bZ;var b3;var Q={};var az={};var cg;var S={};var Y;var cn;var a1;var aD=0;var bS;var ch;var bW;var x;var bm={};var aT;var D;var aW=/((\?)|&)(width|height)=[^&]*/ig;var aO;var bR;var cq;var cc;var a4;var ap;var aq;var bc;var aL;var i;var b4={};var f=0;var ag=8;var g=[];var b9=true;var A=false;var cb=0;var ab;var bK={strings:{dir:"",fpxservertemplate:"",effects:"",overlays:"",quality:"",cropRect:"",cropValues:"",headers:"cors",scrollColor:"#999",placeHolderColor:"#EEEEEE",backgroundColor:"#FFF",zoomBorderStyle:"solid",zoomBorderColor:"#777",zoomBackgroundColor:"white",zoomFadeColor:"white",imageBorderColor:"none",presentationType:"carousel",elementWidth:"10%",elementSpacing:"0.25%"},booleans:{autoDestroy:true,autoResize:true,enableZoom:true,enableScrollBar:true,transparency:false,centerZoomedImage:true,zoomCenteredImageOnly:false,positionQuantization:false,endlessScrolling:false,duplicateImagesIfNeeded:false},floats:{mirrorHeight:0.5,mirrorStartOpacity:0.5,backgroundDarkness:0.3,depthFadeout:0.2,curveHeight:0.35,autoRotateSpeed:0,scrollAlphaNormal:0.35,scrollAlphaActive:1},integers:{zIndexZoom:1000,preloadCount:20,paddingTop:10,paddingBottom:0,zoomFadeOpacity:80,zoomBorderWidth:4,scrollPadding:0,scrollHeight:16}};var r=new a.EmptyDebugger();var ay=function(cs,cr){if(cr&&!r.on&&cs.on){if(bx){bx.stopPendingRequests()}aM.destroy();aM.init(ab,a6,true);return true}r=cs;if(r.on){r.setPrefix(aM.getInstanceName())}};this.init=function(cs,cv,cr){var ct;ab=cs;if(!a.BrowserSupports.canvas()){r.error("<canvas> element not supported.");return}if(!cs){return}if(typeof(cs)==="object"){if(typeof(cs.id)==="string"){aB=cs.id}}else{if(typeof(cs)==="string"){aB=cs}}if(!aB){aB="fsi.imageflow #"+be}if(aM._fsi_parameters){cv=aM._fsi_parameters;delete aM._fsi_parameters}if(typeof(cs)==="object"&&cs.tagName!==b){ct=cs}else{ct=document.getElementById(cs)}if(!ct){return}if(bP){aM.destroy()}ct.setAttribute("x-fsi-id",aB);cb++;bg=ct;ct.innerHTML="";w=document.createElement("div");a.setStyleAttr(w,"width:100%;height:100%;border:0px;none;margin:0px;padding:0px;overflow:hidden");bg.appendChild(w);a6=(cv)?a.cloneParameters(cv):a6;var cw={};cw.onConfigsReady=av;cw.onDebuggerChange=ay;bx=new a.Config(null,cw,{strSection:bD.strConfigSection});b0=aZ.iCallbacks=new a.Callbacks(aM,bx);if(b0.isset("onInit")){b0.run("onInit",[a6])}var cu=a6;if(cr){cu=a.cloneObject(a6);cu.debug=true}bx.init(cu);r.log(aM.getVersion());ao={};bx.loadConfigs();bP=true};this.getConfigValue=function(cr){if(bx&&typeof(cr)==="string"){return bx.cfg[a.trim(cr.toLowerCase())]}};this.getParameters=function(){return a.cloneParameters(a6)};this.getInitDone=function(){return bP};var bE=function(cs){var cr=cs.oCrop={};br(cr,"rectLeft",cs.sourceWidth,0);br(cr,"rectTop",cs.sourceHeight,0);br(cr,"rectRight",cs.sourceWidth,1);br(cr,"rectBottom",cs.sourceHeight,1);cr.rectWidth=1-cr.rectRight-cr.rectLeft;cr.rectHeight=1-cr.rectBottom-cr.rectTop;cr.bCrop=true;cr.query=cr.rectLeft+","+cr.rectTop+","+cr.rectWidth+","+cr.rectHeight};var br=function(cw,ct,cu,cs){var cv=b4[ct];if(typeof(cv)!=="string"){cw[ct]=cv;return}var cr=parseInt(cv);if(isNaN(cr)){cw[ct]=cs;return}cr=Math.max(0,Math.min(cu,cr));cw[ct]=cr/cu};var bz=function(ct,cs){ct=ct.toLowerCase();var cr=cs;if(ct.indexOf("px")!==-1){cr=parseInt(ct);if(isNaN(cr)||cr<=0){cr=cs}else{cr=""+cr+"live";b4.bLive=true}}else{if(ct.indexOf("%")!==-1){cr=Math.max(0,Math.min(100,parseFloat(ct)));cr/=100;if(isNaN(cr)||cr<0){cr=cs}}else{cr=Math.max(0,Math.min(1,parseFloat(ct)));if(isNaN(cr)||cr<0){cr=cs}}}return cr};var ad=function(){var cs;var ct=b4;ct.rectWidth=ct.rectHeight=1;ct.rectLeft=ct.rectTop=0;ct.bCrop=b4.bLive=false;ct.query="";if(ao.cropValues&&ao.cropValues.length>6){cs=ao.cropValues.split(",");ct.rectLeft=bz(cs[0],0);ct.rectTop=bz(cs[1],0);ct.rectRight=bz(cs[2],0);ct.rectBottom=bz(cs[3],0);ct.rectWidth=1-ct.rectRight-ct.rectLeft;ct.rectHeight=1-ct.rectBottom-ct.rectTop;ct.bCrop=true;if(!ct.bLive){ct.query=ct.rectLeft+","+ct.rectTop+","+ct.rectWidth+","+ct.rectHeight}}else{if(ao.cropRect&&ao.cropRect.length>6){cs=ao.cropRect.split(",");if(cs.length>3){while(cs.length>4){cs.pop()}for(var cr=0;cr<cs.length;cr++){cs[cr]=parseFloat(cs[cr])}var cu=cs[0]*cs[1]*cs[2]*cs[3];if(isNaN(cu)){return}ct.rectLeft=cs[0];ct.rectTop=cs[1];ct.rectRight=cs[2];ct.rectBottom=cs[3];ct.rectWidth=cs[2]-cs[0];ct.rectHeight=cs[3]-cs[1];ct.bCrop=true;ct.query=ct.rectLeft+","+ct.rectTop+","+ct.rectWidth+","+ct.rectHeight}}}};var av=function(){if(bx.cfg.viewerid){aM.assignFSIViewer(bx.cfg.viewerid)}var cs=bx.cfg.dir;if(!cs||cs.length===0){var cr=bx.getImageList();if(cr){ai(cr.arImages,cr)}}else{bx.loadImageList(bx.cfg.dir,ai)}if(b0.isset("onConfigsReady")){b0.run("onConfigsReady",[a.cloneObject(bx.cfg)])}};var ai=function(cr,cs){if(!bP){return}Y=0;if(!cr){cr=[]}bQ=cr;r.log("Image list loaded ("+bQ.length+" images)");C();j()};var C=function(){s(ao)};var aY=function(cs,cr,cv,ct){for(var cu in cv){cr[cu]=cs.getFloatParameter(ct+cu,cv[cu])}};var bn=function(cs,cr,cv,ct){for(var cu in cv){cr[cu]=cs.getIntParameter(ct+cu,cv[cu])}};var an=function(ct,cs,cr,cu){for(var cv in cr){cs[cv]=ct.getStringParameter(cu+cv,cr[cv])}};var ah=function(cs,cr,cu,ct){for(var cv in cu){cr[cv]=cs.makeBool(cs.getStringParameter(ct+cv),cu[cv])}};var t=function(cs,cr,cu,ct){var cv;if(cu&&cu.length>0){if(cr[cu]===b){cr[cu]={}}ct=ct[cu];cv=cr[cu]}else{cv=cr}if(ct.strings){an(cs,cv,ct.strings,cu)}if(ct.booleans){ah(cs,cv,ct.booleans,cu)}if(ct.floats){aY(cs,cv,ct.floats,cu)}if(ct.integers){bn(cs,cv,ct.integers,cu)}};var s=function(cr){if(cr===b){cr={}}cr.serverBase=bx.serverBase;t(bx,cr,"",bK);var cu=/[\dabcdef]{3,6}/i;for(var cv in bK.strings){if(cv.indexOf("Color")!==-1){var ct=ao[cv];if(ct.indexOf("#")!==0){var cs=ct.match(cu);if(cs){if(cs[0].length===ct.length&&(cs[0].length===3||cs[0].length===6)){ao[cv]="#"+cs[0]}}}}}};var j=function(){var cs;bI=ao.presentationType.toLowerCase();if(a.isMobileDevice){c=3}else{c=1}cc=ao.transparency;bO=ao.endlessScrolling;ad();cg=bQ.length;cs=ao.placeHolderColor.toLowerCase();bR=(cs!=="none"&&cs!=="transparent");cs=ao.imageBorderColor.toLowerCase();i=(cs!=="none"&&cs!=="false");if(ao.zoomCenteredImageOnly){bL=true}else{bL=ao.positionQuantization}cs=bi();aF=y=aP=cs;ap=-ao.autoRotateSpeed;cf="rgba(0,255,0,";cs=ao.backgroundColor.toLowerCase();if(cs==="false"||cs==="transparent"||cs==="none"){ao.backgroundColor=false;aK=bq;w.style.backgroundColor="transparent"}else{if(!cc&&ao.backgroundDarkness===0){aK=J}else{aK=bq}cs=ao.backgroundColor;if(cs.indexOf("#")===0){cs=cs.substr(1)}if(cs.length===3){cs=cs.charAt(0)+cs.charAt(0)+cs.charAt(1)+cs.charAt(1)+cs.charAt(2)+cs.charAt(2)}var cu=parseInt("0x"+cs.substr(0,2));if(isNaN(cu)){cu=0}var ct=parseInt("0x"+cs.substr(2,2));if(isNaN(ct)){ct=0}var cr=parseInt("0x"+cs.substr(4,2));if(isNaN(cr)){cr=0}cf="rgba("+cu+","+ct+","+cr+",";w.style.backgroundColor=ao.backgroundColor}cq=(aK===bq);al();cp=a.cloneArray(bQ);aN={};if(ao.autoResize===true){if(bb===b){bb=a.addCustomEvent(bg,"FSIElementDimension",b6);a.setCustomEventListenerProperty(bb,"treshold",200)}}else{if(bb!==b){a.removeCustomEvent(bg,"FSIElementDimension",b6);bb=b}}bG();a0()};var bt=function(ct){var cs,cr;if(typeof(ct)==="string"){cr=ct.indexOf("%");cs=parseFloat(ct)}else{cr=-1;cs=ct}if(cr!==-1){cs=Math.round(aF.width*cs/100)}return{val:cs,bRelative:(cr!==-1)}};var al=function(){var cr;cr=bt(ao.elementWidth);if(isNaN(cr.val)){cr=bt(bK.strings.elementWidth)}aR=by.width=Math.max(1,cr.val);by.widthRelative=cr.bRelative;cr=bt(ao.elementSpacing);if(isNaN(cr.val)){cr=bt(bK.strings.elementSpacing)}bk=by.spacing=cr.val;by.spacingRelative=cr.bRelative};var bG=function(){a3=false;n();if(cp.length<1){return}bw=0;a7={};W=0;cb++;if(bQ.length!==cp.length){bQ=a.cloneArray(cp)}cg=bQ.length;a1=!ao.enableScrollBar;b1=aR+bk;aF=aP;ba=aF.width/2;var cw=0;aS=false;switch(bI){case"stacks":cw=2;A=false;b9=false;break;case"flat":aS=!bO;ao.zoomCenteredImageOnly=false;cw=1;if(!bO){ba=0}else{ba-=b1/2}b9=false;A=true;break;default:cw=2;bI="carousel";A=false;b9=true;break}if(bI==="stacks"){bB=aF.width/2-aR/2}else{bB=aF.width/2-aR/4}E();var cu=bZ;if(bO){var cx=false;P=0;if(cg===1){cx=true;bQ.push(bQ[0]);cg++}aE();u();if(cx){bQ.pop();cg=1}if(V.length+cw>cg){if(!ao.duplicateImagesIfNeeded){bO=false}else{var ct=(V.length+cw-cg);for(var cs=0;cs<ct;cs++){bQ.push(bQ[cs%cg])}cg=bQ.length}}}aE();E();if(bZ<=0){a1=true}b3={height:ao.scrollHeight,padding:ao.scrollPadding,alphaNormal:ao.scrollAlphaNormal,alphaActive:ao.scrollAlphaActive};b3.height=Math.max(3,b3.height);b3.padding=Math.max(0,b3.padding);b3.alpha=b3.alphaTarget=b3.alphaNormal;b3.width=Math.round(aF.width-2*b3.padding);b3.y=Math.round(aF.height-b3.height-b3.padding);if(!a1){var cr=Math.max(0,cu);b3.buttonWidth=Math.round(Math.max(20,b3.width*Math.min(1,aF.width/(aF.width+cr))))}else{b3.buttonWidth=20}b3.range=b3.width-b3.buttonWidth;if(!a1){a1=(b3.buttonWidth>=b3.width)}cn=(cg<2);if(!a1){a1=cn}if(!bO&&bI==="flat"&&cg*b1<aF.width){ba=(aF.width-cg*b1)/2}var cy=ao.paddingBottom;if(!a1){cy=Math.max(b3.height,cy)}bc=aF.height-ao.paddingTop-cy;ae=0;ao.mirrorHeight=Math.max(0,Math.min(1,ao.mirrorHeight));if(ao.mirrorHeight>0){ae=Math.round(ao.mirrorHeight*bc/2);a9=(ae>0)}else{a9=false}bc-=ae;if(b9){aL=Math.round(ao.curveHeight*bc)}else{aL=0}aA();if(l!==b){var cv=l.offsetLeft/l.xAdvance;P=cv*b1;l=b}if(bL){P=Math.round(P/b1)*b1}P=aa(P);a3=true;if(bc<1){r.error("Insufficient instance height. Resulting image height is "+bc+"px");return}bw=bQ.length;am=aV;aU=m;ar();if(ao.preloadCount>0){R()}if(ap!==0){Z()}};var aE=function(){if(cg<2){bM=o}else{if(aS){bM=h}else{bM=ck}}};var a0=function(){if(b0.isset("onStart")){b0.run("onStart",[ao.dir,bQ.length,a.cloneArray(bQ)])}G(0);ca()};var E=function(){bZ=cg*b1;if(!bO){if(bI==="flat"){bZ-=aF.width}else{bZ-=b1}}};var aA=function(){if(!aF||aF.width<1||aF.height<1){return false}if(!B){B=document.createElement("canvas");B.setAttribute("draggable","false");B.style.width=B.style.height="100%";if(a.isIETouch){B.style.msTouchAction="pan-y pinch-zoom double-tap-zoom"}B.setAttribute("width",aF.width);B.setAttribute("height",aF.height);cj=B.getContext("2d");w.appendChild(B)}else{B.setAttribute("width",aF.width);B.setAttribute("height",aF.height)}if(a9&&!U){U=document.createElement("canvas");aI=U.getContext("2d");aH=U.cloneNode();bY=aH.getContext("2d");bj=U.cloneNode();bT=bj.getContext("2d")}if(a9){var cr=Math.ceil(aR);var ct=Math.ceil((bc+1));U.setAttribute("width",cr);U.setAttribute("height",ct);aH.setAttribute("width",cr);aH.setAttribute("height",ct);bj.setAttribute("width",cr);bj.setAttribute("height",ct);bC=aI.createLinearGradient(0,0,0,ae);if(cq){bC.addColorStop(0,cf+ao.mirrorStartOpacity+")");bC.addColorStop(1,cf+"0)")}else{bC.addColorStop(0,cf+(1-ao.mirrorStartOpacity)+")");bC.addColorStop(1,cf+"1)")}aI.strokeStyle=ao.imageBorderColor;aI.fillStyle=bC;aI.lineWidth=0;bT.strokeStyle=ao.imageBorderColor}if(ao.backgroundDarkness>0){aj=cj.createLinearGradient(0,0,aF.width,0);var cs="rgba(0,0,0,";aj.addColorStop(0,cs+ao.backgroundDarkness+")");aj.addColorStop(0.4,cs+"0)");aj.addColorStop(0.6,cs+"0)");aj.addColorStop(1,cs+ao.backgroundDarkness+")");bs=true}else{bs=false}if(!at){var cu={};cu.detectClick=true;cu.afterTouch={enabled:true};cu.afterTouch.modifyTarget=bu;cu.afterTouch.factorAmount=23;cu.afterTouch.factorFrames=3.7;cu.afterTouch.minFrames=5;cu.afterTouch.offsetFrames=3;cu.afterTouch.useAnimationFrame=true;cu.detectGestures=true;at=new a.TouchHandler(B,cu,bA,bJ,a8);at.setCapture(true,false)}};var bu=function(cu,cr){if(bL){var ct=Q.offsetLeft-Q.x-Q.startX;var cs=Math.round((cu.x+ct)/b1)*b1;cu.x=cs-ct}return cu};var bX=function(){var cr=a.getElementClientPos(B);Q.x=cr.left;Q.y=cr.top};var bA=function(cr,cu,ct){bX();az.x=cu.x-Q.x;az.y=cu.y-Q.y;bN(b3.alphaActive);aw();ap=0;cancelAnimationFrame(bd);bd=b;P=aa(P);if(O(az.x,az.y)){at.enableAfterTouch(false);Q.scrollOffsetX=0;bN(b3.alphaActive);b3.bDragging=true;bJ(cr,cu,ct);af();var cs=b3.padding+b3.x+b3.buttonWidth/2;Q.scrollOffsetX=(cs-az.x)}else{at.enableAfterTouch(true);b3.bImageDragging=true;Q.startX=az.x;Q.startY=az.y;Q.offsetLeft=P}ar();return true};var bJ=function(cs,cv,ct){az.x=cv.x-Q.x;az.y=cv.y-Q.y;if(b3.bDragging){var cr=az.x+Q.scrollOffsetX-b3.padding-b3.buttonWidth/2;cr=Math.max(0,Math.min(bZ-1,Math.round(cr*bZ/b3.range)));P=aa(Math.min(0,Math.max(-cr,-bZ)));ar()}else{if(b3.bImageDragging){Q.dx=az.x-Q.startX;Q.dy=az.y-Q.startY;var cu=P;P=aa(Q.offsetLeft+Q.dx);ar();if(cu===P||Math.abs(Q.dy)>3*Math.abs(Q.dx)){cs.FSI_allowEventDefault=true}}}};var a8=function(cz,cu,cA){var cx=cz._FSI_Click;az.x=cu.x-Q.x;az.y=cu.y-Q.y;bN(b3.alphaNormal);if(b3.bDragging){bN(b3.alphaNormal);b3.bDragging=false;if(bL){var cB=Math.round(P/b1)*b1;var cr=Math.round(-aa(cB)/b1);G(cr);bp(cB,true,55)}}else{if(b3.bImageDragging){b3.bImageDragging=false;if(cx){var cw=az.x;var cv=az.y;var cy=0;var cs;for(var ct=0;ct<V.length;ct++){cs=V[ct];if(cw>=cs.x&&cv>=cs.y&&cw<=cs.x+cs.drawWidth&&cv<=cs.y+cs.drawHeight){cy=1;if(b0.isset("onClick")){b0.run("onClick",[cs.nIndex,bQ[cs.nIndex]])}if(!ao.zoomCenteredImageOnly||aD===cs.nIndex){if(ao.enableZoom){b8(cs)}}if(ao.centerZoomedImage){ce(cs)}break}}}else{ci()}}}ar()};var ci=function(){if(bL){var cr=Math.round(P/b1)*b1;if(Math.abs(cr-P)>0.5){var cs=Math.round(-aa(cr)/b1);G(cs);bp(cr,true,30)}}};var G=function(cr){aD=cr;aO=b;if(b0.isset("onFocus")){var cs=aN[cr];if(cs){b0.run("onFocus",[cs.nIndex,bQ[cs.nIndex]])}}};this.assignFSIViewer=function(cr){if(cr&&typeof(cr)==="string"){if(cr.toLowerCase()==="auto"){var cs=document.getElementsByTagName("fsi-viewer");if(cs&&cs.length>0){cr=cs[0]}else{cr=b}}else{cr=document.getElementById(cr)}}if(!cr||typeof(cr.changeImage)!=="function"){z=b}else{z=cr}aJ=false;ca()};var ca=function(){if(!bP||!z||aJ||bQ.length<1){return}aJ=true;var cr={};cr.path=bQ[0];L(cr)};var L=function(cr){if(!cr||!z||typeof(z.changeImage)!=="function"){return}var cs={};cs.fpxsrc=cr.path;cs.imageWidth=cr.sourceWidth;cs.imageHeight=cr.sourceHeight;cs.cropRect=bx.cfg.croprect;cs.cropValues=bx.cfg.cropvalues;cs.effects=bx.cfg.effects;z.changeImage(cs)};var b8=function(cx){if(z!==b){L(cx);return}I(b,true);if(!cx.bReady){return}bS=document.createElement("div");ch=document.createElement("div");x=document.createElement("img");bm.alphaShader=0;var cJ=a.getDocumentScale();var cK=ao.zoomBorderWidth/cJ;var cC=ao.zIndexZoom;var cD="position:absolute;z-index:"+(cC+1)+";border:"+cK+"px "+ao.zoomBorderStyle+" "+ao.zoomBorderColor+";line-height:0px;box-sizing: content-box;";var cz=ao.zoomBackgroundColor.toLowerCase();if(cz!=="none"&&cz!=="transparent"){cD+="background-color:"+ao.zoomBackgroundColor}bS.setAttribute("style",cD);var cv="position:absolute;z-index:"+cC+";background-color:"+ao.zoomFadeColor+";opacity:0.0;filter:Alpha(opacity=0);";bW=cx.img.cloneNode();bW.style.width=bW.style.height="100%";bS.appendChild(bW);var cw=a.getElementClientPos(B);var ct=a.getElementClientPos(document.body);var cB=-ct.left;var cA=-ct.top;bm.startX=cB+cw.left+cx.x-cK;bm.startY=cA+cw.top+cx.y-cK;bm.startWidth=cx.width;bm.startHeight=cx.height;bS.style.width=bm.startWidth+"px";bS.style.height=bm.startHeight+"px";bS.style.left=bm.startX+"px";bS.style.top=bm.startY+"px";var cI=a.getViewportSize(window);if(a.getDevicePixelRatio()!==1){cI.width-=1;cI.height-=1}a.addEvent(ch,"mousedown",I,false);a.addEvent(window,"touchstart",I,false);a.addEvent(bS,"mousedown",I,false);a.addEvent(window,"scroll",I,false);var cG=Math.ceil(40/cJ);var cs=cI.width-cG-2*cK;var cH=cI.height-cG-2*cK;var cy=cx.maxWidth;var cF=cx.maxHeight;if(cs/cy<cH/cF){cy=cs;cF=Math.round(cy*cx.maxHeight/cx.maxWidth)}else{cF=cH;cy=Math.round(cF*cx.maxWidth/cx.maxHeight)}if(cy>cx.maxWidth||cF>cx.maxHeight){cy=cx.maxWidth;cF=cx.maxHeight}bm.endWidth=cy;bm.enddHeight=cF;bm.dWidth=cy-bm.startWidth;bm.dHeight=cF-bm.startHeight;bm.endX=window.pageXOffset+Math.round((cI.width-cy)/2);bm.endY=window.pageYOffset+Math.round((cI.height-cF)/2);bm.dx=bm.endX-bm.startX;bm.dy=bm.endY-bm.startY;cv+="left:"+window.pageXOffset+"px;top:"+window.pageYOffset+"px;width:"+(cI.width)+"px;height:"+cI.height+"px";bm.bImageReady=false;var cu=cx.img.src;cu=cu.replace(aW,"$1");var cr=Math.min(cx.maxWidth,Math.round(cJ*cy));var cE=Math.min(cx.maxHeight,Math.round(cJ*cF));cu+="&width="+cr+"&height="+cE;aq=true;a.addEvent(x,"load",cd,false);x.style.width=bm.endWidth+"px";x.style.height=bm.endHeight+"px";x.setAttribute("crossorigin","anonymous");x.src=cu;bm.pos=0;bm.frames=b7(20);ch.setAttribute("style",cv);document.body.appendChild(ch);document.body.appendChild(bS);bm.alphaShader=0;cancelAnimationFrame(aT);aT=requestAnimationFrame(au);bm.posFader=0;bm.framesShader=10;bm.startAlpha=bm.alphaShader;bm.endAlpha=ao.zoomFadeOpacity;bm.dAlpha=bm.endAlpha-bm.startAlpha;D=requestAnimationFrame(v);b0.run("onZoomStart",[cx.nIndex,cu]);if(!a.isMobileDevice){a.addEvent(window,"resize",I,false)}else{a.addEvent(window,"orientationchange",I,false)}};var cm=a.Easing.easeOutCubic;var au=function(){bm.pos++;if(bm.pos>bm.frames){aT=b;requestAnimationFrame(co);return}var cr=cm(bm.pos,bm.frames,bm.startX,bm.dx);var cu=cm(bm.pos,bm.frames,bm.startY,bm.dy);var cs=cm(bm.pos,bm.frames,bm.startWidth,bm.dWidth);var ct=cm(bm.pos,bm.frames,bm.startHeight,bm.dHeight);bS.style.left=cr+"px";bS.style.top=cu+"px";bS.style.width=cs+"px";bS.style.height=ct+"px";aT=requestAnimationFrame(au)};var co=function(){if(!bS||!bm.bImageReady||aT!==b){return}bS.firstChild.style.width=x.style.width;bS.firstChild.style.height=x.style.height;bS.firstChild.src=x.src;x=b;bS.style.width="";bS.style.height=""};var cd=function(cr){bm.bImageReady=true;a.removeEvent(x,"load",cd,false);aq=false;co()};var I=this.closeZoom=function(cr,cs){if(!bS){return}aO=b;if(!a.isMobileDevice){a.removeEvent(window,"resize",I,false)}else{a.removeEvent(window,"orientationchange",I,false)}if(D){cancelAnimationFrame(D);D=b}cancelAnimationFrame(aT);aT=b;a.removeEvent(ch,"mousedown",I,false);a.removeEvent(bS,"mousedown",I,false);a.removeEvent(window,"touchstart",I,false);a.removeEvent(window,"scroll",I,false);if(aq){a.removeEvent(x,"load",cd,false)}if(x){x=b}a.removeChild(bS.parentNode,bS);bS=b;if(cs===true){a.removeChild(ch.parentNode,ch);ch=b}else{bm.posFader=0;bm.framesShader=10;bm.startAlpha=bm.alphaShader;bm.endAlpha=0;bm.dAlpha=bm.endAlpha-bm.startAlpha;D=requestAnimationFrame(v)}b0.run("onZoomEnd");if(cr&&cr.touches&&cr.touches.length===1){cr.cancelBubble=true;if(cr.stopPropagation){cr.stopPropagation()}if(cr.preventDefault){cr.preventDefault()}}};var T=function(cr){bm.alphaShader=cr;ch.style.opacity=cr/100;ch.style.filter="Alpha(opacity="+cr+")"};var v=function(){bm.posFader++;if(bm.posFader>bm.framesShader){if(bm.endAlpha===0){a.removeChild(ch.parentNode,ch);ch=b}D=b;return}var cr=cm(bm.posFader,bm.framesShader,bm.startAlpha,bm.dAlpha,3);T(cr);D=requestAnimationFrame(v)};var O=function(cr,cs){return(!a1&&cr>=b3.padding&&cs>=b3.y&&cr<=b3.padding+b3.width&&cs<=b3.y+b3.height)};this.focusImage=function(cr){if(cr<0||cr>=bQ){return false}var cs=b5(cr);ce(cs);return true};this.zoomImage=function(cr){if(!ao.enableZoom||!this.focusImage(cr)){return false}var cs=b5(cr);aO=cs.nIndex;ax()};var ce=function(cs,cr){if(!cs){return false}G(cs.nIndex);return bp(-cs.nIndex*b1,cr,30)};var aa=function(cr){if(bO){cr=Math.round(cr)%bZ;if(cr>0){cr-=bZ}}else{cr=Math.min(0,Math.max(-bZ,cr))}return cr};var b7=function(cr){if(a.isMobileDevice){cr=Math.ceil(cr/1.8)}return cr};var bp=function(cu,cr,ct){ct=b7(ct);aw();if(ct===b){ct=40}if(!cr&&bO){cu=aa(cu);P=aa(P);var cs=cu-P;if(Math.abs(cs)>bZ/2){if(cs>0){cu=-bZ+cu}else{cu=bZ+cu}}}if(cu===P||(bd!==b&&cu===p.end)){return false}cancelAnimationFrame(bd);bd=b;p.frames=ct;p.pos=0;p.start=P;p.end=cu;p.diff=p.end-p.start;bd=requestAnimationFrame(bH);return true};var bH=function(){p.pos++;if(p.pos===p.frames){P=aa(p.end);bd=b;bl();ax();return}P=cm(p.pos,p.frames,p.start,p.diff,3);if(!bO){P=aa(P)}bl();ax();bd=requestAnimationFrame(bH)};var cl=function(cs,cu,cv){if(!bP){return}if(!cu||!cv||cv.nInitID!==cb){return}f--;var cr,ct;cr=parseInt(cu.width);ct=parseInt(cu.height);if(isNaN(cr)&&isNaN(ct)){r.error("Failed to get image info.")}cv.nThumbnailDimWidth=aR;cv.nThumbnailDimHeight=bc;cv.bInfoReady=true;cv.bDrawPlaceHolder=bR;cv.sourceWidth=cr;cv.sourceHeight=ct;if(b4.bLive){bE(cv)}cv.src="&effects="+ao.effects;if(b4.bCrop){cv.rectWidth=b4.rectWidth;cv.rectHeight=b4.rectHeight}a.expandSourceDimensionForPadEffect(cv,aR,bc);if(b4.bCrop){cv.objCropCurrent=(cv.oCrop)?cv.oCrop:b4;cv.maxWidth=Math.round(cv.objCropCurrent.rectWidth*cv.sourceWidth);cv.maxHeight=Math.round(cv.objCropCurrent.rectHeight*cv.sourceHeight)}else{cv.maxWidth=cv.sourceWidth;cv.maxHeight=cv.sourceHeight}aG(cv)};var aG=function(cs){var cy,cu;if(!cs.bInfoReady){return false}cs.nThumbnailDimWidth=aR;cs.nThumbnailDimHeight=bc;if(!cs.bThumbLoading){f++}cs.bThumbLoading=true;cs.bThumbLoadStarted=true;var cv=aR;var cx=bc;if(cv/cs.maxWidth<cx/cs.maxHeight){cy=cv;cu=Math.round(cy*cs.maxHeight/cs.maxWidth)}else{cu=cx;cy=Math.round(cu*cs.maxWidth/cs.maxHeight)}var cw=true;if(cy<1||cu<1){cy=cu=0;cw=false}cs.width=cy;cs.height=cu;cs.offsetX=(cv-cy)/2;cs.offsetY=cx-cu-aL+ao.paddingTop;var cz={width:cy};if(cs.bHasPadEffect){cz.height=cu}if(cs.objCropCurrent){cz.rect=cs.objCropCurrent.query}if(ao.effects.length>0){cz.effects=ao.effects}if(ao.overlays.length>0){cz.overlays=ao.overlays}if(ao.quality.length>0){cz.quality=ao.quality}if(ao.fpxservertemplate.length>0){cz.renderer=ao.fpxservertemplate}var cr=bx.getImageURL(cs.path,cz);if(bx.hasImageParameterConditions){cr=bx.reWriteImageURLByConditions(cr)}var ct;if(cs.img===b){ct=cs.img=document.createElement("img");ct.oSprite=cs;ct.crossOrigin="anonymous"}else{ct=cs.img}cs.nInitID=cb;if(!cs.bHasEvents){aQ[cs.nIndex]=cs;cs.bHasEvents=true;a.addEvent(ct,"load",H,false);a.addEvent(ct,"error",N,false)}if(cs.bDrawPlaceHolder){if(cs.myX!==b){b2(cs)}if(bf(cs)){ar()}}if(!cw){N.call(ct)}else{cs.src=ct.src=cr}return true};var bo=function(cr){return(cr.nThumbnailDimWidth===aR&&cr.nThumbnailDimHeight===bc)};var ak=function(cr){return(cr&&cr.nInitID===cb)};var a5=function(cr){if(cr.bHasEvents){delete aQ[cr.nIndex];a.removeEvent(cr.img,"load",H,false);a.removeEvent(cr.img,"error",N,false);cr.bHasEvents=false}};var N=function(cr){var cs=this.oSprite;if(!cs){return}cs.bReady=false;cs.bDrawPlaceHolder=false;cs.bLoadComplete=true;cs.bThumbLoading=false;a5(cs);if(ak(cs)){f--}aU()};var H=function(cr){var cs=this.oSprite;if(!cs){return}a5(cs);if(!bP){return}cs.bReady=true;cs.bLoadComplete=true;cs.bThumbLoading=false;cs.bDrawPlaceHolder=false;if(!ak(cs)){return}f--;if(!bo(cs)){return}F(cs);if(bf(cs)&&cs.myX!==b){b2(cs);ar()}ax();aU()};var ax=function(){if(aO===b){return}var cr=b5(aO);if(!cr.bReady||!bf(cr)){return}b8(cr);aO=b};var b5=function(ct,cw,cr){var cu;ct%=cg;if(ct<0){ct+=cg}if(a7[ct]!==b){return a7[ct]}var cv=aN[ct];if(cv===b){Y++;cv=aN[ct]={};cv.nIndex=ct;var cs=bc;cv.width=aR;cv.height=cs;cv.offsetX=0;cv.offsetY=cs-cv.height-aL+ao.paddingTop;cv.path=bQ[ct];cu=true}else{if(cv.bThumbLoadStarted&&(cv.nThumbnailDimWidth!==aR||cv.nThumbnailDimHeight!==bc)){if(cv.bReady){cv.bReady=false;cv.oMirrorData=null;cv.bDrawPlaceHolder=false}cu=true}else{if(!cv.bLoadStarted){cu=true}}}if(cu){cv.bPreload=cw;g.push(cv);if(!cr){am()}}return cv};var k=function(){};var n=function(){am=aU=k;if(bv){clearTimeout(bv);bv=b}};var aV=function(){if(!bv){bv=setTimeout(m,50)}};var m=function(){if(bv){clearTimeout(bv);bv=b}while(g.length>0&&f<ag){var cs=g.shift();if(a7[cs.nIndex]===b&&(cs.bPreload||bf(cs))){a7[cs.nIndex]=cs;W++;if(W===cg){n()}bw--;cs.bLoadStarted=true;cs.nInitID=cb;if(!cs.bInfoLoading){f++;cs.bInfoLoading=true;var cr=bx.getImageInfoURL(cs.path);bx.loadFile(cr,cl,b,cs)}else{aG(cs)}}}};var aX=function(ct,cr){if(!bO&&(ct<0||ct>=cg)){return 0}var cu=b5(ct,false,true);cu.nImage=ct;cu.myX=cr;var cs=b2(cu);if(cs){V.push(cu)}return cs};var b2=function(cv){var ct,cu;if(A){var cs=ba+cv.myX;cu=(cs+b1>=0&&cs<=aF.width)?1:0;cv.z=1}else{ct=cv.myX/bB;cu=Math.cos(ct/1.3);if(b9){cv.z=cu}else{cv.z=1}}if(cu<ao.depthFadeout){ac[cv.nIndex]=false;return 0}cv.drawWidth=cv.z*cv.width;cv.drawHeight=cv.z*cv.height;ac[cv.nIndex]=true;if(A){cv.x=ba+cv.myX+Math.round((b1-cv.width)/2)}else{var cr=bB*Math.sin(ct);cv.x=ba+cr-cv.drawWidth/2}if(b9){cv.y=aL*cv.z+cv.offsetY+(cv.height-cv.drawHeight)}else{cv.y=cv.offsetY+(cv.height-cv.drawHeight)}return 1};var bf=function(cr){if(!cr){return false}return ac[cr.nIndex]};var u=function(){if(g.length>0){g=[]}V=[];ac={};var cu;var cs;if(A){cs=aa(P)}else{cs=P}if(cs>0){cu=Math.ceil(-cs/b1)}else{cu=Math.floor(-cs/b1)}var cr=cs%b1;aX(cu,cr);var ct=bM(cu,cr);if(S.interval!==b&&bd===b){S.nLastLeftImage=cu-ct+1;S.nLastRightImage=cu+ct-1;S.nLoad=ao.preloadCount}};var o=function(){return 0};var ck=function(cu,cr){var cv;var ct=0;var cs=0;do{ct+=b1;cs++;cv=aX(cu-cs,cr-ct);cv+=aX(cu+cs,cr+ct)}while(cv>0&&cs<cg);return cs};var h=function(cu,cr){var cv;var ct=0;var cs=0;do{ct+=b1;cs++;cv=aX(cu+cs,cr+ct)}while(cv>0&&cs<cg);return cs};var R=function(){if(S.interval!==b){return}S.interval=setInterval(aC,100)};var bU=function(){clearInterval(S.interval);S.interval=b};var aC=function(){if(g.length>0||S.nLoad<=0){return}if(bw<1){bU();return}while(g.length<2&&S.nLoad>0){if(!aS){b5(--S.nLastLeftImage,true,true);S.nLoad--}b5(++S.nLastRightImage,true,true);S.nLoad--}aU()};var ar=function(){if(q!==b){return}q=requestAnimationFrame(bl)};var bl=function(){if(q!==b){cancelAnimationFrame(q);q=b}if(K){return}u();aK();am()};var bq=function(){if(!bP){return}cj.globalCompositeOperation="source-over";cj.globalAlpha=1;cj.clearRect(0,0,aF.width,aF.height);cj.strokeStyle=ao.imageBorderColor;cj.lineWidth=0;for(var ct=V.length-1;ct>-1;ct--){var cu=V[ct];if(cu.bReady){cj.drawImage(cu.img,cu.x,cu.y,cu.drawWidth,cu.drawHeight);if(i){cj.strokeRect(cu.x+0.5,cu.y+0.5,cu.drawWidth-1,cu.drawHeight-1)}}else{if(cu.bDrawPlaceHolder){cj.fillStyle=ao.placeHolderColor;cj.fillRect(cu.x,cu.y,cu.drawWidth,cu.drawHeight);if(i){cj.strokeRect(cu.x+0.5,cu.y+0.5,cu.drawWidth-1,cu.drawHeight-1)}}}if(cu.oMirrorData){var cs=cu.y+cu.drawHeight;var cv=Math.abs(cu.z)*cu.nMirrorWidthOut;var cr=Math.abs(cu.z)*cu.nMirrorHeightOut;if(!cc){cj.clearRect(cu.x,cs,cv,cr)}if(cu.bCorsFix){cj.drawImage(cu.mirrorCanvas,0,0,cu.nMirrorWidth,cu.nMirrorHeight,cu.x,cs,cv,cr)}else{bY.clearRect(0,0,cu.nMirrorWidth,cu.nMirrorHeight);bY.putImageData(cu.oMirrorData,0,0);cj.drawImage(aH,0,0,cu.nMirrorWidth,cu.nMirrorHeight,cu.x,cs,cv,cr)}}}if(bs){cj.globalCompositeOperation="source-atop";cj.fillStyle=aj;cj.fillRect(0,0,aF.width,aF.height)}e()};var J=function(){var ct,cu;if(!bP){return}cj.globalCompositeOperation="source-over";cj.globalAlpha=1;cj.clearRect(0,0,aF.width,aF.height);cj.strokeStyle=ao.imageBorderColor;cj.lineWidth=0;for(ct=V.length-1;ct>-1;ct--){cu=V[ct];if(cu.bReady){cj.drawImage(cu.img,cu.x,cu.y,cu.drawWidth,cu.drawHeight);if(i){cj.strokeRect(cu.x+0.5,cu.y+0.5,cu.drawWidth-1,cu.drawHeight-1)}}else{if(cu.bDrawPlaceHolder){cj.fillStyle=ao.placeHolderColor;cj.fillRect(cu.x,cu.y,cu.drawWidth,cu.drawHeight);if(i){cj.strokeRect(cu.x+0.5,cu.y+0.5,cu.drawWidth-1,cu.drawHeight-1)}}}}if(bs){cj.globalCompositeOperation="source-atop";cj.fillStyle=aj;cj.fillRect(0,0,aF.width,aF.height)}cj.globalCompositeOperation="destination-over";for(ct=0;ct<V.length;ct++){cu=V[ct];if(cu.oMirrorData){var cs=cu.y+cu.drawHeight;var cv=Math.abs(cu.z)*cu.nMirrorWidthOut;var cr=Math.abs(cu.z)*cu.nMirrorHeightOut;if(cu.bCorsFix){cj.drawImage(cu.mirrorCanvas,0,0,cu.nMirrorWidth,cu.nMirrorHeight,cu.x,cs,cv,cr)}else{bY.clearRect(0,0,cu.nMirrorWidth,cu.nMirrorHeight);bY.putImageData(cu.oMirrorData,0,0);cj.drawImage(aH,0,0,cu.nMirrorWidth,cu.nMirrorHeight,cu.x,cs,cv,cr)}}}e()};var bN=function(cr){if(a1||b3.alphaTarget===cr){return}b3.alphaTarget=cr;ar()};var af=function(){var cr=aa(P);b3.x=Math.min(b3.range,-cr/bZ*b3.range)};var e=function(){if(a1){return}af();cj.globalCompositeOperation="source-over";if(b3.alpha!==b3.alphaTarget){if(Math.abs(b3.alpha-b3.alphaTarget)>0.01){b3.alpha+=(b3.alphaTarget-b3.alpha)/10;ar()}else{b3.alpha=b3.alphaTarget}}cj.globalAlpha=b3.alpha;cj.fillStyle=ao.scrollColor;var cv=b3.y;var ct=cv+b3.height-1;var cu=ct-cv-1;cj.fillRect(b3.padding,cv,b3.width,1);cj.fillRect(b3.padding,ct,b3.width,1);cv++;cj.fillRect(b3.padding,cv,1,cu);cj.fillRect(b3.width-1,cv,1,cu);var cr=Math.max(1,Math.round(b3.x));var cs=Math.min(b3.buttonWidth,b3.width-1-cr);cj.fillRect(b3.padding+cr,b3.y+1,cs,b3.height-2)};var F=function(cv){if(!a9||!bP){return}var ct=c;ct=Math.min(ct,Math.min(cv.img.width/20,cv.img.height/20));var cr=Math.min(U.width,cv.img.width/ct);var cs=Math.min(U.height,cv.img.height/ct);var cx=Math.min(ae/ct,Math.floor(cs*ao.mirrorHeight));var cw=cs-cx;aI.save();aI.globalCompositeOperation="source-over";if(!cq){aI.clearRect(0,0,cr,cx);aI.scale(1,-1);aI.drawImage(cv.img,0,cw*ct,cr*ct,cx*ct,0,-cx,cr,cx);aI.restore();aI.save();if(i){aI.strokeRect(0,0,cr,cs)}aI.scale(1,cx/ae);aI.fillRect(0,0,cr+1,ae+1)}else{aI.clearRect(0,0,cr,cx);aI.scale(1,cx/ae);aI.fillRect(0,0,cr+1,ae+1);aI.restore();aI.save();aI.globalCompositeOperation="source-in";aI.scale(1,-1);if(i){bT.clearRect(0,0,cr,cx);bT.drawImage(cv.img,0,cw*ct,cr*ct,cx*ct,0,0,cr,cx);bT.strokeRect(0,0,cr,cv.height);aI.drawImage(bj,0,0,cr,cx,0,-cx,cr,cx)}else{aI.drawImage(cv.img,0,cw*ct,cr*ct,cx*ct,0,-cx,cr,cx)}}aI.restore();try{cv.oMirrorData=aI.getImageData(0,0,cr,cx)}catch(cu){cv.mirrorCanvas=U.cloneNode();cv.oMirrorData=cv.mirrorCanvas.getContext("2d");cv.oMirrorData.drawImage(U,0,0);cv.bCorsFix=true}cv.nMirrorWidth=cr;cv.nMirrorHeight=cx;cv.nMirrorWidthOut=cr*ct;cv.nMirrorHeightOut=cx*ct};var Z=function(){if(a4!==b){return}a4=requestAnimationFrame(X)};var X=function(){P=aa(P+ap);ar();a4=requestAnimationFrame(X)};var aw=function(){if(a4===b){return}cancelAnimationFrame(a4);a4=b};var bi=function(){var cr=a.getElementDimension(w);if(cr.width<1){cr.width=1}if(cr.height<1){cr.height=1}return cr};var bh=function(){aF=aP=bi()};var b6=function(cr){if(!a3||cp.length<1){return}if(l===b){l={};l.offsetLeft=P;l.xAdvance=b1;l.nCenter=ba}if(cr.FSI_after_treshold!==b){aw();cancelAnimationFrame(bd);K=false;at.enable(true);n();bU();g=[];bh();if(aF.width>1&&aF.height>1){if(B){B.style.display="block"}var cs=aF.height/y.height;aR=Math.round(by.width*cs);bk=Math.round(by.spacing*cs);bG()}else{}return}if(!K){K=true;at.cancel();at.enable(false);if(B){cj.clearRect(0,0,aF.width,aF.height)}}};this.destroyOnDetach=function(){if(ao&&ao.autoDestroy!==false){M()}};this.addListener=function(cu,cs,ct){var cr=false;if(b0){cr=b0.addListener(cu,cs,ct)}return cr};this.removeListener=function(ct,cs){var cr=false;if(b0){cr=b0.removeListener(ct,cs)}return cr};var M=this.destroy=function(){if(bx){bx.destroy()}if(!bP){return}bP=false;bg.removeAttribute("x-fsi-id");n();bU();for(var cr in aQ){a5(aQ[cr])}aQ={};if(bb!==b){a.removeCustomEvent(bg,"FSIElementDimension",b6);bb=b}g=[];aw();aO=b;I(b,true);aD=0;cancelAnimationFrame(aT);cancelAnimationFrame(q);q=b;cancelAnimationFrame(bd);bd=b;cancelAnimationFrame(D);D=b;V=[];S={};Y=0;if(at){at.destroy();at=b}P=bV=0;a2=b;bQ=[];if(B){a.removeChild(w,B);B=b}cj=b;aH=bY=aI=U=bT=bj=b;b4={};ac={};f=0;a.removeChild(w.parentNode,w);if(b0){b0.run("onDestroy");b0.destroy()}}};(function(){var d="fsi-imageflow";var e="display:block;width:300px;height:300px;";var g=a.customTags[d];if(g){return}var c=function(i){var h=a.attributes2parameters(i);if(h.src!==b&&h.dir===b){h.dir=h.src}return h};var f={};f.registerElement=function(){a.addViewerClassCSSRule(d,e);var h=Object.create(HTMLDivElement.prototype);h.createdCallback=function(){a.customTagDimFromAttributes(this);a.ImageFlow.prototype.constructor.call(this)};h.attachedCallback=function(){if(this.getInitDone()){return}if(a.FullScreen&&a.FullScreen.bChanging){return}this.init(this,c(this))};h.detachedCallback=function(){if(a.FullScreen&&a.FullScreen.bChanging){return}this.destroyOnDetach()};document.registerElement(d,{prototype:h})};f.replaceTagInit=function(h){a.addViewerClassCSSRule(d,e)};f.replaceTag=function(h){if(!h||(typeof(h.getInitDone)==="function"&&h.getInitDone())){return}a.customTagDimFromAttributes(h);a.ImageFlow.prototype.constructor.call(h);h.init(h,c(h))};a.registerCustomTag(d,f)}())}(window.$FSI=window.$FSI||{}));