/*!
 * FSI Quick Zoom
 * Build: 18.05.17.1
 * 
 * Copyright (c) 2018 NeptuneLabs GmbH - All rights reserved.
 *
 * info@neptunelabs.com
 * www.neptunelabs.com
 * 
 * IMPORTANT NOTE
 * ------------------------------------------------------
 * Usage limited to the terms of the NeptuneLabs Software 
 * END-USER LICENSE AGREEMENT.
 * ------------------------------------------------------
 *
 */

"use strict";
(function($FSI,undefined){if($FSI.defined!=undefined){return}$FSI.defined=true;if(typeof(console.error)!="function"){$FSI.console={};$FSI.console.log=$FSI.fnDoNothing;$FSI.console.warn=$FSI.fnDoNothing;$FSI.console.error=$FSI.fnDoNothing;$FSI.console.dir=$FSI.fnDoNothing;$FSI.console.info=$FSI.fnDoNothing}else{$FSI.console=console}$FSI.oSupportedViewers={};try{if(typeof(top.window.alert)=="function"){$FSI.topWindow=top.window}else{$FSI.topWindow=window}}catch(e){$FSI.console.warn("FSI: top.window is not accessible. This is likely due to cross domain security restrictions. Viewer functionality might be limited.");$FSI.topWindow=window}$FSI.oInstanceCreated={};$FSI.ClassDef=function(instance,strClassName,oOptions){var version=oOptions.strVersion;var build=oOptions.strBuild;var self=this;this.instance=instance;this.strClassName=strClassName;this.strConfigSection=oOptions.strConfigSection;this.version=version;this.build=build;this.traceConfigValue=function(strParam){var parameters=(typeof(instance.getParameters)==="function")?instance.getParameters():undefined;var tmpCfg=new $FSI.Config(null,null,{strSection:self.strConfigSection});return tmpCfg.traceConfigValue(strParam,parameters)};instance.traceConfigValue=this.traceConfigValue;this.printAPI=function(){if(!self.oAPI){return}var line="------------------------------";line+=line+line;line="\r\n"+line+"\r\n";var toArray=function(obj){var ret=[];if(obj){for(var o in obj){var itm=obj[o];if(typeof(itm)!=="object"){itm={val:itm}}itm.nam=o;ret.push(itm)}}return ret};var outputData=function(obj,strTitle,strReturn,bArgs,objCompare){var i,arOut,strResult,strType,itm;var out="";var nNotAvailable=0;var args="";if(!obj){return}var ar=toArray(obj);if(ar.length>0){arOut=[];if(fnGroup){fnGroupCollapsed(strTitle.replace(/^API /,""))}else{out+="\r\n"+strTitle+" of "+strVersionString+line}for(i=0;i<ar.length;i++){if(bArgs){if(ar[i].a==undefined){ar[i].a="void"}args="( "+ar[i].a+" )"}strResult=(ar[i].r==undefined)?"":strReturn+ar[i].r;strType=(ar[i].t==undefined)?"":" ("+ar[i].t+")";itm=ar[i].nam+args+strResult+strType;if(objCompare&&objCompare[ar[i].nam]==undefined){nNotAvailable++;itm+=" [x]"}arOut.push(itm)}out+=arOut.join("\r\n");if(nNotAvailable>0){out+="\r\n\r\nPLEASE NOTE: items marked with [x] are not available with the current configuration options"}$FSI.console.log(out);if(fnGroup!=undefined){console.groupEnd()}}};var fnGroup,fnGroupCollapsed;if(!$FSI.isInternetExplorer&&typeof(console.group)=="function"){fnGroup=console.group;if(typeof(console.groupCollapsed)=="function"){fnGroupCollapsed=console.groupCollapsed}else{console.groupCollapsed=fnGroup}}if(fnGroup!=undefined){fnGroup("API of "+strVersionString)}outputData(self.oAPI.oMethods,"API Methods"," // RETURNS: ",true);outputData(self.oAPI.oProperties,"API Properties","","");outputData(self.oAPI.oCallbacks,"API Listeners"," // RETURN: ",true);var oActiveButtons=(typeof(self.oAPI.getActiveMenuButtons)=="function")?self.oAPI.getActiveMenuButtons():undefined;outputData(self.oAPI.oMenuCommands,"Button IDs","",false,oActiveButtons);if(fnGroup!=undefined){console.groupEnd()}};instance.printAPI=this.printAPI;this.testAPIListenersStart=function(){if(!instance.addListener||instance._TestAPIListeners){return}var strInstance=instance.getInstanceName();instance._TestAPIListeners={};for(var listenerName in self.oAPI.oCallbacks){instance._TestAPIListeners[listenerName]={};instance._TestAPIListeners[listenerName].listenerName=listenerName;instance._TestAPIListeners[listenerName].fn=function(){$FSI.console.log(strInstance+" called listener ["+this.listenerName+"]",arguments)};instance.addListener(listenerName,instance._TestAPIListeners[listenerName].fn,instance._TestAPIListeners[listenerName])}};this.testAPIListenersStop=function(){if(!instance.removeListener||!instance._TestAPIListeners){return}for(var listenerName in self.oAPI.oCallbacks){instance.removeListener(listenerName,instance._TestAPIListeners[listenerName].fn)}instance._TestAPIListeners=undefined;delete instance._TestAPIListeners};if(oOptions.bHasListeners){instance.testAPIListenersStart=this.testAPIListenersStart;instance.testAPIListenersStop=this.testAPIListenersStop}var strVersionString=strClassName+" "+version+" build "+build;var getVersion=function(){return strVersionString};var getBuild=function(){return build};instance.getVersion=getVersion;instance.getBuild=getBuild;if(!$FSI.oInstanceCreated[strClassName]){$FSI.oInstanceCreated[strClassName]=true;if(instance.getBuild()!=$FSI.getBuild()){$FSI.console.error("FSI version mismatch: "+getVersion()+" and "+$FSI.getVersion())}}};var oClassOptions={strVersion:"2018",strBuild:"18.05.17.1"};var classDef=new $FSI.ClassDef($FSI,"FSI Core",oClassOptions);$FSI.SVGNameSpaceURL="http://www.w3.org/2000/svg";$FSI.regexPlusToSpace=/\+/g;$FSI.regExServerRenderer=/([?&])(renderer|profile)=([^&]*)/i;$FSI.nViewerInstanceID=0;$FSI.bHTTPS=(document.location.protocol=="https:");$FSI.getViewerInstanceID=function(){return ++$FSI.nViewerInstanceID};$FSI.BoolTable={"0":false,"false":false,"1":true,"true":true};$FSI.makeBool=function(value,def){var ret;var t=typeof(value);if(t==="boolean"){ret=value}else{if(t==="string"){value=value.toLowerCase()}ret=$FSI.BoolTable[value];if(ret==undefined){ret=def}}return ret};$FSI.changeRendererInURL=function(url,strRenderer){url=url.replace($FSI.regExServerRenderer,"$1renderer="+strRenderer);return url};$FSI.loadSkinCSS=function(skinName,scope,fnReady,nPriority,arDependencies){if(typeof($FSI.iLoaderCSSSkin)!=="object"){if(typeof($FSI.LoaderCSSSkin)!=="function"){$FSI.console.error("Class $FSI.LoaderCSSSkin missing.");fnReady.call(scope,false);return}$FSI.iLoaderCSSSkin=new $FSI.LoaderCSSSkin()}return $FSI.iLoaderCSSSkin.load(skinName,scope,fnReady,nPriority,arDependencies)};$FSI.addedCSSBlocks={};$FSI.cssClassExists=function(cssID){return(typeof($FSI.addedCSSBlocks[cssID])!="undefined")};$FSI.addCSSClass=function(cssID,strCode){if($FSI.cssClassExists(cssID)){return false}var node=$FSI.addCSSNode(cssID);if(node){try{node.innerHTML=strCode;$FSI.addedCSSBlocks[cssID]=node}catch(e){$FSI.console.error("FSI: addCSSClass failed")}}};$FSI.addCSSNode=function(cssID){var node=null;try{node=document.createElement("style");node.setAttribute("x-generated-by","FSI");node.setAttribute("x-generated-for",cssID);node.setAttribute("x-fsi-priority","0");node.appendChild(document.createTextNode(""));if(document.head.firstChild){document.head.insertBefore(node,document.head.firstChild)}else{document.head.appendChild(node)}}catch(e){$FSI.console.error("FSI: FAILED to create style node for "+cssID);$FSI.console.error(e.message)}return node};$FSI.deleteInstanceCSSRules=function(iInstance){var ar=iInstance._arCSSLayoutSelectors;if(ar!=undefined&&ar.length>0){for(var i=0;i<ar.length;i++){$FSI.deleteCSSRule(ar[i])}iInstance._arCSSLayoutSelectors=[]}};$FSI.addInstanceCSSRule=function(iInstance,strSelector,strRule){if(iInstance._arCSSLayoutSelectors==undefined){iInstance._arCSSLayoutSelectors=[]}iInstance._arCSSLayoutSelectors.push(strSelector);$FSI.addCSSRule(strSelector,strRule,0)};$FSI.addCSSRule=function(selector,rules,index){if($FSI.oInsertedCSS==undefined){$FSI.oInsertedCSS=$FSI.addCSSNode("FSI.Core")}if($FSI.oInsertedCSS!=undefined){try{if($FSI.oInsertedCSS&&$FSI.oInsertedCSS.sheet){if("insertRule" in $FSI.oInsertedCSS.sheet){$FSI.oInsertedCSS.sheet.insertRule(selector+"{"+rules+"}",index)}else{if("addRule" in $FSI.oInsertedCSS.sheet){$FSI.oInsertedCSS.sheet.addRule(selector,rules,index)}}}}catch(e){$FSI.console.error("FSI: FAILED to add css rule for "+selector);$FSI.console.error(e.message)}}};$FSI.deleteCSSRule=function(selector){var ret=false;if($FSI.oInsertedCSS!=undefined){try{var arDelete=[];var ar=$FSI.oInsertedCSS.sheet.cssRules;for(var i=0;i<ar.length;i++){var rule=ar[i];if(rule.selectorText==selector){arDelete.push(i)}}if(arDelete.length>0){for(var i=arDelete.length-1;i>-1;i--){$FSI.oInsertedCSS.sheet.deleteRule(arDelete[i])}ret=true}}catch(e){console.error(e.message);ret=false}}return ret};$FSI.setStyleAttr=function(el,strStyle){
/*@cc_on
		 @if (@_jscript_version < 9)
		 el.style.setAttribute('cssText', strStyle);
		 @else @*/
el.setAttribute("style",strStyle);
/*@end
		 @*/
};$FSI.rgbaHexToDecimal=function(str){var ret={};if(typeof(str)!=="string"){str=""}str=str.toLowerCase();str=str.replace(/[^0-9-a-f]/g,"F");if(str.length>8){str=str.substr(0,8)}else{var def="FFFFFFFF";str+=def.substr(0,8-str.length)}ret.hex=str;ret.redHex=str.substr(0,2);ret.greenHex=str.substr(2,2);ret.blueHex=str.substr(4,2);ret.alphaHex=str.substr(6,2);ret.red=parseInt(ret.redHex,16);ret.green=parseInt(ret.greenHex,16);ret.blue=parseInt(ret.blueHex,16);ret.alpha=parseInt(ret.alphaHex,16)/255;ret.strRGBA=ret.red+","+ret.green+","+ret.blue+","+ret.alpha;return ret};$FSI.documentDomain=document.location.hostname;$FSI.regCors=new RegExp("//"+$FSI.documentDomain+"[:/]");$FSI.isCrossDomain=function(url){if(!url||url.indexOf("http")!==0){return false}return url.match($FSI.regCors)==null};$FSI.loadImageCors=function(img,url){if($FSI.isCrossDomain(url)){img.crossOrigin="";img.src=url}else{img.src=url}};$FSI.getSVGID=function(){return"$FSI.SVGID_"+$FSI.SVGID++};$FSI.BrowserSupports={};$FSI.BrowserSupports[false]=function(){return false};$FSI.BrowserSupports[true]=function(){return true};$FSI.osVersion=[0,0,0];$FSI.SVGID=0;$FSI.initialWindowWidth=window.innerWidth;$FSI.bElementPosRespectsScroll=true;$FSI.oSupportedEvents={};$FSI.isEventSupported=function(eventName){if($FSI.oSupportedEvents[eventName]!=undefined){return $FSI.oSupportedEvents[eventName]}var el=document.createElement("div");var eventNameOn="on"+eventName;var isSupported=(eventNameOn in el);if(!isSupported){el.setAttribute(eventNameOn,"return;");isSupported=typeof el[eventNameOn]==="function"}el=null;$FSI.oSupportedEvents[eventName]=isSupported;return isSupported};var lastTime=0;var vendors=["ms","moz","webkit","o"];for(var x=0;x<vendors.length&&!window.requestAnimationFrame;++x){window.requestAnimationFrame=window[vendors[x]+"RequestAnimationFrame"];window.cancelAnimationFrame=window[vendors[x]+"CancelAnimationFrame"]||window[vendors[x]+"CancelRequestAnimationFrame"]}if(!window.requestAnimationFrame||!window.cancelAnimationFrame){window.requestAnimationFrame=function(callback,element){var currTime=new Date().getTime();var timeToCall=Math.max(0,16-(currTime-lastTime));var id=window.setTimeout(function(){callback(currTime+timeToCall)},timeToCall);lastTime=currTime+timeToCall;return id};window.cancelAnimationFrame=function(id){clearTimeout(id)}}$FSI.userAgent=navigator.userAgent.toLowerCase();var uagent=$FSI.userAgent;var result,t,i;if(uagent.search(/iphone|ipad|ipod|android|symbian|mobile|phone|windows ce|opera mini|opera mobi/i)>-1){result=true;if(uagent.search("android")>-1){$FSI.mobileOS="android";$FSI.isTouch=true;$FSI.noMouse=true;t=uagent.match(/android (\S*)/);if(t&&t.length>1){t=t[1].split(".");for(i=0;i<t.length;i++){t[i]=parseInt(t[i])}$FSI.osVersion=[].concat(t)}}else{if(uagent.indexOf("mac os")!==-1){$FSI.mobileOS="ios";$FSI.isTouch=true;$FSI.noMouse=true;t=uagent.match(/ os (\S*)/);if(t&&t.length>1){t=t[1].split("_");for(i=0;i<t.length;i++){t[i]=parseInt(t[i])}$FSI.osVersion=[].concat(t)}}}}else{result=false}$FSI.isMobileDevice=result;$FSI.isSmallMobileDevice=(uagent.search(/iphone|ipod|phone|mobile safari|iemobile|opera mini|opera mobi/i)>-1);$FSI.isInternetExplorer=false;$FSI.versionInternetExplorer=0;$FSI.isIETouch=false;if(uagent.search("msie")>-1){$FSI.isInternetExplorer=true;var t=uagent.match(/msie ([^;]*)/);if(t&&t.length>1){$FSI.versionInternetExplorer=parseFloat(t[1])}}else{if(navigator.userAgent.match(/Trident.*rv:(\d+\.)/gi)){$FSI.isInternetExplorer=true;$FSI.versionInternetExplorer=parseFloat(RegExp.$1)}else{$FSI.isInternetExplorer=(typeof(window.onmsgestureend)!=="undefined");$FSI.versionInternetExplorer=12}}if(window.navigator.msPointerEnabled){$FSI.isIETouch=(window.navigator.msMaxTouchPoints>1)}if($FSI.isIETouch){$FSI.bElementPosRespectsScroll=false}if(!$FSI.isTouch){$FSI.isTouch=(window.navigator.maxTouchPoints>1||window.navigator.msMaxTouchPoints>1)}if(uagent.search("chrome")!==-1&&uagent.search("edge")===-1){$FSI.isChrome=true}else{if(uagent.search("safari")!==-1){$FSI.isSafari=true}else{if(uagent.search("firefox")!==-1){$FSI.isFirefox=true}else{if(uagent.search("opera")!==-1){$FSI.isOpera=true}}}}if(uagent.search("mac os")>-1){$FSI.isMac=true}if(typeof(window.pageYOffset)==="number"){$FSI.getDocumentScroll=function(wnd){return{x:wnd.pageXOffset,y:wnd.pageYOffset}}}else{if(document.body&&(document.body.scrollLeft||document.body.scrollTop)){$FSI.getDocumentScroll=function(wnd){return{x:wnd.document.body.scrollLeft,y:wnd.document.body.scrollTop}}}else{if(document.documentElement&&(document.documentElement.scrollLeft||document.documentElement.scrollTop)){$FSI.getDocumentScroll=function(wnd){return{x:wnd.document.documentElement.scrollLeft,y:wnd.document.documentElement.scrollTop}}}}}$FSI.getDocumentScaleNone=function(){return 1};$FSI.__getMediaMinScreenWidthCount=0;$FSI.__getMediaMinScreenWidthLoopCount=0;$FSI.oMatchMedia=$FSI.topWindow.matchMedia||$FSI.topWindow.msMatchMedia;$FSI.getMediaMinScreenWidth=function(nam,unit){var init=$FSI.topWindow.document.documentElement.clientWidth;if($FSI.__LastGetMediaMinScreenWidth==$FSI.topWindow.document.documentElement.clientWidth){return $FSI.__LastGetMediaMinScreenWidthResult}$FSI.__LastGetMediaMinScreenWidth=$FSI.topWindow.document.documentElement.clientWidth;$FSI.__getMediaMinScreenWidthCount++;var step=10;var pre="("+nam+":";var suf=unit+")";while($FSI.oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){$FSI.__getMediaMinScreenWidthLoopCount++}init-=step;step=5;while($FSI.oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){$FSI.__getMediaMinScreenWidthLoopCount++}init-=step;step=1;while($FSI.oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){$FSI.__getMediaMinScreenWidthLoopCount++}$FSI.__LastGetMediaMinScreenWidthResult=$FSI.__getDocumentScaleReferenceWidth=init-step;return $FSI.__LastGetMediaMinScreenWidthResult};$FSI.getDocumentScaleInit=function(){$FSI.getDocumentScale=$FSI.getDocumentScaleNone;if($FSI.BrowserSupports.visualViewportAPI()){$FSI.documentScaleMethod="visualViewport API";$FSI.getDocumentScale=function(){return window.visualViewport.scale};return $FSI.getDocumentScale()}if($FSI.topWindow.innerWidth==undefined){$FSI.documentScaleMethod="none";return $FSI.getDocumentScale()}if($FSI.isInternetExplorer&&$FSI.isMobileDevice){$FSI.documentScaleMethod="window.outerWidth / window.innerWidth windows mobile";$FSI.getDocumentScale=function(){if(screen.width!=$FSI.topWindow.outerWidth){return($FSI.topWindow.outerWidth-192)/$FSI.topWindow.innerWidth}return($FSI.topWindow.outerWidth-83)/$FSI.topWindow.innerWidth};return $FSI.getDocumentScale()}if(window.orientation!=undefined){if(!window.outerWidth){$FSI.documentScaleMethod="screen.width / window.innerWidth iOS";$FSI.getDocumentScale=function(){$FSI.__getDocumentScaleReferenceWidth=(window.orientation%180===0)?screen.width:screen.height;return $FSI.__getDocumentScaleReferenceWidth/window.innerWidth};return $FSI.getDocumentScale()}$FSI.documentScaleMethod="window.outerWidth / window.innerWidth";$FSI.getDocumentScale=function(){return window.outerWidth/window.innerWidth};return $FSI.getDocumentScale()}if($FSI.oMatchMedia&&$FSI.topWindow.document.documentElement.clientWidth>0){var w=$FSI.getMediaMinScreenWidth("min-width","px");if(!isNaN(w)){$FSI.documentScaleMethod="CSS Media Query";$FSI.getDocumentScale=function(){var res=$FSI.getMediaMinScreenWidth("min-width","px")/$FSI.topWindow.innerWidth;if(isNaN(res)){res=1}return res};return $FSI.getDocumentScale()}}$FSI.documentScaleMethod="fallback";$FSI.getDocumentScale=function(){return $FSI.topWindow.outerWidth/$FSI.topWindow.innerWidth};return $FSI.getDocumentScale()};$FSI.getDocumentScale=$FSI.getDocumentScaleInit;if(typeof(window.devicePixelRatio)!=="undefined"){$FSI.getDevicePixelRatio=function(){return window.devicePixelRatio||1}}else{$FSI.getDevicePixelRatio=function(){return 1}}$FSI.getDocumentScaleWithPixelRatio=function(){return $FSI.getDocumentScale()*$FSI.getDevicePixelRatio()};$FSI.fnDoNothing=function(){};$FSI.preventDefaultEvent=function(evt){if(evt.preventDefault){evt.preventDefault()}evt.returnValue=false;return false};$FSI.getVisualViewportSize=function(){var ret={};if(window.visualViewport){ret.width=window.visualViewport.width;ret.height=window.visualViewport.height}else{ret.width=window.innerWidth;ret.height=window.innerHeight}return ret};$FSI.getElementDimension=function(elem){return{width:elem.offsetWidth,height:elem.offsetHeight}};$FSI.getElementInnerDimension=function(elem){var ret={width:elem.clientWidth,height:elem.clientHeight};var padding=$FSI.getElementPaddings(elem);ret.width-=padding.left+padding.right;ret.height-=padding.top+padding.bottom;return ret};$FSI.getViewportSize=function(wnd){var ret;if($FSI.BrowserSupports.visualViewportAPI()){ret={width:wnd.visualViewport.width,height:wnd.visualViewport.height}}else{ret={width:wnd.innerWidth,height:wnd.innerHeight}}return ret};$FSI.mergeObjects=function(o1,o2){for(var o in o2){o1[o]=o2[o]}return o1};$FSI.cloneArray=function(ar){if(ar==undefined||ar.length==undefined){return[]}return ar.concat([])};$FSI.cloneArrayRecursive=function(ar){if(ar==undefined||ar.length==undefined){return[]}var ret=ar.concat([]);for(var i=0;i<ar.length;i++){ar[i]=$FSI.cloneValue(ar[i])}return ret};$FSI.cloneValue=function(val){var ret;switch(typeof(val)){case"object":if(val!=null&&typeof(val.cloneNode)==="function"){ret=val}else{if(val!=null&&typeof(val.push)==="function"){ret=$FSI.cloneArrayRecursive(val)}else{ret=$FSI.cloneObject(val)}}break;default:ret=val}return ret};$FSI.cloneObject=function(obj){if(obj==null){return null}var ret={};if(typeof(obj)=="object"&&typeof(obj.push)==="function"){ret=$FSI.cloneArrayRecursive(obj)}else{for(var o in obj){ret[o]=$FSI.cloneValue(obj[o])}}return ret};$FSI.cloneParameters=function(parameters){return $FSI.cloneObject(parameters)};$FSI.replaceChild=function(parent,existingChild,newChild){try{var elNext=existingChild.nextSibling;if(elNext){parent.removeChild(existingChild);parent.insertBefore(newChild,elNext)}else{parent.appendChild(newChild)}}catch(e){$FSI.console.error(e.message);$FSI.console.log(parent);$FSI.console.log(existingChild);$FSI.console.log(newChild)}};$FSI.removeChild=function(parent,child){try{parent.removeChild(child)}catch(e){$FSI.console.error(e.message);$FSI.console.log(parent);$FSI.console.log(child)}};$FSI.callbackFunctionID=0;$FSI.oCustomEventListenerClasses={};$FSI.oCustomEventListenerInstances={};$FSI.oCustomEventListeners={};$FSI.nCustomEventListeners=0;$FSI.nCustomEventListenerID=0;$FSI.addCustomEvent=function(myObj,myEvent,myFunc,bCapturingPhase){var obj,listenerID;var listener=$FSI.oCustomEventListenerInstances[myEvent];if(!listener){if(typeof($FSI.oCustomEventListenerClasses[myEvent])==="undefined"){$FSI.console.error("$FSI.oCustomEventListenerClass for '"+myEvent+"' is undefined.");return false}listener=$FSI.oCustomEventListenerInstances[myEvent]=new $FSI.oCustomEventListenerClasses[myEvent](myObj,myFunc)}obj=listener.addListener(myObj,myFunc);if(obj!=undefined){listenerID=obj.nCustomEventListenerID=$FSI.nCustomEventListenerID++;$FSI.oCustomEventListeners[obj.nCustomEventListenerID]=obj;$FSI.nCustomEventListeners++}else{$FSI.console.error("Failed to add custom event listener: "+myEvent)}return listenerID};$FSI.removeCustomEvent=function(myObj,myEvent,myFunc,bCapturingPhase){var listener=$FSI.oCustomEventListenerInstances[myEvent];if(!listener){return false}var obj=listener.removeListener(myObj,myFunc);if(obj&&$FSI.oCustomEventListeners[obj.nCustomEventListenerID]!=undefined){delete $FSI.oCustomEventListeners[obj.nCustomEventListenerID];$FSI.nCustomEventListeners--}else{$FSI.console.error("Failed to remove custom event listener")}};$FSI.setCustomEventListenerProperty=function(listenerID,nam,val){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.setListenerProps.call(obj.instanceListener,obj.uniqueID,nam,val)};$FSI.enableCustomEventListener=function(listenerID,bEnable){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.enableListener.call(obj.instanceListener,obj.uniqueID,bEnable)};$FSI.pauseCustomEventListener=function(listenerID,bPause){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.pauseListener.call(obj.instanceListener,obj.uniqueID,bPause)};$FSI.triggerCustomEvent=function(listenerID){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.triggerEvent.call(obj.instanceListener,obj.uniqueID)};$FSI.removeEvent=function(myObj,myEvent,myFunc,bCapturingPhase){if(window.removeEventListener&&myObj){if(bCapturingPhase==undefined){bCapturingPhase=true}myObj.removeEventListener(myEvent,myFunc,bCapturingPhase)}else{if(window.detachEvent&&myObj){myObj.detachEvent("on"+myEvent,myFunc)}}};$FSI.addEvent=function(myObj,myEvent,myFunc,bCapturingPhase){if(window.addEventListener&&myObj){if(bCapturingPhase==undefined){bCapturingPhase=true}myObj.addEventListener(myEvent,myFunc,bCapturingPhase)}else{if(window.attachEvent&&myObj){myObj.attachEvent("on"+myEvent,myFunc)}}};$FSI.getScriptTagByFileName=function(strScriptName){var tag,strSelector;if(typeof(document.querySelector)==="function"){strSelector="script[src$='"+strScriptName+"']";tag=document.querySelector(strSelector);if(!tag){strSelector="script[src*='"+strScriptName+"']";tag=document.querySelector(strSelector)}}if(!tag){var tmp=$FSI.escapeRegEx(strScriptName);var regEx=new RegExp("(^|/)"+tmp+"(\\s*|\\?.*)$");var scripts=document.getElementsByTagName("script");for(var i=0;i<scripts.length;i++){var src=scripts[i].src;if(src.match(regEx)){tag=scripts[i];break}}}return tag};$FSI.getScriptPath=function(strScriptName,depth){var src;depth++;var ret="";var tag=$FSI.getScriptTagByFileName(strScriptName);if(tag){src=tag.src.split("/");src.splice(src.length-depth,depth);ret=src.join("/")}return ret};$FSI.guessFSIViewerLocation=function(strScriptName,depth){if($FSI._FSIViewerLocation!=undefined){return $FSI._FSIViewerLocation}var ret=$FSI.getScriptPath(strScriptName,depth);if(ret){$FSI._FSIViewerLocation=ret}return ret};$FSI.createJavascriptLoader=function(){if(typeof($FSI.iLoaderJavascript)!=="object"){if(typeof($FSI.LoaderJavascript)!=="function"){$FSI.console.error("Class $FSI.LoaderJavascript missing.");return false}$FSI.iLoaderJavascript=new $FSI.LoaderJavascript()}return true};$FSI.loadJavascript=function(strScriptPath,idInstance,argScope,fnOnLoad,oPassThrough){if(!$FSI.createJavascriptLoader()){return false}return $FSI.iLoaderJavascript.load(strScriptPath,idInstance,argScope,fnOnLoad,oPassThrough)};$FSI.releaseLoadJavascript=function(strScriptPath,idInstance){if(!$FSI.createJavascriptLoader()){return false}return $FSI.iLoaderJavascript.release(strScriptPath,idInstance)};$FSI.customTags={};$FSI.bCustomTagsAdded=false;$FSI.customTagDimFromAttributes=function(el){var rpl=function(nam){var tmp=el.getAttribute(nam);if(typeof(tmp)==="string"&&tmp.length>0){if(!tmp.match(/[^0-9\s]/)){tmp+="px"}el.style[nam]=tmp}};rpl("width");rpl("height")};$FSI.setParameters=function(node,parameters){if(!node||typeof(node.tagName)!=="string"){return false}var t=typeof(parameters);if(t!=="object"&&t!=="function"){return false}node._fsi_parameters=parameters};$FSI.getParameters=function(node){if(!node||typeof(node.tagName)!=="string"){return false}return node._fsi_parameters};$FSI.initCustomNode=function(node){if($FSI.BrowserSupports.registerElement()){return true}if(!node||typeof(node.tagName)!=="string"){return false}var strTagName=node.tagName.toLowerCase();var oCustomTag=$FSI.customTags[strTagName];if(!oCustomTag||typeof(oCustomTag.replaceTag)!=="function"){return false}if(oCustomTag.replaceTagInit){oCustomTag.replaceTagInit();delete oCustomTag.replaceTagInit}oCustomTag.replaceTag(node);return true};$FSI.initCustomTags=function(){if($FSI.BrowserSupports.registerElement()){return}for(var o in $FSI.customTags){$FSI.initCustomTag(o)}};$FSI.initCustomTag=function(strTagName){if($FSI.BrowserSupports.registerElement()){return}var oCustomTag=$FSI.customTags[strTagName];if(!oCustomTag||typeof(oCustomTag.replaceTag)!=="function"){return false}var ar=document.getElementsByTagName(strTagName);if(ar&&ar.length>0){if(oCustomTag.replaceTagInit){oCustomTag.replaceTagInit();delete oCustomTag.replaceTagInit}for(var i=0;i<ar.length;i++){oCustomTag.replaceTag(ar[i])}}};$FSI.registerCustomTag=function(strTagName,oFunctions){var oCustomTag=$FSI.customTags[strTagName];if(oCustomTag){return false}oCustomTag=$FSI.customTags[strTagName]={};if($FSI.BrowserSupports.registerElement()){oCustomTag.bRegistered=true;oFunctions.registerElement()}else{oCustomTag.bRegistered=false;oCustomTag.replaceTag=oFunctions.replaceTag;if(typeof(oFunctions.replaceTagInit)==="function"){oCustomTag.replaceTagInit=oFunctions.replaceTagInit}if(!$FSI.bCustomTagsAdded){$FSI.bCustomTagsAdded=true;$FSI.addEvent(window,"DOMContentLoaded",$FSI.initCustomTags)}}return true};$FSI.attributes2parameters=function(node){var ret={};if(!node||typeof(node.attributes)!=="object"){return ret}var attr;var attrs=node.attributes;for(var i=0;i<attrs.length;i++){attr=attrs[i];ret[attr.name]=attr.value}return ret};$FSI.oViewerClassCSSRules={};$FSI.addViewerClassCSSRule=function(strClass,strRule){if(typeof(strClass)!=="string"||strClass.length<1){return}if(typeof(strRule)!=="string"||strRule.length<1){return}var res=$FSI.oViewerClassCSSRules[strClass];if(res==strRule){return}$FSI.addCSSRule(strClass,strRule,0);$FSI.oViewerClassCSSRules[strClass]=strRule};$FSI.now=(typeof(Date.now)==="function")?Date.now:function(){return new Date().getTime()};$FSI.getWindowOffset=function(el){var ofsX=0;var ofsY=0;try{if(el.frameElement){var w=el;while(w.frameElement){var node=w.frameElement;var nodePos=$FSI.getElementPosition(node);ofsX+=nodePos.left;ofsY+=nodePos.top;w=w.parent}}}catch(e){}return{x:ofsX,y:ofsY}};$FSI.getElementPaddings=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.paddingLeft);ret.top=parseFloat(style.paddingTop);ret.right=parseFloat(style.paddingRight);ret.bottom=parseFloat(style.paddingBottom)}catch(e){}return ret};$FSI.getElementMargins=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.marginLeft);ret.top=parseFloat(style.marginTop);ret.right=parseFloat(style.marginRight);ret.bottom=parseFloat(style.marginBottom)}catch(e){}return ret};$FSI.getElementBorders=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.borderLeftWidth);ret.top=parseFloat(style.borderTopWidth);ret.right=parseFloat(style.borderRightWidth);ret.bottom=parseFloat(style.borderBottomWidth)}catch(e){}return ret};$FSI.getBoundingClientRect=function(el){var ret;try{ret=el.getBoundingClientRect()}catch(e){ret={top:0,left:0,right:0,bottom:0,width:0,height:0}}return ret};$FSI.getElementClientDim=function(element){var rc=$FSI.getBoundingClientRect(element);return{width:(rc.right-rc.left),height:(rc.bottom-rc.top)}};$FSI.getElementClientPos=function(element){return $FSI.getBoundingClientRect(element)};$FSI.getElementPosition=function(element){var rc=$FSI.getBoundingClientRect(element);var bl=element.clientLeft;var bt=element.clientTop;var br=0;var bb=0;var pl=0;var pr=0;var pt=0;var pb=0;try{var style=window.getComputedStyle(element,null);pl=parseFloat(style.paddingLeft);pr=parseFloat(style.paddingRight);pt=parseFloat(style.paddingTop);pb=parseFloat(style.paddingBottom);bl=parseFloat(style.borderLeftWidth);br=parseFloat(style.borderRightWidth);bt=parseFloat(style.borderTopWidth);bb=parseFloat(style.borderBottomWidth)}catch(e){}var x1=rc.left+bl+pl;var y1=rc.top+bt+pt;var x2=rc.right-br-pr;var y2=rc.bottom-bb-pb;return{left:x1,top:y1,right:x2,bottom:y2}};$FSI.trim=function(s){if(!s||typeof(s)!=="string"||s.length<1){return s}return s.replace(/(^\s+)|(\s+$)/g,"")};$FSI.escapeRegEx=function(s){return s.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")};$FSI.addClass=function(el,strClass){if(!el||typeof(el.className)!=="string"){return}if(typeof(strClass)!=="string"){return}strClass=$FSI.trim(strClass);if(strClass.length<1){return}strClass=strClass.replace(/\s+/," ");var needle=$FSI.escapeRegEx(strClass);var regex=new RegExp("(^|\\s+)"+needle+"(\\s+|$)");var strCurrent=$FSI.trim(el.className);var bFound=strCurrent.match(regex);if(!bFound){if(strCurrent.length>0){strCurrent+=" "+strClass}else{strCurrent+=strClass}el.className=strCurrent}};$FSI.removeClass=function(el,strClass){if(!el||typeof(el.className)!=="string"){return}if(typeof(strClass)!=="string"){return}strClass=$FSI.trim(strClass);if(strClass.length<1){return}strClass=strClass.replace(/\s+/," ");var needle=$FSI.escapeRegEx(strClass);var regex=new RegExp("(^|\\s+)"+needle+"(\\s+|$)","g");var str=$FSI.trim(el.className.replace(regex," "));if(str.length>0){el.className=str}else{el.removeAttribute("class")}};$FSI.hasClass=function(el,strClass){if(typeof(strClass)!=="string"){return false}strClass=$FSI.trim(strClass);if(strClass.length<1){return false}var str=el.className;if(typeof(str)!=="string"||str.length<1){return false}strClass=strClass.replace(/\s+/," ");var needle=$FSI.escapeRegEx(strClass);var regex=new RegExp("(^|\\s+)"+needle+"(\\s+|$)","g");return(str.match(regex)!=null)};$FSI.urlDecode=function(str){if(!str){return str}var ret=str.replace($FSI.regexPlusToSpace," ");try{ret=decodeURIComponent(ret)}catch(e){$FSI.console.error("Malformed URI: "+ret)}return ret};$FSI.getCSSTransformStyleName=function(){if($FSI._CSSTransformStyleName!=undefined){return $FSI._CSSTransformStyleName}var ret="transform";var ar=["transform","webkitTransform","msTransform","MozTransform","OTransform"];var div=document.createElement("DIV");for(var i=0;i<ar.length;i++){div.style[ar[i]]="translate( 0 , 0)";if(div.style[ar[i]]!="translate( 0 , 0)"){ret=ar[i];break}}div=null;$FSI._CSSTransformStyleName=ret;return ret};$FSI.regExEffects=/((\?)|&)effects=([^&]*)/ig;$FSI.regExPadEffect=/[=,]+Pad\([^)]*/ig;$FSI.expandSourceDimensionForPadEffect=function(o,w,h){var dimOrg;if(typeof(o)!=="object"||typeof(o.src)!=="string"){return}var res=o.src.match($FSI.regExEffects);if(res&&typeof(res)==="object"&&typeof(res[0])==="string"){o.bHasEffects=true;res[0]=decodeURIComponent(res[0]);if(res[0].match($FSI.regExPadEffect)){o.bHasPadEffect=true;var rectWidth=(o.rectWidth!==undefined)?o.rectWidth:1;var rectHeight=(o.rectHeight!==undefined)?o.rectHeight:1;if(rectWidth>0&&rectHeight>0){var sourceWidth=rectWidth*o.sourceWidth;var sourceHeight=rectHeight*o.sourceHeight;if(sourceWidth/w>sourceHeight/h){dimOrg=sourceHeight/sourceWidth*w;o.sourceHeight=Math.round(h/dimOrg*sourceHeight)/rectHeight}else{dimOrg=sourceWidth/sourceHeight*h;o.sourceWidth=Math.round(w/dimOrg*sourceWidth)/rectWidth}}}}};$FSI.getFSIServerImageDim=function(wSource,hSource,wTarget,hTarget,range,keepAspectRatio){var sourceDim={width:wSource,height:hSource};var targetDim={width:wTarget,height:hTarget};$FSI.calcFSIServerImageDim(sourceDim,targetDim,range,keepAspectRatio);return targetDim};$FSI.calcFSIServerImageDim=function(sourceDimension,targetDimension,range,keepAspectRatio){if(typeof(range)!=="object"){range={left:0,top:0,width:1,height:1}}else{range.left=range.left<0?0:range.left>1?1:range.left;range.top=range.top<0?0:range.top>1?1:range.top;range.width=range.width<0?1-range.left:range.width+range.left>1?1-range.left:range.width;range.height=range.height<0?1-range.top:range.height+range.top>1?1-range.top:range.height}targetDimension.width=targetDimension.width<=0||targetDimension.width===undefined?-1:targetDimension.width;targetDimension.height=targetDimension.height<=0||targetDimension.height===undefined?-1:targetDimension.height;var scale={};if(targetDimension.width!=-1&&targetDimension.height!=-1){scale.x=targetDimension.width/(sourceDimension.width*range.width);scale.y=targetDimension.height/(sourceDimension.height*range.height)}else{if(targetDimension.height==-1){scale.x=scale.y=targetDimension.width/(sourceDimension.width*range.width)}else{scale.x=scale.y=targetDimension.height/(sourceDimension.height*range.height)}}if(targetDimension.width==-1||targetDimension.height==-1){var scaleFactor=Math.min(scale.x,scale.y);if(targetDimension.width==-1){targetDimension.width=Math.round(sourceDimension.width*range.width*scaleFactor)}else{if(targetDimension.height==-1){targetDimension.height=Math.round(sourceDimension.height*range.height*scaleFactor)}}scale.x=scaleFactor;scale.y=scaleFactor}if(keepAspectRatio&&Math.abs(scale.x-scale.y)>1e-7){if(scale.x>scale.y){var preciseTargetWidth=targetDimension.height*sourceDimension.width*range.width/(sourceDimension.height*range.height);scale.x=preciseTargetWidth/sourceDimension.width;targetDimension.width=Math.round(preciseTargetWidth)}else{var preciseTargetHeight=targetDimension.width*sourceDimension.height*range.height/(sourceDimension.width*range.width);scale.y=preciseTargetHeight/sourceDimension.height;targetDimension.height=Math.round(preciseTargetHeight)}}targetDimension.width=targetDimension.width==0?1:targetDimension.width;targetDimension.height=targetDimension.height==0?1:targetDimension.height;return scale};if(typeof(window.JSON)==="undefined"){$FSI.JSON={};$FSI.JSON._emulated=true}else{$FSI.JSON=JSON}(function(){function f(n){return n<10?"0"+n:n}if(typeof Date.prototype.toJSON!=="function"){Date.prototype.toJSON=function(key){return isFinite(this.valueOf())?this.getUTCFullYear()+"-"+f(this.getUTCMonth()+1)+"-"+f(this.getUTCDate())+"T"+f(this.getUTCHours())+":"+f(this.getUTCMinutes())+":"+f(this.getUTCSeconds())+"Z":null};String.prototype.toJSON=Number.prototype.toJSON=Boolean.prototype.toJSON=function(key){return this.valueOf()}}var cx=/[\u0000\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,escapable=/[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,gap,indent,meta={"\b":"\\b","\t":"\\t","\n":"\\n","\f":"\\f","\r":"\\r",'"':'\\"',"\\":"\\\\"},rep;function quote(string){escapable.lastIndex=0;return escapable.test(string)?'"'+string.replace(escapable,function(a){var c=meta[a];return typeof c==="string"?c:"\\u"+("0000"+a.charCodeAt(0).toString(16)).slice(-4)})+'"':'"'+string+'"'}function str(key,holder){var i,k,v,length,mind=gap,partial,value=holder[key];if(value&&typeof value==="object"&&typeof value.toJSON==="function"){value=value.toJSON(key)}if(typeof rep==="function"){value=rep.call(holder,key,value)}switch(typeof value){case"string":return quote(value);case"number":return isFinite(value)?String(value):"null";case"boolean":case"null":return String(value);case"object":if(!value){return"null"}gap+=indent;partial=[];if(Object.prototype.toString.apply(value)==="[object Array]"){length=value.length;for(i=0;i<length;i+=1){partial[i]=str(i,value)||"null"}v=partial.length===0?"[]":gap?"[\n"+gap+partial.join(",\n"+gap)+"\n"+mind+"]":"["+partial.join(",")+"]";gap=mind;return v}if(rep&&typeof rep==="object"){length=rep.length;for(i=0;i<length;i+=1){if(typeof rep[i]==="string"){k=rep[i];v=str(k,value);if(v){partial.push(quote(k)+(gap?": ":":")+v)}}}}else{for(k in value){if(Object.prototype.hasOwnProperty.call(value,k)){v=str(k,value);if(v){partial.push(quote(k)+(gap?": ":":")+v)}}}}v=partial.length===0?"{}":gap?"{\n"+gap+partial.join(",\n"+gap)+"\n"+mind+"}":"{"+partial.join(",")+"}";gap=mind;return v}}if(typeof $FSI.JSON.stringify!=="function"){$FSI.JSON.stringify=function(value,replacer,space){var i;gap="";indent="";if(typeof space==="number"){for(i=0;i<space;i+=1){indent+=" "}}else{if(typeof space==="string"){indent=space}}rep=replacer;if(replacer&&typeof replacer!=="function"&&(typeof replacer!=="object"||typeof replacer.length!=="number")){throw new Error("JSON.stringify")}return str("",{"":value})}}if(typeof $FSI.JSON.parse!=="function"){$FSI.JSON.parse=function(text,reviver){var j;function walk(holder,key){var k,v,value=holder[key];if(value&&typeof value==="object"){for(k in value){if(Object.prototype.hasOwnProperty.call(value,k)){v=walk(value,k);if(v!==undefined){value[k]=v}else{delete value[k]}}}}return reviver.call(holder,key,value)}text=String(text);cx.lastIndex=0;if(cx.test(text)){text=text.replace(cx,function(a){return"\\u"+("0000"+a.charCodeAt(0).toString(16)).slice(-4)})}if(/^[\],:{}\s]*$/.test(text.replace(/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g,"@").replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g,"]").replace(/(?:^|:|,)(?:\s*\[)+/g,""))){j=eval("("+text+")");return typeof reviver==="function"?walk({"":j},""):j}throw new SyntaxError("JSON.parse")}}}());$FSI.BrowserSupports.visualViewportAPI=function(){var res=false;try{if(typeof(window.visualViewport)!="undefined"){res=true}}catch(e){}$FSI.BrowserSupports.visualViewportAPI=$FSI.BrowserSupports[res];return res};$FSI.BrowserSupports.registerElement=function(){var res=false;try{if(typeof(document.registerElement)=="function"){res=true}}catch(e){}$FSI.BrowserSupports.registerElement=$FSI.BrowserSupports[res];return res};$FSI.BrowserSupports.canvas=function(){var res=false;try{var cv=document.createElement("canvas");var ctx=cv.getContext("2d");if(ctx&&ctx.clearRect!=undefined){res=true}}catch(e){}$FSI.BrowserSupports.canvas=$FSI.BrowserSupports[res];return res};$FSI.BrowserSupports.cssTouchAction=function(){var res=false;try{if($FSI.isTouch){if(typeof(window.getComputedStyle)==="function"){var stl=window.getComputedStyle(document.body);res=(typeof(stl.touchAction)==="string")}}}catch(e){}$FSI.BrowserSupports.cssTouchAction=$FSI.BrowserSupports[res];return res};var ret=($FSI.isMobileDevice||$FSI.isIETouch||$FSI.isTouch||($FSI.isMac&&$FSI.isSafari))?true:false;$FSI.BrowserSupports.documentZoom=$FSI.BrowserSupports[ret]}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CORSLoader!=b){return}a.CORSLoader=function(){var h=this;var d=0;var c={};var g=false;var i;var f=null;if(a.isInternetExplorer&&a.versionInternetExplorer<10){i=function(k){var e;if(!a.isCrossDomain(k)){g=false;e=new XMLHttpRequest()}else{g=true;e=new XDomainRequest()}return e}}else{if(typeof XMLHttpRequest!="undefined"){i=function(){return new XMLHttpRequest()}}}if(!i){try{f=new ActiveXObject("Msxml2.XMLHTTP");i=function(){return new ActiveXObject("Msxml2.XMLHTTP")}}catch(j){try{f=new ActiveXObject("Microsoft.XMLHTTP");i=function(){return new ActiveXObject("Microsoft.XMLHTTP")}}catch(j){f=null;i=function(){return null}}}}this.getSupported=function(){return(i()!=null)};this.load=function(l,m,o,q){var k=i(l);if(!k){return}if(o&&k.overrideMimeType){k.overrideMimeType(o)}k._url=l;var n=d;c[d]=k;d++;if(g){k.onerror=function(){delete c[n];if(m==b||this.FSIaborted){return}m(this,this.responseText,q,400)};k.onload=function(){delete c[n];if(m==b||this.FSIaborted){return}var r=this.responseText;switch(this.contentType){case"application/xml":case"text/xml":try{var s=new ActiveXObject("Microsoft.XMLDOM");s.async=false;s.loadXML(r);r=this.responseXML=s}catch(t){}break}m(this,r,q,200)}}else{k.onreadystatechange=function(e){if(k.readyState!=4){return}delete c[n];if(m==b||this.FSIaborted){return}var r=(this.responseXML!=null&&this.responseXML.firstChild)?this.responseXML:this.responseText;m(this,r,q,k.status)}}try{k.open("GET",l,true);k.send(null)}catch(p){m(this,"",q,500)}return k};this.stopPendingRequests=function(){for(var k in c){var e=c[k];if(e){e.FSIaborted=true;if(e.abort){e.abort()}}}};this.destroy=function(){h.reset()};this.reset=function(){this.stopPendingRequests();c={}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Config!=b){return}a.Config=function(Z,z,g){if(typeof(g)!=="object"){g={}}if(!z||typeof(z)!=="object"){z={}}var p=this;this.parameters=(Z&&typeof(Z)==="object")?Z:{};this.queryParameters=b;try{this.XMLSerializer=(XMLSerializer)?new XMLSerializer():b}catch(ab){}this.plugins={};this.arPlugins=[];this.nPluginToInit=-1;this.arUnrecognizedConfigNodes=[];this.arConditions=[];this.locales={};this.locales.tips={};var R=false;this.strListFilePrefix="";this.strListFileSuffix="";var J={};var B=0;var t;var V={};var d="FSI> ";var E=p.debug=new a.EmptyDebugger();var C=false;var A={};var af=false;var M={stickynotes:"bookmarks"};var h;var Q=false;var v;var G;var W;var c;var o;var x="token";var y;this.strConfigFileExtension=".xml";p.strTemplateSuffix=".json";var r;var i=null;if(a.isInternetExplorer&&a.versionInternetExplorer<10){r=function(ag){var e;if(!a.isCrossDomain(ag)){af=false;e=new XMLHttpRequest()}else{af=true;e=new XDomainRequest()}return e}}else{if(typeof XMLHttpRequest!="undefined"){r=function(){return new XMLHttpRequest()}}}if(!r){try{i=new ActiveXObject("Msxml2.XMLHTTP");r=function(){return new ActiveXObject("Msxml2.XMLHTTP")}}catch(ab){try{i=new ActiveXObject("Microsoft.XMLHTTP");r=function(){return new ActiveXObject("Microsoft.XMLHTTP")}}catch(ab){i=null;r=function(){return null}}}}this.bForceVersion5=false;this.pluginDefaultParameters={};this.pluginDefaultParameters.pages={};this.cfgAliasNames={imagesrc:"fpxsrc",imagesources:"fpxsources",imageheight:"fpxheight",imagewidth:"fpxwidth",imageservertemplate:"fpxservertemplate",profile:"fpxservertemplate",renderer:"fpxservertemplate",imageinfotemplate:"fpxinfotemplate",imageservertype:"fpxservertype",imagetilepaddingx:"fpxtilepaddingx",imagetilepaddingy:"fpxtilepaddingy",imagetilewidth:"fpxtilewidth",imagetileheight:"fpxtileheight",imagetilesx:"fpxtilesx",imagetilesy:"fpxtilesy",imageserver:"fpxserver",imagepath:"fpxpath",imagetransparency:"fpxtransparency"};this.cfg=this.cfgDefaults={defaultcfg:"_default",headers:"cors",fsibase:"config/",fpxservertemplate:"jpeg",listtemplate:"image_list"};this.init=function(ai){p.reset();v=(typeof(g.strSection)==="string")?g.strSection:"";G=v.toLowerCase();if(typeof(g.strTraceParam)==="string"){var ag=g.strTraceParam.toLowerCase();c={};c[ag]=true;if(ag.indexOf("_")>0&&ag.indexOf("pages")===0){ag=ag.split("_");ag.shift();ag=ag.join("_");c[ag]=true}var ah=p.getParameterAlias(ag);if(ah){c[ah]=true}}else{c=false}if(ai){if(p.parameters){p.parameters=a.mergeObjects(p.parameters,ai)}else{p.parameters=ai}}Y(p.parameters);p.getQueryParameters();p.cloneParameters(p.cfgDefaults,p.cfg);p.cloneParameters(p.queryParameters,p.cfg);p.elevateToHTTPS();f();p.BaseURL=p.getBaseURL();if(p.bForceVersion5==true){}var e=p.queryParameters.fsiviewerversion;if(p.bForceVersion5==true){e="5"}if(e!=b){if(parseInt(e)<6){p.strConfigFileExtension=".fsi"}}var aj=p.queryParameters.fsiserverversion;if(p.bForceVersion5==true){aj="2"}if(aj!=b){if(parseInt(aj)<3){p.strTemplateSuffix="_json"}}p.locationFSIViewer="";if(p.queryParameters.fsiviewerlocation!=b){p.locationFSIViewer=p.queryParameters.fsiviewerlocation}else{if(a!=b&&a._FSIViewerLocation!=b){E.log("FSI Viewer location guessed based on script location: "+a._FSIViewerLocation);p.locationFSIViewer=a._FSIViewerLocation}else{p.locationFSIViewer=p.BaseURL.split("/");if(p.locationFSIViewer.length>4){p.locationFSIViewer.splice(p.locationFSIViewer.length-3,2);p.locationFSIViewer=p.locationFSIViewer.join("/")}}}if(p.locationFSIViewer.charAt(p.locationFSIViewer.length-1)!="/"){p.locationFSIViewer+="/"}p.nextConfigURL=p.getReloadPath(p.locationFSIViewer,p.expandFSIPath(p.cfg.defaultcfg));p.checkDebug(false)};var Y=this.makeObjectPropertiesLowerCase=function(e){for(var ag in e){var ah=ag.toLowerCase();if(ag!=ah){if(e[ah]==b){e[ah]=e[ag]}delete e[ag]}}};this.getClassParameters=function(){return W};this.setAccessToken=function(e){y=e};this.getParameterAlias=function(ah){var e;if(p.cfgAliasNames[ah]){e=p.cfgAliasNames[ah]}else{for(var ag in p.cfgAliasNames){if(p.cfgAliasNames[ag]===ah){e=ag;break}}}return e};var f=function(){R=p.makeBool(p.cfg.usenc,false);if(p.cfg.usencquery!=b&&p.cfg.usencquery.length>0){C=p.cfg.usencquery;R=true;p.queryToObject("?"+C,A)}};this.stopPendingRequests=function(){for(var ag in J){var e=J[ag];if(e){e.FSIaborted=true;if(e.abort){e.abort()}}}};this.destroy=function(){p.stopPendingRequests()};this.getBaseURL=function(){var ah;var ag=document.getElementsByTagName("base");if(ag&&ag.length>0){ah=ag[ag.length-1].href;if(ah&&ah.charAt(ah.length-1)!="/"){ah+="/"}}else{ah=document.location.href;var e=ah.indexOf("?");if(e!=-1){ah=ah.slice(0,e)}e=ah.indexOf("#");if(e!=-1){ah=ah.substring(0,e)}e=ah.lastIndexOf("/");if(e!=-1){ah=ah.slice(0,e+1)}}return ah};this.reset=function(){W={};p.parameters={};E=p.debug=new a.EmptyDebugger();p.stopPendingRequests();t=Math.random();p.nIncludedConfigs=0;p.completedConfigs={};p.plugins={};p.cfg={};p.queryParameters=b;p.arUnrecognizedConfigNodes=[];aa=0;p.arConditions=[];V={}};this.getQueryParameters=function(){if(p.queryParameters!=b){return}p.queryParameters={};p.cloneParameters(p.parameters,p.queryParameters)};this.makeBool=function(ai,e){if(typeof(e)!="boolean"){e=false}var ag=e;switch(typeof(ai)){case"string":var ah=a.makeBool(ai);if(ah!=b){ag=ah}break;case"number":ag=Boolean(ai);break;case"boolean":ag=ai;break}return ag};this.parsePositionParameter=function(ag){if(typeof(ag)!="string"||ag.length<3){return b}ag=ag.split(",");if(ag.length<3){return b}for(var e=0;e<3;e++){ag[e]=parseFloat(ag[e]);if(isNaN(ag[e])){ag[e]=0}}return{x:ag[0],y:ag[1],z:ag[2]}};this.logLoadFileFailed=function(e){if(!E.on){return}if(e&&e.status!=b){var ah="HTTP "+e.status;if(e&&e.statusText){ah+=", "+e.statusText}var ag=(e._url)?e._url:"";E.error("Failed to load "+ag+" ("+ah+")")}else{E.error("Failed loading a file");if(e&&e._url){E.error(e._url)}}};this.logXMLResponseOK=function(e){};this.parseLanguage=function(aj){if(!aj||!aj.firstChild){return false}var e=aj.firstChild.childNodes;var ak,ah,ai;for(var ag=0;ag<e.length;ag++){ah=e[ag];ak=p.getAttributeValue(ah,"id");if(ak==b){continue}ak=ak.toLowerCase();if(ah.childNodes.length>0){ai=p.XMLChildNodesToString(ah)}else{ai=p.getAttributeValue(ah,"txt")}p.locales.tips[ak]=ai}return true};this.getAttributeValue=function(ag,e){if(!ag){return}return ag.getAttribute(e)};this.onLanguageLoaded=function(ag,e){E.log("Language loaded");if(ag){p.parseLanguage(e.responseXML)}if(z.onConfigReady){z.onConfigReady()}};this.onConfigReadyDone=function(){if(!p.readCustomPageNumbers()){p.loadImageList()}};this.swapParameters=function(ah,e){ah=ah.toLowerCase();e=e.toLowerCase();var ag=p.plugins.pages.parameters;if(ag==b){return}p.swapValues(ag,ah,e);p.swapValues(p.cfg,"pages_"+ah,"pages_"+e)};this.swapValues=function(ai,ah,ag){var e=ai[ah];ai[ah]=ai[ag];ai[ag]=e};this.getTranslation=function(ag){var e=p.locales.tips[ag.toLowerCase()];if(e==b){e=ag}return e};this.getImageURL=function(ah,e){if(ah==b){return""}if(e===b){e={}}if(e.type===b){e.type="image"}if(e.renderer===b){e.renderer="jpeg"}if(y){e[x]=y}e.source=ah;for(var ag in V){if(V[ag]!==b&&e[ag]===b){e[ag]=V[ag]}}for(var ag in T){if(e[ag]){if(T[ag]!==ag){if(!e[T[ag]]){e[T[ag]]=e[ag]}e[ag]=null}}}return p.requestBase+"?"+p.objectToQuery(e)};this.getImageInfoURL=function(ag,e){if(ag==b){return""}if(e==b){e={}}if(e.type==b){e.type="info"}if(e.tpl==b){if(p.cfg.fpxinfotemplate!=b){e.tpl=p.cfg.fpxinfotemplate}else{e.tpl="info.json"}}if(p.cfg.headers&&p.cfg.headers.length>0){e.headers=p.cfg.headers}if(!e.tpl.match(/.json$/)){e.tpl+=".json"}e.source=ag;if(y){e[x]=y}return p.requestBase+"?"+p.objectToQuery(e)};this.queryToObject=function(aj,ah){if(ah==b){ah={}}var ai,al,ak,e,ag;ai=aj.indexOf("?");if(ai!=-1){ag=aj.slice(ai+1)}else{ag=""}ai=ag.indexOf("#");if(ai!=-1){ag=ag.substring(0,ai)}ag=ag.split("&");for(ai=0;ai<ag.length;ai++){al=ag[ai].split("=");ak=a.urlDecode(al[0]).toLowerCase();if(ak.length>0){e=a.urlDecode(al[1]);ah[ak]=e}}return ah};this.parseSceneSets=function(e,aj){var aq={};if(aj==b){aj=true}var aw=[];var au=0;var ar=0;var ah;var al,ak,ai,ap,an,av;var am,ao,at;var ag=p.cfg.scenesets;if(e>1&&ag!=b&&typeof(ag)=="string"){ao=ag.split(";");for(al=0;al<ao.length;al++){at=[];am=ao[al].split(",");ar=0;for(ak=0;ak<am.length;ak++){av=am[ak].split("-");ap=an=0;if(av.length==1){ap=parseInt(av[0])}else{ap=parseInt(av[0]);if(isNaN(ap)){ap=1}ah=false;if(av[1].charAt(0)==">"){av[1]=av[1].substr(1);if(!isNaN(parseInt(av[1]))){ah=true}}an=parseInt(av[1]);if(isNaN(an)){an=e}if(ap>0&&an>0&&ap<=e&&an<=e){if(ah==true||ap!=an){if(ah!=true){if(an<ap){for(ai=ap;ai>=an;ai--){at[ar]=ai;ar++}}else{for(ai=ap;ai<=an;ai++){at[ar]=ai;ar++}}}else{for(ai=ap;ai<=e;ai++){at[ar]=ai;ar++}for(ai=1;ai<=an;ai++){at[ar]=ai;ar++}}}}}if(ap>0&&ap<=e&&(an==0||an==ap)){at[ar]=ap;ar++}}if(ar>0){aw[au]={};aw[au].arScenes=[];aw[au].arScenes=aw[au].arScenes.concat(at);au++}}}if(au==0){aq.bDefault=true;if(aj){aw[0]={};aw[0].arScenes=[];for(al=0;al<e;al++){aw[0][al]=al}}}aq.nSceneSets=au;aq.bHasMultipleSets=(aq.nSceneSets>1);aq.arSets=aw;aq.nCurrent=1;return aq};this.objectToQuery=function(ag){var e=[];var ai,ah;if(R&&C!==false){for(ai in A){ag[ai]=A[ai]}}for(ai in ag){ah=ag[ai];if(ah!==null){ah=encodeURIComponent(ah);e.push(encodeURIComponent(ai)+"="+ah)}}return e.join("&")};this.loadConfigs=function(){W=(v.length>0)?{}:false;h=true;p.loadNextConfig(true)};this.loadImageInfo=function(ai,e,ah){var ag=p.getImageInfoURL(ai);p.loadFile(ag,e,b,ah)};this.loadFile=function(aj,ai,ah,an,am,ag,ak){if(!aj||aj.length<0){if(ai){setTimeout(function(){ai(null,"",an)},0)}return}if(am==b){am="GET"}if(ag==b){ag=null}else{if(typeof(ag)=="object"){ag=p.objectToQuery(ag)}}if(ah==b){ah="application/json"}var al=r(aj);if(!al){return}if(ah&&al.overrideMimeType){al.overrideMimeType(ah)}al._url=aj;var e=B;J[B]=al;B++;if(af){al.onerror=function(){delete J[e];if(ai==b||this.FSIaborted){return}p.logLoadFileFailed(this)};al.onload=function(){delete J[e];if(ai==b||this.FSIaborted){return}var ao=this.responseText;switch(this.contentType){case"application/xml":case"text/xml":try{var ap=new ActiveXObject("Microsoft.XMLDOM");ap.async=false;ap.loadXML(ao);ao=this.responseXML=ap}catch(aq){E.log("Failed parsing XML using Microsoft.XMLDOM");E.log(aj)}break;case"application/json":ao={};try{ao=a.JSON.parse(this.responseText)}catch(aq){E.error("Failed parsing JSON from URL: "+aj+" ("+aq.message+")")}break;default:ao=this.responseText}ai(this,ao,an)}}else{al.onreadystatechange=function(ao){var ap;if(al.readyState!=4){return}delete J[e];if(ai==b||this.FSIaborted){return}if(this.status>299){p.logLoadFileFailed(this)}switch(ah){case"application/xml":case"text/xml":ap=this.responseXML;break;case"application/json":ap={};try{ap=a.JSON.parse(this.responseText)}catch(aq){E.error("Failed parsing JSON from URL: "+aj+" ("+aq.message+")")}break;default:ap=this.responseText}ai(this,ap,an)}}al.open(am,aj,true);if(ak&&y){al.setRequestHeader("x-token",y)}if(ag){al.setRequestHeader("Content-type","application/x-www-form-urlencoded");al.send(ag)}else{al.send()}return al};this.onConfigXMLLoaded=function(e,ag){p.logXMLResponseOK(e.response);p.onConfigLoaded(e.responseXML)};this.loadNextConfig=function(ag){if(p.nextConfigURL==b){p.finalCheck();return}var ah={};if(g.bPreventCaching||p.makeBool(p.cfg.debug)||(!ag&&!p.makeBool(p.cfg.configcaching,true)&&p.makeBool(p.cfg.enableconfigcachingparameter))){p.addNoCacheParams(ah)}p.finishRequestParams(ah);var e=p.addURLParameters(p.nextConfigURL,ah);E.log("Loading config file: "+e);p.loadFile(e,p.onConfigXMLLoaded,"application/xml")};this.parseFloatPercentDef=function(ai,ah,ag,e){if(ai==b||ai.length<1){return ag}return Math.max(e,p.parseFloatPercent(ai,ah))};this.parsePercentDef=function(ah,e){if(ah==b||ah.length<1){return e}var ag=parseFloat(ah);if(isNaN(ag)){ag=0}else{if(ah.indexOf("%")!=-1){ag/=100}}return ag};this.parseFloatPercent=function(ah,ag){var e=parseFloat(ah);if(isNaN(e)||e<0){e=0}else{if(ah.indexOf("%")!=-1){e=Math.round(e*ag/100)}else{e=Math.ceil(e)}}return e};this.setDebugPrefix=function(e){d=e+"> "};this.setDebugger=function(e){E=p.debug=e};this.checkDebug=function(ah){if(g.bNoDebug){return}var ag;var e;if(p.parameters.debug!=b){e=p.makeBool(p.parameters.debug)}else{e=p.makeBool(p.cfg.debug)}if(e){if(!E||!E.on){E=p.debug=new a.Debugger();if(z.onDebuggerChange){ag=z.onDebuggerChange(E,ah)}}}else{if(!E||E.on===true){E=p.debug=new a.EmptyDebugger();if(z.onDebuggerChange){ag=z.onDebuggerChange(E,ah)}}}return ag};this.onConfigLoaded=function(ag){o=p.nextConfigURL;p.parseConfig(ag);o=b;p.elevateToHTTPS();if(p.checkDebug(true)==true){return}f();if(h&&g.bCaptureDefaultCfg){h=false;p.cfgFromDefaultConfig=a.cloneValue(p.cfg)}var e;if(p.cfg.includeconfig!=b&&p.nIncludedConfigs<10){e=p.getFSIPath(p.locationFSIViewer,p.expandFSIPath(p.cfg.includeconfig));p.nIncludedConfigs++;p.cfg["_includeconfig("+p.nIncludedConfigs+")"]=p.cfg.includeconfig;p.cfg.includeconfig=b}else{if(p.cfg.cfg!=b){e=p.getFSIPath(p.locationFSIViewer,p.expandFSIPath(p.cfg.cfg))}}if(e!=b&&!p.completedConfigs[e]){p.completedConfigs[e]=true;p.nextConfigURL=e;p.loadNextConfig()}else{p.evaluateQuery(p.queryParameters,p.cfg);p.finalCheck()}};this.elevateToHTTPS=function(){if(!a.bHTTPS){return}if(!p.makeBool(p.cfg.autoelevatetohttps,true)){return}k("fpxbase");k("fpxserver")};var k=function(e){if(p.cfg[e]!=b&&p.cfg[e].length>0&&p.cfg[e].indexOf("http://")==0){p.cfg[e]="https"+p.cfg[e].substr(4)}};this.evaluateQuery=function(ag,e){for(var ah in ag){p.setConfigParamByValue(e,ah.toLowerCase(),ag[ah])}};this.parseConfig=function(ag,ah){var aq="";var ak;var am=false;if(ag!=b){if(ah===b){ah=ag.firstChild}if(ah&&ah.nodeName=="xml"){ah=ah.nextSibling}var ap=ah.childNodes;for(var al=0;al<ap.length;al++){var aj=ap[al];if(aj.nodeType!=1){continue}var an;if(aj._myTagName!==b){an=aj._myTagName}else{an=aj.nodeName.toLowerCase()}aq=an;var ai=aj.childNodes;am=false;switch(an){case"licence":break;case"if":p.arConditions.push(aj);break;case"plugins":for(ak=0;ak<ai.length;ak++){p.parsePluginNode(ai[ak])}break;case G:am=true;case"info":case"options":aq=b;case"fpx":case"image":case"video":case"virtualspace":case"camera":case"include":for(ak=0;ak<ai.length;ak++){var ao=ai[ak];if(ao.nodeType!=1){continue}if(ao.tagName==="if"){ao._myTagName=an;p.arConditions.push(ao)}else{var e=p.getValueFromXMLNode(ao,aq);if(aq===b&&W){if(am){p.setConfigParam(W,e,null,true);p.setConfigParam(p.cfg,e,ao)}else{if(W[e.name]===b){p.setConfigParam(p.cfg,e,ao)}}}else{p.setConfigParam(p.cfg,e,ao)}}}break;default:p.arUnrecognizedConfigNodes.push(aj)}}}};this.getData=function(){var e={};e.cfg={};for(var ag in p.cfg){e.cfg[ag]=p.cfg[ag]}return e};this.setData=function(e){if(!e||!e.cfg){return}p.cfg={};this.setCfgValues(e.cfg)};this.setCfgValues=function(e){for(var ag in e){p.cfg[ag]=e[ag]}P()};this.getImagesNodeList=function(ah){var e=[];if(ah==b){ah=p.getUnrecognizedConfigNode("images")}if(ah){var ai=ah.firstChild;while(ai){if(ai.nodeType==1){var ag={};ag.attributes={};I(ai,ag.attributes);ag.cfg={};p.parseConfigFragment(ai,ag.cfg);e.push(ag)}ai=ai.nextSibling}}return e};this.removeUnrecognizedConfigNodes=function(){p.arUnrecognizedConfigNodes=[]};this.getUnrecognizedConfigNode=function(ai){var e;ai=ai.toLowerCase();for(var ag=p.arUnrecognizedConfigNodes.length-1;ag>-1;ag--){var ah=p.arUnrecognizedConfigNodes[ag];if(ah&&ah.nodeName.toLowerCase()==ai){e=ah;break}}return e};this.parseConfigFragment=function(ag,am,al){var aq="";if(ag!=b&&am!=b){if(al==b){al=[]}var ap=ag.childNodes;for(var ak=0;ak<ap.length;ak++){var ai=ap[ak];if(ai.nodeType!=1){continue}var an=ai.nodeName.toLowerCase();aq=an;var ah=ai.childNodes;switch(an){case"info":case"options":aq=b;case"fpx":case"image":case"include":for(var aj=0;aj<ah.length;aj++){var ao=ah[aj];if(ao.nodeType!=1){continue}var e=p.getValueFromXMLNode(ao,aq);p.setConfigParam(am,e,ao)}break;default:al.push(ai)}}}};this.findXMLNode=function(ag,e){if(ag==b||ag.nodeType==b){return b}while(ag){if(ag.nodeName.toLowerCase()==e){break}if(ag.firstChild!=b){ag=ag.firstChild}else{if(ag.nextSibling!=b){ag=ag.nextSibling}else{ag=ag.parentNode.nextSibling}}}return ag};this.getValueFromXMLNode=function(ah,e){if(!ah||ah.nodeType!=1){return}var ag={};var ai=(e)?e:"";ag.name=ai+ah.nodeName.toLowerCase();var aj=ah.getAttribute("value");if(aj){ag.value=aj;return ag}ag.value=p.XMLChildNodesToString(ah);ag.node=ah;return ag};this.getXMLNodeAttribute=function(ai,ah,e){if(!ai||ai.nodeType!=1||!ai.getAttribute){return e}var ag=ai.getAttribute(ah);if(ag==b||ag==null){ag=e}return ag};this.XMLChildNodesToString=function(ah,ag){if(!ah||!ah.firstChild){return""}var e="";if(ah.childNodes.length===1&&ah.firstChild.nodeType==3){e=ah.firstChild.nodeValue}else{e=p._XMLChildNodesToString(ah)}if(ag!==b){e=e.replace(/[\x00-\x1f]/g,ag)}return e};this.hasPlugin=function(e){return(p.plugins&&p.plugins[e]!=b)};this.getPluginParameter=function(al,ag,e,ak,am){al=al.toLowerCase();ag=ag.toLowerCase();if(p.plugins[al]==b){E.error("CANNOT GET PLUGIN PARAMETER, because plugin is not defined: "+al+"."+ag);return e}var aj;var ai=al+"_"+ag;if(am&&p.cfg[ai]==b){ai=ag}if(p.cfg[ai]!=b){aj=p.cfg[ai]}else{if(W&&W[ag]!==b&&G==="pages"){aj=W[ag]}else{var ah=p.plugins[al].parameters;if(ah!=b&&ah[ag]!=b){aj=ah[ag]}}}if(aj==b){aj=e}if(ak){aj=p.makeBool(aj,e)}return aj};var L=this.getAllPluginParameters=function(ag){ag=ag.toLowerCase();var ah=a.cloneObject(p.plugins[ag].parameters);var aj=ag+"_";var e=aj.length;for(var ak in p.cfg){if(ak.toLowerCase().indexOf(aj)==0){var ai=ak.substr(e);ah[ai]=p.cfg[ak]}}return ah};this.getIntParameterMinMax=function(ag,ah,e,ai){return Math.min(ai,Math.max(e,p.getIntParameter(ag,ah)))};this.getIntParameter=function(ag,ah){var e=parseInt(p.cfg[ag.toLowerCase()]);if(isNaN(e)){e=ah}return e};this.getStringParameter=function(ag,ah){var e=p.cfg[ag.toLowerCase()];if(e==b){e=ah}return e};this.getFloatParameter=function(ag,ah){var e=parseFloat(p.cfg[ag.toLowerCase()]);if(isNaN(e)){e=ah}return e};this.getRGBAValue=function(ag){var e={};if(ag==b){ag=""}if(ag.charAt(0)=="#"){ag=ag.substr(1)}if(ag.length>8){ag=ag.substr(0,8)}if(ag.length>5){e.webColor="#"+ag.substr(0,6);e.red=parseInt(ag.substr(0,2),16);e.green=parseInt(ag.substr(2,2),16);e.blue=parseInt(ag.substr(4,2),16);if(ag.length<7){e.alpha=255}else{e.alpha=parseInt(ag.substr(6,2),16)}}else{e.alpha=255;e.webColor="#000000";e.red=e.green=e.blue=0}e.webAlpha=e.alpha/255;return e};var I=function(ak,ag){if(!ak||!ak.attributes||!ak.attributes.length||!ag){return false}var ah=ak.attributes;for(var aj=0;aj<ah.length;aj++){var e=ah[aj];var ai=e.nodeName.toLowerCase();ag[ai]=e.value}return true};this.parsePluginNode=function(ah){if(ah.nodeType!=1){return}var aj={};I(ah,aj);var ai=ah.childNodes;for(var e=0;e<ai.length;e++){var ak=ai[e];if(ak.nodeType!=1){continue}var ag=p.getValueFromXMLNode(ak);if(ag.value!=b){aj[ag.name]=ag.value;if(ag.node!=b){aj[ag.name+".node"]=ag.node}}}this.addPluginFromString(aj.src,aj)};this.trimString=function(e){return e.replace(/^\s\s*/,"").replace(/\s\s*$/,"")};this.clone=function(){var e=new a.Config(Z,z,g);e.init();e.cfg=a.cloneObject(p.cfg);e.plugins=a.cloneObject(p.plugins);e.arPlugins=a.cloneArray(e.arPlugins);e.arUnrecognizedConfigNodes=a.cloneArray(e.arUnrecognizedConfigNodes);e.setImageQueryParameters(V);e.locales=a.cloneObject(p.locales);e.arConditions=a.cloneArray(p.arConditions);e.hasImageParameterConditions=p.hasImageParameterConditions;return e};this.setImageQueryParameters=function(e){V=a.cloneObject(e)};this.addPluginsFromString=function(ah){if(ah==b||ah.split==b||ah.length<1){return}var e=ah.split(",");for(var ag=0;ag<e.length;ag++){var ai=p.trimString(e[ag]);p.addPluginFromString(ai)}};this.addPluginFromString=function(ai,aj){if(ai==b||ai.length<1){E.error("PLUGIN without src parameter:");return}ai=ai.toLowerCase();if(M[ai]!=b){ai=M[ai]}if(aj==b){aj={}}var ag=p.plugins[ai]={};ag.name=ai;if(aj.src===b){aj.src=ai}if(p.pluginDefaultParameters[ai]!=b){ag.parameters={};p.cloneParameters(p.pluginDefaultParameters[ai],ag.parameters);p.cloneParameters(aj,ag.parameters)}else{ag.parameters=aj}if(c){for(var ak in c){if(ak.indexOf(ai+"_")===0){var ah=ai+"_";var e=ak.substr(ah.length);if(typeof(ag.parameters[e])!=="undefined"){p.iTraceParameterDebug.group(o);p.iTraceParameterDebug.log('<Plugin src="'+ai+'">');p.iTraceParameterDebug.log(ag.parameters[e]);p.iTraceParameterDebug.log("");p.iTraceParameterDebug.groupEnd()}}else{if(ak===ai){p.iTraceParameterDebug.group(o);p.iTraceParameterDebug.log('<Plugin src="'+ai+'">');p.iTraceParameterDebug.log("(enabled)");p.iTraceParameterDebug.log("");p.iTraceParameterDebug.groupEnd()}}}}};this.setConfigParamByValue=function(ag,ah,e){p.setConfigParam(ag,{name:ah.toLowerCase(),value:e})};var O=function(ag){if(ag.nodeType!==1){return"<unknown>"}var e=p.XMLSerializer.serializeToString(ag.cloneNode(false));e=e.replace(/\/>$/gi,">");return e};this.setConfigParam=function(ai,e,aj,ak){var am=e.name;var ao=e.value;if(am==b){return}if(c){for(var an in c){if(an===am&&!ak){if(typeof(aj)==="object"&&typeof(aj.tagName)==="string"){var al;if(o){al=o}var ah=aj.parentNode;var ag=[];while(ah){if(ah.tagName==="if"){al="Matched Condition"}ag.unshift(O(ah));ah=ah.parentNode}ag.shift();ag.shift();p.iTraceParameterDebug.group(al);p.iTraceParameterDebug.log(ag.join(" "));p.iTraceParameterDebug.log(aj);p.iTraceParameterDebug.log("");p.iTraceParameterDebug.groupEnd()}else{p.iTraceParameterDebug.group("By Parameter/Attribute:");p.iTraceParameterDebug.log(ao);p.iTraceParameterDebug.log("");p.iTraceParameterDebug.groupEnd()}}}}if(p.cfgAliasNames[am]!=b){am=p.cfgAliasNames[am]}if(ai[am]!=b&&(typeof(ao)=="string"&&a.BoolTable[ao.toLowerCase()]==false)&&a.BoolTable[ai[am]]==b){delete ai[am]}else{switch(am){case"effects":case"righteffects":case"lefteffects":case"tileeffects":case"sceneeffects":case"naveffects":case"thumbeffects":if(ai[am]!=b&&ai[am].length>0&&ai[am].indexOf(ao)==-1){ai[am]+=","+ao}else{ai[am]=ao}break;case"plugins":p.addPluginsFromString(ao);break;case"fpxpath":ai[am]=ao;ai.fpxsrc=encodeURIComponent(ao);break;default:ai[am]=ao;if(e.node!=b){ai[am+".node"]=e.node}}}};var n={};n["="]=function(ag,e){return(ag.toLowerCase()==e.toLowerCase())};n["=="]=function(ag,e){return(ag==e)};n["!="]=function(ag,e){return(ag.toLowerCase()!=e.toLowerCase())};n["!=="]=function(ag,e){return(ag!=e)};n["<"]=function(ag,e){return(ag<e)};n["<="]=function(ag,e){return(ag<=e)};n[">"]=function(ag,e){return(ag>e)};n[">="]=function(ag,e){return(ag>=e)};n.match=function(ah,ag){var ai=false;var ak="g";if(ag.charAt(0)==="/"&&ag.lastIndexOf("/")>0){var aj=ag.split("/");aj.shift();ak=aj.pop();ag=aj.join("/")}try{var al=new RegExp(ag,ak);ai=(ah.match(al)!==null)}catch(am){E.error("Invalid regex in condition: "+ag)}return ai};n.notmatch=function(ag,e){return !n.match(ag,e)};var u={lessthan:"<",lt:"<",lessthanequal:"<=",lte:"<=",greaterthan:">",gt:">",greaterthanequal:">=",gte:">=",eq:"=",not:"!="};var w=function(ag,ah){if(p.cfgAliasNames[ah]){ah=p.cfgAliasNames[ah]}var e=p.cfg[ah];if(e==b){e=""}if(!p.hasImageParameterConditions){p.hasImageParameterConditions=(T[ah]!==b)}return D(ag,ah,e)};var H=function(ai,aj){var e=false;var ah;var ag=ai.getAttribute("value");switch(aj){case"@mobile":ag=p.makeBool(ag,true);ah=a.isMobileDevice;break;case"@devicepixelratio":ah=a.getDevicePixelRatio();break;case"@navigatoruseragent":ah=navigator.userAgent;break;case"@navigatorlanguage":ah=navigator.language;break;case"@navigatorplatform":ah=navigator.platform;break}if(ah!==b){if(typeof(ag)!=="string"){ag=""+ag}if(typeof(ah)!=="string"){ah=""+ah}e=D(ai,aj,ah,ag)}return e};var D=function(ai,ah,ak,aj){var am;var ag=ai.getAttribute("operator");if(typeof(ag)!=="string"){ag="="}ag=ag.toLowerCase();if(u[ag]){ag=u[ag]}if(n[ag]===b){ag="="}if(aj===b){aj=ai.getAttribute("value")}if(aj===null){aj=""}var e=n[ag];if(ag.match(/[<,>]+/)){var an=function(ao){ao=parseFloat(ao);if(isNaN(ao)){am=false}return ao};ak=an(ak);aj=an(aj)}else{ak=decodeURIComponent(ak)}if(am===b){am=e(ak,aj)}if(E.on){E.log("Evaluating condition: "+ah+": "+ak+" "+ag+" "+aj+" => "+am)}if(am===true){if(ai._myTagName!==b){var al={};al.nodeType=1;al.tagName=ai._myTagName;al.childNodes=[ai];ai=al}p.parseConfig(ai,ai)}return am};var T={fpxsrc:"source",headers:"headers",croprect:"rect",fpxservertemplate:"renderer",quality:"quality",effects:"effects",imageformat:"format",imagecolorspace:"colorspace",imageencoding:"encoding",imagemaxcolors:"maxcolors",imagebackgroundcolor:"backgroundcolor",imageditherer:"ditherer",imagequantizer:"quantizer",referencewidth:"referencewidth",referenceheight:"referenceheight",pixelrange:"pixelrange",imagedpi:"dpi"};var U={headers:"headers",fpxservertemplate:"renderer",quality:"quality",effects:"effects",imageformat:"format",imagecolorspace:"colorspace",imageencoding:"encoding",imagemaxcolors:"maxcolors",imagebackgroundcolor:"backgroundcolor",imageditherer:"ditherer",imagequantizer:"quantizer",imagedpi:"dpi"};var S;var N=function(){if(S===b){S={};for(var e in T){S[T[e]]=e}}return S};var s=function(aj,ai,ah){if(ah===b){ah=""}var al=ah+"left";if(aj[al]===b){return}var ak=ah+"top";var ag=ah+"right";var e=ah+"bottom";if(ai==="pixelrange"){aj[ag]=aj[ag]-aj[al];aj[e]=aj[e]-aj[ak]}aj[ai]=aj[al]+","+aj[ak]+","+aj[ag]+","+aj[e];if(aj[al]){delete aj[al]}if(aj[ak]){delete aj[ak]}if(aj[ag]){delete aj[ag]}if(aj[e]){delete aj[e]}};var ad=this.mapImageParametersToViewer=function(e){s(e,"rect");s(e,"pixelrange","pixel");var ag=N();e=X(e,N())};var ac=this.mapImageParametersToServer=function(e){X(e,T)};var X=function(ag,e){for(var ah in ag){if(e[ah]&&ah!==e[ah]){ag[e[ah]]=ag[ah];delete ag[ah]}}};this.reWriteImageURLByConditions=function(am){if(p.arConditions.length<1){return am}if(typeof(am)!=="string"||am.length<1){return am}var ah=am.indexOf("?");if(ah===-1){return am}var ag=p.clone();var aj={};p.parseQuery(am,aj);ad(aj);p.evaluateQuery(aj,ag.cfg);var e=ag.evaluateConditions();if(!e){return am}var al;for(al in aj){if(ag.cfg[al]!==b){aj[al]=decodeURIComponent(ag.cfg[al])}}for(al in U){if(ag.cfg[al]!==b){aj[al]=decodeURIComponent(ag.cfg[al])}}ac(aj);var ai=am.substr(0,ah);var ak=ai+"?"+p.objectToQuery(aj);return ak};var q=this.applyConditions=function(){if(p.arConditions.length<1){return}if(p.cfgBeforeConditions===b){p.cfgBeforeConditions=a.cloneObject(p.cfg)}p.cfg=p.cfgBeforeConditions;return j()};var aa=0;var j=this.evaluateConditions=function(){if(p.arConditions.length<1){return false}var ag=false;for(var ah=aa;ah<p.arConditions.length;ah++){var ai=p.arConditions[ah];if(ai.fsiConfigEvaluated){continue}aa++;var aj=ai.getAttribute("parameter");if(typeof(aj)==="string"){aj=aj.toLowerCase();var e;if(aj.charAt(0)==="@"){e=H(ai,aj)}else{e=w(ai,aj)}if(!ag&&e){ag=e}}}return ag};var P=function(){q();p.serverProfile=p.cfg.fpxservertemplate;p.serverProfileDoublePage=p.cfg.fpxservertemplatedoublepage;if(p.serverProfileDoublePage==b){p.serverProfileDoublePage="doublepage"}p.serverBase=p.cfg.fpxserver;if(p.serverBase==b){E.warn("PLEASE NOTE: Parameter 'imageserver' undefined, deriving server location from viewer location ("+p.locationFSIViewer+")");var ag;ag=p.locationFSIViewer.indexOf("/users/");if(ag!=-1){p.serverBase=p.locationFSIViewer.substring(0,ag)+"/server"}else{ag=p.locationFSIViewer.indexOf("/viewer/");p.serverBase=p.locationFSIViewer.substring(0,ag)+"/server"}E.log("Derived server location is: ["+p.serverBase+"]")}p.requestBase=p.serverBase;V={};var e=p.cfg;for(var ah in U){if(e[ah]!==b){V[ah]=e[ah]}}if(V.fpxsrc!==b){V.fpxsrc=decodeURIComponent(V.fpxsrc)}e=p.cfg.effects;if(e!=b){p.cfg.effectsUnFiltered=e;p.cfg.effects=e=m(e)}if(e!=b){V.effects=e}e=p.cfg.lefteffects;if(e!=b){V.lefteffects=e}e=p.cfg.righteffects;if(e!=b){V.righteffects=e}};this.getAreaEffects=function(){return"BLUR,DISTORT,EMBOSS,FLIP,GLOW,GRADIENTMAP,LINEARGRADIENT,PAD,PIXELIZE,SHARPEN"};this.setEffectsFilterArea=function(){p.setEffectsFilter(p.getAreaEffects())};this.setEffectsFilter=function(ai){if(typeof(ai)!=="string"||ai.length<1){Q=false;return}ai=a.trim(ai);var ag=ai.split(",");for(var ah=0;ah<ag.length;ah++){ag[ah]=a.escapeRegEx(ag[ah])}var e="(^|[=,]+)("+ag.join("|")+")\\([^)]*\\)";Q=new RegExp(e,"ig")};var m=function(e){if(Q===false){return e}return e.replace(Q,"")};var l=function(){for(var ag in p.plugins){var ah=ag.toLowerCase();var e=p.makeBool(p.cfg[ah],true);if(!e){p.plugins[ag]=b}}};this.finalCheck=function(){p.elevateToHTTPS();l();P();p.dumpConfig();if(z.onConfigsReady){z.onConfigsReady()}};this.dumpConfig=function(ah){if(!ah){ah=E}if(ah.on){if(p.cfg.fpxsrc!==b){p.cfg["fpxsrc (decoded)"]=decodeURIComponent(p.cfg.fpxsrc)}ah.info("Evaluated Configuration:",K(p.cfg));if(p.queryParameters){ah.info("Parameters:",K(p.queryParameters))}if(W){ah.info("Class <"+v+"> Configuration:",K(W))}var ag=p.getPluginsAndParameters();var e=ag.data;if(ag.count===0){e="No active plugins."}ah.info("Plugin Configuration:",K(e))}};var K=function(ah){var e="--- none ---";if(typeof(ah)!=="object"){return e}for(var ag in ah){e=ah;break}return e};this.getPluginsAndParameters=function(){var e={};var ah=0;for(var ag in p.plugins){if(p.hasPlugin(ag)){e[ag]=L(ag);ah++}}return{count:ah,data:e}};var F=this.addQueryParameterToURL=function(ai,e,ah){var ag=ai.lastIndexOf("?");if(ag===-1){ai+="?"}else{if(ag!==ai.length-1){ai+="&"}}return ai+encodeURIComponent(e)+"="+encodeURIComponent(ah)};var ae=p.finishURL=function(e){if(y){e=F(e,x,y)}if(!R||e==b){return e}var ag;if(C===false){ag="cache=0&cachernd="+t;if(e.indexOf("?")==-1){e+="?"+ag}else{e+="&"+ag}}else{ag=C;if(e.indexOf("?")==-1){e+="?"+ag}else{e+=ag}}return e};this.addURLParameters=function(ag,ah){if(!ag||!ah){return ag}var e=[];for(var ai in ah){e.push(encodeURIComponent(ai)+"="+encodeURIComponent(ah[ai]))}if(e.length>0){if(ag.indexOf("?")==-1){ag+="?"}else{ag+="&"}ag+=e.join("&")}return ag};this.finishRequestParams=function(ag){if(R){if(C===false){ag.cache=0;ag.cachernd=t}else{for(var e in A){ag[e]=A[e]}}}};this.addNoCacheParams=function(e){e.cache=0;e.cachernd=t};this.parseQuery=function(ag,e){if(e==b||ag==b||ag.length<1){return}p.queryToObject(ag,e);if(e.ignorequeryparameters!=b){delete e.ignorequeryparameters}if(e.enableconfigcachingparameter!=b){delete e.enableconfigcachingparameter}};this.cloneParameters=function(e,ag){if(e==b||ag==b){E.error("Cloning object failed: "+e+" / "+ag)}for(var ah in e){ag[ah]=e[ah]}};this.getFSIPath=function(e,ag){if(ag.indexOf("//")!=-1){return ag}if(p.cfg.fsibase!=b){ag=p.cfg.fsibase+ag}return p.getReloadPath(e,ag)};this.expandFSIPath=function(ag){if(ag==b){return ag}var e=a.urlDecode(ag);if(e.indexOf("?")!=-1||e.indexOf(p.strConfigFileExtension)==(e.length-4)){return ag}return ag+p.strConfigFileExtension};this.getReloadPath=function(ai,ak){var ag,al,e,aj;if(ai==b){ai=p.locationFSIViewer}if(ak==b){ak=""}var ah="/";if(ak.indexOf("//")!=-1){return ak}ag=ai;aj=ag.lastIndexOf("?");if(aj==-1){aj=ag.length}al=ag.lastIndexOf("\\",aj);e=ag.lastIndexOf("/",aj);al=Math.max(al,e);if(al==-1){al=ag.length-1}ag=ag.slice(0,al);if(ag.length>0&&ak.indexOf(ah)!=0){ag+=ah}return ag+ak};this.cloneValueObject=function(ag){var e={};for(var ah in ag){e[ah]=ag[ah]}return e};this._getXMLConfigValue=function(e){var ag;if(!e){return}if(e.childNodes.length>0){ag=p._XMLChildNodesToString(e)}else{ag=e.getAttribute("value")}return ag};this._XMLChildNodesToString=function(ai){if(!ai||!ai.firstChild){return""}var ag="";var ah;try{if(ai.xml!=b){for(ah=0;ah<ai.childNodes.length;ah++){ag+=ai.childNodes[ah].xml}}else{for(ah=0;ah<ai.childNodes.length;ah++){ag+=p.XMLSerializer.serializeToString(ai.childNodes[ah])}}}catch(aj){}return ag};this._findFirstXMLNode=function(ah,ai){var ag,e;while(ah){if(ah.nodeName==ai){e=ah;break}ag=ah.firstChild;if(!ag){ag=ah.nextSibling}if(!ag&&ah.parentNode){ag=ah.parentNode.nextSibling}ah=ag}return e};this._parseXMLImageList=function(ag){var e=p._findFirstXMLNode(ag,"images");if(!e){e=p._findFirstXMLNode(ag,"images3d")}return p.parseXMLImageListNode(e)};this._parseXMLImageListNode=function(aj){var am={};var e=am.arImages=[];var ai="";var ak="";var ah;if(!aj){return am}var ag;ag=p.getAttributeValue(aj,"prefix");if(typeof(ag)=="string"){ai=ag}ag=p.getAttributeValue(aj,"suffix");if(typeof(ag)=="string"){ak=ag}aj=p._findFirstXMLNode(aj,"image");if(!aj){return am}while(aj){if(aj.nodeType==1){ah=p._findFirstXMLNode(aj,"path");var al=p._getXMLConfigValue(ah);if(!al){al=a.urlDecode(p.getAttributeValue(aj,"src"))}if(!al){al=a.urlDecode(p.getAttributeValue(aj,"file"))}if(al!=b){e.push(ai+al+ak)}if(am.width==b){ah=p._findFirstXMLNode(aj,"width");ah=p._getXMLConfigValue(ah);if(ah!=b){am.width=parseInt(ah)}ah=p._findFirstXMLNode(aj,"height");ah=p._getXMLConfigValue(ah);if(ah!=b){am.height=parseInt(ah)}}}aj=aj.nextSibling}return am};this.getImageList=function(){var e,ai;if(p.cfg&&p.cfg.fpxsources!=b){var ah=p.cfg.fpxsources;if(typeof(ah)=="string"||(typeof(ah)=="object")&&typeof(ah.push)=="function"){e={};e.oXML=null;if(typeof(ah)=="string"){e.arImages=ah.split(",");for(ai=0;ai<e.arImages.length;ai++){e.arImages[ai]=a.urlDecode(e.arImages[ai])}}else{e.arImages=ah}return e}}if(p.arUnrecognizedConfigNodes&&p.arUnrecognizedConfigNodes.length>0){var ag=p.arUnrecognizedConfigNodes;for(ai=0;ai<ag.length;ai++){var aj=ag[ai];if(typeof(aj.nodeName)=="string"){var ak=aj.nodeName.toLowerCase();if(ak=="images"||ak=="images3d"){if(E.on){E.log("Reading image list from XML node: <"+aj.nodeName+">")}e=p._parseXMLImageListNode(aj);e.oXML=aj;break}}}}if(p.cfg&&p.cfg.fpxsrc!=b){e={};e.oXML=null;e.arImages=[];e.arImages.push(a.urlDecode(p.cfg.fpxsrc));return e}return e};this.getServerBase=function(){return p.serverBase};this.loadImageList=function(ai,aj,al,ak){if(!p.serverBase||!ai){aj([],b,ak);return false}var ah=p.serverBase+"?type=list";if(ai.indexOf("tpl")==-1){var ag=p.cfg.listtemplate;if(ag&&ag.length>0&&ag.indexOf(".json")==-1&&ag.indexOf(".xml")==-1){ag+=".json"}ah+="&tpl="+ag}if(p.cfg.headers&&p.cfg.headers.length>0&&A.headers==b){ah+="&headers="+p.cfg.headers}ah+="&source="+encodeURIComponent(ai);if(al!=b){ah+=al}ah=ae(ah);var e=p.loadFile(ah,function(am,ap){if(typeof(ap)=="object"&&typeof(ap.images)=="object"){ap.images.pop();var aq="";if(ap&&ap.imagesattributes&&ap.imagesattributes.dir){aq=ap.imagesattributes.dir}var an=new Array(ap.images.length);for(var ao=0;ao<ap.images.length;ao++){an[ao]=aq+ap.images[ao].src}aj(an,ap,ak)}else{aj([],ap,ak)}},"application/json",ak);return e};this.traceConfigValue=function(e,ai){if(typeof(e)!=="string"){return false}e=a.trim(e);if(e.length<1){return false}var ag=e.toLowerCase();if(ag.indexOf(".")!==-1){ag=ag.split(".").join("")}if(ag.indexOf("/")!==-1){ag=ag.split("/").join("")}if(ag.indexOf(" ")!==-1){ag=ag.split(" ").join("")}var ah=new a.Debugger();ah.setPrefix("");ah.group('Tracing parameter "'+e+'"');var aj=function(){var ak=e;var ap=p.getParameterAlias(ag);if(typeof(ap)==="string"){ak+=" (alias: "+ap+")";if(typeof(p.cfgAliasNames[ag])==="string"){ag=p.cfgAliasNames[ag]}}var al=p.cfg[ag];var ao=true;if(ag.indexOf("_")!==-1){var an=ag.split("_");var am=an.shift();var aq=an.join("_");if(p.hasPlugin(am)){al=p.getPluginParameter(am,aq)}}else{if(p.hasPlugin(ag)){ao=false;al="is enabled."}}if(al===b){ao=false;al="is undefined (default value applies)"}if(ao){al='= "'+al+'"'}ah.group("RESULT:");ah.log(ak+" "+al);ah.groupEnd();ah.groupEnd()};z={onConfigsReady:aj};g.strTraceParam=ag;g.bNoDebug=true;p.iTraceParameterDebug=ah;p.init(ai);p.loadConfigs();return""};this.loadLanguageFile=function(e,aq,aj,ah){var ak=arguments;var al,ao;if(typeof(aq)!=="string"||p.makeBool(aq,true)==false){return aj.call(p,{},"")}var ap=function(ar){try{a.oLanguageMap=JSON.parse(ar.responseText)}catch(at){a.oLanguageMap={"default":"english"}}p.loadLanguageFile.apply(this,ak)};var am=function(ar,av){e.urlLanguageCurrentLoaded=al;var au=e.oLanguageData={};if(av){var at=p.findXMLNode(av,"data");if(at){at=p.findXMLNode(at,"tip")}while(at){if(at.nodeType===1){var aw=at.getAttribute("id");au[aw]=p.XMLChildNodesToString(at)}at=at.nextSibling}}aj.call(p,e.oLanguageData,ao)};if(aq.toLowerCase()==="auto"){if(!a.oLanguageMap){p.loadFile(a._FSIViewerLocation+"/languages/mapping.json",ap,"application/json");return}if(a.oLanguageMap._current!==b){aq=a.oLanguageMap._current}else{aq=a.oLanguageMap["default"];var ai=navigator.language;if(typeof(ai)==="string"){ai=ai.toLowerCase()}if(a.oLanguageMap[ai]!=b){aq=a.oLanguageMap[ai]}else{if(ai.indexOf("-")!=-1){ai=ai.split("-")[0];if(a.oLanguageMap[ai]!=b){aq=a.oLanguageMap[ai]}}}}if(aq==b){return aj.call(p,{},"")}if(ah){ah.log('Automatically choosing language "'+aq+'" from navigator.language "'+navigator.language+'"')}a.oLanguageMap._current=aq}var an=aq+".xml";var ag=a._FSIViewerLocation+"/languages/"+an;if(ag!==e.urlLanguageCurrentLoaded){ao=aq;al=ag;if(ah){ah.log("Loading language file: "+ag)}p.loadFile(ag,am,"application/xml")}else{aj.call(p,e.oLanguageData,ao)}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Rect!=b){return}a.Rect=function(d,f,g,c){var e=this;e.left=(isNaN(d))?0:d;e.top=(isNaN(f))?0:f;e.right=(isNaN(g))?0:g;e.bottom=(isNaN(c))?0:c;this.width=function(){var h=e.right-e.left;return Math.abs(h)};this.height=function(){var h=e.bottom-e.top;return Math.abs(h)};this.offsetRect=function(i,h){e.left+=i;e.right+=i;e.top+=h;e.bottom+=h};this.inflateRect=function(j,i){var h=j/2;var k=i/2;e.left-=h;e.top-=k;e.right+=h;e.bottom+=k};this.normalizeRect=function(){var h;if(e.left>e.right){h=e.left;e.left=e.right;e.right=h}if(e.top>e.bottom){h=e.top;e.top=e.bottom;e.bottom=h}};this.setRect=function(i,j,k,h){e.left=i;e.top=j;e.right=k;e.bottom=h};this.scaleRect=function(h){if(h==1){return}e.left*=h;e.top*=h;e.right*=h;e.bottom*=h};this.scaleRectXY=function(i,h){e.left*=i;e.top*=h;e.right*=i;e.bottom*=h};this.scaleRectInt=function(h){if(h==1){return}e.left=Math.round(e.left*h);e.top=Math.round(e.top*h);e.right=Math.round(e.right*h);e.bottom=Math.round(e.bottom*h)};this.interSectRect=function(l){e.normalizeRect();l.normalizeRect();var k=Math.max(e.left,l.left);var h=Math.max(e.top,l.top);var i=Math.min(e.right,l.right);var j=Math.min(e.bottom,l.bottom);e.setRect(k,h,i,j)};this.interSectRectValidate=function(h){e.interSectRect(h);if(e.right<e.left){e.left=e.right=0}if(e.bottom<e.top){e.top=e.bottom=0}};this.isInsideRect=function(h){return(e.left>=h.left&&e.top>=h.top&&e.right<=h.right&&e.bottom<=h.bottom)};this.isRectInsideMe=function(h){return(e.left<=h.left&&e.top<=h.top&&e.right>=h.right&&e.bottom>=h.bottom)};this.getBoundingRect=function(l){e.normalizeRect();l.normalizeRect();var k=Math.min(e.left,l.left);var h=Math.min(e.top,l.top);var i=Math.max(e.right,l.right);var j=Math.max(e.bottom,l.bottom);return new a.Rect(k,h,i,j)};this.equalRect=function(h){return(e.left==h.left&&e.top==h.top&&e.right==h.right&&e.bottom==h.bottom)};this.copyRect=function(h){e.setRect(h.left,h.top,h.right,h.bottom)};this.duplicateRect=function(){return new a.Rect(e.left,e.top,e.right,e.bottom)};this.join=function(h){this.left=Math.min(this.left,h.left);this.top=Math.min(this.top,h.top);this.right=Math.max(this.right,h.right);this.bottom=Math.max(this.bottom,h.bottom)};this.round=function(h){var i=function(k,j){k*=j;k=(k>=0)?Math.floor(k+0.5):Math.ceil(k-0.5);return k/j};if(isNaN(h)){h=1000000}e.left=i(e.left,h);e.top=i(e.top,h);e.right=i(e.right,h);e.bottom=i(e.bottom,h)};this.flipHorz=function(){var h=e.left;e.left=e.right;e.right=h};this.flipVert=function(){var h=e.top;e.top=e.bottom;e.bottom=h};this.toString=function(){return e.left+","+e.top+","+e.right+","+e.bottom};this.getRange=function(){var h={};h.left=e.left;h.top=e.top;h.width=e.width();h.height=e.height();return h}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.ObjectCollection!=b){return}a.ObjectCollection=function(){var d=this;var f;var h;var c=0;var g;var e;this.reset=function(){c=0;d.empty()};this.empty=function(){f=[];h={};g=0;e=false};this.getCount=function(){return g};this.add=function(j){if(!j){return}c++;h[c]=j;j.__id=c;j.__arrayPos=f.length;f.push(j);g++;return c};this.deleteObject=function(j){if(!j||!j.__id){return}return d.deleteObjectById(j.__id)};this.deleteObjectById=function(j){if(!h[j]){console.error("ObjectCollection deleteObjectById "+j+" failed.");return}g--;delete h[j];e=true;return true};this.replace=function(j,k){if(!j||!k){return}return d.replaceById(j.__id,k)};this.replaceById=function(l,k){if(h[l]==b||k==b){return}var j=h[l].__arrayPos;delete h[l];c++;k.__id=c;k.__arrayPos=j;f[j]=k;h[c]=k;return true};var i=function(){if(!e){return}f=new Array(g);var l=0;for(var k in h){var j=h[k];j.__arrayPos=l;f[l]=j;l++}e=false};this.getById=function(j){return h[j]};this.getArray=function(){if(e){i()}return f};this.getObjects=function(){return h};d.empty()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.ImageTagCollection!=b){return}a.ImageTagCollection=function(c,p){a.ObjectCollection.prototype.constructor.apply(this,arguments);var r=this;var q=false;var k=false;var o=false;var s;var i;var d;var e,g;this.init=function(){if(typeof(p.imgsrcattributename)==="string"&&p.imgsrcattributename.length>0){i=p.imgsrcattributename}else{i="src"}d=(i==="src");if(typeof(c.NameID)=="string"){s=c.NameID}else{s="$FSI_ImageTagID"}if(typeof(p.fnfilterimagesource)=="function"){k=p.fnfilterimagesource}if(typeof(p.addcssclass)=="string"){o=p.addcssclass}if(typeof(p.enablebycssclass)=="string"&&p.enablebycssclass.length>0){g={};var v=p.enablebycssclass.split(",");for(var u=0;u<v.length;u++){g[v[u]]=true}}if(typeof(p.disablebycssclass)=="string"&&p.disablebycssclass.length>0){e={};var v=p.disablebycssclass.split(",");for(var u=0;u<v.length;u++){e[v[u]]=true}}q=(e!=b||g!=b)};var n=this.isValidFSIImageServerImageSource=function(t){if(typeof(t)!=="string"){return false}return !(t.length<1||t.search(/[?,&]type=image/i)===-1||t.search(/[?,&]source=/i)===-1)};var j=this.createObjectForImageTag=function(u,y){var t=false;var v=y;if(y==b){v=y=l(u)}if(k!==false){var x=y;y=k(y,u);t=(y!==x)}if(!n(y)){return}if(!f(u)){return}if(o){a.addClass(u,o)}var w={};w.img=u;w.src=y;w.orgSrc=v;w.orgSrcDisplay=u.src;if(t){w.bIgnoreSourceChange=true}return w};var l=this.getSrc=function(t){var u=null;if(typeof(t)==="object"&&t.nodeName==="IMG"){if(d){u=t.src}else{u=t.getAttribute(i);if(typeof(u)!=="string"||u.length<1){u=null}}}return u};this.addBaseMethod=this.add;this.add=function(t){if(t[s]!==b){return}var v=l(t);if(v===null){return}var u=j(t,v);if(u){this.addBaseMethod(u);t[s]=u.__id}return u};this.replaceBaseMethod=this.replace;this.replace=function(t,u){if(r.replaceBaseMethod(t,u)){u.img[s]=u.__id}};var m=this.releaseImage=function(u){if(!u||!u.img){return false}var t=u.img;if(!t[s]==b||t[s]!=u.__id){return}if(o){a.removeClass(t,o)}return true};var h=this.remove=function(t){if(!this.deleteObject(t)){return false}m(t);return true};var f=this.isImageEnabledByCSSClass=function(t){if(!q){return true}var u=false;var w=t.className;if(typeof(w)!="string"){w=[]}else{w=w.split(" ")}if(e){u=true;for(var v=0;v<w.length;v++){if(e[w[v]]){u=false;break}}}if(g){for(var v=0;v<w.length;v++){if(g[w[v]]){u=true;break}}}return u}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomEventListener!=b){return}a.CustomEventListener=function(j){var l=this;var d=[];var g={};var h={};var i=0;l._strClassName="$FSI.CustomEventListener";var k=function(){if(a.eventFunctionID==b){a.eventFunctionID=0}if(a.eventElementID==b){a.eventElementID=0}};this.destroy=function(){for(var m=0;m<d.length;m++){var n=d[m];f(n.element,n.fn)}d=[];g={};h={};l.onDestroy()};this.fireEvent=function(m,n){if(!m||!m.enabled){return false}if(typeof(n)!="object"){n={}}if(m.paused){n.FSI_paused=true}n.FSI_custom_event=true;n.FSI_type=j;n.FSI_target=m.element;return m.fn.call(m.element,n)};this.fireEvents=function(n){if(typeof(n)!="object"){n={}}n.FSI_custom_event=true;n.FSI_type=j;for(var o=0;o<d.length;o++){var m=d[o];if(m.enabled){if(m.paused){n.FSI_paused=true}else{if(n.FSI_paused){delete n.FSI_paused}}n.FSI_target=m.element;m.fn.call(m.element,n)}}};var c=this.addListener=function(q,p){if(typeof(q)!="object"||typeof(p)!="function"){a.console.error(l._strClassName+": Invalid parameters for addListener");return}if(q.__FSI==b){q.__FSI={}}if(q.__FSI.eventElementID==b){q.__FSI.eventElementListenerCount=1;q.__FSI.eventElementID=a.eventElementID++}else{q.__FSI.eventElementListenerCount++}if(p.__FSIEventFunctionID==b){p.__FSIEventFunctionListenerCount=1;p.__FSIEventFunctionID=a.eventFunctionID++}else{p.__FSIEventFunctionListenerCount++}var n=q.__FSI.eventElementID;var o=p.__FSIEventFunctionID;if(g[n]==b){var m=g[n]={};m.nFunction=0;m.oFunctions={}}if(g[n].oFunctions[o]==b){g[n].nFunction++;g[n].oFunctions[o]=[]}else{a.console.warn(l._strClassName+": There is already a listener for this exact element and function");a.console.log(q);a.console.log(p)}var r={};r.element=q;r.elementID=n;r.fn=p;r.fnID=o;r.instanceListener=l;r.enabled=true;r.paused=false;r.uniqueID=i++;g[n].oFunctions[o].push(r);d.push(r);h[r.uniqueID]=r;l._onListenerAdd(r);l._onListenerCountChange(d.length);return r};this.setListenerProps=function(p,n,o){var m=h[p];if(!m){return false}if(m.props==b){m.props={}}m.props[n]=o;return true};this.enableListener=function(o,n){var m=h[o];if(m==b||m.enabled==n){return}m.enabled=n};this.pauseListener=function(o,n){var m=h[o];if(m==b||m.paused==n){return}m.paused=n};var f=this.removeListener=function(q,p){if(typeof(q)!="object"||typeof(p)!="function"){a.console.error(l._strClassName+": Invalid parameters for removeListener");return}if(q.__FSI==b||q.__FSI.eventElementID==b||p.__FSIEventFunctionID==b){if(p.__FSIEventFunctionID==b){a.console.error(l._strClassName+": Function not registered for listener in removeListener")}else{a.console.error(l._strClassName+": Element not registered for listener in removeListener")}return}var m=q.__FSI.eventElementID;var o=p.__FSIEventFunctionID;if(!g[m]){a.console.error(l._strClassName+": No registered listener for this element in removeListener");return}var n=g[m].oFunctions[o];if(n==b||typeof(n.pop)!="function"){a.console.error(l._strClassName+": No registered listener for this function in removeListener");return}var r=n.pop();r.fn.__FSIEventFunctionListenerCount--;r.element.__FSI.eventElementListenerCount--;if(r.element.__FSI.eventElementListenerCount==0){delete r.element.__FSI.eventElementListenerCount;delete r.element.__FSI.eventElementID}if(r.fn.__FSIEventFunctionListenerCount==0){delete r.fn.__FSIEventFunctionListenerCount;delete r.fn.__FSIEventFunctionID}if(n.length==0){delete g[m].oFunctions[o];g[m].nFunction--;if(g[m].nFunction==0){delete g[m]}}delete h[r.uniqueID];e();l._onListenerRemove(r);l._onListenerCountChange(d.length);return r};this.getEventListenerByID=function(m){return h[m]};this.getListenerObjectByID=function(m){return h[m]};this.getListenersArray=function(){return d};this.getListenerCount=function(){return d.length};var e=function(){d=[];for(var n in g){var p=g[n].oFunctions;for(var o in p){var m=p[o];d=d.concat(m)}}};this.dump=function(){a.console.dir(g);a.console.dir(d)};this._onListenerCountChange=function(m){};this._onListenerAdd=function(n,m){};this._onListenerRemove=function(n,m){};this.triggerEvent=function(m){};this.triggerEvents=function(){};this.setListenerProps=function(o,m,n){};this.onDestroy=function(){};k()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomEventListenerElementDimension!=b){return}a.CustomEventListenerElementDimension=a.oCustomEventListenerClasses.FSIElementDimension=function(){var o=this;var k=25;var e;var d=0;var f={};f[0]=25;f[25]=50;f[50]=100;f[75]=250;var l=76;var g;var j=typeof(ResizeObserver)=="function";a.CustomEventListener.prototype.constructor.call(o,"FSIElementDimension");o._strClassName="$FSI.CustomEventListenerElementDimension";this._onListenerCountChange=function(p){if(j){return}if(p<1){clearInterval(e);e=b}else{if(e==b){e=setInterval(n,f[0])}}};var c=function(r,q){for(var p=0;p<r.length;p++){i(r[p])}};var i=function(q){var p=o.getEventListenerByID(q.target.__FSI.idListener);if(p.__elementWidth!=p.element.offsetWidth||p.__elementHeight!=p.element.offsetHeight){m(p,false);if(p.tresholdEnd>0){if(p.timeoutTreshold!=b){clearTimeout(p.timeoutTreshold)}if(p.skiptreshold){p.treshold=p.tresholdEnd;p.skiptreshold=false;m(p,true)}else{p.timeoutTreshold=setTimeout(function(){p.treshold=p.tresholdEnd;p.timeoutTreshold=b;m(p,true)},p.tresholdEnd)}}}};this._onListenerRemove=function(p){if(g){g.unobserve(p.element)}if(p.timeoutTreshold!=b){clearTimeout(p.timeoutTreshold)}};this._onListenerAdd=function(p){p.__elementWidth=p.element.offsetWidth;p.__elementHeight=p.element.offsetHeight;if(j){if(g==b){g=new ResizeObserver(c)}p.element.__FSI.idListener=p.uniqueID;g.observe(p.element)}};this.setListenerProps=function(s,q,r){if(typeof(q)!="string"){return false}var p=o.getListenerObjectByID(s);if(!p){return false}switch(q){case"treshold":if(r&&r>0){p.tresholdEnd=r}break;case"skiptreshold":p.skiptreshold=r;h(15);break;case"fireTresholdEventOnly":p.fireTresholdEventOnly=r;break}};var n=function(){var r=o.getListenersArray();var v=false;var q=false;for(var u=0;u<r.length;u++){var p=r[u];if(p.__elementWidth!=p.element.offsetWidth||p.__elementHeight!=p.element.offsetHeight){v=true;if(p.tresholdEnd){p.treshold=k}m(p,false)}else{if(p.treshold>0){p.treshold+=k;if(p.skiptreshold){q=true;p.treshold=p.tresholdEnd}if(p.treshold>=p.tresholdEnd){p.skiptreshold=false;m(p,true);p.treshold=0}}}}if(!q){if(v){d=0;h(f[0])}else{if(d<l){d++;var s=f[d];if(s!=b){h(s)}}}}};var h=function(p){if(p==k||e==b){return}k=p;clearInterval(e);e=setInterval(n,k)};var m=function(p,r){var q={};if(r){q.FSI_after_treshold=p.treshold}q.FSI_target=p.element;q.FSI_dimension_old={width:p.__elementWidth,height:p.__elementHeight};p.__elementWidth=p.element.offsetWidth;p.__elementHeight=p.element.offsetHeight;q.FSI_dimension={width:p.__elementWidth,height:p.__elementHeight};if(r||!p.fireTresholdEventOnly){o.fireEvent(p,q)}};this.triggerEvent=function(q){var p=o.getEventListenerByID(q);if(!p){return}if(p.tresholdEnd){p.treshold=1}m(p)};this.triggerEvents=function(){var p=o.getListenersArray();for(var q=0;q<p.length;q++){if(p[q].tresholdEnd){p[q].treshold=1}m(p[q])}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomEventListenerDocumentZoom!=b){return}a.CustomEventListenerDocumentZoom=a.oCustomEventListenerClasses.FSIDocumentZoomChange=function(){var o=this;var c=false;var g;var h;var l=0;var f=false;var e;var n;a.CustomEventListener.prototype.constructor.call(o,"FSIDocumentZoomChange");o._strClassName="$FSI.CustomEventListenerDocumentZoom";var j=function(){if(c){return}c=true;g=a.getDocumentScaleWithPixelRatio();if(a.BrowserSupports.visualViewportAPI()){n=m;a.addEvent(window.visualViewport,"resize",n);h=setInterval(n,250)}else{n=d;e=0;h=setInterval(n,50)}a.addEvent(window,"orientationchange",n)};var i=function(){if(!c){return}c=false;if(a.BrowserSupports.visualViewportAPI()){a.removeEvent(window.visualViewport,"resize",n)}a.removeEvent(window,"orientationchange",n);clearInterval(h);h=b};this.onDestroy=function(){i()};this._onListenerCountChange=function(p){var q=(p>0);if(q!=c){if(q){j()}else{i()}}};var m=function(p){var q;var r=a.getDocumentScaleWithPixelRatio();if(g!=r){g=r;k(r);q=true}else{q=false}return q};var d=function(){var p;var q=a.getDocumentScaleWithPixelRatio();if(g!=q){if(f==false){e=0;clearInterval(h);h=setInterval(n,50)}l=0;g=q;k(q);p=true}else{p=false;if(e<3){l++;if(l==20){e=1;clearInterval(h);h=setInterval(n,150)}else{if(l==40){e=2;clearInterval(h);h=setInterval(n,300)}else{if(l==50){e=3;clearInterval(h);h=setInterval(n,600)}}}}}return p};this.triggerEvent=function(r){var p=o.getEventListenerByID(r);if(!p){return}var q={};q.FSI_scale=a.getDocumentScale();q.FSI_scale_with_pixel_ratio=a.getDocumentScaleWithPixelRatio();o.fireEvent(p,q)};this.triggerEvents=function(){k(a.getDocumentScaleWithPixelRatio())};var k=function(q){var p={};p.FSI_scale=a.getDocumentScale();p.FSI_scale_with_pixel_ratio=q;o.fireEvents(p)}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Debugger!=b){return}a.EmptyDebugger=function(){this.log=this.error=this.warn=this.dir=this.group=this.groupCollapsed=this.groupEnd=this.info=this.setPrefix=function(){};this.on=false};a.Debugger=function(){var c=this;var f="FSI";this.on=true;var e=console||{};var d=0;var h=function(j,i){if(d<1){i=Array.prototype.slice.call(i);i.unshift(f)}e[j].apply(e,i)};var g=function(i,j){if(typeof(e[i])=="function"){c[i]=function(){h(i,arguments)}}else{c[i]=j}};g("log",a.fnDoNothing);g("warn",this.log);g("error",this.log);g("info",this.log);if(typeof(e.dir)=="function"){this.dir=e.dir}else{this.dir=this.log}if(!a.isInternetExplorer&&typeof(e.group)=="function"){this.group=function(i){d++;e.group.call(e,f+i)}}else{this.group=this.log}if(!a.isInternetExplorer&&typeof(e.groupCollapsed)=="function"){this.groupCollapsed=function(i){d++;e.groupCollapsed.call(e,f+i)}}else{this.groupCollapsed=this.group}if(typeof(e.groupEnd)=="function"){this.groupEnd=function(){d--;e.groupEnd.apply(e,arguments)}}else{this.groupEnd=a.fnDoNothing}this.setPrefix=function(i){f=i+"> "}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Callbacks!=b){return}a.Callbacks=function(o,g,d){if(g==b){g={cfg:{}}}if(typeof(d)!="object"){d={}}var p=this;var f={};var n={};var l=0;var k={count:0};var e=new a.EmptyDebugger();var j={};this.destroy=function(){if(e.on){this.removeConfigListeners();if(k.count>0){e.error("WARNING: "+k.count+" listener(s) have not been removed:");for(var q in k){if(q!="count"){e.error("- "+q+" ("+k[q].count+" listener)")}}}}};this.removeConfigListeners=function(){for(var q in n){var r=n[q];if(r!==false){i(r.evt,r.fn)}}n={}};this.setDebug=function(q){e=q};this.setConfig=function(q){p.removeConfigListeners();g=q};var m=function(s){if(n[s]!=b){return f[s]}var r=false;var q=s.toLowerCase();if(typeof(g.cfg[q])=="string"&&typeof(window[g.cfg[q]])=="function"){r=window[g.cfg[q]]}else{if(typeof(g.cfg[q])=="function"){r=g.cfg[q]}}if(r!=false&&c(s,r,o)){n[s]={evt:s,fn:r}}else{n[s]=false}return f[s]};var c=this.addListener=function(s,q,r){if(typeof(q)!="function"){e.error("Failed to add listener for "+s+". The function argument is not a function.");return false}if(r==b){r=o}if(q.__FSICallbackFunctionID==b){q.__FSICallbackFunctionID=a.callbackFunctionID++}if(k[s]==b){k[s]={count:0}}if(k[s][q.__FSICallbackFunctionID]==b){k[s][q.__FSICallbackFunctionID]=[]}k.count++;k[s].count++;k[s][q.__FSICallbackFunctionID].push(l);if(e.on){var w=k[s][q.__FSICallbackFunctionID].length;if(w>1){var v="";try{v=" "+q.name+"()"}catch(t){}e.error(w+" listeners for "+s+" have been added for the same function"+v+". Did you forget to remove a listener?")}if(k[s].count>20){e.error(w+" listeners for "+s+" have been added for this instance. Did you forget to remove a listener?")}}var u=f[s];if(u==b){u=f[s]={};u.reg={};u.nam=s}u.reg[l]={fn:q,scope:r};u.bNeedsArrayRebuild=true;if(typeof(d[s])=="function"){u.handleCallbackResult=d[s]}if(j[s]!==b){q.apply(r,j[s][0])}l++;return true};var i=this.removeListener=function(s,r){if(k[s]==b||typeof(r)!="function"||r.__FSICallbackFunctionID==b){e.error("Unable to remove listener: no callback for "+s+" registered");return false}var q=k[s][r.__FSICallbackFunctionID];if(q==b){if(e.on){var w="this function";try{w="the function "+r.name}catch(t){}e.error("Unable to remove listener: no callback for "+s+" registered for "+w)}return false}var v=q.pop();k.count--;k[s].count--;if(q.length==0){k[s][r.__FSICallbackFunctionID]=b;delete k[s][r.__FSICallbackFunctionID]}if(k[s].count<1){k[s]=b;delete k[s]}var u=f[s];if(u!=b){u.bNeedsArrayRebuild=true;u.reg[v]=b;delete u.reg[v]}return true};var h=function(q){q.ar=[];for(var r in q.reg){if(typeof(q.reg[r].fn)=="function"){q.ar.push(q.reg[r])}}q.bNeedsArrayRebuild=false};this.isset=function(q){return(m(q)!=b)};this.runPersistent=function(r,q){p.run(r,q);j[r]=[q]};this.run=function(v,s){var r;var x=m(v);if(x!==b){if(x.bNeedsArrayRebuild){h(x)}var q=x.ar;for(var u=0;u<q.length;u++){var w=q[u];var t=w.fn.apply(w.scope,s);if(t!=b){r=t;if(x.handleCallbackResult){r=x.handleCallbackResult(r,s)}}}}return r}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a._API_QuickZoom!=b){return}a._API_QuickZoom=function(d,e){var c=this;c.scriptMainFile="FSI.QuickZoom.js";c.oMethodAndPropertyExclusions={devParseAPI:true,attachedCallback:true,createdCallback:true,destroyOnDetach:true,detachedCallback:true,__FSI:true,align:true};c.oMethods={addListener:{a:"strListenerName, fn, iScope",r:"bSuccess"},addImage:{a:"elImg"},destroy:{},getBuild:{r:"strBuild"},getConfigValue:{a:"strName",r:"mixed"},getInstanceID:{r:"nInstanceID"},getInstanceName:{r:"strInstanceName"},getVersion:{r:"strVersion"},init:{},printAPI:{},removeImages:{a:"arImageDOMElements"},removeListener:{a:"strListenerName, fn",r:"bSuccess"},testAPIListenersStart:{},testAPIListenersStop:{},traceConfigValue:{a:"strName"},scanForNewImages:{}};c.oCallbacks={onConfigsReady:{a:"oConfigValues"},onDestroy:{},onInit:{},onModifyPositionAndSize:{a:"oModify, oInfo"},onStart:{a:"nImagesPrepared, arImageDOMElements"},onZoomEnd:{},onZoomStart:{a:"elImage, strZoomImage"}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.QuickZoom!==b){return}a.addViewerClassCSSRule("div.FSIQuickZoom","position:absolute!important;z-index:10000;box-sizing:content-box!important;overflow:hidden!important;padding:0px 0px 0px 0px;cursor: crosshair;background-color:white;border:0px none;");a.QuickZoom=function(Z){var t={};var R={strVersion:"2018",strBuild:"18.05.17.1",strConfigSection:"QuickZoom",bHasListeners:true};var ah=new a.ClassDef(this,"FSI QuickZoom",R);ah.oAPI=new a._API_QuickZoom(this,t);var n=ah.instance;a.guessFSIViewerLocation("fsiquickzoom.js",3);var r=a.getViewerInstanceID();var K=new a.EmptyDebugger();var m=function(am,al){if(al&&!K.on&&am.on){if(H){H.stopPendingRequests()}n.destroy();n.init(true);return true}K=am;if(K.on){K.setPrefix(n.getInstanceName())}};this.getInstanceID=function(){return r};this.getInstanceName=function(){return ah.strClassName+" [#"+r+"]"};var af=(Z)?a.cloneParameters(Z):{};var G;var aj;var w=false;var H;var C;var I=false;var d=true;var N=/((\?)|&)effects=([^&]*)/ig;var ai=/((\?)|&)rect=([^&]*)/ig;var ac=/[=,]+Pad\([^)]*/ig;var l=/((\?)|&)(width|height)=[^&]*/ig;var i;var v={};var ak={};var ag=3;var D=false;var U={x:0,y:0};var o={x:10000000,y:10000000};var M;var A;var j;var ab,J;var y;var q=1;var L=true;var aa=false;var g=true;var f=true;var T;K.log(n.getVersion());this.init=function(al){if(w){return}if(al!==b){af.debug=al}if(a.isMobileDevice&&a.BrowserSupports.documentZoom()){return false}aj=new a.CORSLoader();if(a.getDocumentScroll===b||!aj.getSupported()){K.error("Unsupported browser. "+aj.getSupported()+" => "+navigator.userAgent);return}var am={};am.onConfigsReady=V;am.onDebuggerChange=m;H=new a.Config(null,am,{strSection:ah.strConfigSection});H.init(af);H.loadConfigs();C=t.iCallbacks=new a.Callbacks(n,H);if(C.isset("onInit")){C.runPersistent("onInit",[af])}return true};this.getConfigValue=function(al){if(H&&typeof(al)==="string"){return H.cfg[a.trim(al.toLowerCase())]}};this.getParameters=function(){return a.cloneParameters(af)};this.destroy=function(){if(H){H.destroy();H=b}if(C){C.run("onDestroy");C.destroy();C=b}if(y!==b){a.removeCustomEvent(n,"FSIDocumentZoomChange",h);y=b}P();if(G){var al=G.getArray();for(var am=0;am<al-length;am++){k(img)}G.empty()}w=false};var V=function(){var at;if(n.bAutoInitialized){K.log("Start (auto initialized)")}else{K.log("Start")}if(C.isset("onConfigsReady")){C.runPersistent("onConfigsReady",[a.cloneObject(H.cfg)])}T=H.makeBool(H.cfg.usedevicepixelratio,true);I=H.makeBool(H.cfg.inplacezoom,false);if(I){d=false}else{d=H.makeBool(H.cfg.autozoomdimension,true)}L=H.makeBool(H.cfg.moverangecentercorners,!I);if(a.BrowserSupports.documentZoom()){y=a.addCustomEvent(n,"FSIDocumentZoomChange",h);aa=(a.getDocumentScale()>1)}if(!G){var al={NameID:"$FSIQuickZoom_TagID"};G=new a.ImageTagCollection(al,H.cfg);G.init()}a._FSIQuickZoomInstance=n;if(H.cfg.headers===b){H.cfg.headers="cors"}if(H.cfg.length>0){i="&headers="+H.cfg.headers}else{i=""}ag=F("magnification",2);ag=Math.max(1,ag);o.x=F("maxZoomWindowWidth",o.x);o.y=F("maxZoomWindowHeight",o.y);ab=F("minZoomWindowWidth",100);J=F("minZoomWindowHeight",100);U.x=F("skipImageWidth",0);U.y=F("skipImageHeight",0);M=F("pageMargin",18);A=F("zoomImageBorderWidth",-1);j=F("zoomImageOffset",0);if(A<0){try{var an=document.createElement("div");an.style.display="none";a.addClass(an,"FSIQuickZoom");document.body.appendChild(an);var am=window.getComputedStyle(an,null);var ao=0;ao=Math.max(ao,parseFloat(am.borderLeftWidth));ao=Math.max(ao,parseFloat(am.borderRightWidth));ao=Math.max(ao,parseFloat(am.borderTopWidth));ao=Math.max(ao,parseFloat(am.borderBottomWidth));A=ao;a.removeChild(document.body,an)}catch(au){}}var av=document.getElementsByTagName("img");K.log("Preparing images (total images: "+av.length+")");for(at=0;at<av.length;at++){ae(av[at])}K.log(G.getCount()+" images have been prepared for FSI QuickZoom");if(C.isset("onStart")){var aq=G.getArray();var ap=new Array(aq.length);for(at=0;at<aq.length;at++){ap[at]=aq[at].tag}C.runPersistent("onStart",[ap.length,ap])}w=true};this.addListener=function(ao,am,an){var al=false;if(C){al=C.addListener(ao,am,an)}return al};this.removeListener=function(an,am){var al=false;if(C){al=C.removeListener(an,am)}return al};var h=function(al){var am=(al.FSI_scale>1);if(aa===am){return}aa=am;if(am){P()}};var F=function(am,an){var al=parseFloat(H.cfg[am]);if(isNaN(al)){al=an}return al};this.removeImages=function(al){if(al===b){return}if(al.join===b){al=[al]}var am=G.getCount();for(var ao=0;ao<al.length;ao++){k(al[ao])}var an=G.getCount();var ap=am-an;K.log("removeImages: "+ap+" images have been removed, total zoom images now: "+an+" images.");return ap};var u=function(al){if(!al){return}var am=G.getById(al.$FSIQuickZoom_TagID);a.removeEvent(al,"load",z,false);a.removeEvent(al,"error",W,false);a.removeEvent(al,"mouseover",E,false);if(typeof(ak)==="object"&&ak.id===am.__id){P()}return am};var k=function(al){var am=u(al);G.remove(am);am.img.$FSIQuickZoom_TagID=b;delete am.img.$FSIQuickZoom_TagID};this.addImage=function(al){if(!al||al.$FSIQuickZoom_TagID!==b){return}var am=ae(al);return(am!==b)};var ae=function(al){if(!G){return}var am=G.add(al);if(!am){return}am.srcCurrent=am.src;am.tag=al;a.addEvent(al,"load",z,false);a.addEvent(al,"error",W,false);a.addEvent(al,"mouseover",E,false);return am};var Y=function(am){if(!am||!am.img||am.bPrepared===true){return}var al=am.img;am.src=X(am.src);if(al.width!==b&&al.width>0){am.width=al.width}if(al.height!==b&&al.height>0){am.height=al.height}if(am.width>0&&am.height>0){p(am)}else{am.bFinishOnLoad=true}am.bPrepared=true;return am};var p=function(ap){ap.ready=true;ap.wOrg=ap.width;ap.hOrg=ap.height;ap.src=H.reWriteImageURLByConditions(ap.src);var an;an=ap.src.match(N);if(an&&typeof(an)==="object"&&typeof(an[0])==="string"){an[0]=decodeURIComponent(an[0]);if(an[0].match(ac)){ap.bHasPadEffect=true}}if(!ap.bHasPadEffect){an=ap.src.match(ai);if(an&&an[0]){var am=an[0].split("=");if(am.length>0){am=decodeURIComponent(am[1]).split(",");if(am.length>3){var al=parseFloat(am[2]);var ao=parseFloat(am[3]);if(al>0&&al<=1&&ao>0&&ao<=1){ap.cropRectWidth=al;ap.cropRectHeight=ao}}}}}};var X=function(al){return al.replace(l,"$2")};var W=function(){var al=(!a.isInternetExplorer)?this:window.event.srcElement;var am=G.getById(al.$FSIQuickZoom_TagID);if(am.bLoading){am.ready=false;am.bLoading=false}};var z=function(){var am=(!a.isInternetExplorer)?this:window.event.srcElement;var ao=G.getById(am.$FSIQuickZoom_TagID);var al=G.getSrc(am);if(!ao.bLoading&&ao.orgSrc!==al){var an=false;if(typeof(ak)==="object"&&ak.idVisible===ao.__id){an=true}if(an){P()}ao.bPrepared=ao.ready=false;ao.bInfo=b;X(ao.src);ao.srcCurrent=ao.orgSrc=al;ao.sourceWidth=ao.sourceHeight=b;ao.src=X(ao.orgSrc);Y(ao);ad(ao);if(an){ak.id=ao.__id}}if(ao.bFinishOnLoad){delete ao.bFinishOnLoad;ao.width=am.width;ao.height=am.height;p(ao)}else{if(ao.bLoading){ao.bLoading=false}}};var B=function(al){v.x=al.clientX;v.y=al.clientY};var P=function(){var al=ak.el;var am=ak.elDiv;if(ak.id!==b){a.removeEvent(al,"mousemove",c,false);a.removeEvent(al,"mouseout",e,false);ak.id=ak.img=b;ak.src=ak.idVisible=b}if(!am){return}a.removeEvent(ak.elImageFinalZoom,"load",s,false);a.removeChild(am.parentNode,am);ak.elDiv=b;a.removeClass(al,"FSIQuickZoom");C.run("onZoomEnd")};var x=function(au,aR){if(aa){return}var ax=au.img;if(T){q=Math.max(1,a.getDevicePixelRatio())}else{q=1}var ao=A;var aX=j;if(typeof(ak)==="object"&&ak.idVisible===au.__id){return}if(!au.bInfo){return}g=f=false;var aA=a.getViewportSize(window);var ba=M;var aG=aA.width-M-2*ao;var aE=M;var a6=aA.height-M-2*ao;var aF=a.getDocumentScroll(window);var ap=a.getElementPosition(ax);var aZ=O(ax);var aK;var az,aO,bc,aq;if(!d){aK=a.getElementPaddings(ax);az=ap.right-ap.left;aO=ap.bottom-ap.top;bc=az+aK.left+aK.right;aq=aO+aK.top+aK.bottom}else{bc=Math.max(o.x,au.wOrg);aq=Math.max(o.y,au.hOrg)}if(!I){var am;var aY;var aH=aA.width-2*M-2*ao;var aV=aA.height-2*M-2*ao;var a8,a7;if(aH-bc>aV-aq){aY=aV;var aT=ap.left-M-aZ.left-aX-2*ao;var aS=aA.width-ap.right-M-aZ.right-aX-2*ao;a7=0;if(aS>aT){am=aS;a8=1}else{am=aT;a8=-1}}else{am=aH;var aQ=ap.top-M-aZ.top-aX-2*ao;var aP=aA.height-ap.bottom-M-aZ.bottom-aX-2*ao;a8=0;if(aP>aQ){aY=aP;a7=1}else{aY=aQ;a7=-1}}bc=Math.min(am,bc);aq=Math.min(aY,aq)}var aL=false;if(typeof(au.tag.getAttribute)==="function"){var a2=au.tag.getAttribute("FSIQuickZoomMagnification")||au.tag.getAttribute("data-fsi-quickzoom-magnification");if(typeof(a2)==="string"){a2=parseFloat(a2);if(!isNaN(a2)&&a2>1){aL=a2}}}if(!aL){aL=ag}a.expandSourceDimensionForPadEffect(au,au.wOrg,au.hOrg);var aw=au.sourceWidth;var a5=au.sourceHeight;var aJ=Math.round(aw/q);var a3=Math.min(aJ,Math.round(aL*au.wOrg));aJ=Math.round(a5/q);var aW=Math.min(aJ,Math.round(aL*au.hOrg));var at;if(au.cropRectWidth){at=a.getFSIServerImageDim(au.cropRectWidth*aw,au.cropRectHeight*a5,a3,aW,b,!au.bHasPadEffect)}else{at=a.getFSIServerImageDim(aw,a5,a3,aW,b,!au.bHasPadEffect)}a3=at.width;aW=at.height;var aD=Math.min(aw,Math.round(a3*q));var a1=Math.min(a5,Math.round(aW*q));var aN=a3/aD;if(d){g=(a3<=bc);f=(aW<=aq);if(g){bc=a3}if(f){aq=aW}}var ay=au.src+"&width="+aD+"&height="+a1;if(ak.src===ay){return}var ar,av,aC,aB,be,bd;if(I){ar=-ao-aK.left;av=-ao-aK.top}else{if(a8===0){ar=(ap.right-ap.left)/2-bc/2-ao}else{if(a8>0){ar=ap.right-ap.left+aZ.right+aX}else{ar=-aZ.left-bc-2*ao-aX}}aC=ap.left+ar;aB=aC+bc;if(aC<ba){ar+=ba-aC}if(aB>aG){ar-=aB-aG}if(a7===0){av=(ap.bottom-ap.top)/2-aq/2-ao}else{if(a7>0){av=ap.bottom-ap.top+aZ.bottom+aX}else{av=-aZ.top-aq-2*ao-aX}}be=ap.top+av;bd=be+aq;if(be<aE){av+=aE-be}if(bd>a6){av-=bd-a6}}if(C.isset("onModifyPositionAndSize")){var a4={};var bb={};bb.left=ar;bb.top=av;bb.width=bc;bb.height=aq;bb.srcZoomImage=ay;a4.sourceElement=ax;a4.imageWidth=a3;a4.imageHeight=aW;a4.imageWidthDPR=aD;a4.imageHeightDPR=a1;a4.sourceImageWidth=aw;a4.sourceImageHeight=a5;a4.borderWidth=ao;a4.imageMargin=aX;a4.minZoomWidth=ab;a4.minZoomHeight=J;a4.maxZoomWidth=o.x;a4.maxZoomHeight=o.y;a4.elementPosition=a.cloneObject(ap);a4.imgPaddings=a.cloneObject(aZ);a4.scrollPos=a.cloneObject(aF);a4.event=aR;C.run("onModifyPositionAndSize",[bb,a4]);ar=bb.left;av=bb.top;bc=bb.width;aq=bb.height;ay=bb.srcZoomImage;g=(a3<=bc);f=(aW<=aq)}if(bc<ab||aq<J){return}a.addClass(ax,"FSIQuickZoom");if(ak.elDiv!==b){P()}ak.id=ak.idVisible=au.__id;ak.el=ax;ak.width=ax.offsetWidth;ak.height=ax.offsetHeight;ak.oImage=au;ak.elOffsetX=-ap.left-aF.x;ak.elOffsetY=-ap.top-aF.y;var al=ak.elImageZoom=document.createElement("img");al.setAttribute("width",String(aD));al.setAttribute("height",String(a1));var aU="position:relative;border:0px none; padding:0px; margin:0px;";aU+="max-width:none;max-height:none;min-width:none;min-height:none;";aU+="width:"+aD+"px;height:"+a1+"px";a.setStyleAttr(al,aU);if(aN!==1){al.style.width=a3+"px";al.style.height=aW+"px"}var a9=document.createElement("div");a.setStyleAttr(a9,"margin-left:0px;margin-top:0px;");a9.setAttribute("class","FSIQuickZoom");a9.style.width=bc+"px";a9.style.height=aq+"px";a9.style.left=Math.round(aF.x+ap.left+ar)+"px";a9.style.top=Math.round(aF.y+ap.top+av)+"px";ak.src=ay;ak.elDiv=a9;ak.elImageFinalZoom=al;ak.elImageZoom=ak.elImagePreviewZoom=al.cloneNode(false);ak.elImagePreviewZoom.src=au.orgSrcDisplay;a.addEvent(ak.elImageFinalZoom,"load",s,false);al.src=ay;ak.scaleX=a3/au.wOrg;ak.scaleY=aW/au.hOrg;ak.centerX=ak.elOffsetX-au.wOrg/2;ak.centerY=ak.elOffsetY-au.hOrg/2;if(L){ak.moveFactorX=a3/au.wOrg;ak.moveFactorY=aW/au.hOrg;ak.moveOffsetX=Math.round(bc/2);ak.moveOffsetY=Math.round(aq/2)}else{ak.moveFactorX=(a3-au.wOrg)/au.wOrg;ak.moveFactorY=(aW-au.hOrg)/au.hOrg;ak.moveOffsetX=0;ak.moveOffsetY=0}a9.style.pointerEvents="none";a9.appendChild(ak.elImagePreviewZoom);document.body.appendChild(a9);var aM=new a.Rect();var aI=new a.Rect();var an=a.getElementClientPos(ax);aM.copyRect(an);var a0=a.getElementClientPos(a9);aI.copyRect(a0);aI.interSectRectValidate(aM);D=(aI.width()>0&&aI.height()>0);c();C.run("onZoomStart",[au.tag,ay])};var s=function(){var al=this;a.removeEvent(al,"load",s,false);var am=ak.elImagePreviewZoom;setTimeout(function(){am.src=al.src},25)};var O=function(am){var al={left:0,top:0,right:0,bottom:0};try{var an=window.getComputedStyle(am,null);al.left+=parseFloat(an.paddingLeft);al.right+=parseFloat(an.paddingRight);al.top+=parseFloat(an.paddingTop);al.bottom+=parseFloat(an.paddingBottom);al.left+=parseFloat(an.borderLeftWidth);al.right+=parseFloat(an.borderRightWidth);al.top+=parseFloat(an.borderTopWidth);al.bottom+=parseFloat(an.borderBottomWidth)}catch(ao){}return al};var c=function(am){if(am){B(am)}if(!ak||!ak.elDiv){return}var ap=a.getDocumentScroll(window);var al,ao;if(g){v.x=-ak.centerX-ap.x}if(f){v.y=-ak.centerY-ap.y}al=v.x+ak.elOffsetX+ap.x;ao=v.y+ak.elOffsetY+ap.y;al=al*ak.moveFactorX-ak.moveOffsetX;ao=ao*ak.moveFactorY-ak.moveOffsetY;var an=ak.elImageZoom;an.style.left=-Math.round(al*q)/q+"px";an.style.top=-Math.round(ao*q)/q+"px"};var E=function(al){B(al);var am=(!a.isInternetExplorer)?this:window.event.srcElement;var an=G.getById(am.$FSIQuickZoom_TagID);if(!an){return}if(ak.id!==an.__id){if(ak.id){P()}a.addEvent(am,"mousemove",c,false);a.addEvent(am,"mouseout",e,false);ak.id=an.__id;ak.img=am}Y(an);ad(an);x(an,al)};var e=function(){P()};this.scanForNewImages=function(){var al=document.getElementsByTagName("img");var am=0;K.log("...scanning for new images: "+al.length+" image(s) in total");for(var an=0;an<al.length;an++){if(al[an].$FSIQuickZoom_ID===b){if(ae(al[an])){am++}}}K.log(am+" new QuickZoom image(s) added")};var ad=function(ao){if(!ao||ao.bInfo!==b){return}ao.bInfo=false;var al=ao.src;var am=al.match(/.*[?]/);var an=al.match(/[?&]source=[^&]*/);al=am+"type=info&tpl=info.json"+i+an;aj.load(al,Q,b,ao)};var Q=function(am,ao,aq){var an;try{an=a.JSON.parse(ao)}catch(ap){K.error("Failed to get image info for "+aq.src);an=a.getFSIServerImageDim(aq.wOrg,aq.hOrg,4000,4000,b,true)}aq.sourceWidth=an.width;aq.sourceHeight=an.height;S(aq);var al=false;if(U.x>0&&aq.wOrg<U.x){al=true}if(U.y>0&&aq.hOrg<U.y){al=true}if(al){k(aq.img)}else{if(ak.id===aq.__id){x(aq)}}};var S=function(al){if(!al.sourceWidth||!al.sourceHeight){al.ready=false;return}if(al.rectWidth){al.maxWidth=Math.round(al.rectWidth*al.sourceWidth);al.maxHeight=Math.round(al.rectHeight*al.sourceHeight)}else{al.maxWidth=al.sourceWidth;al.maxHeight=al.sourceHeight}al.bInfo=true}};a.addEvent(window,"DOMContentLoaded",function(){if(typeof(a.quickZoomParameters)!=="object"||a.makeBool(a.quickZoomParameters.autoInit,true)){if(typeof(a.quickZoom)==="object"&&typeof(a.quickZoom.destroy)==="function"){a.quickZoom.destroy()}var c;if(typeof(a.quickZoomParameters)==="object"){c=a.quickZoomParameters}a.quickZoom=new a.QuickZoom(c);a.quickZoom.bAutoInitialized=true;a.quickZoom.init()}})}(window.$FSI=window.$FSI||{}));