﻿/*!
 * FSI Server Interface
 * http://www.fsi-viewer.com
 *
 * Copyright (C) 2000-2009 NeptuneLabs GmbH - All rights reserved.
 *
 * Version: 1.0.1
 */

initGlobal();
var savedsettings = new Array();
var quickzoom;

function updateSliders() {

	if(savedsettings['effects_compressionslider'])compressionslider.setValue(savedsettings['effects_compressionslider']);

		compressionslider.recalculate();
		pngmaxcolorsslider.recalculate();
		gifmaxcolorsslider.recalculate();
}

function initPreview() {

	if (typeof(quickzoom) != "undefined" && quickzoom && quickzoom.destroy) {
		quickzoom.destroy();
//		delete(quickzoom);
	}
	if(!document.settings.enablequickzoom.checked) return;
	if (typeof($FSI) != "undefined" && typeof($FSI.QuickZoom) != "undefined") {
		updateCode(true);
		
		var opts = getQZObject();
		var quickzoom = new $FSI.QuickZoom(opts);

		quickzoom.init();
	} else {
		interfaceControl.showPublishMessage("Error","Error initializing preview. Scripts have not loaded yet.");

	}
}

function toActive(o,skipupdate) {

	
		if (o=='7' || o=='6') document.body.className = "grey";
		else document.body.className = "";

		if ( colorPickerVisible ) hideCP('false');
		if ( helpvisible ) closeHelp();
		p = document.getElementById('preview');
		var px = document.layers ? "" : "px";
			for (x=0; x<divs.length+1; x++) { // 8
				hide(divs[x]);
				hide('div' + x);
				changeImages(divs[x],'inactive');
			}
			updateSliders();
			updateCrop(true);
			if (o=='7') { //Crop
				initCrop();
				bindCropHelper(true);
			}
			else bindCropHelper(false);

			if (o=='6' || o =='7') { //Preview

					var bByPassProxy = interfaceControl.getByPassProxyInPreviews();
					var bUseLocalServer = (build && build == "downloadimage");

					var new_w = save_width = document.settings.FSIwidth.value;
					var new_h = save_height = document.settings.FSIheight.value;
					p.style.height = new_h + px;
					p.style.width = new_w + px;
					if (o=='6') {
						var infoimage = updateCode();
						interfaceControl.getPublishingView().writePreviewInfo(infoimage, 'image_notification');
						writePreviewURL("preview_notification");
					}

					updateCode(true);

					try {
						ci = document.getElementById('preview');
						var itag = updateCode(true);
						var cname = "";
						if(document.settings.EnableByCSSClass.value != "") cname = ' class="'+document.settings.EnableByCSSClass.value+'"';

						ci.innerHTML = '<img'+cname+' src="'+itag+'" id="pim"/>';;
						initPreview();
						var pim = document.getElementById("pim");
						pim.onload = function() {
							$('#preview').css("background-image","");
							p.style.height = "100%";

						}
					} catch (e) {}

					//document.settings.FSIwidth.value = save_width;
					//document.settings.FSIheight.value = save_height;

			} else {
				p.style.width = 750 + px;
			}
			show('div' + o);
			if(document.settings.enablequickzoom.checked) initPreview();
			if (o=="5") updateEffectThumbs();
			compressionslider.recalculate();
			gifmaxcolorsslider.recalculate();
			pngmaxcolorsslider.recalculate();

			aktiveDiv = o;
			updateCode(true);

			if (o == '5'){
				if (typeof(resizeEffectsTable) == "function") resizeEffectsTable();
			}

			return true;

}



function checkJPEGType() {

	document.getElementById('qualityvisible').style.display = "none";

	document.getElementById('nonjpegoptions').style.display = "none";

	document.getElementById('pngmaxcolorsvisible').style.display = "none";

	document.getElementById('gifmaxcolorsvisible').style.display = "none";
	document.getElementById('gifcoloroptions').style.display = "none";
	document.getElementById('animgifoptions_div').style.display = "none";

	var rend = document.getElementById('image_format').value.toLowerCase();

	if (rend == 'jpeg') {
		document.getElementById('qualityvisible').style.display = "block";

		compressionslider.setMinimum(0);
		compressionslider.setMaximum(100);
		if(savedsettings['compressionslider']) {
			compressionslider.setValue(savedsettings['compressionslider']);
		}
		else compressionslider.setValue(0);
		compressionslider.recalculate();
	} else {
		document.getElementById('nonjpegoptions').style.display = "block";
	}


	if (rend == 'gif') {
		document.getElementById('gifmaxcolorsvisible').style.display = "block";
		document.getElementById('gifcoloroptions').style.display = "block";
		if(savedsettings['maxcolorsslidergif'] ) gifmaxcolorsslider.setValue(savedsettings['maxcolorsslidergif']);
		else gifmaxcolorsslider.setValue(256);
	}

	if (rend == 'png') {
		document.getElementById('pngmaxcolorsvisible').style.display = "block";

		if(savedsettings['maxcolorssliderpng'] ) pngmaxcolorsslider.setValue(savedsettings['maxcolorssliderpng']);
		else pngmaxcolorsslider.setValue(0);

	}

	qdata['image_format'] = document.getElementById('image_format').value.toLowerCase();
	gifmaxcolorsslider.recalculate();
	pngmaxcolorsslider.recalculate();
	window.setTimeout("doUpdateCode()", 500);

}


function activateWrap() {
	var opt=document.settings;

	if ((opt.enabletouchzoom && opt.enabletouchzoom.checked) || (opt.enablequickzoom && opt.enablequickzoom.checked) ){
		opt.publishwrap.checked = true;
		document.getElementById("thisshallbehidden").style.display = "block";
	} else {
		opt.publishwrap.checked = false;
		document.getElementById("thisshallbehidden").style.display = "none";
	}

}


function setMatrix(){
	var opt = document.settings;

	var Left = opt.lrgba_rr.value+","+opt.lrgba_rg.value+","+opt.lrgba_rb.value+",";
	Left += opt.lrgba_gr.value+","+opt.lrgba_gg.value+","+opt.lrgba_gb.value+",";
	Left += opt.lrgba_br.value+","+opt.lrgba_bg.value+","+opt.lrgba_bb.value;

	qdata["options_lefteffects"] = "RGBMatrix("+Left+")";
	if (Left == "1,0,0,0,1,0,0,0,1") delete qdata["options_lefteffects"];
	if(opt.leftextraeffect.value != "") {
		if (qdata["options_lefteffects"]) qdata["options_lefteffects"] = qdata["options_lefteffects"] + ",";
		qdata["options_lefteffects"] += opt.leftextraeffect.value;
	}

	var Right = opt.rrgba_rr.value+","+opt.rrgba_rg.value+","+opt.rrgba_rb.value+",";
	Right += opt.rrgba_gr.value+","+opt.rrgba_gg.value+","+opt.rrgba_gb.value+",";
	Right += opt.rrgba_br.value+","+opt.rrgba_bg.value+","+opt.rrgba_bb.value;

	qdata["options_righteffects"] = "RGBMatrix("+Right+")";
	if (Right == "1,0,0,0,1,0,0,0,1") delete qdata["options_righteffects"];
	if(opt.rightextraeffect.value != "") {
		if (qdata["options_righteffects"]) qdata["options_righteffects"] = qdata["options_righteffects"] + ",";
		qdata["options_righteffects"] += opt.rightextraeffect.value;
	}

	updateCode();
}


function updateCode(forPreview) {
	//console.log("updateCode:"+forPreview);
	var opt=document.settings;

	var imgurl = getSSImage(opt.FSIwidth.value, opt.FSIheight.value, false, false, false);
	if (changedDimensionElement && build != "html") {
		if (changedDimensionElement == 'height') imgurl = imgurl.replace(/&width=[0-9]+/,"");
		if (changedDimensionElement == 'width') imgurl = imgurl.replace(/&height=[0-9]+/,"");
	}
	if(imgurl == false) return;
	if (build=="html") imgurl = imgurl.replace(/renderer=anaglyph/,"");

	//if(interfaceControl.getThumbView().getSingleSelectedItemType() == "directory")  imgurl = imgurl.replace(/type=image/,"type=directoryimage");

	try {
		document.getElementById('downloadbutton').innerHTML='<input type="button" value="Download Image" onclick="openImage()";>';
	} catch (e){}

	var rend = document.getElementById('image_format').value.toLowerCase();

	if (rend=="gif") { //AnimGif
		var ne = interfaceControl.getThumbView().getFirstSelectedThumb();
		if(ne && ne.type=="directory") {
			var pic = interfaceControl.getThumbView().getFirstImageEntryForDir(decodeURIComponent(ne.fullsrc), interfaceControl.getBasePathType());
			if(pic.type == "file") {
				document.getElementById('animgifoptions_div').style.display = "block";
				imgurl = imgurl.replace(/type=image/,"type=directoryimage");
				imgurl = imgurl.replace(/source=[^&]*/,"source="+ne.fullsrc);
				imgurl = imgurl.replace(/format=gif/,"renderer=animate");
			}
		} else {
			document.getElementById('animgifoptions_div').style.display = "none";
		}

	}

	var alt = "";

	var cname = "";
  if(document.settings.EnableByCSSClass.value != "") cname = ' class="'+document.settings.EnableByCSSClass.value+'"';

	var imgtag =  '<img'+cname+' alt="" src="'+imgurl+'" ';

	if (opt.FSIwidth.value != "") imgtag +=  'width="'+opt.FSIwidth.value+'" ';
//	if (opt.FSIheight.value != "") imgtag +=  'height="'+opt.FSIheight.value+'" ';


	if (opt.makesrcset.checked) {

		/*
		getSrcSetLevels(entry, startWidth, mode, aCrop)
		Wobei "startWidth" einfach die ausgewählte Breite ist.
		Mode 1: server side levels
		Mode 2: source x 2.0
		Mode 3: source x 1.5
		*/
		var myTmpImgUrl = imgurl;
		myTmpImgUrl = myTmpImgUrl.replace(/&height=[0-9]+/,"");
		var entry = getPublishImageEntry();
		var mode = document.getElementById('srclevelmode').selectedIndex+1;
		var aCrop = getCropRectangle();
		var imgLevels = interfaceControl.getThumbView().getSrcSetLevels(entry, opt.FSIwidth.value, mode, aCrop);
		if(imgLevels.length > 0) {
			document.getElementById('HTMLCodeSnippet').rows = "16";
			imgtag += "\nsrcset=\"";
			for (var i = 0; i <= imgLevels.length - 1; i++) {
				imgtag += myTmpImgUrl.replace(/&width=[0-9]+/,"&width="+imgLevels[i])+' '+imgLevels[i]+"w, \n";
			};
			imgtag = imgtag.substr(0,imgtag.length-3); //remove trailing ", \n"
			imgtag += '" sizes="'+opt.FSIwidth.value+'px"' ;
		}
	} else {document.getElementById('HTMLCodeSnippet').rows = "8";}

	imgtag += '/>';

	imgtag = imgtag.replace(/&/g, "&amp;");
	var previewImageTag = imgtag;

	if (opt.publishwrap && opt.publishwrap.checked){
		imgtag = wrapinXHTML(imgtag);
	} else {
		if (opt.enabletouchzoom.checked) opt.enabletouchzoom.checked = false;
		if (opt.enablequickzoom.checked) opt.enablequickzoom.checked = false;
	}


	try
	{
		opt.htmldata.value = imgtag;
		opt.dirvalue.value = imgurl;

		opt.renderingquery.value = getSSImage(opt.FSIwidth.value, opt.FSIheight.value, false, false, false, true);

	} catch (e){}
	interfaceControl.updatePreviewCode(wrapinXHTML(previewImageTag,true));
	StorePublishingSettings();

	if (opt.enabletouchzoom.checked && opt.enablequickzoom.checked){
		//return previewImageTag;
	}
  return imgurl;

}

function enableTZ() {
	var opt=document.settings;
	opt.enabletouchzoom.checked=true;
	activateWrap();
}

function enableQZ() {
	var opt=document.settings;
	opt.enablequickzoom.checked=true;
	activateWrap();
}

function getTouchZoomOptions(bAsString,bForPreview) {

	var opt = document.settings;

	if(typeof(bAsString) == "undefined" || !bAsString) {
		var retstr = "";
		for (var option in qdata) {
				if(option != "magnification" && option !=  "inPlaceZoom" && option != "imgsrcattributename" && option != "addcssclass" && option != "imgsrcattribute" && option != "autozoomdimension" && option != "moverangecentercorners" && option != "maxzoomwindowwidth" && option != "maxzoomwindowheight" && option != "minzoomwindowwidth" && option != "minzoomwindowheight" && option != "skipimagewidth" && option !="skipimageheight" && option != "pagemargin" && option != "zoomimageborderwidth" && option != "zoomimageoffset")
						if(qdata[option] == "") delete(qdata[option]);
						else retstr += option+":\""+qdata[option]+"\",";
			}
		retstr = "{" + retstr.substr(0,retstr.length-1) + "}"; //remove last comma
		return retstr;
	} else {
		var retstr = new Object;
		for (var option in qdata) {
			if(option != "magnification" && option !=  "inPlaceZoom" && option != "imgsrcattributename" && option != "addcssclass" && option != "imgsrcattribute" && option != "autozoomdimension" && option != "moverangecentercorners" && option != "maxzoomwindowwidth" && option != "maxzoomwindowheight" && option != "minzoomwindowwidth" && option != "minzoomwindowheight" && option != "skipimagewidth" && option !="skipimageheight" && option != "pagemargin" && option != "zoomimageborderwidth" && option != "zoomimageoffset")
					if(qdata[option] == "") delete(qdata[option]);
					else retstr[option] = qdata[option];
		}
		return retstr;
	}
	return retstr;
}

function getQuickZoomOptions(forPreview) {

	var opt = document.settings;
	var retstr = "";
	for (var option in qdata) {
		 if(option != "MonitorImagePositions"  && option != "UseTiledImages" && option != "loadingImage")
					retstr += option+":\""+qdata[option]+"\",";
		}
	if (forPreview) retstr += "disableByCSSClass:\"no_quickzoom\"";
	retstr = "{" + retstr.substr(0,retstr.length-1) + "}"; //remove last comma
	return retstr;
}

function getQZObject() {
	//console.log("getQZObject");
	//console.log("qdata is:");
	//console.log(qdata);
	//console.log(typeof qdata
	//console.log("with length of:" + qdata.length);
	//console.log("end Qdata");
  var keys = Object.keys(qdata);
  
  var values = Object.values(qdata);
  

	var opt = document.settings;
	var retstr = new Object;

  for (var option in qdata) {
  //for (var option in keys) {

		 if(option != "MonitorImagePositions"  && option != "UseTiledImages" && option != "loadingImage")
					if(qdata[option] == "") delete(qdata[option]);
					else retstr[option] = qdata[option];
		}

	return retstr;
}

function getTouchZoomHeaders(forPreview) {

	var retstr = "";
	var tz = document.settings.enabletouchzoom;
	var qz = document.settings.enablequickzoom;

	if ((tz && tz.checked) || (qz && qz.checked)) {
		if (!forPreview)var jsurl = interfaceControl.getUserProxyPagesMobileUrl(); //req HLK
		else var jsurl = interfaceControl.getUserLocalFSIViewerBase() + "applications/pagesmobile/";

		if(tz && tz.checked) {
			var jsurltz = jsurl.replace(/pagesmobile/g, "touchzoom");
			retstr += '<script type="text/javascript" src="'+jsurltz+'js/fsitouchzoom.js"><\/script>\n';
		}
		if(qz && qz.checked) {
			var jsurlqz = jsurl.replace(/pagesmobile/g, "quickzoom");
			retstr += '<script type="text/javascript" src="'+jsurlqz+'js/fsiquickzoom.js"><\/script>\n';
		}
		if(getTouchZoomOptions() != "{}" || getQuickZoomOptions(forPreview) != "{}") {
			retstr += "<script type=\"text/javascript\">\n";
			if(tz && tz.checked) {
				retstr += "\t$FSI.touchZoomParameters="+getTouchZoomOptions()+";\n";
			}
			if(qz && qz.checked && getQuickZoomOptions() != "{}") {
				retstr += "\t$FSI.quickZoomParameters="+getQuickZoomOptions(forPreview)+";\n";
			}
			retstr += "</script>\n";
		}
		retstr += "<meta http-equiv=\"X-UA-Compatible\" content=\"IE=Edge,chrome=1\">\n";
	}

	return retstr;

}


function wrapinXHTML(imgtag,forPreview) {

			htmlcode = '<!DOCTYPE HTML>\n';
			if(typeof(forPreview) != undefined && forPreview) htmlcode += interfaceControl.getPreviewWindowComment();
			htmlcode+='<html>\n';
			htmlcode+='<head>\n';
			htmlcode+=getTouchZoomHeaders(forPreview);

			htmlcode+='<meta http-equiv="content-type" content="text/html; charset=UTF-8">\n';
			htmlcode+='<title></title>\n';
			if (forPreview) htmlcode += interfaceControl.getPreviewWindowStyle();
			htmlcode+='</head>\n';
			htmlcode+='<body>\n';
			htmlcode+=imgtag;
			htmlcode+='\n</body>\n';
			htmlcode+='</html>\n';

		return htmlcode;
}


function openImage() {

	w = document.settings.FSIwidth.value;
	h = document.settings.FSIheight.value
	var url = getSSImage(w,h, false, false, true);
	url = interfaceControl.appendQueryParameterToUrl(url, "disposition=true&save=true");

	if (browser.name == "IE" || browser.name == "Chrome") window.open(url, "_self");
	else window.open(url);

}

function setWatermarkImage(id) {
	interfaceControl.browseForFileName("/", false, setWMImage, {"connectorTypeFilter":{"STATIC":1}}, id);
}

function setWMImage(fileName, id) {
	var imf = document.getElementById("wm_image"+id)
	imf.value=fileName;
	addEffect();
}


function getPublishImageEntry(bforCrop){

	if(typeof(bforCrop) == "undefined") bforCrop = false;

	var rend = document.getElementById('image_format').value.toLowerCase();

	if(build == "htmlanaglyph" && interfaceControl.isBasePath3D() ) {
		var entry = interfaceControl.getBasePath3D();
		return oPreviewEntry;
	} else if(build == "htmlanaglyph" && interfaceControl.isBasePath3DImages() ) {
		var entry =  interfaceControl.getBasePath3DImages();
		return oPreviewEntry;
	}

	var entry = interfaceControl.getThumbView().getFirstSelectedThumb();
	var basePath = interfaceControl.getBasePath();

	if((entry && entry.type == 'directory') && rend == "gif" && !bforCrop) return entry;
	if((entry && entry.type == 'directory') && rend == "gif" && bforCrop) {
				var ne = interfaceControl.getThumbView().getFirstSelectedThumb();
				if(ne && ne.type=="directory") {
					entry = entryFirstImage = interfaceControl.getThumbView().getFirstImageEntryForDir(decodeURIComponent(ne.fullsrc), interfaceControl.getBasePathType());
				}
		return entry;
	}

	if (entry && entry.type != 'file') {
		strFirstImagePath = basePath;
		entry = entryFirstImage = interfaceControl.getThumbView().getFirstImageEntryForDir(decodeURIComponent(entry.fullsrc), interfaceControl.getBasePathType());
	}

	if (entry) {
		oPreviewEntry = entry;
	}
	else entry = oPreviewEntry;

	return entry;
}

function doUpdateAfterPublishingChange() {

	updateCode();
	document.getElementById('effectsContainer').innerHTML = "";
	appendEffectNodes();
	updateEffectPreview();

	if (aktiveDiv == '6') toActive('6');

	updateEffectThumbs();
	checkRestrictions();

}

function onPublishingSourceChanged(){
	if(document.getElementById('image_format')) var rend = document.getElementById('image_format').value.toLowerCase();
	var oldPrevEntry = oPreviewEntry; //Same type selected?!
	var newPrevEntry = getPublishImageEntry();
	if (!newPrevEntry) return;
	if(newPrevEntry.type=="directory" && rend == "gif") {
		newPrevEntry = interfaceControl.getThumbView().getFirstImageEntryForDir(decodeURIComponent(newPrevEntry.fullsrc), interfaceControl.getBasePathType()); // empty dir?
		if ( (!newPrevEntry || newPrevEntry.type == "directory") && oldPrevEntry && oldPrevEntry.type=="file" ) newPrevEntry = oldPrevEntry;
	}
	if(rend && rend=="gif") {
		if(aktiveDiv==7) {
			var cr = getCropRectangle();
			updateCrop(true);
			cr = orgCoords2thumbCoords(cr);
			if (typeof(cr) != 'undefined') {
				$(objCrop).data("Jcrop").setSelect(cr);
				recalcCropDimensions();
			}
		}
	} else {
		updateCrop(true);
	}
	if (rend != "gif" && typeof(oldPrevEntry) != "undefined" && oldPrevEntry.type != newPrevEntry.type) return;
	if (rend != "gif" && (typeof(newPrevEntry) == 'undefined' || newPrevEntry.type == 'directory') ) return;
	if(document.getElementById('keepRatio').checked) changeDimensionOnRatio();
	updateCode();
	if(document.settings.enablequickzoom.checked) initPreview();
	window.setTimeout("doUpdateAfterPublishingChange()", 600); //ensure cropRect is displayed

}

function getFirstDimensions() {

	var new_w;
	var new_h;
	var forceWidthCalc = false;
	var entry = getPublishImageEntry();
	if (entry.type=="directory") {
		entry = interfaceControl.getThumbView().getFirstImageEntryForDir(decodeURIComponent(entry.fullsrc), interfaceControl.getBasePathType());
	}
	var screen_w = interfaceControl.getPublishingView().getDimension().width;
	var screen_h = interfaceControl.getPublishingView().getDimension().height;

	if (screen_h < entry.height) new_h = screen_h; else new_h = entry.height;
	if (screen_w < entry.width) new_w = screen_h; else new_w = entry.width;

	new_h -=104;
	if (new_h < 100) new_h = 100;

	if (entry.width == entry.height) { ratio = 1; }
	else {
		var ratio = entry.width / entry.height;
	}

	new_w = Math.round(new_h * ratio);

	document.settings.FSIwidth.value = parseInt(new_w);
	document.settings.FSIheight.value = parseInt(new_h - 1);
	changeDimensionOnRatio();
	updateCode();
}

function getInitialDimensions() {

	try {
			var entry = getPublishImageEntry();
			if (entry.type=="directory") {
				entry = interfaceControl.getThumbView().getFirstImageEntryForDir(decodeURIComponent(entry.fullsrc), interfaceControl.getBasePathType());
			}
			var addMenuSpace = false;
			var forceWidthCalc = false;
			var forceHeightCalc = false;
			var ratio = 1;
			var new_w;
			var new_h;

			if(document.settings.FSIwidth.value != "" ) { new_w=document.settings.FSIwidth.value; forceHeightCalc = true; }
			else if(document.settings.FSIheight.value != "") { new_h=document.settings.FSIheight.value; forceWidthCalc = true; }

			if (isNaN(new_w)) forceWidthCalc = true;

			if (entry.width > entry.height) var ratio = entry.width / entry.height;
			if (entry.height > entry.width) var ratio = entry.height / entry.width;

			if (forceWidthCalc) { //landscape
				new_w = Math.round(new_h * ratio);
			}
			else  { //portrait & square
				new_h = Math.round(new_w * ratio);
			}

	} catch(e) {}

	if (build=="imageflow") { new_w += 300; new_h -= 250; }

	return {"width":new_w, "height":new_h};
}


function changeDimensionOnRatio(changedElement) {

if (!document.settings) return;

	if(!document.settings.keepRatio.checked) {
		if (typeof(changedElement) != "undefined" && changedElement.id == 'options_height') { //height changed
			document.settings.options_width.value = "";
		} else {
			document.settings.options_height.value = "";
		}
	}

	if (document.settings.options_width.value == "" && document.settings.options_height.value == "") setInitialDimensions();

	if (!document.settings.keepRatio) return;
	if (!document.settings.keepRatio.checked) return;

	var entry = getPublishImageEntry();
	if(!entry) entry = interfaceControl.getThumbView().getFirstSelectedThumb();
	if(entry && entry.type=="directory") {
		entry = entryFirstImage = interfaceControl.getThumbView().getFirstImageEntryForDir(decodeURIComponent(entry.fullsrc), interfaceControl.getBasePathType());
	}

	//defaults
	keepAspectRatio = true;

	var sourceDimension = {
		width: entry.width,
		height: entry.height
	};

	var range = { //override
		left: 0.0,
		top: 0.0,
		width: 1.0,
		height: 1.0
	};

	var w; var h;
	if (typeof(changedElement) != "undefined" && changedElement.id == 'options_height' && changedElement.value != '') { //height changed
		var targetDimension = {
			width: -1,
			height: document.settings.options_height.value
		};
	} else if (typeof(changedElement) != "undefined" && changedElement.id == 'options_width' && changedElement.value != '') {
	 	var targetDimension = {
			width: document.settings.options_width.value,
			height: -1
		};
	} else if (document.settings.options_width.value != '') {
		var targetDimension = {
			width: document.settings.options_width.value,
			height: -1
		};
	} else if (document.settings.options_height.value != '') {
		var targetDimension = {
			width: -1,
			height: document.settings.options_height.value
		};
	}
	//go

	// correct range values
	range.left = range.left < 0 ? 0 : range.left > 1 ? 1 : range.left;
	range.top = range.top < 0 ? 0 : range.top > 1 ? 1 : range.top;
	range.width = range.width < 0 ? 1 - range.left : range.width + range.left > 1 ? 1 - range.left : range.width;
	range.height = range.height < 0 ? 1 - range.top : range.height + range.top > 1 ? 1 - range.top : range.height;

	// correct target
	targetDimension.width = targetDimension.width <= 0 || targetDimension.width === undefined ? -1 : targetDimension.width;
	targetDimension.height = targetDimension.height <= 0 || targetDimension.height === undefined ? -1 : targetDimension.height;

	// calc scale factors
	var scale = {};
	if (targetDimension.width != -1 && targetDimension.height != -1) {
		scale.x = targetDimension.width / (sourceDimension.width * range.width);
		scale.y = targetDimension.height / (sourceDimension.height * range.height);
	}
	else if (targetDimension.height == -1) {
		scale.x = targetDimension.width / (sourceDimension.width * range.width);
		scale.y = scale.x;
	}
	else {
		scale.y = targetDimension.height / (sourceDimension.height * range.height);
		scale.x = scale.y;
	}

	// calculate target.width or target.height if one is missing in request
	if (targetDimension.width == -1 || targetDimension.height == -1) {
		var scaleFactor = Math.min(scale.x, scale.y);
		if (targetDimension.width == -1) {
			targetDimension.width = Math.round(sourceDimension.width * range.width * scaleFactor);
		}
		else if (targetDimension.height == -1) {
			targetDimension.height = Math.round(sourceDimension.height * range.height * scaleFactor);
		}
		scale.x = scaleFactor;
		scale.y = scaleFactor;
	}

	// check if correcting targetWidth or targetHeight is necessary
	if (keepAspectRatio && Math.abs(scale.x - scale.y) > .0000001) { // instead of > 0
		if (scale.x > scale.y) {
			// correct targetWidth and scaleFactors[0]
			var preciseTargetWidth = targetDimension.height * sourceDimension.width * range.width / (sourceDimension.height * range.height);
			scale.x = preciseTargetWidth / sourceDimension.width;
			targetDimension.width = Math.round(preciseTargetWidth);
		}
		else {
			// correct targetHeight and scaleFactors[1]
			var preciseTargetHeight = targetDimension.width * sourceDimension.height * range.height / (sourceDimension.width * range.width);
			scale.y = preciseTargetHeight / sourceDimension.height;
			targetDimension.height = Math.round(preciseTargetHeight);
		}
	}


	// 0.0x == 1
	targetDimension.width = targetDimension.width == 0 ? 1 : targetDimension.width;
	targetDimension.height = targetDimension.height == 0 ? 1 : targetDimension.height;

	//return scale;

	document.settings.options_width.value = targetDimension.width;
	document.settings.options_height.value = targetDimension.height;

	if (typeof(changedElement) != "undefined" && changedElement.id == 'options_height' && changedElement.value != '4') {
		changedDimensionElement = 'height';
	} else {

		if (build == "html360") document.settings.options_height.value = targetDimension.height + 30; //Menu bar
		changedDimensionElement = 'width';
	}
	updateCode();
}

function enableRatio() {
	if (document.settings.FSIheight.value != "") var change = "options_height";
	if (document.settings.FSIwidth.value != "") var change = "options_width";
	if (document.settings.FSIheight.value == "" || document.settings.FSIwidth.value == "") setInitialDimensions();
	changeDimensionOnRatio(document.getElementById(change));
	updateCode();
}
