/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework;

import com.neptunelabs.fsiframework.VersionHelper;
import com.neptunelabs.fsiframework.VersionInterface;
import com.neptunelabs.fsiframework.logging.FSILogger;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SoftwareVersion {
    private static final byte[] vendorRaw = new byte[]{-44, -1, -22, -18, -17, -12, -1, -42, -5, -8, -23};
    private static String vendor;
    private static final int RELEASE_NIGHTLY = 0;
    private static final int RELEASE_ALPHA = 1;
    private static final int RELEASE_BETA = 2;
    private static final int RELEASE_GAMMA = 3;
    private static final int RELEASE_EA = 4;
    private static final int RELEASE_RC = 5;
    private static final int RELEASE_FINAL = 6;
    private static final int RELEASE_GA = 7;
    private static VersionInterface version;
    private static String software;
    private static int versionNumber;
    private static String fullVersion;
    private static final Pattern versionPattern;

    public static void setSoftware(FSILogger logger, VersionInterface vi) {
        version = vi;
        software = version.getSoftware();
        versionNumber = SoftwareVersion.versionToDecimal(SoftwareVersion.getVersionString(logger));
        StringBuilder sb = new StringBuilder();
        for (byte b : vendorRaw) {
            char c = (char)((b ^ 0x97) & 0xFF);
            sb.append(c);
        }
        vendor = sb.toString();
    }

    public static String getVendor() {
        return vendor;
    }

    public static String getSoftware(boolean full) {
        String ret = full ? software + " " + SoftwareVersion.decimalToVersion(versionNumber, false) : software;
        return ret;
    }

    public static String getVersion(boolean full) {
        return SoftwareVersion.decimalToVersion(versionNumber, full);
    }

    public static int getMajorVersion() {
        return versionNumber >> 26 & 0x3F;
    }

    public static int getMinorVersion() {
        return versionNumber >> 21 & 0x1F;
    }

    public static int getBuildNumber() {
        return versionNumber >> 6 & Short.MAX_VALUE;
    }

    public static String readPublicKey() {
        return version.readPublicKey();
    }

    public static int getSoftwareID() {
        return version.getSoftwareID();
    }

    public static int getKeyVersion() {
        return version.getKeyVersion();
    }

    public static int getMajorVersion(String versionStr) {
        int decimal = SoftwareVersion.versionToDecimal(versionStr);
        return decimal >> 26 & 0x3F;
    }

    public static int getMajorVersion(int decimal) {
        return decimal >> 26 & 0x3F;
    }

    public static int versionToDecimal(String versionString) throws NumberFormatException {
        Matcher mat1;
        int dec = -1;
        if (versionString != null && (mat1 = versionPattern.matcher(versionString)).find()) {
            Pattern pat2;
            Matcher mat2;
            int major = Integer.valueOf(mat1.group(1));
            int minor = Integer.valueOf(mat1.group(2));
            String buildadds = mat1.group(3);
            int build = 0;
            int release = 6;
            int releasenumber = 0;
            if (!buildadds.equals("") && (mat2 = (pat2 = Pattern.compile("^(\\d{0,5}+)\\s*(.*)")).matcher(buildadds)).find()) {
                Pattern pat3;
                Matcher mat3;
                try {
                    build = Integer.valueOf(mat2.group(1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                String addon = mat2.group(2);
                if (!addon.equals("") && (mat3 = (pat3 = Pattern.compile("([a-z]+)\\s*(\\d*)", 2)).matcher(addon)).find()) {
                    String releasestr = mat3.group(1).toLowerCase();
                    if (releasestr.equals("nightly")) {
                        release = 0;
                    } else if (releasestr.equals("alpha")) {
                        release = 1;
                    } else if (releasestr.equals("beta")) {
                        release = 2;
                    } else if (releasestr.equals("gamma")) {
                        release = 3;
                    } else if (releasestr.equals("ea")) {
                        release = 4;
                    } else if (releasestr.equals("rc")) {
                        release = 5;
                    } else if (releasestr.equals("final")) {
                        release = 6;
                    } else if (releasestr.equals("ga")) {
                        release = 7;
                    }
                    if (!mat3.group(2).equals("")) {
                        releasenumber = Integer.valueOf(mat3.group(2));
                    }
                }
            }
            if (major < 32 && minor < 32 && build < 32768 && release < 8 && releasenumber < 8) {
                dec = releasenumber & 7;
                dec |= (release & 7) << 3;
                dec |= (build & Short.MAX_VALUE) << 6;
                dec |= (minor & 0x1F) << 21;
                dec |= (major & 0x3F) << 26;
            }
        }
        return dec;
    }

    public static String decimalToVersion(int decimal, boolean full) {
        StringBuilder versionSB = new StringBuilder(32);
        if (decimal > 0) {
            int major = decimal >> 26 & 0x3F;
            int minor = decimal >> 21 & 0x1F;
            int build = decimal >> 6 & Short.MAX_VALUE;
            int release = decimal >> 3 & 7;
            int releasenumber = decimal & 7;
            versionSB.append(major);
            versionSB.append('.');
            versionSB.append(String.format("%02d", minor));
            if (build > 0) {
                versionSB.append('.');
                versionSB.append(build);
            }
            if (release <= 5 || full) {
                versionSB.append(' ');
                switch (release) {
                    case 0: {
                        versionSB.append("Nightly");
                        break;
                    }
                    case 1: {
                        versionSB.append("Alpha");
                        break;
                    }
                    case 2: {
                        versionSB.append("Beta");
                        break;
                    }
                    case 3: {
                        versionSB.append("Gamma");
                        break;
                    }
                    case 4: {
                        versionSB.append("EA");
                        break;
                    }
                    case 5: {
                        versionSB.append("RC");
                        break;
                    }
                    case 6: {
                        if (!full) break;
                        versionSB.append("Final");
                        break;
                    }
                    case 7: {
                        versionSB.append("GA");
                        break;
                    }
                }
                if (release != 6) {
                    versionSB.append(releasenumber);
                }
            }
            return versionSB.toString();
        }
        return "";
    }

    public static int compare(String version1, String version2) {
        int v2;
        int v1 = SoftwareVersion.versionToDecimal(version1);
        int ret = v1 < (v2 = SoftwareVersion.versionToDecimal(version2)) ? -1 : (v1 > v2 ? 1 : 0);
        return ret;
    }

    public static int compare(String versionCMP) {
        return SoftwareVersion.compare(versionCMP, SoftwareVersion.decimalToVersion(versionNumber, true));
    }

    public static Properties readBuildResource(FSILogger logger, String resource) {
        Properties buildenv = new Properties();
        VersionHelper vh = new VersionHelper();
        try (InputStream buildst = vh.getResourceAsStream(resource);){
            buildenv.load(buildst);
        }
        catch (IOException e) {
            if (logger != null) {
                logger.log(1012, resource);
            }
            System.err.println("Resource Problems with " + resource);
        }
        return buildenv;
    }

    public static int getVersionDecimal(FSILogger logger) {
        String versionstr = SoftwareVersion.getVersionString(logger);
        return SoftwareVersion.versionToDecimal(versionstr);
    }

    public static String getVersionString(FSILogger logger) {
        if (fullVersion == null) {
            Properties versionProperties = SoftwareVersion.readBuildResource(logger, version.getBuildResourceLocation());
            String buildnum = versionProperties.getProperty("build.number");
            if (buildnum == null) {
                buildnum = "";
            }
            try {
                fullVersion = version.getRawVersionString().replaceFirst("%s", "." + buildnum);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return fullVersion;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Please specify path to VersionInterface implementation");
        } else {
            try {
                VersionInterface vi = (VersionInterface)Class.forName(args[0]).getConstructor(new Class[0]).newInstance(new Object[0]);
                SoftwareVersion.setSoftware(null, vi);
                System.out.println(SoftwareVersion.getVersionString(null));
            }
            catch (ClassNotFoundException e) {
                System.err.println("VersionInterface implementation not found");
            }
            catch (IllegalAccessException e) {
                System.err.println("Illegal Access to VersionInterface implementation");
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                System.err.println("Missing contructor implementation in Version Interface");
            }
            catch (NoSuchMethodException e) {
                System.err.println("Missing method implementation in Version Interface");
            }
            catch (InvocationTargetException e) {
                System.err.println("Exception invocation getInstance");
            }
        }
    }

    static {
        fullVersion = null;
        versionPattern = Pattern.compile("(\\d{1,5}+)[.\\s]+(\\d{1,5}+)[.\\s]*(.*)");
    }
}

