/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework;

import com.neptunelabs.fsiframework.io.ByteArrayOutputStreamFast;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;

public abstract class VersionInterface {
    private final String SOFTWARE;
    private final String VERSION;
    private final int SOFTWARE_ID;
    private final int KEY_VERSION;
    private final String buildResourceLocation;
    private final String pkResourceLocation;
    private Cipher cipher;
    private String publicKey;

    public VersionInterface(String SOFTWARE, String VERSION, int SOFTWARE_ID, int KEY_VERSION, String buildResourceLocation, String pkResourceLocation) {
        this.SOFTWARE = SOFTWARE;
        this.VERSION = VERSION;
        this.SOFTWARE_ID = SOFTWARE_ID;
        this.KEY_VERSION = KEY_VERSION;
        this.buildResourceLocation = buildResourceLocation;
        this.pkResourceLocation = pkResourceLocation;
        try {
            this.cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        }
        catch (GeneralSecurityException e) {
            this.cipher = null;
        }
    }

    String readPublicKey() {
        String result = null;
        if (this.publicKey == null) {
            try (ByteArrayOutputStreamFast baosf = new ByteArrayOutputStreamFast();){
                VersionHelper vh = new VersionHelper();
                try (InputStream buildst = vh.getResourceAsStream(this.pkResourceLocation);){
                    int c;
                    while ((c = buildst.read()) != -1) {
                        baosf.write(c);
                    }
                    buildst.close();
                    result = this.publicKey = new String(baosf.toByteArray());
                }
            }
            catch (IOException iOException) {}
        } else {
            result = this.publicKey;
        }
        return result;
    }

    public Cipher getCipher() {
        return this.cipher;
    }

    String getSoftware() {
        return this.SOFTWARE;
    }

    int getSoftwareID() {
        return this.SOFTWARE_ID;
    }

    String getRawVersionString() {
        return this.VERSION;
    }

    String getBuildResourceLocation() {
        return this.buildResourceLocation;
    }

    int getKeyVersion() {
        return this.KEY_VERSION;
    }

    private static final class VersionHelper {
        public InputStream getResourceAsStream(String resource) {
            return this.getClass().getResourceAsStream(resource);
        }
    }
}

