/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.cache;

public class CacheKey {
    private final String assetURLPath;
    private final String key;
    private final String keyFuzzy;
    private final char type;

    private CacheKey(String assetURLPath, String key, String keyFuzzy, char type) {
        this.assetURLPath = assetURLPath;
        this.key = key;
        this.keyFuzzy = keyFuzzy;
        this.type = type;
    }

    public static CacheKey getInstance(String assetURLPath) {
        CacheKey ck = new CacheKey(assetURLPath, assetURLPath, assetURLPath, '*');
        return ck;
    }

    public static CacheKey getInstance(String assetURLPath, char type) {
        CacheKey ck = new CacheKey(assetURLPath, assetURLPath + ':' + type, assetURLPath + ":*", type);
        return ck;
    }

    public static CacheKey getInstance(String assetURLPath, char type, String suffix) {
        CacheKey ck = new CacheKey(assetURLPath, assetURLPath + ':' + type + (suffix != null ? ':' + suffix : ""), assetURLPath + ":*" + (suffix != null ? ':' + suffix : ""), type);
        return ck;
    }

    public char getType() {
        return this.type;
    }

    public String getAssetURLPath() {
        return this.assetURLPath;
    }

    public String get() {
        return this.key;
    }

    public String getFuzzy() {
        return this.keyFuzzy;
    }
}

