/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.cache;

import com.neptunelabs.fsiframework.cache.BlockCache;
import com.neptunelabs.fsiframework.cache.CacheKey;
import com.neptunelabs.fsiframework.cache.CacheLoad;
import com.neptunelabs.fsiframework.cache.CacheType;
import com.neptunelabs.fsiframework.cache.CacheableData;
import com.neptunelabs.fsiframework.collections.PairKeyAccent;
import com.neptunelabs.fsiframework.collections.SoftLRUMap;
import com.neptunelabs.fsiframework.logging.FSILogger;
import java.lang.ref.SoftReference;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class CacheManager
extends Thread {
    private final boolean useL1;
    private final boolean useL2;
    private final boolean cacheResponse;
    private boolean enabled;
    private final boolean packAsync;
    private final int L1_DEFAULT_SIZE = 1000;
    private final int L2_QUEUE_DEFAULT_OVERLOAD = 4000;
    protected final BlockingQueue<PairKeyAccent<String, SoftReference<CacheableData<?>>>> cacheQueue;
    protected final SoftLRUMap<String, CacheableData<?>> softMap_L1;
    protected final BlockCache blockCache_L2;
    volatile boolean running = false;
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock read = this.readWriteLock.readLock();
    private final Lock write = this.readWriteLock.writeLock();
    private final int numOfTypes;
    protected AtomicLong[] statsRequests;
    protected AtomicLong[] statsL1Hits;
    protected AtomicLong[] statsL2Hits;
    protected AtomicLong[] statsSaved;
    protected AtomicLong[] statsSaveFailed;

    public CacheManager(FSILogger logger, boolean enabled, long byteCacheSize, boolean useDirectMemory, boolean useL1, int l1Size, boolean useL2, boolean cacheResponse, boolean packAsync) {
        this.setName("CacheManager");
        this.useL1 = useL1;
        this.useL2 = useL2;
        this.cacheResponse = cacheResponse;
        this.enabled = !useL1 && !useL2 ? false : enabled;
        this.packAsync = packAsync;
        this.cacheQueue = new LinkedBlockingQueue();
        int useL1Size = l1Size < 0 ? 1000 : l1Size;
        this.softMap_L1 = new SoftLRUMap(useL1Size);
        this.blockCache_L2 = new BlockCache(logger, byteCacheSize, useDirectMemory, enabled);
        this.numOfTypes = CacheType.values().length;
        this.statsRequests = new AtomicLong[this.numOfTypes];
        this.statsL1Hits = new AtomicLong[this.numOfTypes];
        this.statsL2Hits = new AtomicLong[this.numOfTypes];
        this.statsSaved = new AtomicLong[this.numOfTypes];
        this.statsSaveFailed = new AtomicLong[this.numOfTypes];
        for (int c = 0; c < this.numOfTypes; ++c) {
            this.statsRequests[c] = new AtomicLong(0L);
            this.statsL1Hits[c] = new AtomicLong(0L);
            this.statsL2Hits[c] = new AtomicLong(0L);
            this.statsSaved[c] = new AtomicLong(0L);
            this.statsSaveFailed[c] = new AtomicLong(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.running = true;
        while (this.running) {
            try {
                PairKeyAccent<String, SoftReference<CacheableData<?>>> uncachedObjPair = this.cacheQueue.take();
                this.read.lock();
                try {
                    if (!this.useL2 || uncachedObjPair == null) continue;
                    if (this.cacheQueue.size() < 4000) {
                        String key = (String)uncachedObjPair.getItem1();
                        Object uncachedObj = ((SoftReference)uncachedObjPair.getItem2()).get();
                        if (uncachedObj == null) continue;
                        this.putL2CacheableData(key, (CacheableData)uncachedObj);
                        continue;
                    }
                    CacheableData cc = (CacheableData)((SoftReference)uncachedObjPair.getItem2()).get();
                    this.statsSaveFailed[cc.getCacheType().ordinal()].incrementAndGet();
                }
                finally {
                    this.read.unlock();
                }
            }
            catch (InterruptedException e) {
                this.running = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touchChangedFile(CacheKey cacheKey) {
        String keyPrefixFix = cacheKey.get();
        String keyPrefixFuzzy = cacheKey.getFuzzy();
        HashSet<Object> keysToDeleteL1 = new HashSet<Object>();
        for (Map.Entry<String, SoftReference<CacheableData<?>>> entry : this.softMap_L1.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(keyPrefixFix, 0) && !key.startsWith(keyPrefixFuzzy, 0)) continue;
            keysToDeleteL1.add(key);
        }
        Set<String> cacheKeysL2 = this.blockCache_L2.getKeys();
        HashSet<String> keysToDeleteL2 = new HashSet<String>();
        for (String key : cacheKeysL2) {
            if (!key.startsWith(keyPrefixFix, 0) && !key.startsWith(keyPrefixFuzzy, 0)) continue;
            keysToDeleteL2.add(key);
        }
        HashSet<PairKeyAccent> removeQueueEntries = new HashSet<PairKeyAccent>();
        for (PairKeyAccent pairKeyAccent : this.cacheQueue) {
            String key = (String)pairKeyAccent.getItem1();
            if (!key.startsWith(keyPrefixFix, 0) && !key.startsWith(keyPrefixFuzzy, 0)) continue;
            removeQueueEntries.add(pairKeyAccent);
        }
        this.write.lock();
        try {
            this.softMap_L1.removeAll(keysToDeleteL1);
            this.blockCache_L2.deleteKeys(keysToDeleteL2);
            this.cacheQueue.removeAll(removeQueueEntries);
        }
        finally {
            this.write.unlock();
        }
    }

    private CacheLoad getFromCacheL1(String key) {
        CacheLoad result;
        if (this.useL1) {
            CacheableData<?> o = this.softMap_L1.get(key);
            if (o != null) {
                result = new CacheLoad();
                result.requestedL1Object = o;
            } else {
                result = null;
            }
        } else {
            result = null;
        }
        return result;
    }

    private boolean hasL1(String key) {
        if (this.useL1) {
            return this.softMap_L1.containsKey(key);
        }
        return false;
    }

    private CacheLoad getFromCacheL2(String key, CacheType type) {
        CacheLoad result;
        if (this.useL2 && (result = this.blockCache_L2.loadObject(key)) != null && result.type == type) {
            return result;
        }
        return null;
    }

    private boolean hasL2(String key) {
        if (this.useL2) {
            return this.blockCache_L2.hasObject(key);
        }
        return false;
    }

    public boolean cacheReponses() {
        return this.cacheResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheLoad get(CacheKey cacheKey, CacheType type) {
        CacheLoad result;
        String key = cacheKey.get();
        try {
            this.read.lock();
            this.statsRequests[type.ordinal()].incrementAndGet();
            result = type == CacheType.BLOB || type == CacheType.LIST || type == CacheType.METADATA || type == CacheType.TILE || type == CacheType.RESPONSE ? this.getFromCacheL1(key) : null;
            if (result == null) {
                result = this.getFromCacheL2(key, type);
                if (result != null) {
                    this.statsL2Hits[type.ordinal()].incrementAndGet();
                }
            } else {
                this.statsL1Hits[type.ordinal()].incrementAndGet();
            }
        }
        finally {
            this.read.unlock();
        }
        return result;
    }

    public Set<Map.Entry<String, SoftReference<CacheableData<?>>>> getL1EntrySet() {
        return this.softMap_L1.entrySet();
    }

    public CacheLoad getL1Load(String key) {
        return this.getFromCacheL1(key);
    }

    public boolean hasKey(CacheKey cacheKey) {
        String key = cacheKey.get();
        return this.hasL1(key) | this.hasL2(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(CacheKey cacheKey, CacheableData<?> cd, boolean async) {
        boolean result;
        String key = cacheKey.get();
        if (this.enabled && this.running & key != null && cd != null) {
            try {
                this.read.lock();
                CacheType type = cd.getCacheType();
                if (this.useL1 && (type == CacheType.BLOB || type == CacheType.LIST || type == CacheType.METADATA || type == CacheType.TILE || type == CacheType.RESPONSE) && (type != CacheType.RESPONSE || this.cacheResponse && type == CacheType.RESPONSE)) {
                    this.softMap_L1.put(key, cd);
                }
                if (type != CacheType.RESPONSE || type == CacheType.RESPONSE && this.cacheResponse) {
                    if (async && this.packAsync) {
                        PairKeyAccent aSyncObj = new PairKeyAccent(key, new SoftReference(cd));
                        if (this.cacheQueue.contains(aSyncObj)) {
                            this.cacheQueue.remove(aSyncObj);
                        }
                        result = this.cacheQueue.offer(aSyncObj);
                    }
                    result = this.putL2CacheableData(key, cd);
                }
                result = false;
            }
            finally {
                this.read.unlock();
            }
        } else {
            result = false;
        }
        return result;
    }

    private boolean putL2CacheableData(String key, CacheableData<?> cd) {
        boolean saved;
        if (this.useL2 && this.running) {
            byte[] data;
            try {
                data = cd.pack();
            }
            catch (Exception e) {
                data = null;
            }
            if (data != null) {
                CacheLoad cacheLoad = new CacheLoad(cd.getCacheType(), data);
                saved = this.blockCache_L2.saveObject(key, cacheLoad);
            } else {
                saved = false;
            }
            if (saved) {
                this.statsSaved[cd.getCacheType().ordinal()].incrementAndGet();
            } else {
                this.statsSaveFailed[cd.getCacheType().ordinal()].incrementAndGet();
            }
        } else {
            saved = false;
        }
        return saved;
    }

    public void clearAll() {
        try {
            this.write.lock();
            this.cacheQueue.clear();
            this.softMap_L1.clear();
            this.blockCache_L2.clear();
            for (int c = 0; c < this.numOfTypes; ++c) {
                this.statsRequests[c].set(0L);
                this.statsL1Hits[c].set(0L);
                this.statsL2Hits[c].set(0L);
                this.statsSaved[c].set(0L);
                this.statsSaveFailed[c].set(0L);
            }
        }
        finally {
            this.write.unlock();
        }
    }

    public long getMaximumCacheSize() {
        return this.blockCache_L2.getMaximumCacheSize();
    }

    public long getAllocatedCacheSize() {
        return this.blockCache_L2.getAllocatedCacheSize();
    }

    public long getUsedCacheSize() {
        return this.blockCache_L2.getUsedCacheSize();
    }

    public int getObjectCountL1() {
        return this.softMap_L1.size();
    }

    public int getObjectCountL2() {
        return this.blockCache_L2.size();
    }

    public BlockCache getBlockCache() {
        return this.blockCache_L2;
    }

    public long getStatRequests(CacheType type) {
        return this.statsRequests[type.ordinal()].get();
    }

    public long getStatL1Hits(CacheType type) {
        return this.statsL1Hits[type.ordinal()].get();
    }

    public long getStatL2Hits(CacheType type) {
        return this.statsL2Hits[type.ordinal()].get();
    }

    public long getStatSaved(CacheType type) {
        return this.statsSaved[type.ordinal()].get();
    }

    public long getStatSaveFailed(CacheType type) {
        return this.statsSaveFailed[type.ordinal()].get();
    }

    public int getStatL2QueueSize() {
        return this.cacheQueue.size();
    }

    public void dispose() {
        this.running = false;
        this.clearAll();
        this.interrupt();
        this.softMap_L1.dispose();
        this.blockCache_L2.destroy();
    }
}

