/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.collections;

import com.neptunelabs.fsiframework.collections.DoubleLinkedList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class AdjustableLRUMap<K, V>
implements Map<K, V> {
    private volatile int maxSize = 5000;
    private Map<K, V> backingMap = new ConcurrentHashMap();
    private final DoubleLinkedList<K> lruList = new DoubleLinkedList();

    @Override
    public V put(K key, V value) {
        boolean keyAlreadyPresent = this.backingMap.containsKey(key);
        V result = this.backingMap.put(key, value);
        if (!keyAlreadyPresent) {
            this.lruList.addHead(key);
        }
        this.ensureMaxSize();
        return result;
    }

    @Override
    public V get(Object key) {
        V result = this.backingMap.get(key);
        if (result != null) {
            this.lruList.remove(key);
            this.lruList.addHead(key);
        }
        this.ensureMaxSize();
        return result;
    }

    private boolean ensureMaxSize() {
        int size = this.backingMap.size();
        if (size > this.maxSize) {
            K key;
            int numberOfEntriesToRemove = size - this.maxSize;
            for (int i = 0; i < numberOfEntriesToRemove && (key = this.lruList.removeTail()) != null; ++i) {
                this.backingMap.remove(key);
            }
            return true;
        }
        return false;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public boolean setMaxSize(int newMaxSize) {
        this.maxSize = newMaxSize;
        return this.ensureMaxSize();
    }

    @Override
    public void clear() {
        this.lruList.clear();
        this.backingMap = new ConcurrentHashMap();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.backingMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.backingMap.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.backingMap.entrySet();
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.backingMap.keySet();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        if (this.lruList.remove(key) != null) {
            return this.backingMap.remove(key);
        }
        return null;
    }

    @Override
    public int size() {
        return this.backingMap.size();
    }

    @Override
    public Collection<V> values() {
        return this.backingMap.values();
    }
}

