/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.collections;

public class DoubleLinkedList<E> {
    private ListNode<E> head;
    private ListNode<E> tail;
    protected long num;

    public DoubleLinkedList() {
        this.setHead(new ListNode());
        this.setTail(new ListNode());
        this.getTail().setPrev(this.head);
        this.getHead().setNext(this.tail);
        this.num = 0L;
    }

    public long size() {
        return this.num;
    }

    public boolean isEmpty() {
        return this.num == 0L;
    }

    public void addHead(E o) {
        ListNode<E> newNode = new ListNode<E>(o);
        newNode.setPrev(this.getHead());
        newNode.setNext(this.getHead().getNext());
        this.getHead().setNext(newNode);
        newNode.getNext().setPrev(newNode);
        ++this.num;
    }

    public E removeTail() {
        E o = null;
        if (!this.isEmpty()) {
            ListNode<E> p = this.getTail().getPrev();
            this.getTail().setPrev(p.getPrev());
            p.getPrev().setNext(this.getTail());
            o = p.getData();
            --this.num;
        }
        return o;
    }

    public void add(E o) {
        this.addHead(o);
    }

    public E remove(E d) {
        if (!this.isEmpty()) {
            for (ListNode<E> p = this.getHead().getNext(); p != this.getTail(); p = p.getNext()) {
                if (p.data == null || !p.data.equals(d)) continue;
                this.removeNode(p);
                return (E)p.data;
            }
        }
        return null;
    }

    private void removeNode(ListNode<E> nodeToRemove) {
        ListNode<E> next = nodeToRemove.getNext();
        ListNode<E> prev = nodeToRemove.getPrev();
        next.setPrev(prev);
        prev.setNext(next);
    }

    private ListNode<E> getHead() {
        return this.head;
    }

    private ListNode<E> getTail() {
        return this.tail;
    }

    private void setHead(ListNode<E> p) {
        this.head = p;
    }

    private void setTail(ListNode<E> p) {
        this.tail = p;
    }

    public void clear() {
        this.setHead(new ListNode());
        this.setTail(new ListNode());
        this.getTail().setPrev(this.head);
        this.getHead().setNext(this.tail);
        this.num = 0L;
    }

    private class ListNode<T> {
        protected T data = null;
        protected ListNode<T> next = null;
        protected ListNode<T> prev = null;

        public ListNode() {
            this.data = null;
        }

        public ListNode(T d) {
            this.data = d;
        }

        public void setNext(ListNode<T> n) {
            this.next = n;
        }

        public void setPrev(ListNode<T> p) {
            this.prev = p;
        }

        public ListNode<T> getNext() {
            return this.next;
        }

        public ListNode<T> getPrev() {
            return this.prev;
        }

        public T getData() {
            return this.data;
        }
    }
}

