/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.collections;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;

public class LeastRecentlyUsedCacheM<K, V extends ByteBuffer>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 249126258484906454L;
    long maxSize = 100000L;
    long currentSize = 0L;

    public LeastRecentlyUsedCacheM(long maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public V put(K key, V value) {
        ByteBuffer result = (ByteBuffer)super.put(key, value);
        if (result != null) {
            this.currentSize -= (long)result.capacity();
        }
        this.currentSize += (long)((Buffer)value).capacity();
        return (V)result;
    }

    @Override
    public V remove(Object key) {
        ByteBuffer result = (ByteBuffer)super.remove(key);
        if (result != null) {
            this.currentSize -= (long)result.capacity();
        }
        return (V)result;
    }

    @Override
    public boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.currentSize > this.maxSize;
    }
}

