/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.collections;

import com.neptunelabs.fsiframework.collections.AdjustableLRUMap;
import com.neptunelabs.fsiframework.io.MemoryManager;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;

public class MemoryMonitoredLRUMap<K, V>
extends AdjustableLRUMap<K, V> {
    private final int MINIMUM_ALLOWED_CACHE_ENTRIES = 100;
    private final MemoryManager memoryManager = MemoryManager.getInstance();

    public MemoryMonitoredLRUMap() {
        this.memoryManager.adaptThreshold();
        MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
        NotificationEmitter emitter = (NotificationEmitter)((Object)mbean);
        emitter.addNotificationListener(new LowMemoryNotificationListener(this), null, null);
    }

    public void reduceMaxSize() {
        int reduction = (int)((float)this.getMaxSize() * 0.5f);
        int newMaxSize = this.getMaxSize() - reduction;
        if (newMaxSize > 100) {
            this.setMaxSize(newMaxSize);
        }
    }

    @Override
    public V put(K key, V value) {
        V result = super.put(key, value);
        if (this.size() >= this.getMaxSize() - 25) {
            this.increaseMaxSizeIfApproriate();
        }
        return result;
    }

    private void increaseMaxSizeIfApproriate() {
        if (this.memoryManager.usesG1GC()) {
            long currentThreshold;
            long usedMem = this.memoryManager.getCommitedOldGen();
            if (usedMem < (currentThreshold = this.memoryManager.getCurrentThreshold())) {
                this.memoryManager.adaptThreshold();
                this.increaseMaxSize();
            }
        } else {
            long currentThreshold;
            long usedMem = this.memoryManager.getUsedOldGen();
            if (usedMem < (currentThreshold = this.memoryManager.getCurrentThreshold())) {
                this.increaseMaxSize();
            }
        }
    }

    private void increaseMaxSize() {
        int increase = (int)((float)this.getMaxSize() * 0.3f);
        int newMaxSize = this.getMaxSize() + increase;
        this.setMaxSize(newMaxSize);
    }

    private class LowMemoryNotificationListener
    implements NotificationListener {
        private final MemoryMonitoredLRUMap<?, ?> theMap;

        public LowMemoryNotificationListener(MemoryMonitoredLRUMap<?, ?> theMap) {
            this.theMap = theMap;
        }

        @Override
        public void handleNotification(Notification notification, Object handback) {
            if (notification.getType().equals("java.management.memory.threshold.exceeded")) {
                this.theMap.reduceMaxSize();
            }
        }
    }
}

