/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.collections;

import java.util.Comparator;
import java.util.List;
import java.util.concurrent.RecursiveAction;

public class ParallelQuickSort<T>
extends RecursiveAction {
    private static final long serialVersionUID = 1L;
    private final List<T> data;
    private final Comparator<T> comp;
    private final int left;
    private final int right;

    public ParallelQuickSort(List<T> data, Comparator<T> comp) {
        this.data = data;
        this.comp = comp;
        this.left = 0;
        this.right = data.size() - 1;
    }

    public ParallelQuickSort(List<T> data, Comparator<T> comp, int left, int right) {
        this.data = data;
        this.comp = comp;
        this.left = left;
        this.right = right;
    }

    @Override
    protected void compute() {
        if (this.left < this.right) {
            int pivotIndex = this.left + (this.right - this.left) / 2;
            pivotIndex = this.partition(pivotIndex);
            ParallelQuickSort.invokeAll(new ParallelQuickSort<T>(this.data, this.comp, this.left, pivotIndex - 1), new ParallelQuickSort<T>(this.data, this.comp, pivotIndex + 1, this.right));
        }
    }

    private int partition(int pivotIndex) {
        T pivotValue = this.data.get(pivotIndex);
        this.swap(pivotIndex, this.right);
        int storeIndex = this.left;
        for (int i = this.left; i < this.right; ++i) {
            if (this.comp.compare(this.data.get(i), pivotValue) >= 0) continue;
            this.swap(i, storeIndex);
            ++storeIndex;
        }
        this.swap(storeIndex, this.right);
        return storeIndex;
    }

    private void swap(int i, int j) {
        if (i != j) {
            T iValue = this.data.get(i);
            this.data.set(i, this.data.get(j));
            this.data.set(j, iValue);
        }
    }
}

