/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.collections;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SoftHashMap<K, V>
extends AbstractMap<K, V> {
    private final Map<K, SoftValue<V>> hash = new HashMap<K, SoftValue<V>>();
    private final ReferenceQueue<K> queue = new ReferenceQueue();

    @Override
    public V get(Object key) {
        V result = null;
        SoftReference soft_ref = this.hash.get(key);
        if (soft_ref != null && (result = (V)soft_ref.get()) == null) {
            this.hash.remove(key);
        }
        return result;
    }

    private void processQueue() {
        SoftValue sv;
        while ((sv = (SoftValue)this.queue.poll()) != null) {
            this.hash.remove(sv.key);
        }
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        SoftValue<V> oldvaluref = this.hash.put(key, new SoftValue<V>(value, key, this.queue));
        return oldvaluref != null ? (V)oldvaluref.get() : null;
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        SoftValue<V> valueref = this.hash.remove(key);
        return valueref != null ? (V)valueref.get() : null;
    }

    @Override
    public void clear() {
        this.processQueue();
        this.hash.clear();
    }

    @Override
    public int size() {
        this.processQueue();
        return this.hash.size();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    private static class SoftValue<T>
    extends SoftReference<T> {
        final Object key;

        SoftValue(T value, Object key, ReferenceQueue<T> q) {
            super(value, q);
            this.key = key;
        }
    }
}

