/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.collections;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class SoftLRUMap<K, V> {
    private final int HARD_SIZE;
    private final ConcurrentHashMap<K, SoftReference<V>> cache;
    private final List<K> hardKeyCache;
    private final ReferenceQueue<K> queue = new ReferenceQueue();

    public SoftLRUMap() {
        this(100);
    }

    public SoftLRUMap(int hardSize) {
        this.HARD_SIZE = hardSize;
        this.cache = new ConcurrentHashMap(hardSize);
        this.hardKeyCache = new CopyOnWriteArrayList<K>();
    }

    public V get(K key) {
        V result = null;
        this.purgeReferences();
        SoftReference<V> soft_ref = this.cache.get(key);
        if (soft_ref != null) {
            result = soft_ref.get();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, V value) {
        if (key != null && value != null) {
            if (this.hardKeyCache.size() > this.HARD_SIZE) {
                ConcurrentHashMap<K, SoftReference<V>> concurrentHashMap = this.cache;
                synchronized (concurrentHashMap) {
                    int deleteCount = this.HARD_SIZE / 4;
                    int hsize = this.hardKeyCache.size();
                    for (int c = 0; c < deleteCount; ++c) {
                        try {
                            K k = this.hardKeyCache.remove(hsize - c);
                            if (k == null) continue;
                            this.cache.remove(k);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            this.purgeReferences();
            SoftValue<V, K> result = new SoftValue<V, K>(value, key, this.queue);
            if (this.cache.put(key, result) == null) {
                this.hardKeyCache.add(key);
            }
        }
    }

    public synchronized Object remove(Object key) {
        Object result = null;
        SoftReference<V> sv = this.cache.remove(key);
        if (sv != null) {
            this.hardKeyCache.remove(key);
            result = sv.get();
        }
        return result;
    }

    public synchronized void removeAll(Set<K> keys) {
        for (K key : keys) {
            SoftReference<V> sv = this.cache.remove(key);
            if (sv == null) continue;
            this.hardKeyCache.remove(key);
        }
    }

    public synchronized void removeAll() {
        SoftValue sv;
        this.clear();
        while ((sv = (SoftValue)this.queue.poll()) != null) {
        }
    }

    public synchronized void clear() {
        this.hardKeyCache.clear();
        this.cache.clear();
    }

    public int size() {
        return this.cache.size();
    }

    public boolean containsKey(K key) {
        return this.hardKeyCache.contains(key);
    }

    public Set<Map.Entry<K, SoftReference<V>>> entrySet() {
        return this.cache.entrySet();
    }

    public void dispose() {
        this.clear();
    }

    private synchronized void purgeReferences() {
        SoftValue ref;
        while ((ref = (SoftValue)this.queue.poll()) != null) {
            if (ref.key == null) continue;
            this.cache.remove(ref.key);
        }
    }

    private static class SoftValue<V2, K2>
    extends SoftReference<V2> {
        final K2 key;

        SoftValue(V2 value, K2 key, ReferenceQueue<V2> q) {
            super(value, q);
            this.key = key;
        }
    }
}

