/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.collections;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class WeakLRUMap<K, V> {
    private final int HARD_SIZE;
    private final Map<K, WeakReference<V>> hash = new HashMap<K, WeakReference<V>>(100);
    private final LinkedList<K> hardCache = new LinkedList();
    private final ReferenceQueue<K> queue = new ReferenceQueue();

    public WeakLRUMap() {
        this(100);
    }

    public WeakLRUMap(int hardSize) {
        this.HARD_SIZE = hardSize;
    }

    public V get(K key) {
        V result = null;
        WeakReference<V> soft_ref = this.hash.get(key);
        if (soft_ref != null) {
            result = (V)soft_ref.get();
            if (result == null) {
                this.hash.remove(key);
            } else {
                this.hardCache.addFirst(key);
                if (this.hardCache.size() > this.HARD_SIZE) {
                    try {
                        this.hardCache.removeLast();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return result;
    }

    public void put(K key, V value) {
        if (key != null && value != null) {
            this.processQueue();
            if (this.hash.size() > this.HARD_SIZE) {
                int deleteCount = this.HARD_SIZE / 4;
                for (int c = 0; c < deleteCount; ++c) {
                    try {
                        K k = this.hardCache.removeLast();
                        if (k == null) continue;
                        this.hash.remove(k);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.hardCache.add(key);
            WeakValue<V, K> result = new WeakValue<V, K>(value, key, this.queue);
            this.hash.put(key, result);
        }
    }

    public Object remove(Object key) {
        this.processQueue();
        return this.hash.remove(key);
    }

    public void removeAll() {
        WeakValue sv;
        while ((sv = (WeakValue)this.queue.poll()) != null) {
            this.hash.remove(sv.key);
        }
        this.hash.clear();
        this.hardCache.clear();
    }

    public void clear() {
        this.hardCache.clear();
        this.processQueue();
        this.hash.clear();
    }

    public int size() {
        this.processQueue();
        return this.hash.size();
    }

    public Set<Map.Entry<K, WeakReference<V>>> entrySet() {
        return this.hash.entrySet();
    }

    public Set<K> keySet() {
        return this.hash.keySet();
    }

    private void processQueue() {
        WeakValue sv;
        while ((sv = (WeakValue)this.queue.poll()) != null) {
            this.hash.remove(sv.key);
        }
    }

    private static class WeakValue<V2, K2>
    extends WeakReference<V2> {
        final K2 key;

        WeakValue(V2 value, K2 key, ReferenceQueue<V2> q) {
            super(value, q);
            this.key = key;
        }
    }
}

