/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.comparator;

import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Comparator;
import java.util.Locale;

public abstract class FSIStringComparator
implements Comparator<String> {
    boolean ascending = true;
    boolean ignoreCase = true;
    RuleBasedCollator collator = null;

    FSIStringComparator() {
    }

    FSIStringComparator(RuleBasedCollator collator) {
        this.collator = collator;
        if (collator.getStrength() == 0) {
            collator.setStrength(1);
        }
    }

    FSIStringComparator(String language, String country, boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        if (country != null && language != null) {
            this.collator = this.makeLanguageCollator(language, country, ignoreCase);
        }
    }

    public Collator getCollator() {
        return this.collator;
    }

    public void setAscendingOrder(boolean state) {
        this.ascending = state;
    }

    private RuleBasedCollator makeLanguageCollator(String language, String country, boolean ignoreCaseValue) {
        language = language.toLowerCase();
        country = country.toUpperCase();
        this.ignoreCase = ignoreCaseValue;
        RuleBasedCollator collatorValue = null;
        try {
            if (language.equals("es")) {
                String traditionalSpanishRules = "< a,A < b,B < c,C < ch, cH, Ch, CH < d,D < e,E < f,F < g,G < h,H < i,I < j,J < k,K < l,L < ll, lL, Ll, LL < m,M < n,N < \u00f1,\u00d1 < o,O < p,P < q,Q < r,R < s,S < t,T < u,U < v,V < w,W < x,X < y,Y < z,Z";
                collatorValue = new RuleBasedCollator(traditionalSpanishRules);
                if (ignoreCaseValue) {
                    collatorValue.setStrength(1);
                } else {
                    collatorValue.setStrength(3);
                }
            } else if (language.equals("de")) {
                String addRules = country.equalsIgnoreCase("AT") ? "& a,A < a\u0308,A\u0308 & o,O < o\u0308,O\u0308 & u,U < u\u0308,U\u0308 & ss < \u00df" : "& ae , a\u0308 & AE , A\u0308 & oe , o\u0308 & OE , O\u0308 & ue , u\u0308 & UE , U\u0308";
                RuleBasedCollator baseCollator = (RuleBasedCollator)Collator.getInstance(new Locale(language, country));
                collatorValue = new RuleBasedCollator(baseCollator.getRules() + addRules);
                collatorValue.setDecomposition(1);
                if (ignoreCaseValue) {
                    collatorValue.setStrength(1);
                } else {
                    collatorValue.setStrength(3);
                }
            } else if (language.equals("test")) {
                String testRules = "< a,A < b,B < c,C < ch, cH, Ch, CH < d,D < e,E < f,F < g,G < h,H < i,I < j,J < k,K < l,L < ll, lL, Ll, LL < m,M < n,N < o,O < p,P < q,Q < r,R < s,S < t,T < u,U < v,V < w,W < x,X < y,Y < z,Z";
                String DIN5007_2_tailorings = "& ae , a\u0308 & AE , A\u0308 & oe , o\u0308 & OE , O\u0308 & ue , u\u0308 & UE , U\u0308";
                collatorValue = new RuleBasedCollator(testRules + DIN5007_2_tailorings);
                collatorValue.setStrength(1);
            } else {
                collatorValue = (RuleBasedCollator)Collator.getInstance(new Locale(language, country));
                collatorValue.setDecomposition(2);
                if (ignoreCaseValue) {
                    collatorValue.setStrength(1);
                } else {
                    collatorValue.setStrength(3);
                }
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return collatorValue;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName() + "@" + this.hashCode() + "\n");
        sb.append("Ascending: " + this.ascending + "\n");
        sb.append("IgnoreCase: " + this.ignoreCase + "\n");
        sb.append("Collator: " + this.collator + "\n");
        return sb.toString();
    }

    public int hashCode() {
        String hash = this.getClass().getName() + String.valueOf(this.ascending) + String.valueOf(this.ignoreCase) + " " + (this.collator != null ? this.collator.toString() : "");
        return hash.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        return this.hashCode() == other.hashCode();
    }
}

