/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.comparator;

import com.neptunelabs.fsiframework.comparator.FSIStringComparator;

public class LogicalStringComparator
extends FSIStringComparator {
    public LogicalStringComparator(String language, String country, boolean ignoreCase) {
        super(language, country, ignoreCase);
    }

    @Override
    public int compare(String as, String bs) {
        char[] a = as.toCharArray();
        char[] b = bs.toCharArray();
        if (a.length == 0 || b.length == 0) {
            return this.end(a.length - b.length);
        }
        return this.compareCharArrays(a, b);
    }

    private int compareCharArrays(char[] a, char[] b) {
        int aend = a.length;
        int bend = b.length;
        int result = 0;
        int ap = 0;
        int bp = 0;
        boolean lastNoDigit = true;
        do {
            int cx;
            char ca = a[ap];
            char cb = b[bp];
            while (ap + 1 < aend && Character.isSpaceChar(ca)) {
                ca = a[++ap];
            }
            while (bp + 1 < bend && Character.isSpaceChar(cb)) {
                cb = b[++bp];
            }
            if (lastNoDigit) {
                while (ap + 1 < aend && ca == '0' && a[ap + 1] == '0') {
                    ca = a[++ap];
                }
                while (bp + 1 < bend && cb == '0' && b[bp + 1] == '0') {
                    cb = b[++bp];
                }
            }
            if (Character.isDigit(ca) && Character.isDigit(cb)) {
                if (ca == '0' || cb == '0') {
                    while (ap + 1 < aend && ca == '0') {
                        ca = a[++ap];
                    }
                    while (bp + 1 < bend && cb == '0') {
                        cb = b[++bp];
                    }
                    result = this.compareRight(a, ap, aend, b, bp, bend);
                } else {
                    result = this.compareRight(a, ap, aend, b, bp, bend);
                }
                if (result != 0) {
                    return this.end(result);
                }
                if (ap == aend && bp == bend) {
                    return this.end(0);
                }
                ca = a[ap];
                cb = b[bp];
                lastNoDigit = false;
            } else {
                lastNoDigit = true;
            }
            if (this.ignoreCase) {
                ca = Character.toUpperCase(ca);
                cb = Character.toUpperCase(cb);
            }
            if ((cx = this.collator.compare(Character.toString(ca), Character.toString(cb))) < 0) {
                return this.end(-1);
            }
            if (cx > 0) {
                return this.end(1);
            }
            if (++ap >= aend && ++bp >= bend) {
                return this.end(0);
            }
            if (ap < aend) continue;
            return this.end(-1);
        } while (bp < bend);
        return this.end(1);
    }

    private int end(int val) {
        return this.ascending ? val : val * -1;
    }

    private int compareRight(char[] a, int ap, int aend, char[] b, int bp, int bend) {
        int bias = 0;
        while (ap < aend && bp < bend) {
            if (!Character.isDigit(a[ap]) && !Character.isDigit(b[bp])) {
                return bias;
            }
            if (!Character.isDigit(a[ap])) {
                return -1;
            }
            if (!Character.isDigit(b[bp])) {
                return 1;
            }
            if (a[ap] < b[bp]) {
                if (bias == 0) {
                    bias = -1;
                }
            } else if (a[ap] > b[bp] && bias == 0) {
                bias = 1;
            }
            ++ap;
            ++bp;
        }
        if (ap == aend && bp != bend) {
            bias = -1;
        } else if (ap != aend && bp == bend) {
            bias = 1;
        }
        return bias;
    }
}

