/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.comparator;

import com.neptunelabs.fsiframework.comparator.FSIStringComparator;

public class NaturalStringComparator
extends FSIStringComparator {
    public NaturalStringComparator(String language, String country, boolean ignoreCase) {
        super(language, country, ignoreCase);
    }

    @Override
    public int compare(String s, String t) {
        int sIndex = 0;
        int tIndex = 0;
        int sLength = s.length();
        int tLength = t.length();
        block0: while (sIndex != sLength || tIndex != tLength) {
            if (sIndex == sLength) {
                return this.end(-1);
            }
            if (tIndex == tLength) {
                return this.end(1);
            }
            char sChar = s.charAt(sIndex);
            char tChar = t.charAt(tIndex);
            boolean sCharIsDigit = Character.isDigit(sChar);
            boolean tCharIsDigit = Character.isDigit(tChar);
            if (sCharIsDigit && tCharIsDigit) {
                boolean tAllZero;
                int sLeadingZeroCount = 0;
                while (sChar == '0') {
                    ++sLeadingZeroCount;
                    if (++sIndex == sLength) break;
                    sChar = s.charAt(sIndex);
                }
                int tLeadingZeroCount = 0;
                while (tChar == '0') {
                    ++tLeadingZeroCount;
                    if (++tIndex == tLength) break;
                    tChar = t.charAt(tIndex);
                }
                boolean sAllZero = sIndex == sLength || !Character.isDigit(sChar);
                boolean bl = tAllZero = tIndex == tLength || !Character.isDigit(tChar);
                if (sAllZero && tAllZero) continue;
                if (sAllZero && !tAllZero) {
                    return this.end(-1);
                }
                if (tAllZero) {
                    return this.end(1);
                }
                int diff = 0;
                do {
                    if (diff == 0) {
                        diff = sChar - tChar;
                    }
                    if (++sIndex == sLength && ++tIndex == tLength) {
                        return this.end(diff != 0 ? diff : sLeadingZeroCount - tLeadingZeroCount);
                    }
                    if (sIndex == sLength) {
                        if (diff == 0) {
                            return this.end(-1);
                        }
                        return this.end(Character.isDigit(t.charAt(tIndex)) ? -1 : diff);
                    }
                    if (tIndex == tLength) {
                        if (diff == 0) {
                            return this.end(1);
                        }
                        return this.end(Character.isDigit(s.charAt(sIndex)) ? 1 : diff);
                    }
                    sChar = s.charAt(sIndex);
                    tChar = t.charAt(tIndex);
                    sCharIsDigit = Character.isDigit(sChar);
                    tCharIsDigit = Character.isDigit(tChar);
                    if (!sCharIsDigit && !tCharIsDigit) {
                        if (diff == 0) continue block0;
                        return this.end(diff);
                    }
                    if (sCharIsDigit) continue;
                    return this.end(-1);
                } while (tCharIsDigit);
                return this.end(1);
            }
            if (this.collator != null) {
                String bs;
                int aw = sIndex;
                int bw = tIndex;
                while (++sIndex < sLength && !Character.isDigit(s.charAt(sIndex))) {
                }
                while (++tIndex < tLength && !Character.isDigit(t.charAt(tIndex))) {
                }
                String as = s.substring(aw, sIndex);
                int subwordResult = this.collator.compare(as, bs = t.substring(bw, tIndex));
                if (subwordResult == 0) continue;
                return this.end(subwordResult);
            }
            do {
                if (sChar != tChar) {
                    if (!this.ignoreCase) {
                        return this.end(sChar - tChar);
                    }
                    if ((sChar = Character.toUpperCase(sChar)) != (tChar = Character.toUpperCase(tChar)) && (sChar = Character.toLowerCase(sChar)) != (tChar = Character.toLowerCase(tChar))) {
                        return this.end(sChar - tChar);
                    }
                }
                if (++sIndex == sLength && ++tIndex == tLength) {
                    return 0;
                }
                if (sIndex == sLength) {
                    return this.end(-1);
                }
                if (tIndex == tLength) {
                    return this.end(1);
                }
                sChar = s.charAt(sIndex);
                tChar = t.charAt(tIndex);
                sCharIsDigit = Character.isDigit(sChar);
                tCharIsDigit = Character.isDigit(tChar);
            } while (!sCharIsDigit && !tCharIsDigit);
        }
        return 0;
    }

    private int end(int val) {
        return this.ascending ? val : val * -1;
    }
}

