/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.concurrent;

import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class LockerReadWrite<T> {
    private final Object lockObj = new Object();
    private final Map<T, Value<T>> map = new TreeMap<T, Value<T>>();

    public Map<T, Value<T>> getMap() {
        return this.map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value<T> lockRead(T id) {
        Value<T> r;
        Object object = this.lockObj;
        synchronized (object) {
            if (!this.map.containsKey(id)) {
                Value value = new Value();
                value.id = id;
                value.count = 0L;
                ReentrantReadWriteLock rrwLock = new ReentrantReadWriteLock();
                value.readlock = rrwLock.readLock();
                value.writelock = rrwLock.writeLock();
                this.map.put(id, value);
            }
            r = this.map.get(id);
            ++r.count;
        }
        r.readlock.lock();
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value<T> lockWrite(T id) {
        Value<T> r;
        Object object = this.lockObj;
        synchronized (object) {
            if (!this.map.containsKey(id)) {
                Value value = new Value();
                value.id = id;
                value.count = 0L;
                ReentrantReadWriteLock rrwLock = new ReentrantReadWriteLock();
                value.readlock = rrwLock.readLock();
                value.writelock = rrwLock.writeLock();
                this.map.put(id, value);
            }
            r = this.map.get(id);
            ++r.count;
        }
        r.writelock.lock();
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockRead(Value<T> r) {
        r.readlock.unlock();
        Object object = this.lockObj;
        synchronized (object) {
            --r.count;
            if (r.count == 0L) {
                this.map.remove(r.id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockWrite(Value<T> r) {
        r.writelock.unlock();
        Object object = this.lockObj;
        synchronized (object) {
            --r.count;
            if (r.count == 0L) {
                this.map.remove(r.id);
            }
        }
    }

    public static class Value<T> {
        Lock readlock;
        Lock writelock;
        long count;
        T id;
    }
}

