/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.concurrent;

import com.neptunelabs.fsiframework.concurrent.PriorityTask;
import com.neptunelabs.fsiframework.concurrent.PriorityTaskComparator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class PriorityExecutor
extends ThreadPoolExecutor {
    public PriorityExecutor() {
        super(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new PriorityBlockingQueue<Runnable>(11, new PriorityTaskComparator()));
    }

    public PriorityExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, new PriorityBlockingQueue<Runnable>(11, new PriorityTaskComparator()));
    }

    public PriorityExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, new PriorityBlockingQueue<Runnable>(11, new PriorityTaskComparator()), threadFactory);
    }

    public PriorityExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> queue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, queue, threadFactory);
    }

    public PriorityExecutor(ThreadFactory threadFactory) {
        super(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new PriorityBlockingQueue<Runnable>(11, new PriorityTaskComparator()), threadFactory);
    }

    public PriorityExecutor(RejectedExecutionHandler handler) {
        super(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new PriorityBlockingQueue<Runnable>(11, new PriorityTaskComparator()), handler);
    }

    public PriorityExecutor(ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new PriorityBlockingQueue<Runnable>(11, new PriorityTaskComparator()), threadFactory, handler);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        if (callable instanceof Important) {
            return new PriorityTask<T>(((Important)((Object)callable)).getPriority(), callable);
        }
        return new PriorityTask<T>(0, callable);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        if (runnable instanceof Important) {
            return new PriorityTask<T>(((Important)((Object)runnable)).getPriority(), runnable, value);
        }
        return new PriorityTask<T>(0, runnable, value);
    }

    public static interface Important {
        public int getPriority();
    }
}

