/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.concurrent;

import com.neptunelabs.fsiframework.concurrent.PriorityExecutor;
import com.neptunelabs.fsiframework.concurrent.PriorityTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;

public class PriorityExecutorCompletionService<V>
implements CompletionService<V> {
    private final PriorityExecutor executor;
    final BlockingQueue<Future<V>> completionQueue;
    private int submitted = 0;

    private RunnableFuture<V> newTaskFor(Callable<V> task) {
        return this.executor.newTaskFor(task);
    }

    private RunnableFuture<V> newTaskFor(Runnable task, V result) {
        return this.executor.newTaskFor(task, result);
    }

    public PriorityExecutorCompletionService(PriorityExecutor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        this.executor = executor;
        this.completionQueue = new LinkedBlockingQueue<Future<V>>();
    }

    public PriorityExecutorCompletionService(PriorityExecutor executor, int size) {
        if (executor == null) {
            throw new NullPointerException();
        }
        this.executor = executor;
        this.completionQueue = new LinkedBlockingQueue<Future<V>>(size);
    }

    public PriorityExecutorCompletionService(PriorityExecutor executor, BlockingQueue<Future<V>> completionQueue) {
        if (executor == null || completionQueue == null) {
            throw new NullPointerException();
        }
        this.executor = executor;
        this.completionQueue = completionQueue;
    }

    @Override
    public Future<V> submit(Callable<V> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture<V> f = this.newTaskFor(task);
        int prio = task instanceof PriorityExecutor.Important ? ((PriorityExecutor.Important)((Object)task)).getPriority() : 0;
        this.executor.execute(new PriorityQueueingFuture(prio, f));
        ++this.submitted;
        return f;
    }

    public Future<V> submit(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture<Object> f = this.newTaskFor(task, null);
        int prio = task instanceof PriorityExecutor.Important ? ((PriorityExecutor.Important)((Object)task)).getPriority() : 0;
        this.executor.execute(new PriorityQueueingFuture(prio, f));
        ++this.submitted;
        return f;
    }

    @Override
    public Future<V> submit(Runnable task, V result) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture<V> f = this.newTaskFor(task, result);
        int prio = task instanceof PriorityExecutor.Important ? ((PriorityExecutor.Important)((Object)task)).getPriority() : 0;
        this.executor.execute(new PriorityQueueingFuture(prio, f));
        ++this.submitted;
        return f;
    }

    public int count() {
        return this.submitted;
    }

    @Override
    public Future<V> take() throws InterruptedException {
        return this.completionQueue.take();
    }

    @Override
    public Future<V> poll() {
        return (Future)this.completionQueue.poll();
    }

    @Override
    public Future<V> poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.completionQueue.poll(timeout, unit);
    }

    private class PriorityQueueingFuture
    extends PriorityTask<Void> {
        private final Future<V> task;

        PriorityQueueingFuture(int priority, RunnableFuture<V> task) {
            super(priority, task, null);
            this.task = task;
        }

        @Override
        protected void done() {
            PriorityExecutorCompletionService.this.completionQueue.add(this.task);
        }
    }
}

