/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.concurrent;

import java.util.HashMap;
import java.util.Map;

public class ReadWriteLock {
    private final Map<Thread, Integer> readingThreads = new HashMap<Thread, Integer>();
    private int writeAccesses = 0;
    private int writeRequests = 0;
    private Thread writingThread = null;

    public synchronized void lockRead() throws InterruptedException {
        Thread callingThread = Thread.currentThread();
        while (!this.canGrantReadAccess(callingThread)) {
            this.wait();
        }
        this.readingThreads.put(callingThread, this.getReadAccessCount(callingThread) + 1);
    }

    private boolean canGrantReadAccess(Thread callingThread) {
        if (this.isWriter(callingThread)) {
            return true;
        }
        if (this.hasWriter()) {
            return false;
        }
        if (this.isReader(callingThread)) {
            return true;
        }
        return !this.hasWriteRequests();
    }

    public synchronized void unlockRead() {
        Thread callingThread = Thread.currentThread();
        if (!this.isReader(callingThread)) {
            throw new IllegalMonitorStateException("Calling Thread does not hold a read lock on this ReadWriteLock");
        }
        int accessCount = this.getReadAccessCount(callingThread);
        if (accessCount == 1) {
            this.readingThreads.remove(callingThread);
        } else {
            this.readingThreads.put(callingThread, accessCount - 1);
        }
        this.notifyAll();
    }

    public synchronized void lockWrite() throws InterruptedException {
        ++this.writeRequests;
        Thread callingThread = Thread.currentThread();
        while (!this.canGrantWriteAccess(callingThread)) {
            this.wait();
        }
        --this.writeRequests;
        ++this.writeAccesses;
        this.writingThread = callingThread;
    }

    public synchronized void unlockWrite() {
        if (!this.isWriter(Thread.currentThread())) {
            throw new IllegalMonitorStateException("Calling Thread does not hold the write lock on this ReadWriteLock");
        }
        --this.writeAccesses;
        if (this.writeAccesses == 0) {
            this.writingThread = null;
        }
        this.notifyAll();
    }

    private boolean canGrantWriteAccess(Thread callingThread) {
        if (this.isOnlyReader(callingThread)) {
            return true;
        }
        if (this.hasReaders()) {
            return false;
        }
        if (this.writingThread == null) {
            return true;
        }
        return this.isWriter(callingThread);
    }

    private int getReadAccessCount(Thread callingThread) {
        Integer accessCount = this.readingThreads.get(callingThread);
        if (accessCount == null) {
            return 0;
        }
        return accessCount;
    }

    private boolean hasReaders() {
        return this.readingThreads.size() > 0;
    }

    private boolean isReader(Thread callingThread) {
        return this.readingThreads.get(callingThread) != null;
    }

    private boolean isOnlyReader(Thread callingThread) {
        return this.readingThreads.size() == 1 && this.readingThreads.get(callingThread) != null;
    }

    private boolean hasWriter() {
        return this.writingThread != null;
    }

    private boolean isWriter(Thread callingThread) {
        return this.writingThread == callingThread;
    }

    private boolean hasWriteRequests() {
        return this.writeRequests > 0;
    }
}

