/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.debug;

import com.neptunelabs.fsiframework.helpers.HexDumpEncoder;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import javax.imageio.metadata.IIOMetadata;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;

public class Debug {
    public static final void printStackTrace() {
        Debug.printStackTrace("unnamed");
    }

    public static final void printStackTrace(String comment) {
        StackTraceElement[] trace;
        System.err.println("************ " + comment + " ************");
        for (StackTraceElement traceElement : trace = Thread.currentThread().getStackTrace()) {
            if (traceElement.getClassName().equals(Debug.class.getCanonicalName()) || traceElement.getClassName().startsWith("java.lang.Thread")) continue;
            System.err.println("\tat " + traceElement);
        }
        System.err.println("************ /" + comment + " ************");
    }

    public static final void echo(Object obj) {
        StackTraceElement[] trace;
        for (StackTraceElement traceElement : trace = Thread.currentThread().getStackTrace()) {
            if (traceElement.getClassName().equals(Debug.class.getCanonicalName()) || traceElement.getClassName().startsWith("java.lang.Thread")) continue;
            System.err.println("(" + traceElement.getFileName() + ":" + traceElement.getLineNumber() + "):" + traceElement.getMethodName() + ":" + obj);
            break;
        }
    }

    public static final void dumpIIOMetadata(IIOMetadata imageMeta) {
        if (imageMeta != null) {
            Node standardMeta = imageMeta.getAsTree("javax_imageio_1.0");
            System.err.println(Debug.printDocument(standardMeta));
        }
    }

    public static String printDocument(Node doc) {
        OutputStream output = new OutputStream(){
            private final StringBuilder string = new StringBuilder();

            @Override
            public void write(int b) throws IOException {
                this.string.append((char)b);
            }

            public String toString() {
                return this.string.toString();
            }
        };
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(new DOMSource(doc), new StreamResult(new OutputStreamWriter(output, "UTF-8")));
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try {
            output.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return output.toString();
    }

    public static final void printHexDump(ByteBuffer data) {
        HexDumpEncoder hde = new HexDumpEncoder();
        int pos = data.position();
        data.position(0);
        System.err.println(hde.encode(data));
        data.position(pos);
    }

    public static final void printHexDump(byte[] data) {
        HexDumpEncoder hde = new HexDumpEncoder();
        System.err.println(hde.encode(data));
    }
}

