/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.helpers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CacheTimeReader {
    private CacheTimeReader() {
    }

    public static String prettyPrintTime(long time) {
        String result = "";
        result = time % 1000L != 0L ? String.valueOf(time) : ((time /= 1000L) % 60L != 0L ? (time == 1L ? "1 Second" : time + " Seconds") : ((time /= 60L) % 60L != 0L ? (time == 1L ? "1 Minute" : time + " Minutes") : ((time /= 60L) % 24L != 0L ? (time == 1L ? "1 Hour" : time + " Hours") : ((time /= 24L) == 1L ? "1 Day" : time + " Days"))));
        return result;
    }

    public static long readFutureTime(String inval) {
        Pattern pat_time;
        Matcher mat_time;
        long ret = -1L;
        if (inval != null && (mat_time = (pat_time = Pattern.compile("(\\d+)\\s*(\\w+)", 2)).matcher(inval)).find()) {
            String durationstr = mat_time.group(1);
            try {
                long duration = Long.valueOf(durationstr);
                long newtime = 0L;
                String unit = mat_time.group(2).toLowerCase();
                if (unit.endsWith("s")) {
                    unit = unit.substring(0, unit.length() - 1);
                }
                if (unit.equals("second") || unit.equals("sec") || unit.equals("s")) {
                    newtime = duration;
                } else if (unit.equals("minute") || unit.equals("min") || unit.equals("m")) {
                    newtime = duration * 60L;
                } else if (unit.equals("hour") || unit.equals("h")) {
                    newtime = duration * 3600L;
                } else if (unit.equals("day") || unit.equals("d")) {
                    newtime = duration * 86400L;
                } else if (unit.equals("week")) {
                    newtime = duration * 604800L;
                } else if (unit.equals("month")) {
                    newtime = duration * 2592000L;
                } else if (unit.equals("year")) {
                    newtime = duration * 31536000L;
                }
                if (newtime != 0L) {
                    ret = newtime * 1000L;
                }
            }
            catch (NumberFormatException e) {
                ret = -1L;
            }
        }
        return ret;
    }

    public static long readHumanSize(String path, String inval) {
        long ret = -1L;
        if (path != null && inval != null) {
            Pattern pat_puresize = Pattern.compile("^\\s*(\\d+)\\s*$", 2);
            Matcher mat_puresize = pat_puresize.matcher(inval);
            if (mat_puresize.find()) {
                try {
                    ret = Long.valueOf(mat_puresize.group(1));
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                Pattern pat_unitsize = Pattern.compile("(\\d+)\\s*([kmgtp])b*", 2);
                Matcher mat_unitsize = pat_unitsize.matcher(inval);
                if (mat_unitsize.find()) {
                    String valuestr = mat_unitsize.group(1);
                    try {
                        long value = Long.valueOf(valuestr);
                        String unit = mat_unitsize.group(2).toLowerCase();
                        if (unit.equals("k")) {
                            ret = value * 1024L;
                        } else if (unit.equals("m")) {
                            ret = value * 0x100000L;
                        } else if (unit.equals("g")) {
                            ret = value * 0x40000000L;
                        } else if (unit.equals("t")) {
                            ret = value * 0x10000000000L;
                        } else if (unit.equals("p")) {
                            ret = value * 0x4000000000000L;
                        }
                    }
                    catch (NumberFormatException e) {
                        ret = -1L;
                    }
                }
            }
        }
        return ret;
    }
}

