/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.helpers;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ColorParser {
    private static final Pattern RGBWeb = Pattern.compile("^(0x|#)?([0-9a-f]{6})$", 2);
    private static final Pattern RGBWebSimple = Pattern.compile("^(0x|#)?([0-9a-f]{3})$", 2);
    private static final Pattern ARGBWeb = Pattern.compile("^(0x|#)?([0-9a-f]{8})$", 2);
    private static final Pattern ARGBWebSimple = Pattern.compile("^(0x|#)?([0-9a-f]{4})$", 2);
    private static final Map<String, String> namedColors = new HashMap<String, String>(){
        private static final long serialVersionUID = 9030528906009745507L;
        {
            this.put("aliceblue", "#f0f8ff");
            this.put("antiquewhite", "#faebd7");
            this.put("aquamarine", "#7fffd4");
            this.put("azure", "#f0ffff");
            this.put("beige", "#f5f5dc");
            this.put("blueviolet", "#8a2be2");
            this.put("brown", "#a52a2a");
            this.put("burlywood", "#deb887");
            this.put("cadetblue", "#5f9ea0");
            this.put("chartreuse", "#7fff00");
            this.put("chocolate", "#d2691e");
            this.put("coral", "#ff7f50");
            this.put("cornflowerblue", "#6495ed");
            this.put("cornsilk", "#fff8dc");
            this.put("crimson", "#dc143c");
            this.put("darkblue", "#00008b");
            this.put("darkcyan", "#008b8b");
            this.put("darkgoldenrod", "#b8860b");
            this.put("darkgray", "#a9a9a9");
            this.put("darkgreen", "#006400");
            this.put("darkkhaki", "#bdb76b");
            this.put("darkmagenta", "#8b008b");
            this.put("darkolivegreen", "#556b2f");
            this.put("darkorange", "#ff8c00");
            this.put("darkorchid", "#9932cc");
            this.put("darkred", "#8b0000");
            this.put("darksalmon", "#e9967a");
            this.put("darkseagreen", "#8fbc8f");
            this.put("darkslateblue", "#483d8b");
            this.put("darkslategray", "#2f4f4f");
            this.put("darkturquoise", "#00ced1");
            this.put("darkviolet", "#9400d3");
            this.put("deeppink", "#ff1493");
            this.put("deepskyblue", "#00bfff");
            this.put("dimgray", "#696969");
            this.put("dodgerblue", "#1e90ff");
            this.put("firebrick", "#b22222");
            this.put("floralwhite", "#fffaf0");
            this.put("forestgreen", "#228b22");
            this.put("gainsboro", "#dcdcdc");
            this.put("ghostwhite", "#f8f8ff");
            this.put("gold", "#ffd700");
            this.put("goldenrod", "#daa520");
            this.put("greenyellow", "#adff2f");
            this.put("honeydew", "#f0fff0");
            this.put("hotpink", "#ff69b4");
            this.put("indianred", "#cd5c5c");
            this.put("indigo", "#4b0082");
            this.put("ivory", "#fffff0");
            this.put("khaki", "#f0e68c");
            this.put("lavender", "#e6e6fa");
            this.put("lavenderblush", "#fff0f5");
            this.put("lawngreen", "#7cfc00");
            this.put("lemonchiffon", "#fffacd");
            this.put("lightblue", "#add8e6");
            this.put("lightcoral", "#f08080");
            this.put("lightcyan", "#e0ffff");
            this.put("lightgoldenrodyellow", "#fafad2");
            this.put("lightgreen", "#90ee90");
            this.put("lightgrey", "#d3d3d3");
            this.put("lightpink", "#ffb6c1");
            this.put("lightsalmon", "#ffa07a");
            this.put("lightseagreen", "#20b2aa");
            this.put("lightskyblue", "#87cefa");
            this.put("lightslategray", "#778899");
            this.put("lightsteelblue", "#b0c4de");
            this.put("limegreen", "#32cd32");
            this.put("linen", "#faf0e6");
            this.put("mediumaquamarine", "#66cdaa");
            this.put("mediumblue", "#0000cd");
            this.put("mediumorchid", "#ba55d3");
            this.put("mediumpurple", "#9370db");
            this.put("mediumseagreen", "#3cb371");
            this.put("mediumslateblue", "#7b68ee");
            this.put("mediumspringgreen", "#00fa9a");
            this.put("mediumturquoise", "#48d1cc");
            this.put("mediumvioletred", "#c71585");
            this.put("midnightblue", "#191970");
            this.put("mintcream", "#f5fffa");
            this.put("mistyrose", "#ffe4e1");
            this.put("moccasin", "#ffe4b5");
            this.put("navajowhite", "#ffdead");
            this.put("oldlace", "#fdf5e6");
            this.put("olivedrab", "#6b8e23");
            this.put("orange", "#ffa500");
            this.put("orangered", "#ff4500");
            this.put("orchid", "#da70d6");
            this.put("palegoldenrod", "#eee8aa");
            this.put("palegreen", "#98fb98");
            this.put("paleturquoise", "#afeeee");
            this.put("palevioletred", "#db7093");
            this.put("papayawhip", "#ffefd5");
            this.put("peachpuff", "#ffdab9");
            this.put("peru", "#cd853f");
            this.put("pink", "#ffc0cb");
            this.put("plum", "#dda0dd");
            this.put("powderblue", "#b0e0e6");
            this.put("rosybrown", "#bc8f8f");
            this.put("royalblue", "#4169e1");
            this.put("saddlebrown", "#8b4513");
            this.put("salmon", "#fa8072");
            this.put("sandybrown", "#f4a460");
            this.put("seagreen", "#2e8b57");
            this.put("seashell", "#fff5ee");
            this.put("sienna", "#a0522d");
            this.put("skyblue", "#87ceeb");
            this.put("slateblue", "#6a5acd");
            this.put("slategray", "#708090");
            this.put("snow", "#fffafa");
            this.put("springgreen", "#00ff7f");
            this.put("steelblue", "#4682b4");
            this.put("tan", "#d2b48c");
            this.put("thistle", "#d8bfd8");
            this.put("tomato", "#ff6347");
            this.put("turquoise", "#40e0d0");
            this.put("violet", "#ee82ee");
            this.put("wheat", "#f5deb3");
            this.put("whitesmoke", "#f5f5f5");
            this.put("yellowgreen", "#9acd32");
        }
    };

    private static int parseWebNotation(String colorStr) throws NumberFormatException {
        int result = 0;
        Matcher m1 = ARGBWeb.matcher(colorStr = colorStr.trim());
        if (m1.matches()) {
            long l = Long.parseLong(m1.group(2), 16);
            result = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        } else {
            Matcher m2 = RGBWeb.matcher(colorStr);
            if (m2.matches()) {
                result = Integer.parseInt(m2.group(2), 16);
            } else {
                Matcher m3 = RGBWebSimple.matcher(colorStr);
                if (m3.matches()) {
                    String cs = m3.group(2);
                    String r = cs.substring(0, 1) + cs.substring(0, 1);
                    String g = cs.substring(1, 2) + cs.substring(1, 2);
                    String b = cs.substring(2, 3) + cs.substring(2, 3);
                    result += Integer.parseInt(r, 16) << 16;
                    result += Integer.parseInt(g, 16) << 8;
                    result += Integer.parseInt(b, 16);
                } else {
                    Matcher m4 = ARGBWebSimple.matcher(colorStr);
                    if (m4.matches()) {
                        String cs = m4.group(2);
                        String a = cs.substring(0, 1) + cs.substring(0, 1);
                        String r = cs.substring(1, 2) + cs.substring(1, 2);
                        String g = cs.substring(2, 3) + cs.substring(2, 3);
                        String b = cs.substring(3, 4) + cs.substring(3, 4);
                        result += Integer.parseInt(a, 16) << 24;
                        result += Integer.parseInt(r, 16) << 16;
                        result += Integer.parseInt(g, 16) << 8;
                        result += Integer.parseInt(b, 16);
                    } else {
                        throw new NumberFormatException("Invalid color string " + colorStr);
                    }
                }
            }
        }
        return result;
    }

    public static int parseColorWithDefault(String colorString, int defaultColor) {
        try {
            return ColorParser.parseColor(colorString);
        }
        catch (NumberFormatException e) {
            return defaultColor;
        }
    }

    public static int parseColor(String colorString) throws NumberFormatException {
        colorString = colorString.toLowerCase();
        int color = -1;
        if (namedColors.containsKey(colorString)) {
            colorString = namedColors.get(colorString);
        }
        color = ColorParser.parseWebNotation(colorString);
        return color;
    }

    public static boolean hasAlpha(String colorString) throws NumberFormatException {
        boolean result = false;
        if (namedColors.containsKey(colorString = colorString.toLowerCase())) {
            result = false;
        } else {
            Matcher m1 = ARGBWeb.matcher(colorString);
            if (m1.matches()) {
                result = true;
            } else {
                Matcher m4 = ARGBWebSimple.matcher(colorString);
                if (m4.matches()) {
                    result = true;
                }
            }
        }
        return result;
    }
}

