/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.helpers;

import com.neptunelabs.fsiframework.io.StringWriterFast;
import java.io.IOException;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DOMTreeDump {
    private StringWriterFast sw;

    public String dump(Node doc) {
        this.sw = new StringWriterFast();
        this.dumpLoop(doc, "");
        try {
            this.sw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.sw.toString();
    }

    private void dumpLoop(Node node, String indent) {
        switch (node.getNodeType()) {
            case 2: {
                this.dumpAttributeNode((Attr)node, indent);
                break;
            }
            case 4: {
                this.dumpCDATASectionNode((CDATASection)node, indent);
                break;
            }
            case 8: {
                this.dumpCommentNode((Comment)node, indent);
                break;
            }
            case 9: {
                this.dumpDocument(indent);
                break;
            }
            case 11: {
                this.dumpDocumentFragment(indent);
                break;
            }
            case 10: {
                this.dumpDocumentType((DocumentType)node, indent);
                break;
            }
            case 1: {
                this.dumpElement((Element)node, indent);
                break;
            }
            case 6: {
                this.dumpEntityNode((Entity)node, indent);
                break;
            }
            case 5: {
                this.dumpEntityReferenceNode((EntityReference)node, indent);
                break;
            }
            case 12: {
                this.dumpNotationNode((Notation)node, indent);
                break;
            }
            case 7: {
                this.dumpProcessingInstructionNode((ProcessingInstruction)node, indent);
                break;
            }
            case 3: {
                this.dumpTextNode((Text)node, indent);
                break;
            }
            default: {
                this.sw.append(indent + "Unknown node");
                this.sw.append('\n');
            }
        }
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            this.dumpLoop(list.item(i), indent + "   ");
        }
    }

    private void dumpAttributeNode(Attr node, String indent) {
        this.sw.append(indent + "ATTRIBUTE " + node.getName() + "=\"" + node.getValue() + "\"");
        this.sw.append('\n');
    }

    private void dumpCDATASectionNode(CDATASection node, String indent) {
        this.sw.append(indent + "CDATA SECTION length=" + node.getLength());
        this.sw.append('\n');
        this.sw.append(indent + "\"" + node.getData() + "\"");
        this.sw.append('\n');
    }

    private void dumpCommentNode(Comment node, String indent) {
        this.sw.append(indent + "COMMENT length=" + node.getLength());
        this.sw.append('\n');
        this.sw.append(indent + "  " + node.getData());
        this.sw.append('\n');
    }

    private void dumpDocument(String indent) {
        this.sw.append(indent + "DOCUMENT");
        this.sw.append('\n');
    }

    private void dumpDocumentFragment(String indent) {
        this.sw.append(indent + "DOCUMENT FRAGMENT");
        this.sw.append('\n');
    }

    private void dumpDocumentType(DocumentType node, String indent) {
        NamedNodeMap notations;
        NamedNodeMap entities;
        this.sw.append(indent + "DOCUMENT_TYPE: " + node.getName());
        this.sw.append('\n');
        if (node.getPublicId() != null) {
            this.sw.append(indent + " Public ID: " + node.getPublicId());
            this.sw.append('\n');
        }
        if (node.getSystemId() != null) {
            this.sw.append(indent + " System ID: " + node.getSystemId());
            this.sw.append('\n');
        }
        if ((entities = node.getEntities()).getLength() > 0) {
            for (int i = 0; i < entities.getLength(); ++i) {
                this.dumpLoop(entities.item(i), indent + "  ");
            }
        }
        if ((notations = node.getNotations()).getLength() > 0) {
            for (int i = 0; i < notations.getLength(); ++i) {
                this.dumpLoop(notations.item(i), indent + "  ");
            }
        }
    }

    private void dumpElement(Element node, String indent) {
        this.sw.append(indent + "ELEMENT: " + node.getTagName());
        this.sw.append('\n');
        NamedNodeMap nm = node.getAttributes();
        for (int i = 0; i < nm.getLength(); ++i) {
            this.dumpLoop(nm.item(i), indent + "  ");
        }
    }

    private void dumpEntityNode(Entity node, String indent) {
        this.sw.append(indent + "ENTITY: " + node.getNodeName());
        this.sw.append('\n');
    }

    private void dumpEntityReferenceNode(EntityReference node, String indent) {
        this.sw.append(indent + "ENTITY REFERENCE: " + node.getNodeName());
        this.sw.append('\n');
    }

    private void dumpNotationNode(Notation node, String indent) {
        this.sw.append(indent + "NOTATION");
        this.sw.append('\n');
        this.sw.append(indent + "  " + node.getNodeName() + "=");
        if (node.getPublicId() != null) {
            this.sw.append(node.getPublicId());
            this.sw.append('\n');
        } else {
            this.sw.append(node.getSystemId());
            this.sw.append('\n');
        }
    }

    private void dumpProcessingInstructionNode(ProcessingInstruction node, String indent) {
        this.sw.append(indent + "PI: target=" + node.getTarget());
        this.sw.append('\n');
        this.sw.append(indent + "  " + node.getData());
        this.sw.append('\n');
    }

    private void dumpTextNode(Text node, String indent) {
        this.sw.append(indent + "TEXT length=" + node.getLength());
        this.sw.append('\n');
        this.sw.append(indent + "  " + node.getData());
        this.sw.append('\n');
    }
}

