/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.helpers;

import com.neptunelabs.fsiframework.helpers.URLEncoderFast;
import java.text.StringCharacterIterator;

public final class Escaper {
    private Escaper() {
    }

    public static final String unescapeFromXML(String aText) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator i = new StringCharacterIterator(aText);
        char c = i.current();
        StringBuilder buffer = new StringBuilder(6);
        while (c != '\uffff') {
            if (c == '&') {
                if (buffer.length() != 0) {
                    return result.toString();
                }
                buffer.append(c);
            } else if (c == ';') {
                if (buffer.length() == 0) {
                    result.append(c);
                } else {
                    buffer.append(c);
                    String entity = buffer.toString();
                    buffer = new StringBuilder(6);
                    if (entity.equalsIgnoreCase("&amp;")) {
                        result.append("&");
                    } else if (entity.equalsIgnoreCase("&lt;")) {
                        result.append("<");
                    } else if (entity.equalsIgnoreCase("&gt;")) {
                        result.append(">");
                    } else if (entity.equalsIgnoreCase("&quot;")) {
                        result.append("\"");
                    } else if (entity.equalsIgnoreCase("&apos;")) {
                        result.append("'");
                    }
                }
            } else if (buffer.length() > 0) {
                buffer.append(c);
            } else {
                result.append(c);
            }
            c = i.next();
        }
        return result.toString();
    }

    public static final String escapeForXML(String aText) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator i = new StringCharacterIterator(aText);
        char c = i.current();
        while (c != '\uffff') {
            if (c == '<') {
                result.append("&lt;");
            } else if (c == '>') {
                result.append("&gt;");
            } else if (c == '\"') {
                result.append("&quot;");
            } else if (c == '\'') {
                result.append("&apos;");
            } else if (c == '&') {
                result.append("&amp;");
            } else {
                result.append(c);
            }
            c = i.next();
        }
        return result.toString();
    }

    public static final String escapeForXMLURI(String aText) {
        URLEncoderFast encoder = new URLEncoderFast("", false);
        return encoder.escape(Escaper.escapeForXML(aText));
    }

    public static final String escapeForURIXML(String aText) {
        URLEncoderFast encoder = new URLEncoderFast("", false);
        return Escaper.escapeForXML(encoder.escape(aText));
    }

    public static final String escapeForJSON(String jsonSnippet) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator i = new StringCharacterIterator(jsonSnippet);
        char c = i.current();
        while (c != '\uffff') {
            if (c == '\\') {
                result.append("\\\\");
            } else if (c == '\"') {
                result.append("\\\"");
            } else if (c != '\u0000') {
                if (c == '\u0007') {
                    result.append("\\");
                    result.append('\u0007');
                } else if (c == '\b') {
                    result.append("\\b");
                } else if (c == '\f') {
                    result.append("\\f");
                } else if (c == '\n') {
                    result.append("\\n");
                } else if (c == '\r') {
                    result.append("\\r");
                } else if (c == '\t') {
                    result.append("\\t");
                } else if (c == '\u000b') {
                    result.append("\\");
                    result.append('\u000b');
                } else {
                    result.append(c);
                }
            }
            c = i.next();
        }
        return result.toString();
    }

    public static enum EscaperType {
        NONE,
        XML,
        XMLURI,
        URIXML,
        JSON;

    }
}

