/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.helpers;

import com.neptunelabs.fsiframework.concurrent.PriorityExecutor;
import com.neptunelabs.fsiframework.concurrent.PriorityTaskComparator;
import com.neptunelabs.fsiframework.concurrent.PriorityThreadFactory;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;

public final class ExecutorPool
extends Thread {
    private int maxCPU;
    private int maxIO;
    private int maxThreadsPerCPUJob;
    private PriorityExecutor rendererCPUExecutor;
    private PriorityBlockingQueue<Runnable> rendererCPUQueue;
    private PriorityExecutor rendererIOExecutor;
    private PriorityBlockingQueue<Runnable> rendererIOQueue;
    private PriorityExecutor converterCPUExecutor;
    private PriorityBlockingQueue<Runnable> converterCPUQueue;
    private PriorityExecutor converterIOExecutor;
    private PriorityBlockingQueue<Runnable> converterIOQueue;

    public ExecutorPool(int cpuExecutorThreads, int ioExecutorThreads, int maxThreadsPerJob) {
        this.init(cpuExecutorThreads, ioExecutorThreads, maxThreadsPerJob);
    }

    public void reinitialize(int cpuExecutorThreads, int ioExecutorThreads, int maxThreadsPerJob) {
        this.shutdown();
        this.init(cpuExecutorThreads, ioExecutorThreads, maxThreadsPerJob);
    }

    private void init(int maxCPUV, int maxIOV, int maxTPCJ) {
        this.maxCPU = maxCPUV;
        this.maxIO = maxIOV;
        this.maxThreadsPerCPUJob = maxTPCJ;
        PriorityThreadFactory ptfRender = new PriorityThreadFactory("Renderer-CPU", false, 5);
        this.rendererCPUQueue = new PriorityBlockingQueue<Runnable>(11, new PriorityTaskComparator());
        this.rendererCPUExecutor = new PriorityExecutor(this.maxCPU, this.maxCPU, 60L, TimeUnit.SECONDS, this.rendererCPUQueue, ptfRender);
        PriorityThreadFactory ptfRenderIO = new PriorityThreadFactory("Renderer-IO", false, 5);
        this.rendererIOQueue = new PriorityBlockingQueue<Runnable>(11, new PriorityTaskComparator());
        this.rendererIOExecutor = new PriorityExecutor(this.maxIO, this.maxIO, 60L, TimeUnit.SECONDS, this.rendererIOQueue, ptfRenderIO);
        PriorityThreadFactory ptfCPU = new PriorityThreadFactory("Converter-CPU", false, 1);
        this.converterCPUQueue = new PriorityBlockingQueue<Runnable>(11, new PriorityTaskComparator());
        this.converterCPUExecutor = new PriorityExecutor(this.maxCPU, this.maxCPU, 60L, TimeUnit.SECONDS, this.converterCPUQueue, ptfCPU);
        PriorityThreadFactory ptfIO = new PriorityThreadFactory("Converter-IO", false, 1);
        this.converterIOQueue = new PriorityBlockingQueue<Runnable>(11, new PriorityTaskComparator());
        this.converterIOExecutor = new PriorityExecutor(this.maxIO, this.maxIO, 2L, TimeUnit.HOURS, this.converterIOQueue, ptfIO);
    }

    public PriorityExecutor getExecutorService(Type type) {
        if (type == Type.RENDERER_CPU) {
            return this.rendererCPUExecutor;
        }
        if (type == Type.RENDERER_IO) {
            return this.rendererIOExecutor;
        }
        if (type == Type.CONVERTER_CPU) {
            return this.converterCPUExecutor;
        }
        return this.converterIOExecutor;
    }

    public int getMaxThreads(Type type) {
        if (type == Type.RENDERER_CPU) {
            return this.maxCPU;
        }
        if (type == Type.RENDERER_IO) {
            return this.maxIO;
        }
        if (type == Type.CONVERTER_CPU) {
            return this.maxCPU;
        }
        return this.maxIO;
    }

    public int getQueueSize(Type type) {
        if (type == Type.RENDERER_CPU) {
            return this.rendererCPUQueue.size();
        }
        if (type == Type.RENDERER_IO) {
            return this.rendererIOQueue.size();
        }
        if (type == Type.CONVERTER_CPU) {
            return this.converterCPUQueue.size();
        }
        return this.converterIOQueue.size();
    }

    public int getMaxThreadsPerCPUJob() {
        return this.maxThreadsPerCPUJob;
    }

    public int getAvailableThreads(Type type) {
        if (type == Type.RENDERER_CPU) {
            return Math.max(1, Math.min(this.maxThreadsPerCPUJob, this.maxCPU) - this.rendererCPUExecutor.getActiveCount());
        }
        if (type == Type.RENDERER_IO) {
            return Math.max(1, Math.min(this.maxThreadsPerCPUJob, this.maxIO) - this.rendererIOExecutor.getActiveCount());
        }
        if (type == Type.CONVERTER_CPU) {
            return Math.max(1, Math.min(this.maxThreadsPerCPUJob, this.maxCPU) - this.converterCPUExecutor.getActiveCount());
        }
        return Math.max(1, Math.min(this.maxThreadsPerCPUJob, this.maxIO) - this.converterIOExecutor.getActiveCount());
    }

    public Future<?> submit(Runnable task, Type type) {
        if (type == Type.RENDERER_CPU) {
            return this.rendererCPUExecutor.submit(task);
        }
        if (type == Type.RENDERER_IO) {
            return this.rendererIOExecutor.submit(task);
        }
        if (type == Type.CONVERTER_CPU) {
            return this.converterCPUExecutor.submit(task);
        }
        return this.converterIOExecutor.submit(task);
    }

    public <V> Future<V> submit(Runnable task, V result, Type type) {
        if (type == Type.RENDERER_CPU) {
            return this.rendererCPUExecutor.submit(task, result);
        }
        if (type == Type.RENDERER_IO) {
            return this.rendererIOExecutor.submit(task, result);
        }
        if (type == Type.CONVERTER_CPU) {
            return this.converterCPUExecutor.submit(task, result);
        }
        return this.converterIOExecutor.submit(task, result);
    }

    public Future<?> submit(Thread task, Type type) {
        if (type == Type.RENDERER_CPU) {
            return this.rendererCPUExecutor.submit(task);
        }
        if (type == Type.RENDERER_IO) {
            return this.rendererIOExecutor.submit(task);
        }
        if (type == Type.CONVERTER_CPU) {
            return this.converterCPUExecutor.submit(task);
        }
        return this.converterIOExecutor.submit(task);
    }

    public <V> Future<V> submit(Thread task, V result, Type type) {
        if (type == Type.RENDERER_CPU) {
            return this.rendererCPUExecutor.submit(task, result);
        }
        if (type == Type.RENDERER_IO) {
            return this.rendererIOExecutor.submit(task, result);
        }
        if (type == Type.CONVERTER_CPU) {
            return this.converterCPUExecutor.submit(task, result);
        }
        return this.converterIOExecutor.submit(task, result);
    }

    public <T> Future<T> submit(Callable<T> task, Type type) {
        if (type == Type.RENDERER_CPU) {
            return this.rendererCPUExecutor.submit(task);
        }
        if (type == Type.RENDERER_IO) {
            return this.rendererIOExecutor.submit(task);
        }
        if (type == Type.CONVERTER_CPU) {
            return this.converterCPUExecutor.submit(task);
        }
        return this.converterIOExecutor.submit(task);
    }

    public int getPoolSize(Type type) {
        if (type == Type.RENDERER_CPU) {
            return this.rendererCPUExecutor.getPoolSize();
        }
        if (type == Type.RENDERER_IO) {
            return this.rendererIOExecutor.getPoolSize();
        }
        if (type == Type.CONVERTER_CPU) {
            return this.converterCPUExecutor.getPoolSize();
        }
        return this.converterIOExecutor.getPoolSize();
    }

    public int getActiveCount(Type type) {
        if (type == Type.RENDERER_CPU) {
            return this.rendererCPUExecutor.getActiveCount();
        }
        if (type == Type.RENDERER_IO) {
            return this.rendererIOExecutor.getActiveCount();
        }
        if (type == Type.CONVERTER_CPU) {
            return this.converterCPUExecutor.getActiveCount();
        }
        return this.converterIOExecutor.getActiveCount();
    }

    public long getTaskCount(Type type) {
        if (type == Type.RENDERER_CPU) {
            return this.rendererCPUExecutor.getTaskCount();
        }
        if (type == Type.RENDERER_IO) {
            return this.rendererIOExecutor.getTaskCount();
        }
        if (type == Type.CONVERTER_CPU) {
            return this.converterCPUExecutor.getTaskCount();
        }
        return this.converterIOExecutor.getTaskCount();
    }

    public boolean isShutdown() {
        boolean result = true;
        if (this.rendererCPUExecutor != null) {
            result &= this.rendererCPUExecutor.isShutdown();
        }
        if (this.rendererIOExecutor != null) {
            result &= this.rendererIOExecutor.isShutdown();
        }
        if (this.converterCPUExecutor != null) {
            result &= this.converterCPUExecutor.isShutdown();
        }
        if (this.converterIOExecutor != null) {
            result &= this.converterIOExecutor.isShutdown();
        }
        return result;
    }

    public void waitUntilShutdown(long timeout, TimeUnit tu) {
        try {
            this.rendererCPUExecutor.awaitTermination(timeout, tu);
            this.rendererIOExecutor.awaitTermination(timeout, tu);
            this.converterCPUExecutor.awaitTermination(timeout, tu);
            this.converterIOExecutor.awaitTermination(timeout, tu);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isTerminated() {
        boolean result = true;
        if (this.rendererCPUExecutor != null) {
            result &= this.rendererCPUExecutor.isTerminated();
        }
        if (this.rendererIOExecutor != null) {
            result &= this.rendererIOExecutor.isTerminated();
        }
        if (this.converterCPUExecutor != null) {
            result &= this.converterCPUExecutor.isTerminated();
        }
        if (this.converterIOExecutor != null) {
            result &= this.converterIOExecutor.isTerminated();
        }
        return result;
    }

    public void shutdown() {
        if (this.rendererCPUExecutor != null) {
            this.rendererCPUExecutor.shutdown();
        }
        if (this.rendererIOExecutor != null) {
            this.rendererIOExecutor.shutdown();
        }
        if (this.converterCPUExecutor != null) {
            this.converterCPUExecutor.shutdown();
        }
        if (this.converterIOExecutor != null) {
            this.converterIOExecutor.shutdown();
        }
    }

    public boolean shutdownNow() {
        int count;
        boolean result = false;
        if (this.rendererCPUExecutor != null) {
            this.rendererCPUExecutor.shutdownNow();
        }
        if (this.rendererIOExecutor != null) {
            this.rendererIOExecutor.shutdownNow();
        }
        if (this.converterCPUExecutor != null) {
            this.converterCPUExecutor.shutdownNow();
        }
        if (this.converterIOExecutor != null) {
            this.converterIOExecutor.shutdownNow();
        }
        if (this.rendererCPUExecutor != null) {
            do {
                result = true;
                count = this.rendererCPUExecutor.getActiveCount();
                if (count > 0) {
                    result = false;
                }
                try {
                    this.rendererCPUExecutor.awaitTermination(100L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (!result);
        }
        if (this.rendererIOExecutor != null) {
            do {
                result = true;
                count = this.rendererIOExecutor.getActiveCount();
                if (count > 0) {
                    result = false;
                }
                try {
                    this.rendererIOExecutor.awaitTermination(100L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (!result);
        }
        if (this.converterCPUExecutor != null) {
            do {
                result = true;
                count = this.converterCPUExecutor.getActiveCount();
                if (count > 0) {
                    result = false;
                }
                try {
                    this.converterCPUExecutor.awaitTermination(100L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (!result);
        }
        if (this.converterIOExecutor != null) {
            do {
                result = true;
                count = this.converterIOExecutor.getActiveCount();
                if (count > 0) {
                    result = false;
                }
                try {
                    this.converterIOExecutor.awaitTermination(100L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (!result);
        }
        return result;
    }

    public static void cancelFutures(List<Future<?>> futures) {
        for (Future<?> future : futures) {
            if (future == null) continue;
            future.cancel(true);
        }
    }

    public static boolean getBooleanResult(List<?> objs) {
        boolean result = true;
        for (Object obj : objs) {
            if (obj == null || !(obj instanceof Boolean)) continue;
            result &= ((Boolean)obj).booleanValue();
        }
        return result;
    }

    public static boolean getBooleanResult(Object[] objs) {
        boolean result = true;
        for (Object obj : objs) {
            if (obj == null || !(obj instanceof Boolean)) continue;
            result &= ((Boolean)obj).booleanValue();
        }
        return result;
    }

    public static enum Type {
        CONVERTER_CPU,
        CONVERTER_IO,
        RENDERER_CPU,
        RENDERER_IO;

    }
}

