/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.helpers;

public class FloatAdvancer {
    public static float int16ToFloat(int hbits) {
        return Float.intBitsToFloat(FloatAdvancer.int16ToInt32(hbits));
    }

    public static int int16ToInt32(int hbits) {
        int mant = hbits & 0x3FF;
        int exp = hbits & 0x7C00;
        if (exp == 31744) {
            exp = 261120;
        } else if (exp != 0) {
            if (mant == 0 && (exp += 114688) > 115712) {
                return (hbits & 0x8000) << 16 | exp << 13 | 0x3FF;
            }
        } else if (mant != 0) {
            exp = 115712;
            do {
                exp -= 1024;
            } while (((mant <<= 1) & 0x400) == 0);
            mant &= 0x3FF;
        }
        return (hbits & 0x8000) << 16 | (exp | mant) << 13;
    }

    public static float int16ToFloat2(int h) {
        int si = (h & 0x8000) >> 15;
        int s = si == 1 ? -1 : 1;
        int e = (h & 0x7C00) >> 10;
        int f = h & 0x3FF;
        if (e == 0) {
            return (float)((double)s * Math.pow(2.0, -14.0) * (double)((float)f / 1024.0f));
        }
        if (e == 31) {
            if (f == 0) {
                return Float.NaN;
            }
            if (s == -1) {
                return Float.NEGATIVE_INFINITY;
            }
            return Float.POSITIVE_INFINITY;
        }
        return (float)((double)s * Math.pow(2.0, e - 15) * (double)(1.0f + (float)f / 1024.0f));
    }

    public static float int24ToFloat(int h) {
        int si = (h & 0x800000) >> 23;
        int s = si == 1 ? -1 : 1;
        int e = (h & 0x7F0000) >> 16;
        int f = h & 0xFFFF;
        if (e == 0) {
            return (float)((double)s * Math.pow(2.0, -14.0) * (double)((float)f / 65536.0f));
        }
        if (e == 127) {
            if (f == 0) {
                return Float.NaN;
            }
            if (s == -1) {
                return Float.NEGATIVE_INFINITY;
            }
            return Float.POSITIVE_INFINITY;
        }
        return (float)((double)s * Math.pow(2.0, e - 63) * (double)(1.0f + (float)f / 65536.0f));
    }

    public static float int32ToFloat(int h) {
        int si = (h & Integer.MIN_VALUE) >> 31;
        int s = si == 1 ? -1 : 1;
        int e = (h & 0x7F800000) >> 23;
        int f = h & 0x7FFFFF;
        if (e == 0) {
            return (float)((double)s * Math.pow(2.0, -14.0) * (double)((float)f / 8388608.0f));
        }
        if (e == 255) {
            if (f == 0) {
                return Float.NaN;
            }
            if (s == -1) {
                return Float.NEGATIVE_INFINITY;
            }
            return Float.POSITIVE_INFINITY;
        }
        return (float)((double)s * Math.pow(2.0, e - 127) * (double)(1.0f + (float)f / 8388608.0f));
    }

    public static int int24ToInt32(int hbits) {
        return Float.floatToIntBits(FloatAdvancer.int24ToFloat(hbits));
    }
}

