/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.helpers;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FormatBytes {
    private static final DecimalFormat df1 = new DecimalFormat("##0.0");
    private static final DecimalFormat df2 = new DecimalFormat("##0");
    private static final String[] units = new String[]{"Bytes", "KB", "MB", "GB", "TB", "PB", "EB"};
    private static final Pattern pattern = Pattern.compile("([\\d.]+)([GMK]B)", 2);

    private FormatBytes() {
    }

    public static final String byteToString(double value, int limes, int comma) {
        StringBuilder rt_string = new StringBuilder();
        double dh = Math.pow(10.0, comma);
        double li = Math.pow(10.0, limes);
        String unit = units[0];
        int d = 6;
        int ex = 15;
        while (d >= 1) {
            if (value >= li * Math.pow(10.0, ex)) {
                value = (double)Math.round(value / (Math.pow(1024.0, d) / dh)) / dh;
                unit = units[d];
                break;
            }
            --d;
            ex -= 3;
        }
        if (d > 0) {
            rt_string.append(df1.format(value));
        } else {
            rt_string.append(df2.format(value));
        }
        rt_string.append(' ');
        rt_string.append(unit);
        return rt_string.toString();
    }

    public static long parseBytesString(String value) throws IllegalArgumentException {
        Matcher matcher = pattern.matcher(value);
        if (matcher.find()) {
            HashMap<String, Integer> powerMap = new HashMap<String, Integer>();
            powerMap.put("TB", 4);
            powerMap.put("GB", 3);
            powerMap.put("MB", 2);
            powerMap.put("KB", 1);
            String number = matcher.group(1);
            String suffix = matcher.group(2).toUpperCase();
            int pow = (Integer)powerMap.get(suffix);
            BigDecimal bytes = new BigDecimal(number);
            bytes = bytes.multiply(BigDecimal.valueOf(1024L).pow(pow));
            return bytes.longValue();
        }
        throw new IllegalArgumentException(value);
    }
}

