/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.helpers;

import com.neptunelabs.fsiframework.interfaces.ProgressListener;

public class GenericProgressListener
implements ProgressListener {
    private long value = 0L;
    private long minValue = 0L;
    private long maxValue = 0L;

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public int getValuePercental() {
        int result = 0;
        long base = this.value - this.minValue;
        if (base > 0L && this.maxValue > 0L) {
            result = Math.round((float)(this.maxValue - this.minValue) * 100.0f / (float)base);
        }
        return result;
    }

    @Override
    public long getMin() {
        return this.minValue;
    }

    @Override
    public long getMax() {
        return this.maxValue;
    }

    @Override
    public void increase() {
        if (this.value <= this.maxValue) {
            ++this.value;
        }
    }

    @Override
    public void increase(long amount) {
        this.value += amount;
        if (this.value > this.maxValue) {
            this.value = this.maxValue;
        } else if (this.value < this.minValue) {
            this.value = this.minValue;
        }
    }

    @Override
    public void reset() {
        this.value = this.minValue;
    }

    @Override
    public void setMax(long maxValue) {
        this.maxValue = maxValue;
    }

    @Override
    public void setMin(long minValue) {
        this.minValue = minValue;
    }

    @Override
    public void setValue(long value) {
        this.value = value;
    }

    @Override
    public void update(long newValue, long newMinValue, long newMaxValue) {
        this.value = newValue;
        this.minValue = newMinValue;
        this.maxValue = newMaxValue;
        if (this.value > newMaxValue) {
            this.value = newMaxValue;
        } else if (this.value < newMinValue) {
            this.value = newMinValue;
        }
    }
}

