/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.helpers;

import com.neptunelabs.fsiframework.io.ByteArrayOutputStreamFast;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;

public class HexDumpEncoder {
    private int offset;
    private int thisLineLength;
    private int currentByte;
    private final byte[] thisLine = new byte[16];
    private PrintStream pStream;

    static void hexDigit(PrintStream p, byte x) {
        char c = (char)(x >> 4 & 0xF);
        c = c > '\t' ? (char)(c - 10 + 65) : (char)(c + 48);
        p.write(c);
        c = (char)(x & 0xF);
        c = c > '\t' ? (char)(c - 10 + 65) : (char)(c + 48);
        p.write(c);
    }

    private static int bytesPerAtom() {
        return 1;
    }

    private static int bytesPerLine() {
        return 16;
    }

    private void encodeBufferPrefix(OutputStream o) {
        this.offset = 0;
        this.pStream = new PrintStream(o);
    }

    private void encodeLinePrefix(OutputStream o, int len) {
        HexDumpEncoder.hexDigit(this.pStream, (byte)(this.offset >>> 8 & 0xFF));
        HexDumpEncoder.hexDigit(this.pStream, (byte)(this.offset & 0xFF));
        this.pStream.print(": ");
        this.currentByte = 0;
        this.thisLineLength = len;
    }

    private void encodeAtom(OutputStream o, byte[] buf, int off, int len) {
        this.thisLine[this.currentByte] = buf[off];
        HexDumpEncoder.hexDigit(this.pStream, buf[off]);
        this.pStream.print(" ");
        ++this.currentByte;
        if (this.currentByte == 8) {
            this.pStream.print("  ");
        }
    }

    private void encodeLineSuffix(OutputStream o) {
        int i;
        if (this.thisLineLength < 16) {
            for (i = this.thisLineLength; i < 16; ++i) {
                this.pStream.print("   ");
                if (i != 7) continue;
                this.pStream.print("  ");
            }
        }
        this.pStream.print(" ");
        for (i = 0; i < this.thisLineLength; ++i) {
            if (this.thisLine[i] < 32 || this.thisLine[i] > 122) {
                this.pStream.print(".");
                continue;
            }
            this.pStream.write(this.thisLine[i]);
        }
        this.pStream.println();
        this.offset += this.thisLineLength;
    }

    private static int readFully(InputStream in, byte[] buffer) throws IOException {
        for (int i = 0; i < buffer.length; ++i) {
            int q = in.read();
            if (q == -1) {
                return i;
            }
            buffer[i] = (byte)q;
        }
        return buffer.length;
    }

    public void encode(InputStream inStream, OutputStream outStream) throws IOException {
        int numBytes;
        byte[] tmpbuffer = new byte[HexDumpEncoder.bytesPerLine()];
        this.encodeBufferPrefix(outStream);
        while ((numBytes = HexDumpEncoder.readFully(inStream, tmpbuffer)) != 0) {
            this.encodeLinePrefix(outStream, numBytes);
            for (int j = 0; j < numBytes; j += HexDumpEncoder.bytesPerAtom()) {
                if (j + HexDumpEncoder.bytesPerAtom() <= numBytes) {
                    this.encodeAtom(outStream, tmpbuffer, j, HexDumpEncoder.bytesPerAtom());
                    continue;
                }
                this.encodeAtom(outStream, tmpbuffer, j, numBytes - j);
            }
            if (numBytes < HexDumpEncoder.bytesPerLine()) {
                this.encodeLineSuffix(outStream);
                break;
            }
            this.encodeLineSuffix(outStream);
        }
    }

    public void encode(byte[] aBuffer, OutputStream aStream) throws IOException {
        ByteArrayInputStream inStream = new ByteArrayInputStream(aBuffer);
        this.encode(inStream, aStream);
    }

    public String encode(byte[] aBuffer) {
        String retVal = null;
        try (ByteArrayOutputStreamFast outStream = new ByteArrayOutputStreamFast(aBuffer.length);
             ByteArrayInputStream inStream = new ByteArrayInputStream(aBuffer);){
            this.encode(inStream, (OutputStream)outStream);
            inStream.close();
            retVal = outStream.toString("8859_1");
        }
        catch (Exception IOException2) {
            throw new Error("CharacterEncoder.encode internal error");
        }
        return retVal;
    }

    private static byte[] getBytes(ByteBuffer bb) {
        byte[] tmp;
        byte[] buf = null;
        if (bb.hasArray() && (tmp = bb.array()).length == bb.capacity() && tmp.length == bb.remaining()) {
            buf = tmp;
            bb.position(bb.limit());
        }
        if (buf == null) {
            buf = new byte[bb.remaining()];
            bb.get(buf);
        }
        return buf;
    }

    public void encode(ByteBuffer aBuffer, OutputStream aStream) throws IOException {
        byte[] buf = HexDumpEncoder.getBytes(aBuffer);
        this.encode(buf, aStream);
    }

    public String encode(ByteBuffer aBuffer) {
        byte[] buf = HexDumpEncoder.getBytes(aBuffer);
        return this.encode(buf);
    }

    public void encodeBuffer(InputStream inStream, OutputStream outStream) throws IOException {
        int numBytes;
        byte[] tmpbuffer = new byte[HexDumpEncoder.bytesPerLine()];
        this.encodeBufferPrefix(outStream);
        while ((numBytes = HexDumpEncoder.readFully(inStream, tmpbuffer)) != 0) {
            this.encodeLinePrefix(outStream, numBytes);
            for (int j = 0; j < numBytes; j += HexDumpEncoder.bytesPerAtom()) {
                if (j + HexDumpEncoder.bytesPerAtom() <= numBytes) {
                    this.encodeAtom(outStream, tmpbuffer, j, HexDumpEncoder.bytesPerAtom());
                    continue;
                }
                this.encodeAtom(outStream, tmpbuffer, j, numBytes - j);
            }
            this.encodeLineSuffix(outStream);
            if (numBytes >= HexDumpEncoder.bytesPerLine()) continue;
            break;
        }
    }

    public void encodeBuffer(byte[] aBuffer, OutputStream aStream) throws IOException {
        ByteArrayInputStream inStream = new ByteArrayInputStream(aBuffer);
        this.encodeBuffer(inStream, aStream);
    }

    /*
     * Exception decompiling
     */
    public String encodeBuffer(byte[] aBuffer) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void encodeBuffer(ByteBuffer aBuffer, OutputStream aStream) throws IOException {
        byte[] buf = HexDumpEncoder.getBytes(aBuffer);
        this.encodeBuffer(buf, aStream);
    }

    public String encodeBuffer(ByteBuffer aBuffer) {
        byte[] buf = HexDumpEncoder.getBytes(aBuffer);
        return this.encodeBuffer(buf);
    }
}

