/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.helpers;

import com.neptunelabs.fsiframework.collections.Pair;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.BitSet;

public class Inet6AddressUtils {
    public static Inet6Address parseInet6AddressString(String addressStr) {
        Inet6Address result = null;
        try {
            InetAddress address = InetAddress.getByName(addressStr);
            if (address instanceof Inet6Address) {
                result = (Inet6Address)address;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return result;
    }

    public static Pair<Inet6Address, Inet6Address> parseCIDR(String cidrString) {
        Pair<Inet6Address, Integer> components = Inet6AddressUtils.getValidCIDRComponents(cidrString);
        BitSet prefixAddress = Inet6AddressUtils.createPrefixAddress(components.getItem2());
        BitSet address = Inet6AddressUtils.getBitSetfromByteArray(components.getItem1().getAddress());
        BitSet netrangeLow = (BitSet)address.clone();
        netrangeLow.and(prefixAddress);
        BitSet mask = new BitSet(128);
        mask.set(0, 128 - components.getItem2());
        BitSet netrangeHigh = (BitSet)netrangeLow.clone();
        netrangeHigh.or(mask);
        try {
            Inet6Address low = (Inet6Address)InetAddress.getByAddress(Inet6AddressUtils.getByteArrayFromBitSet(netrangeLow));
            Inet6Address high = (Inet6Address)InetAddress.getByAddress(Inet6AddressUtils.getByteArrayFromBitSet(netrangeHigh));
            Pair<Inet6Address, Inet6Address> result = new Pair<Inet6Address, Inet6Address>(low, high);
            return result;
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public static boolean isInRange(Inet6Address address, Pair<Inet6Address, Inet6Address> range) {
        return Inet6AddressUtils.isLargerOrEqual(address, range.getItem1()) && Inet6AddressUtils.isSmallerOrEqual(address, range.getItem2());
    }

    private static boolean isSmallerOrEqual(Inet6Address a1, Inet6Address a2) {
        BitSet b1 = Inet6AddressUtils.getBitSetfromByteArray(a1.getAddress());
        BitSet b2 = Inet6AddressUtils.getBitSetfromByteArray(a2.getAddress());
        return Inet6AddressUtils.isSmallerOrEqual(b1, b2);
    }

    private static boolean isSmallerOrEqual(BitSet b1, BitSet b2) {
        for (int i = b1.size(); i >= 0; --i) {
            if (!b1.get(i) && b2.get(i)) {
                return true;
            }
            if (!b1.get(i) || b2.get(i)) continue;
            return false;
        }
        return true;
    }

    private static boolean isLargerOrEqual(Inet6Address a1, Inet6Address a2) {
        BitSet b1 = Inet6AddressUtils.getBitSetfromByteArray(a1.getAddress());
        BitSet b2 = Inet6AddressUtils.getBitSetfromByteArray(a2.getAddress());
        return Inet6AddressUtils.isLargerOrEqual(b1, b2);
    }

    private static boolean isLargerOrEqual(BitSet b1, BitSet b2) {
        for (int i = b1.size(); i >= 0; --i) {
            if (b1.get(i) && !b2.get(i)) {
                return true;
            }
            if (b1.get(i) || !b2.get(i)) continue;
            return false;
        }
        return true;
    }

    private static BitSet createPrefixAddress(int mask) {
        BitSet result = new BitSet(128);
        result.flip(128 - mask, 128);
        return result;
    }

    private static Pair<Inet6Address, Integer> getValidCIDRComponents(String cidrString) {
        String[] components = cidrString.split("/");
        if (components.length != 2) {
            throw new IllegalArgumentException("Given string not a CIDR notation");
        }
        int mask = 0;
        try {
            mask = Integer.parseInt(components[1]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Given string not a CIDR notation");
        }
        try {
            InetAddress adr = InetAddress.getByName(components[0]);
            if (adr instanceof Inet6Address) {
                return new Pair<Inet6Address, Integer>((Inet6Address)adr, mask);
            }
            throw new IllegalArgumentException("Given string does not contain a valid IPv6 address");
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Unable to parse IPv6 address");
        }
    }

    private static BitSet getBitSetfromByteArray(byte[] bytes) {
        BitSet bits = new BitSet();
        for (int i = 0; i < bytes.length * 8; ++i) {
            if ((bytes[bytes.length - i / 8 - 1] & 1 << i % 8) <= 0) continue;
            bits.set(i);
        }
        return bits;
    }

    private static byte[] getByteArrayFromBitSet(BitSet bits) {
        byte[] bytes = new byte[bits.size() / 8];
        for (int i = 0; i < bits.size(); ++i) {
            if (!bits.get(i)) continue;
            int n = bytes.length - i / 8 - 1;
            bytes[n] = (byte)(bytes[n] | 1 << i % 8);
        }
        return bytes;
    }
}

