/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.helpers;

import java.nio.charset.Charset;

public final class URLDecoderFast {
    public static String decode(String s, Charset charset) {
        char[] e = s.toCharArray();
        int numChars = e.length;
        boolean needToChange = false;
        StringBuilder sb = new StringBuilder(numChars > 500 ? numChars / 2 : numChars);
        int i = 0;
        byte[] bytes = null;
        block6: while (i < numChars) {
            char c = e[i];
            switch (c) {
                case '+': {
                    sb.append(' ');
                    ++i;
                    needToChange = true;
                    continue block6;
                }
                case '%': {
                    if (i + 5 < numChars && e[i + 1] == 'u') {
                        char c1 = (char)(URLDecoderFast.hexNibbleDigit(e[i + 2]) << 12 | URLDecoderFast.hexNibbleDigit(e[i + 3]) << 8 | URLDecoderFast.hexNibbleDigit(e[i + 4]) << 4 | URLDecoderFast.hexNibbleDigit(e[i + 5]));
                        sb.append(c1);
                        i += 6;
                    } else {
                        try {
                            if (bytes == null) {
                                bytes = new byte[(numChars - i) / 3];
                            }
                            int pos = 0;
                            while (i + 2 < numChars && c == '%') {
                                bytes[pos++] = (byte)(URLDecoderFast.hexNibbleDigit(e[i + 1]) << 4 | URLDecoderFast.hexNibbleDigit(e[i + 2]));
                                if ((i += 3) >= numChars) continue;
                                c = e[i];
                            }
                            if (i < numChars && c == '%') {
                                throw new IllegalArgumentException("URLUnescaper: Incomplete trailing escape (%) pattern");
                            }
                            sb.append(new String(bytes, 0, pos, charset));
                        }
                        catch (NumberFormatException nfe) {
                            throw new IllegalArgumentException("URLUnescaper: Illegal hex characters in escape (%) pattern - " + nfe.getMessage());
                        }
                    }
                    needToChange = true;
                    continue block6;
                }
            }
            sb.append(c);
            ++i;
        }
        return needToChange ? sb.toString() : s;
    }

    private static int hexNibbleDigit(char c) {
        int result;
        switch (c) {
            case '0': {
                result = 0;
                break;
            }
            case '1': {
                result = 1;
                break;
            }
            case '2': {
                result = 2;
                break;
            }
            case '3': {
                result = 3;
                break;
            }
            case '4': {
                result = 4;
                break;
            }
            case '5': {
                result = 5;
                break;
            }
            case '6': {
                result = 6;
                break;
            }
            case '7': {
                result = 7;
                break;
            }
            case '8': {
                result = 8;
                break;
            }
            case '9': {
                result = 9;
                break;
            }
            case 'A': 
            case 'a': {
                result = 10;
                break;
            }
            case 'B': 
            case 'b': {
                result = 11;
                break;
            }
            case 'C': 
            case 'c': {
                result = 12;
                break;
            }
            case 'D': 
            case 'd': {
                result = 13;
                break;
            }
            case 'E': 
            case 'e': {
                result = 14;
                break;
            }
            case 'F': 
            case 'f': {
                result = 15;
                break;
            }
            default: {
                throw new IllegalArgumentException("URLUnescaper: Illegal hex characters in escape (%) pattern: " + c);
            }
        }
        return result;
    }
}

