/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.helpers.deletepool;

import com.neptunelabs.fsiframework.helpers.deletepool.PriorityComparator;
import com.neptunelabs.fsiframework.helpers.deletepool.PriorityFile;
import com.neptunelabs.fsiframework.io.IOController;
import com.neptunelabs.fsiframework.logging.FSILogger;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;

public class DeletePool
extends Thread {
    private static final String threadname = "Delete Pool";
    private static final boolean daemon = true;
    final FSILogger logger;
    private final Path basedir;
    private final IOController ioController;
    volatile boolean stop = false;
    private volatile PoolStates status = PoolStates.IDLE;
    private static final int lockCount = 10000;
    private final BlockingQueue<PriorityFile> filePool = new PriorityBlockingQueue<PriorityFile>(10000, new PriorityComparator());

    public DeletePool(FSILogger logger, Path basedir, IOController ioController) {
        this.logger = logger;
        this.basedir = basedir;
        this.ioController = ioController;
        this.init();
    }

    private void init() {
        this.setName(threadname);
        this.setDaemon(true);
    }

    public boolean isEmpty() {
        return this.filePool.size() == 0 && this.status == PoolStates.IDLE;
    }

    @Override
    public void run() {
        while (!this.stop) {
            try {
                Path path;
                this.status = PoolStates.IDLE;
                PriorityFile pfile = this.filePool.take();
                this.status = PoolStates.DELETING;
                if (this.stop) break;
                if (pfile == null || this.stop || !Files.isWritable(path = Paths.get(pfile.getFilepath(), new String[0])) || path.equals(this.basedir) || !path.startsWith(this.basedir)) continue;
                if (Files.isDirectory(path, new LinkOption[0])) {
                    try {
                        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                DeletePool.this.writeLock();
                                try {
                                    Files.delete(file);
                                }
                                finally {
                                    DeletePool.this.unlockWrite();
                                }
                                if (DeletePool.this.stop) {
                                    return FileVisitResult.TERMINATE;
                                }
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                                if (DeletePool.this.logger != null) {
                                    DeletePool.this.logger.log(1019, dir);
                                }
                                if (exc == null) {
                                    DeletePool.this.writeLock();
                                    try {
                                        Files.delete(dir);
                                    }
                                    finally {
                                        DeletePool.this.unlockWrite();
                                    }
                                    if (DeletePool.this.stop) {
                                        return FileVisitResult.TERMINATE;
                                    }
                                    return FileVisitResult.CONTINUE;
                                }
                                throw exc;
                            }
                        });
                    }
                    catch (IOException iOException) {}
                    continue;
                }
                if (!Files.isRegularFile(path, new LinkOption[0])) continue;
                try {
                    Files.delete(path);
                }
                catch (IOException e) {
                    try {
                        Files.deleteIfExists(path);
                    }
                    catch (IOException iOException) {
                    }
                }
            }
            catch (InterruptedException e) {
                this.stop = true;
            }
        }
        this.status = PoolStates.STOPPED;
    }

    public synchronized void addFilepath(int priority, Path filepath, boolean recurse) {
        this.addFilepath(priority, filepath.toAbsolutePath().toString(), recurse);
    }

    public synchronized void addFilepath(int priority, String filepath, boolean recurse) {
        if (!this.stop) {
            try {
                if (this.filePool.size() > 10000) {
                    while (this.filePool.size() > 10) {
                        Thread.yield();
                        if (!this.stop) continue;
                    }
                }
                if (!this.stop) {
                    this.filePool.put(new PriorityFile(priority, filepath, recurse));
                }
            }
            catch (InterruptedException e) {
                this.stop = true;
            }
        }
    }

    public int size() {
        return this.filePool.size();
    }

    public void writeLock() {
        this.ioController.waitForWrite();
    }

    public void readLock() {
        this.ioController.waitForRead();
    }

    public void unlockRead() {
        this.ioController.unlockRead();
    }

    public void unlockWrite() {
        this.ioController.unlockWrite();
    }

    public void halt() {
        this.stop = true;
        this.interrupt();
    }

    private static enum PoolStates {
        IDLE,
        DELETING,
        STOPPED;

    }
}

