/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.helpers.swap;

import com.neptunelabs.fsiframework.helpers.swap.SwapByteFileAbstract;
import com.neptunelabs.fsiframework.helpers.swap.SwapByteSetup;
import java.nio.Buffer;
import java.nio.ByteBuffer;

class SwapByteFileDirect
extends SwapByteFileAbstract {
    protected SwapByteSetup setupByte;

    public SwapByteFileDirect(SwapByteSetup setup) {
        super(setup);
        this.setupByte = setup;
    }

    @Override
    public SwapByteFileDirect makeSlice() {
        SwapByteFileDirect result = new SwapByteFileDirect(this.setupByte);
        result.size = this.size;
        result.file = this.file;
        result.fileChannel = this.fileChannel;
        if (this.mbb != null) {
            this.mbb.position(0);
            result.mbb = this.mbb.slice();
            result.mbb.position(0);
        }
        return result;
    }

    @Override
    public int capacity() {
        return this.mbb.capacity();
    }

    @Override
    public Buffer position(int newPosition) {
        return this.mbb.position(newPosition);
    }

    @Override
    public int get() {
        return this.mbb.get();
    }

    @Override
    public int get(int index) {
        return this.mbb.get(index);
    }

    @Override
    public ByteBuffer get(byte[] dst, int offset, int length) {
        return this.mbb.get(dst, offset, length);
    }

    @Override
    public ByteBuffer put(byte[] src, int offset, int length) {
        return this.mbb.put(src, offset, length);
    }

    @Override
    public ByteBuffer put(ByteBuffer src) {
        return this.mbb.put(src);
    }

    @Override
    public ByteBuffer put(byte i) {
        return this.mbb.put(i);
    }

    @Override
    public ByteBuffer put(int index, byte i) {
        return this.mbb.put(index, i);
    }

    @Override
    public int remaining() {
        return this.mbb.remaining();
    }

    @Override
    public void rewind() {
        this.mbb.rewind();
    }

    @Override
    public Buffer clear() {
        return this.mbb.clear();
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.mbb;
    }

    @Override
    public boolean isBuffered() {
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.file != null) {
            sb.append("File based Swapfile -");
            sb.append(" File: " + this.file);
        } else {
            sb.append("In RAM Swapfile -");
        }
        sb.append(" Order: " + this.byteOrder);
        sb.append(" Size: " + this.size);
        sb.append(" ByteBuffer: " + this.mbb);
        sb.append(" Mapped: " + this.isMapped);
        sb.append(" Direct: " + this.isDirect);
        return sb.toString();
    }
}

