/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.helpers.swap;

import com.neptunelabs.fsiframework.helpers.swap.SwapByteSetup;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Path;

public abstract class SwapFileAbstract {
    protected ByteOrder byteOrder;
    protected int size = 0;
    protected Path file = null;
    protected FileChannel fileChannel = null;
    protected ByteBuffer mbb = null;
    protected boolean isMapped = false;
    protected boolean isDirect = false;
    protected SwapByteSetup setup;
    private boolean disposed = false;

    public SwapFileAbstract(SwapByteSetup setup) {
        this.setup = setup;
        this.byteOrder = setup.byteOrder;
        this.size = setup.size;
        this.file = setup.file;
        this.fileChannel = setup.fileChannel;
        this.mbb = setup.mbb;
        this.isMapped = setup.isMapped;
        this.isDirect = setup.isDirect;
    }

    public abstract SwapFileAbstract makeSlice();

    public abstract int capacity();

    public abstract Buffer position(int var1);

    public abstract int get();

    public abstract int get(int var1);

    public abstract int remaining();

    public abstract void rewind();

    public abstract Buffer clear();

    public abstract ByteBuffer getByteBuffer();

    public abstract boolean isBuffered();

    public boolean isDisposed() {
        return this.disposed;
    }

    public boolean isMapped() {
        return this.isMapped;
    }

    public void dispose() {
        this.disposed = true;
    }

    public abstract String toString();
}

