/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.helpers.swap;

import com.neptunelabs.fsiframework.helpers.swap.SwapIntFileAbstract;
import com.neptunelabs.fsiframework.helpers.swap.SwapIntSetup;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

class SwapIntFileDirect
extends SwapIntFileAbstract {
    protected SwapIntSetup setupInt;

    public SwapIntFileDirect(SwapIntSetup setup) {
        super(setup);
        this.setupInt = setup;
    }

    @Override
    public SwapIntFileDirect makeSlice() {
        SwapIntFileDirect result = new SwapIntFileDirect(this.setupInt);
        result.size = this.size;
        result.file = this.file;
        result.fileChannel = this.fileChannel;
        if (this.ib != null) {
            this.ib.position(0);
            result.ib = this.ib.slice();
            result.ib.position(0);
        }
        return result;
    }

    @Override
    public int capacity() {
        return this.ib.capacity();
    }

    @Override
    public Buffer position(int newPosition) {
        return this.ib.position(newPosition);
    }

    @Override
    public int get() {
        return this.ib.get();
    }

    @Override
    public int get(int index) {
        return this.ib.get(index);
    }

    @Override
    public IntBuffer get(int[] dst, int offset, int length) {
        return this.ib.get(dst, offset, length);
    }

    @Override
    public IntBuffer put(int[] src, int offset, int length) {
        return this.ib.put(src, offset, length);
    }

    @Override
    public IntBuffer put(IntBuffer src) {
        return this.ib.put(src);
    }

    @Override
    public IntBuffer put(int i) {
        return this.ib.put(i);
    }

    @Override
    public IntBuffer put(int index, int i) {
        return this.ib.put(index, i);
    }

    @Override
    public int remaining() {
        return this.ib.remaining();
    }

    @Override
    public void rewind() {
        this.ib.rewind();
    }

    @Override
    public Buffer clear() {
        return this.ib.clear();
    }

    @Override
    public IntBuffer getIntBuffer() {
        return this.ib;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.mbb;
    }

    @Override
    public boolean isBuffered() {
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.file != null) {
            sb.append("File based Swapfile -");
            sb.append(" File: " + this.file);
        } else {
            sb.append("In RAM Swapfile -");
        }
        sb.append(" Order: " + this.byteOrder);
        sb.append(" Size: " + this.size);
        sb.append(" ByteBuffer: " + this.mbb);
        sb.append(" IntBuffer: " + this.ib);
        sb.append(" Mapped: " + this.isMapped);
        sb.append(" Direct: " + this.isDirect);
        return sb.toString();
    }
}

