/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.helpers.swap;

import com.neptunelabs.fsiframework.helpers.FormatBytes;
import com.neptunelabs.fsiframework.helpers.swap.SwapByteFileAbstract;
import com.neptunelabs.fsiframework.helpers.swap.SwapByteFileDirect;
import com.neptunelabs.fsiframework.helpers.swap.SwapByteFileNull;
import com.neptunelabs.fsiframework.helpers.swap.SwapByteSetup;
import com.neptunelabs.fsiframework.helpers.swap.SwapFileAbstract;
import com.neptunelabs.fsiframework.helpers.swap.SwapIntFileAbstract;
import com.neptunelabs.fsiframework.helpers.swap.SwapIntFileDirect;
import com.neptunelabs.fsiframework.helpers.swap.SwapIntFileNull;
import com.neptunelabs.fsiframework.helpers.swap.SwapIntSetup;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.logging.FSILogger;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;

public final class SwapPool {
    private final FSILogger logger;
    private final Path swapdir;
    private final AtomicLong swapCurrentSize = new AtomicLong(0L);
    private final AtomicInteger swapAllocCounts = new AtomicInteger(0);
    private final AtomicLong swapAllocCount = new AtomicLong(0L);
    private final AtomicLong swapDeallocCount = new AtomicLong(0L);
    private final Random rand = new Random();
    private static final int freeingGCSense = 0x2000000;
    private final AtomicInteger freeingGCCount = new AtomicInteger(0);
    private static final int fileRamCache = 262144;

    public SwapPool(FSILogger logger, Path swapdir) {
        this.logger = logger;
        if (!Files.isDirectory(swapdir, new LinkOption[0])) {
            logger.log(1056, swapdir);
        } else if (!Files.isWritable(swapdir)) {
            logger.log(1057, swapdir);
        }
        this.swapdir = swapdir;
    }

    public SwapIntFileAbstract createSwapIntFile(String prefix, long size, boolean allocateBuffer, boolean forceSwapfile, ByteOrder byteOrder) throws IOException {
        SwapIntFileAbstract swapFile;
        boolean disposeFile = false;
        int cacheSize = (int)Math.min(size, 262144L);
        SwapIntSetup swapSetup = new SwapIntSetup();
        String name = prefix + "_" + Long.toHexString(this.rand.nextLong());
        try {
            if (size > 0x7FFFFFFCL || size < 0L) {
                throw new IllegalArgumentException("Swap size invalid value " + size);
            }
            swapSetup.byteOrder = byteOrder;
            swapSetup.cacheNumber = this.swapAllocCounts.get();
            if (forceSwapfile) {
                swapSetup.file = this.createTempFile(name, ".swp");
                if (this.isSpaceAvailable(swapSetup.file, size)) {
                    swapSetup.isMapped = true;
                    swapSetup.fileChannel = (FileChannel)Files.newByteChannel(swapSetup.file, StandardOpenOption.READ, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                    swapSetup.fileChannel.force(false);
                    swapSetup.mbb = swapSetup.fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, size);
                    swapSetup.mbb.order(byteOrder);
                    swapSetup.size = swapSetup.mbb.capacity();
                    swapSetup.ib = swapSetup.mbb.asIntBuffer();
                    swapSetup.cacheSize = cacheSize;
                } else {
                    disposeFile = true;
                }
            } else if (allocateBuffer) {
                if (size > 0L) {
                    swapSetup.mbb = ByteBuffer.allocateDirect((int)size);
                    swapSetup.isDirect = true;
                    swapSetup.mbb.order(byteOrder);
                    swapSetup.size = swapSetup.mbb.capacity();
                    swapSetup.ib = swapSetup.mbb.asIntBuffer();
                } else {
                    disposeFile = true;
                }
            }
        }
        catch (OutOfMemoryError e) {
            try {
                swapSetup.mbb = ByteBuffer.allocate((int)size);
                if (allocateBuffer) {
                    swapSetup.mbb.order(byteOrder);
                    swapSetup.size = swapSetup.mbb.capacity();
                    swapSetup.ib = swapSetup.mbb.asIntBuffer();
                }
            }
            catch (OutOfMemoryError e3) {
                this.logger.log(1017, size, Boolean.toString(forceSwapfile), Boolean.toString(allocateBuffer), FormatBytes.byteToString(this.swapCurrentSize.get(), 2, 2), FormatBytes.byteToString(this.swapAllocCount.get(), 2, 2), FormatBytes.byteToString(this.swapDeallocCount.get(), 2, 2), this.swapAllocCounts.get());
                try {
                    swapSetup.file = this.createTempFile(name, ".swp");
                    if (this.isSpaceAvailable(swapSetup.file, size)) {
                        swapSetup.isMapped = true;
                        swapSetup.fileChannel = (FileChannel)Files.newByteChannel(swapSetup.file, StandardOpenOption.READ, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                        swapSetup.fileChannel.force(false);
                        swapSetup.mbb = swapSetup.fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, size);
                        swapSetup.mbb.order(byteOrder);
                        swapSetup.size = swapSetup.mbb.capacity();
                        swapSetup.ib = swapSetup.mbb.asIntBuffer();
                        swapSetup.cacheSize = cacheSize;
                    } else {
                        this.logger.log(1023, "Not Enough Disk Space Available on " + this.swapdir);
                        disposeFile = true;
                    }
                }
                catch (OutOfMemoryError e2) {
                    this.logger.log(1023, "OutOfMemoryError " + e2.getLocalizedMessage());
                    disposeFile = true;
                }
                catch (IOException e4) {
                    this.logger.log(1023, "IOException1 " + e4.getLocalizedMessage() + " (" + size + ")");
                    disposeFile = true;
                }
            }
        }
        catch (IOException e) {
            this.logger.log(1023, "IOException2 " + e.getLocalizedMessage() + " " + swapSetup.file + "  (" + size + ")");
            disposeFile = true;
        }
        if (!disposeFile) {
            swapFile = new SwapIntFileDirect(swapSetup);
            this.swapAllocCount.addAndGet(size);
            this.swapCurrentSize.addAndGet(size);
            this.swapAllocCounts.incrementAndGet();
        } else {
            swapFile = new SwapIntFileNull(swapSetup);
        }
        if (swapFile.file != null && Files.size(swapFile.file) != size) {
            disposeFile = true;
        }
        if (disposeFile) {
            this.disposeSwapFile(swapFile);
            swapFile = null;
        }
        return swapFile;
    }

    public SwapByteFileAbstract createSwapByteFile(String prefix, long size, boolean allocateBuffer, boolean forceSwapfile, ByteOrder byteOrder) {
        SwapByteFileAbstract swapFile;
        boolean disposeFile = false;
        int cacheSize = (int)Math.min(size, 262144L);
        SwapByteSetup swapSetup = new SwapByteSetup();
        String name = prefix + "_" + Long.toHexString(this.rand.nextLong());
        try {
            if (size > 0x7FFFFFFCL || size < 0L) {
                throw new IllegalArgumentException("Swap size invalid value " + size);
            }
            swapSetup.byteOrder = byteOrder;
            swapSetup.cacheNumber = this.swapAllocCounts.get();
            if (forceSwapfile) {
                swapSetup.file = this.createTempFile(name, ".swp");
                if (this.isSpaceAvailable(swapSetup.file, size)) {
                    swapSetup.isMapped = true;
                    swapSetup.fileChannel = (FileChannel)Files.newByteChannel(swapSetup.file, StandardOpenOption.READ, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                    swapSetup.fileChannel.force(false);
                    swapSetup.mbb = swapSetup.fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, size);
                    swapSetup.mbb.order(byteOrder);
                    swapSetup.size = swapSetup.mbb.capacity();
                    swapSetup.cacheSize = cacheSize;
                } else {
                    disposeFile = true;
                }
            } else if (allocateBuffer) {
                if (size > 0L) {
                    swapSetup.mbb = ByteBuffer.allocateDirect((int)size);
                    swapSetup.isDirect = true;
                    swapSetup.mbb.order(byteOrder);
                    swapSetup.size = swapSetup.mbb.capacity();
                } else {
                    disposeFile = true;
                }
            }
        }
        catch (OutOfMemoryError e) {
            try {
                swapSetup.mbb = ByteBuffer.allocate((int)size);
                if (allocateBuffer) {
                    swapSetup.mbb.order(byteOrder);
                    swapSetup.size = swapSetup.mbb.capacity();
                }
            }
            catch (OutOfMemoryError e3) {
                this.logger.log(1017, size, Boolean.toString(forceSwapfile), Boolean.toString(allocateBuffer), FormatBytes.byteToString(this.swapCurrentSize.get(), 2, 2), FormatBytes.byteToString(this.swapAllocCount.get(), 2, 2), FormatBytes.byteToString(this.swapDeallocCount.get(), 2, 2), this.swapAllocCounts.get());
                try {
                    swapSetup.file = this.createTempFile(name, ".swp");
                    if (this.isSpaceAvailable(swapSetup.file, size)) {
                        swapSetup.isMapped = true;
                        swapSetup.fileChannel = (FileChannel)Files.newByteChannel(swapSetup.file, StandardOpenOption.READ, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                        swapSetup.fileChannel.force(false);
                        swapSetup.mbb = swapSetup.fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, size);
                        swapSetup.mbb.order(byteOrder);
                        swapSetup.size = swapSetup.mbb.capacity();
                        swapSetup.cacheSize = cacheSize;
                    } else {
                        this.logger.log(1023, "Not Enough Disk Space Available on " + this.swapdir);
                        disposeFile = true;
                    }
                }
                catch (OutOfMemoryError e2) {
                    this.logger.log(1023, "OutOfMemoryError " + e2.getLocalizedMessage());
                    disposeFile = true;
                }
                catch (IOException e4) {
                    this.logger.log(1023, "IOException1 " + e4.getLocalizedMessage() + " (" + size + ")");
                    disposeFile = true;
                }
            }
        }
        catch (IOException e) {
            this.logger.log(1023, "IOException2 " + e.getLocalizedMessage() + " " + swapSetup.file + "  (" + size + ")");
            disposeFile = true;
        }
        if (!disposeFile) {
            swapFile = new SwapByteFileDirect(swapSetup);
            this.swapAllocCount.addAndGet(size);
            this.swapCurrentSize.addAndGet(size);
            this.swapAllocCounts.incrementAndGet();
        } else {
            swapFile = new SwapByteFileNull(swapSetup);
        }
        try {
            if (swapFile.file != null && Files.size(swapFile.file) != size) {
                disposeFile = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (disposeFile) {
            this.disposeSwapFile(swapFile);
            swapFile = null;
        }
        return swapFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean disposeSwapFile(SwapFileAbstract swapFile) {
        boolean result = false;
        if (swapFile != null) {
            try {
                if (swapFile.fileChannel != null && swapFile.fileChannel.isOpen()) {
                    swapFile.fileChannel.close();
                    swapFile.fileChannel = null;
                    this.freeingGCCount.addAndGet(swapFile.size);
                }
                this.swapDeallocCount.addAndGet(swapFile.size);
                this.swapCurrentSize.addAndGet(-swapFile.size);
            }
            catch (IOException e) {
                this.logger.log(8011, swapFile.file);
            }
            if (swapFile.mbb != null) {
                try {
                    this.unmap(swapFile.mbb);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    swapFile.mbb = null;
                }
            }
            if (swapFile.file != null) {
                try {
                    Files.delete(swapFile.file);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                result = Files.notExists(swapFile.file, new LinkOption[0]);
                if (result) {
                    swapFile.file = null;
                    swapFile = null;
                }
            } else if (swapFile.file != null) {
                swapFile.file = null;
                swapFile = null;
            } else if (swapFile.file == null) {
                swapFile = null;
                result = true;
            }
        } else {
            result = true;
        }
        if (this.freeingGCCount.get() > 0x2000000) {
            this.freeingGCCount.set(0);
            System.gc();
            System.runFinalization();
        }
        return result;
    }

    public Random getRandom() {
        return this.rand;
    }

    public Path getSwapDir() {
        return this.swapdir;
    }

    private Path createTempFile(String prefix, String suffix) {
        Path tempFile = null;
        if (prefix == null) {
            prefix = Long.toString(System.nanoTime());
        }
        if (suffix == null) {
            suffix = ".swp";
        }
        boolean next = false;
        do {
            try {
                tempFile = Files.createTempFile(this.swapdir, prefix, ".swp", new FileAttribute[0]);
                next = false;
            }
            catch (IOException e) {
                next = true;
                prefix = Long.toString(System.nanoTime());
            }
            Thread.yield();
        } while (next);
        return tempFile;
    }

    private void unmap(final ByteBuffer buffer) throws Exception {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Cleaner cl;
                if (buffer instanceof DirectBuffer && (cl = ((DirectBuffer)((Object)buffer)).cleaner()) != null) {
                    cl.clean();
                }
                return null;
            }
        });
    }

    private boolean isSpaceAvailable(Path file, long allocSize) {
        boolean result = false;
        long freeSpace = FileOperations.getUsableSpace(file);
        if ((float)freeSpace * 0.9f > (float)(allocSize + this.swapCurrentSize.get())) {
            result = true;
        }
        return result;
    }
}

