/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.helpers.swap;

import com.neptunelabs.fsiframework.helpers.swap.SwapByteFileAbstract;
import com.neptunelabs.fsiframework.helpers.swap.SwapPool;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Random;

public final class UnlimitedByteBuffer {
    private final SwapPool swapPool;
    private final ByteOrder byteOrder;
    private final long totalSize;
    private final int bufferCount;
    private final SwapByteFileAbstract[] swapByteFiles;
    private volatile long position;
    private static final int MAX_SWAP_SIZE = Integer.MAX_VALUE;
    private static final int INT_SPLIT_LENGTH = UnlimitedByteBuffer.multiFourLength(Integer.MAX_VALUE);
    private static final long MAX_INT_VALUE = (long)INT_SPLIT_LENGTH / 4L;
    private boolean error = false;

    public UnlimitedByteBuffer(SwapPool swapPool, ByteOrder forceByteOrder, long size) throws IOException {
        this(swapPool, forceByteOrder, size, null, false);
    }

    public UnlimitedByteBuffer(SwapPool swapPool, ByteOrder forceByteOrder, long size, SwapByteFileAbstract[] swapFilestoSlice, boolean makeSlice) throws IOException {
        this.swapPool = swapPool;
        this.totalSize = size;
        this.byteOrder = forceByteOrder;
        this.bufferCount = (int)(size / (long)INT_SPLIT_LENGTH + 1L);
        this.swapByteFiles = new SwapByteFileAbstract[this.bufferCount];
        if (!makeSlice && swapFilestoSlice == null) {
            Random r = new Random();
            String prefix = Integer.toHexString(r.nextInt(99));
            for (int c = 0; c < this.bufferCount; ++c) {
                int swapLen = c + 1 == this.bufferCount ? (int)(this.totalSize - (long)(c * INT_SPLIT_LENGTH)) : INT_SPLIT_LENGTH;
                SwapByteFileAbstract swapFile = swapPool.createSwapByteFile(prefix + "_" + c + "_" + Long.toHexString(size), swapLen, true, true, forceByteOrder);
                if (swapFile == null) {
                    this.error = true;
                    break;
                }
                this.swapByteFiles[c] = swapFile;
            }
        } else {
            for (int c = 0; c < this.bufferCount; ++c) {
                this.swapByteFiles[c] = swapFilestoSlice[c].makeSlice();
            }
        }
        this.position = 0L;
    }

    public boolean hasError() {
        return this.error;
    }

    public void dispose() throws IOException {
        for (SwapByteFileAbstract sf : this.swapByteFiles) {
            if (sf == null) continue;
            this.swapPool.disposeSwapFile(sf);
        }
    }

    public long capacity() {
        return this.totalSize / 4L;
    }

    public long capacity(int swapFilePos) {
        return this.swapByteFiles[swapFilePos].capacity();
    }

    public long position() {
        return this.position;
    }

    public void position(long pos) {
        this.position = pos;
        long spos = UnlimitedByteBuffer.getSwapPosition(pos);
        int swap = (int)(spos >> 32);
        int npos = (int)(spos & 0xFFFFFFFFFFFFFFFFL);
        this.swapByteFiles[swap].position(npos);
    }

    public void position(int[] spos) {
        this.position = spos[0] * Integer.MAX_VALUE + spos[1];
        this.swapByteFiles[spos[0]].position(spos[1]);
    }

    public int get() throws IndexOutOfBoundsException, BufferUnderflowException {
        long spos = UnlimitedByteBuffer.getSwapPosition(this.position++);
        int swap = (int)(spos >> 32);
        int npos = (int)(spos & 0xFFFFFFFFFFFFFFFFL);
        return this.swapByteFiles[swap].get(npos);
    }

    public int get(long index) throws IndexOutOfBoundsException, BufferUnderflowException {
        long spos = UnlimitedByteBuffer.getSwapPosition(index);
        int swap = (int)(spos >> 32);
        int npos = (int)(spos & 0xFFFFFFFFFFFFFFFFL);
        return this.swapByteFiles[swap].get(npos);
    }

    public void get(byte[] i, int offset, int length) throws BufferUnderflowException, IndexOutOfBoundsException {
        int inslen = length;
        long from = UnlimitedByteBuffer.getSwapPosition(this.position);
        int fromswap = (int)(from >> 32);
        int fromnpos = (int)(from & 0xFFFFFFFFFFFFFFFFL);
        long to = UnlimitedByteBuffer.getSwapPosition(this.position + (long)(inslen * 4));
        int toswap = (int)(to >> 32);
        int tonpos = (int)(to & 0xFFFFFFFFFFFFFFFFL);
        int rLength = length;
        long newPos = this.position;
        int s = fromswap;
        int c = 0;
        while (s <= toswap) {
            int nPos;
            int nLength;
            int nOffset;
            if (c == 0) {
                nOffset = offset;
                nLength = Math.min(length, (int)(MAX_INT_VALUE - (long)length));
                rLength -= nLength;
                nPos = fromnpos;
            } else {
                nOffset = 0;
                if ((long)rLength > MAX_INT_VALUE) {
                    nLength = (int)MAX_INT_VALUE;
                    rLength -= nLength;
                } else {
                    nLength = rLength;
                }
                nPos = 0;
            }
            nLength = Math.min(nLength, this.swapByteFiles[s].remaining());
            this.swapByteFiles[s].position(nPos);
            this.swapByteFiles[s].get(i, nOffset, nLength);
            newPos += (long)nLength;
            ++s;
            ++c;
        }
        this.position = newPos;
    }

    public ByteOrder order() {
        return this.swapByteFiles[0].mbb.order();
    }

    public void put(byte i) throws IndexOutOfBoundsException {
        long spos = UnlimitedByteBuffer.getSwapPosition(this.position++);
        int swap = (int)(spos >> 32);
        int npos = (int)(spos & 0xFFFFFFFFFFFFFFFFL);
        this.swapByteFiles[swap].put(npos, i);
    }

    public void put(byte[] i) throws IndexOutOfBoundsException {
        this.put(i, 0, i.length);
    }

    public void put(byte[] i, int offset, int length) throws IndexOutOfBoundsException {
        int inslen = length;
        long from = UnlimitedByteBuffer.getSwapPosition(this.position);
        int fromswap = (int)(from >> 32);
        int fromnpos = (int)(from & 0xFFFFFFFFFFFFFFFFL);
        long to = UnlimitedByteBuffer.getSwapPosition(this.position + (long)(inslen * 4));
        int toswap = (int)(to >> 32);
        int tonpos = (int)(to & 0xFFFFFFFFFFFFFFFFL);
        int rLength = length;
        long newPos = this.position;
        int s = fromswap;
        int c = 0;
        while (s <= toswap) {
            int nPos;
            int nLength;
            int nOffset;
            if (c == 0) {
                nOffset = offset;
                nLength = Math.min(length, (int)(MAX_INT_VALUE - (long)length));
                rLength -= nLength;
                nPos = fromnpos;
            } else {
                nOffset = 0;
                if ((long)rLength > MAX_INT_VALUE) {
                    nLength = (int)MAX_INT_VALUE;
                    rLength -= nLength;
                } else {
                    nLength = rLength;
                }
                nPos = 0;
            }
            this.swapByteFiles[s].position(nPos);
            this.swapByteFiles[s].put(i, nOffset, nLength);
            newPos += (long)nLength;
            ++s;
            ++c;
        }
        this.position = newPos;
    }

    public void put(long index, byte i) throws IndexOutOfBoundsException {
        long spos = UnlimitedByteBuffer.getSwapPosition(index);
        int swap = (int)(spos >> 32);
        int npos = (int)(spos & 0xFFFFFFFFFFFFFFFFL);
        this.swapByteFiles[swap].put(npos, i);
    }

    public void copyByteBuffer(ByteBuffer src) throws BufferOverflowException, BufferUnderflowException, IndexOutOfBoundsException {
        src.position(0);
        long spos = UnlimitedByteBuffer.getSwapPosition(this.position);
        int fromswap = (int)(spos >> 32);
        int fromnpos = (int)(spos & 0xFFFFFFFFFFFFFFFFL);
        long epos = UnlimitedByteBuffer.getSwapPosition(this.position + (long)(src.capacity() * 4));
        int toswap = (int)(spos >> 32);
        int tonpos = (int)(spos & 0xFFFFFFFFFFFFFFFFL);
        if (fromswap == toswap && this.swapByteFiles[fromswap].remaining() >= src.capacity()) {
            this.swapByteFiles[fromswap].position(fromnpos);
            this.swapByteFiles[fromswap].put(src);
            this.position += (long)src.capacity();
        } else {
            int rLength = src.capacity();
            int maxEPos = Math.min(toswap, this.swapByteFiles.length - 1);
            for (int s = fromswap; s <= maxEPos; ++s) {
                int nLength = Math.min(rLength, (int)MAX_INT_VALUE);
                nLength = Math.min(nLength, this.swapByteFiles[s].remaining());
                for (int i = 0; i < nLength; ++i) {
                    this.swapByteFiles[s].put(src.get());
                }
                this.position += (long)nLength;
                rLength -= nLength;
            }
        }
    }

    public UnlimitedByteBuffer slice() throws IOException {
        return new UnlimitedByteBuffer(this.swapPool, this.byteOrder, this.totalSize, this.swapByteFiles, true);
    }

    public int getSwapCount() {
        return this.swapByteFiles.length;
    }

    public ByteBuffer getSwapIntBuffer(int swapNumber) {
        return this.swapByteFiles[swapNumber].getByteBuffer();
    }

    public void clear() {
        for (SwapByteFileAbstract sf : this.swapByteFiles) {
            sf.mbb.clear();
            sf.clear();
        }
    }

    public static long getSwapPosition(long pos) {
        long swap = (int)(pos / MAX_INT_VALUE);
        return swap << 32 | (long)((int)(pos - swap * MAX_INT_VALUE));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SwapFiles: ");
        sb.append(this.swapByteFiles.length);
        sb.append("\n");
        long totalLen = 0L;
        for (SwapByteFileAbstract sf : this.swapByteFiles) {
            sb.append("File: ");
            sb.append(sf.file.toString());
            sb.append(" : IntBuffer Length: ");
            int len = sf.capacity();
            totalLen += (long)len;
            sb.append(len);
            sb.append("\n");
        }
        sb.append("Total Integer Size: ");
        sb.append(totalLen);
        sb.append("\n");
        return sb.toString();
    }

    private static final int multiFourLength(int size) {
        int fourSize = size / 4;
        return fourSize * 4;
    }
}

