/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.helpers.swap;

import com.neptunelabs.fsiframework.helpers.swap.SwapIntFileAbstract;
import com.neptunelabs.fsiframework.helpers.swap.SwapPool;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.Random;

public final class UnlimitedIntBuffer {
    private final SwapPool swapPool;
    private final ByteOrder byteOrder;
    private final long totalSize;
    private final int bufferCount;
    final SwapIntFileAbstract[] swapIntFiles;
    private volatile long position;
    private static final int MAX_SWAP_SIZE = Integer.MAX_VALUE;
    private static final int INT_SPLIT_LENGTH = UnlimitedIntBuffer.multiFourLength(Integer.MAX_VALUE);
    private static final long MAX_INT_VALUE = (long)INT_SPLIT_LENGTH / 4L;
    private boolean error = false;

    public UnlimitedIntBuffer(SwapPool swapPool, ByteOrder forceByteOrder, long size) throws IOException {
        this(swapPool, forceByteOrder, size, null, false);
    }

    public UnlimitedIntBuffer(SwapPool swapPool, ByteOrder forceByteOrder, long size, SwapIntFileAbstract[] swapFilestoSlice, boolean makeSlice) throws IOException {
        this.swapPool = swapPool;
        this.totalSize = size;
        this.byteOrder = forceByteOrder;
        this.bufferCount = (int)(size / (long)INT_SPLIT_LENGTH + 1L);
        this.swapIntFiles = new SwapIntFileAbstract[this.bufferCount];
        if (!makeSlice && swapFilestoSlice == null) {
            Random r = new Random();
            String prefix = Integer.toHexString(r.nextInt(99));
            for (int c = 0; c < this.bufferCount; ++c) {
                int swapLen = c + 1 == this.bufferCount ? (int)(this.totalSize - (long)(c * INT_SPLIT_LENGTH)) : INT_SPLIT_LENGTH;
                SwapIntFileAbstract swapFile = swapPool.createSwapIntFile(prefix + "_" + c + "_" + Long.toHexString(size), swapLen, true, true, forceByteOrder);
                if (swapFile == null) {
                    this.error = true;
                    break;
                }
                this.swapIntFiles[c] = swapFile;
            }
        } else {
            for (int c = 0; c < this.bufferCount; ++c) {
                this.swapIntFiles[c] = swapFilestoSlice[c].makeSlice();
            }
        }
        this.position = 0L;
    }

    public boolean hasError() {
        return this.error;
    }

    public void dispose() throws IOException {
        for (SwapIntFileAbstract sf : this.swapIntFiles) {
            if (sf == null) continue;
            this.swapPool.disposeSwapFile(sf);
        }
    }

    public long capacity() {
        return this.totalSize / 4L;
    }

    public long capacity(int swapFilePos) {
        return this.swapIntFiles[swapFilePos].capacity();
    }

    public long position() {
        return this.position;
    }

    public void position(long pos) {
        this.position = pos;
        long spos = UnlimitedIntBuffer.getSwapPosition(pos);
        int swap = (int)(spos >> 32);
        int npos = (int)(spos & 0xFFFFFFFFFFFFFFFFL);
        this.swapIntFiles[swap].position(npos);
    }

    public void position(int[] spos) {
        this.position = spos[0] * Integer.MAX_VALUE + spos[1];
        this.swapIntFiles[spos[0]].position(spos[1]);
    }

    public int get() throws IndexOutOfBoundsException, BufferUnderflowException {
        long spos = UnlimitedIntBuffer.getSwapPosition(this.position++);
        int swap = (int)(spos >> 32);
        int npos = (int)(spos & 0xFFFFFFFFFFFFFFFFL);
        return this.swapIntFiles[swap].get(npos);
    }

    public int get(long index) throws IndexOutOfBoundsException, BufferUnderflowException {
        long spos = UnlimitedIntBuffer.getSwapPosition(index);
        int swap = (int)(spos >> 32);
        int npos = (int)(spos & 0xFFFFFFFFFFFFFFFFL);
        return this.swapIntFiles[swap].get(npos);
    }

    public void get(int[] i, int offset, int length) throws BufferUnderflowException, IndexOutOfBoundsException {
        int inslen = length;
        long from = UnlimitedIntBuffer.getSwapPosition(this.position);
        int fromswap = (int)(from >> 32);
        int fromnpos = (int)(from & 0xFFFFFFFFFFFFFFFFL);
        long to = UnlimitedIntBuffer.getSwapPosition(this.position + (long)(inslen * 4));
        int toswap = (int)(to >> 32);
        int tonpos = (int)(to & 0xFFFFFFFFFFFFFFFFL);
        int rLength = length;
        long newPos = this.position;
        int s = fromswap;
        int c = 0;
        while (s <= toswap) {
            int nPos;
            int nLength;
            int nOffset;
            if (c == 0) {
                nOffset = offset;
                nLength = Math.min(length, (int)(MAX_INT_VALUE - (long)length));
                rLength -= nLength;
                nPos = fromnpos;
            } else {
                nOffset = 0;
                if ((long)rLength > MAX_INT_VALUE) {
                    nLength = (int)MAX_INT_VALUE;
                    rLength -= nLength;
                } else {
                    nLength = rLength;
                }
                nPos = 0;
            }
            nLength = Math.min(nLength, this.swapIntFiles[s].remaining());
            this.swapIntFiles[s].position(nPos);
            this.swapIntFiles[s].get(i, nOffset, nLength);
            newPos += (long)nLength;
            ++s;
            ++c;
        }
        this.position = newPos;
    }

    public ByteOrder order() {
        return this.swapIntFiles[0].mbb.order();
    }

    public void put(int i) throws IndexOutOfBoundsException {
        long spos = UnlimitedIntBuffer.getSwapPosition(this.position++);
        int swap = (int)(spos >> 32);
        int npos = (int)(spos & 0xFFFFFFFFFFFFFFFFL);
        this.swapIntFiles[swap].put(npos, i);
    }

    public void put(int[] i) throws IndexOutOfBoundsException {
        this.put(i, 0, i.length);
    }

    public void put(int[] i, int offset, int length) throws IndexOutOfBoundsException {
        int inslen = length;
        long from = UnlimitedIntBuffer.getSwapPosition(this.position);
        int fromswap = (int)(from >> 32);
        int fromnpos = (int)(from & 0xFFFFFFFFFFFFFFFFL);
        long to = UnlimitedIntBuffer.getSwapPosition(this.position + (long)(inslen * 4));
        int toswap = (int)(to >> 32);
        int rLength = length;
        long newPos = this.position;
        int s = fromswap;
        int c = 0;
        while (s <= toswap) {
            int nPos;
            int nLength;
            int nOffset;
            if (c == 0) {
                nOffset = offset;
                nLength = Math.min(length, (int)(MAX_INT_VALUE - (long)length));
                rLength -= nLength;
                nPos = fromnpos;
            } else {
                nOffset = 0;
                if ((long)rLength > MAX_INT_VALUE) {
                    nLength = (int)MAX_INT_VALUE;
                    rLength -= nLength;
                } else {
                    nLength = rLength;
                }
                nPos = 0;
            }
            this.swapIntFiles[s].position(nPos);
            this.swapIntFiles[s].put(i, nOffset, nLength);
            newPos += (long)nLength;
            ++s;
            ++c;
        }
        this.position = newPos;
    }

    public void put(long index, int i) throws IndexOutOfBoundsException {
        long spos = UnlimitedIntBuffer.getSwapPosition(index);
        int swap = (int)(spos >> 32);
        int npos = (int)(spos & 0xFFFFFFFFFFFFFFFFL);
        this.swapIntFiles[swap].put(npos, i);
    }

    public void copyIntBuffer(IntBuffer src) throws BufferOverflowException, BufferUnderflowException, IndexOutOfBoundsException {
        src.position(0);
        long from = UnlimitedIntBuffer.getSwapPosition(this.position);
        int fromswap = (int)(from >> 32);
        int fromnpos = (int)(from & 0xFFFFFFFFFFFFFFFFL);
        long to = UnlimitedIntBuffer.getSwapPosition(this.position + (long)(src.capacity() * 4));
        int toswap = (int)(to >> 32);
        if (fromswap == toswap && this.swapIntFiles[fromswap].remaining() >= src.capacity()) {
            this.swapIntFiles[fromswap].position(fromnpos);
            this.swapIntFiles[fromswap].put(src);
            this.position += (long)src.capacity();
        } else {
            int rLength = src.capacity();
            int maxEPos = Math.min(toswap, this.swapIntFiles.length - 1);
            for (int s = fromswap; s <= maxEPos; ++s) {
                int nLength = Math.min(rLength, (int)MAX_INT_VALUE);
                nLength = Math.min(nLength, this.swapIntFiles[s].remaining());
                for (int i = 0; i < nLength; ++i) {
                    this.swapIntFiles[s].put(src.get());
                }
                this.position += (long)nLength;
                rLength -= nLength;
            }
        }
    }

    public UnlimitedIntBuffer slice() throws IOException {
        return new UnlimitedIntBuffer(this.swapPool, this.byteOrder, this.totalSize, this.swapIntFiles, true);
    }

    public int getSwapCount() {
        return this.swapIntFiles.length;
    }

    public IntBuffer getSwapIntBuffer(int swapNumber) {
        return this.swapIntFiles[swapNumber].getIntBuffer();
    }

    public void clear() {
        for (int s = 0; s < this.swapIntFiles.length; ++s) {
            this.swapIntFiles[s].mbb.clear();
            this.swapIntFiles[s].clear();
        }
    }

    public static long getSwapPosition(long pos) {
        long swap = (int)(pos / MAX_INT_VALUE);
        return swap << 32 | (long)((int)(pos - swap * MAX_INT_VALUE));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SwapFiles: ");
        sb.append(this.swapIntFiles.length);
        sb.append("\n");
        long totalLen = 0L;
        for (SwapIntFileAbstract sf : this.swapIntFiles) {
            sb.append("File: ");
            sb.append(sf.file.toString());
            sb.append(" : IntBuffer Length: ");
            int len = sf.capacity();
            totalLen += (long)len;
            sb.append(len);
            sb.append("\n");
        }
        sb.append("Total Integer Size: ");
        sb.append(totalLen);
        sb.append("\n");
        return sb.toString();
    }

    private static final int multiFourLength(int size) {
        int fourSize = size / 4;
        return fourSize * 4;
    }
}

