/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public final class BitInputStream {
    private InputStream in;
    private int buffer;
    private int nextBit = 8;

    public BitInputStream(InputStream in) {
        this.in = in;
    }

    public synchronized int readBit() throws IOException {
        if (this.in == null) {
            throw new IOException("Already closed");
        }
        if (this.nextBit == 8) {
            this.buffer = this.in.read();
            if (this.buffer == -1) {
                throw new EOFException();
            }
            this.nextBit = 0;
        }
        int bit = this.buffer & 1 << this.nextBit;
        ++this.nextBit;
        bit = bit == 0 ? 0 : 1;
        return bit;
    }

    public synchronized int readBits(int length) throws IOException {
        if (this.in == null) {
            throw new IOException("Already closed");
        }
        int result = 0;
        for (int c = 0; c < length; ++c) {
            result |= this.readBit() << length - 1 - c;
        }
        return result;
    }

    public void close() throws IOException {
        this.in.close();
        this.in = null;
    }
}

