/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.io;

import java.io.IOException;
import java.io.OutputStream;

public class BitOutputStream {
    private OutputStream out;
    private int buffer;
    private int bitCount;

    public BitOutputStream(OutputStream out) {
        this.out = out;
    }

    public synchronized void writeBit(int bit) throws IOException {
        if (this.out == null) {
            throw new IOException("Already closed");
        }
        if (bit != 0 && bit != 1) {
            throw new IOException(bit + " is not a bit");
        }
        this.buffer |= bit << this.bitCount;
        ++this.bitCount;
        if (this.bitCount == 8) {
            this.flush();
        }
    }

    private void flush() throws IOException {
        if (this.bitCount > 0) {
            this.out.write((byte)this.buffer);
            this.bitCount = 0;
            this.buffer = 0;
        }
    }

    public void close() throws IOException {
        this.flush();
        this.out.close();
        this.out = null;
    }
}

