/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class ByteArrayOutputStreamFast
extends OutputStream {
    private byte[] buf;
    private int count;

    public ByteArrayOutputStreamFast() {
        this(32);
    }

    public ByteArrayOutputStreamFast(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative initial size: " + size);
        }
        this.buf = new byte[size];
    }

    @Override
    public void close() {
    }

    public void reset() {
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    public byte[] toByteArray() {
        byte[] res = new byte[this.count];
        System.arraycopy(this.buf, 0, res, 0, this.count);
        return res;
    }

    public synchronized String toString(String charsetName) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.count, charsetName);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            int newlen = Math.max(this.buf.length << 1, newcount);
            byte[] res = new byte[newlen];
            System.arraycopy(this.buf, 0, res, 0, this.buf.length);
            this.buf = res;
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count = newcount;
    }

    @Override
    public void write(int b) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            int newlen = Math.max(this.buf.length << 1, newcount);
            byte[] res = new byte[newlen];
            System.arraycopy(this.buf, 0, res, 0, this.buf.length);
            this.buf = res;
        }
        this.buf[this.count] = (byte)b;
        this.count = newcount;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.count);
    }
}

