/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.io;

import com.neptunelabs.fsiframework.io.ByteArrayWalkerBE;
import com.neptunelabs.fsiframework.io.ByteArrayWalkerLE;
import java.nio.ByteOrder;

public abstract class ByteArrayWalker {
    protected int position;
    protected final byte[] data;
    private final int capacity;

    protected ByteArrayWalker(byte[] bytes) {
        this.data = bytes;
        this.position = 0;
        this.capacity = bytes.length;
    }

    public static ByteArrayWalker wrap(byte[] bytes, ByteOrder order) {
        ByteArrayWalker walker = order == ByteOrder.BIG_ENDIAN ? new ByteArrayWalkerBE(bytes) : new ByteArrayWalkerLE(bytes);
        return walker;
    }

    public static ByteArrayWalker allocate(int size, ByteOrder order) {
        byte[] bytes = new byte[size];
        ByteArrayWalker walker = order == ByteOrder.BIG_ENDIAN ? new ByteArrayWalkerBE(bytes) : new ByteArrayWalkerLE(bytes);
        return walker;
    }

    public abstract ByteArrayWalker slice();

    public byte[] array() {
        return this.data;
    }

    public int position() {
        return this.position;
    }

    public void position(int newPosition) {
        this.position = newPosition;
    }

    public final int capacity() {
        return this.capacity;
    }

    public final int remaining() {
        return this.capacity - this.position;
    }

    public final boolean hasRemaining() {
        return this.position < this.capacity;
    }

    public void get(byte[] out) throws IndexOutOfBoundsException {
        System.arraycopy(this.data, this.position, out, 0, out.length);
        this.position += out.length;
    }

    public void get(byte[] dst, int offset, int length) {
        System.arraycopy(this.data, this.position, dst, offset, length);
        this.position += length;
    }

    public byte get() throws IndexOutOfBoundsException {
        return this.data[this.position++];
    }

    public void put(byte b) throws IndexOutOfBoundsException {
        this.data[this.position++] = b;
    }

    public void putByte(int b) throws IndexOutOfBoundsException {
        this.data[this.position++] = (byte)b;
    }

    public void put(byte[] src) throws IndexOutOfBoundsException {
        System.arraycopy(src, 0, this.data, this.position, src.length);
        this.position += src.length;
    }

    public void put(byte[] src, int offset, int length) throws IndexOutOfBoundsException {
        System.arraycopy(src, offset, this.data, this.position, length);
        this.position += length;
    }

    public byte get(int index) throws IndexOutOfBoundsException {
        return this.data[index];
    }

    public void put(int index, byte b) throws IndexOutOfBoundsException {
        this.data[index] = b;
    }

    public abstract char getChar() throws IndexOutOfBoundsException;

    public abstract void putChar(char var1) throws IndexOutOfBoundsException;

    public abstract char getChar(int var1) throws IndexOutOfBoundsException;

    public abstract void putChar(int var1, char var2) throws IndexOutOfBoundsException;

    public abstract short getShort() throws IndexOutOfBoundsException;

    public abstract void putShort(short var1) throws IndexOutOfBoundsException;

    public abstract short getShort(int var1) throws IndexOutOfBoundsException;

    public abstract void putShort(int var1, short var2) throws IndexOutOfBoundsException;

    public abstract int getInt() throws IndexOutOfBoundsException;

    public abstract void putInt(int var1) throws IndexOutOfBoundsException;

    public abstract int getInt(int var1) throws IndexOutOfBoundsException;

    public abstract void putInt(int var1, int var2) throws IndexOutOfBoundsException;

    public abstract long getLong() throws IndexOutOfBoundsException;

    public abstract void putLong(long var1) throws IndexOutOfBoundsException;

    public abstract long getLong(int var1) throws IndexOutOfBoundsException;

    public abstract void putLong(int var1, long var2) throws IndexOutOfBoundsException;

    public float getFloat() throws IndexOutOfBoundsException {
        return Float.intBitsToFloat(this.getInt());
    }

    public void putFloat(float value) {
        this.putInt(Float.floatToRawIntBits(value));
    }

    public float getFloat(int index) throws IndexOutOfBoundsException {
        return Float.intBitsToFloat(this.getInt(index));
    }

    public void putFloat(int index, float value) {
        this.putInt(index, Float.floatToRawIntBits(value));
    }

    public double getDouble() throws IndexOutOfBoundsException {
        return Double.longBitsToDouble(this.getLong());
    }

    public void putDouble(double value) {
        this.putDouble(Double.doubleToRawLongBits(value));
    }

    public double getDouble(int index) throws IndexOutOfBoundsException {
        return Double.longBitsToDouble(this.getLong(index));
    }

    public void putDouble(int index, double value) {
        this.putDouble(index, Double.doubleToRawLongBits(value));
    }
}

