/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public class DirectOutputStream
implements Closeable {
    private final OutputStream os;
    private final FileChannel channel;
    private final ByteBuffer writeBuffer;
    private static final int DEFAULT_BUFFERSIZE = 8192;
    private ByteOrder byteOrder;

    public DirectOutputStream(OutputStream os) {
        this.os = os;
        this.channel = null;
        this.writeBuffer = ByteBuffer.allocateDirect(8192);
        this.writeBuffer.order(ByteOrder.nativeOrder());
        this.byteOrder = this.writeBuffer.order();
    }

    @Override
    public void close() throws IOException {
        if (this.writeBuffer.position() > 0) {
            this.saveWriteBuffer();
        }
        if (this.channel != null) {
            this.channel.close();
        }
        this.os.close();
    }

    public final void write(byte[] bytes) throws IOException {
        int blen = bytes.length;
        for (int p = 0; p < blen; ++p) {
            this.writeByte(bytes[p]);
        }
    }

    public final void writeBoolean(boolean value) throws IOException {
        if (value) {
            this.writeByte((byte)1);
        } else {
            this.writeByte((byte)0);
        }
    }

    public final void writeByte(byte b) throws IOException {
        if (this.writeBuffer.remaining() <= 0) {
            this.saveWriteBuffer();
        }
        this.writeBuffer.put(b);
    }

    public final void writeShort(short value) throws IOException {
        if (this.writeBuffer.remaining() < 2) {
            this.saveWriteBuffer();
        }
        this.writeBuffer.putShort(value);
    }

    public final void writeInt(int value) throws IOException {
        if (this.writeBuffer.remaining() < 4) {
            this.saveWriteBuffer();
        }
        this.writeBuffer.putInt(value);
    }

    public final void writeLong(long value) throws IOException {
        if (this.writeBuffer.remaining() < 8) {
            this.saveWriteBuffer();
        }
        this.writeBuffer.putLong(value);
    }

    public final void writeFloat(float value) throws IOException {
        if (this.writeBuffer.remaining() < 4) {
            this.saveWriteBuffer();
        }
        this.writeBuffer.putFloat(value);
    }

    public final void writeDouble(double value) throws IOException {
        if (this.writeBuffer.remaining() < 8) {
            this.saveWriteBuffer();
        }
        this.writeBuffer.putDouble(value);
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
        this.writeBuffer.order(byteOrder);
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    private final void saveWriteBuffer() throws IOException {
        if (this.channel != null && this.channel.isOpen()) {
            this.writeBuffer.flip();
            this.channel.write(this.writeBuffer);
            this.writeBuffer.clear();
        } else {
            this.writeBuffer.flip();
            byte[] dst = new byte[this.writeBuffer.limit()];
            this.writeBuffer.get(dst, 0, dst.length);
            this.os.write(dst);
            this.writeBuffer.clear();
        }
    }
}

