/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.io;

import com.neptunelabs.fsiframework.helpers.FileEventCallback;
import com.neptunelabs.fsiframework.logging.FSILogger;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FileEventCursor
extends Thread {
    private final FSILogger logger;
    private final WatchService watcher;
    private final Map<WatchKey, RegisteredPath> keys;
    private final Map<Path, RegisteredPath> registeredPaths = new HashMap<Path, RegisteredPath>();
    boolean running;

    public FileEventCursor(FSILogger logger) throws IOException {
        this.setName("FileEventCursor");
        this.logger = logger;
        this.watcher = FileSystems.getDefault().newWatchService();
        this.keys = new HashMap<WatchKey, RegisteredPath>();
    }

    @Override
    public void run() {
        this.running = true;
        WatchKey key = null;
        try {
            while (this.running) {
                boolean valid;
                key = this.watcher.take();
                RegisteredPath rp = this.keys.get(key);
                if (rp == null) continue;
                boolean fired = false;
                for (WatchEvent<?> watchEvent : key.pollEvents()) {
                    WatchEvent.Kind<?> kind = watchEvent.kind();
                    if (StandardWatchEventKinds.OVERFLOW == kind) continue;
                    Path name = (Path)watchEvent.context();
                    Path dir = (Path)key.watchable();
                    Path totalPath = dir.resolve(name);
                    if (Files.isRegularFile(totalPath, new LinkOption[0]) || Files.notExists(totalPath, new LinkOption[0])) {
                        fired = rp.evaluatePath(totalPath);
                    } else if (rp.recursive && kind == StandardWatchEventKinds.ENTRY_CREATE) {
                        try {
                            if (Files.isDirectory(totalPath, LinkOption.NOFOLLOW_LINKS)) {
                                this.registerAll(totalPath, rp);
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (!fired) continue;
                    break;
                }
                if (key == null || (valid = key.reset())) continue;
                this.keys.remove(key);
            }
        }
        catch (InterruptedException | ClosedWatchServiceException e) {
            this.running = false;
        }
    }

    public synchronized RegisteredPath addPathMonitor(Path path, List<FileEventCallback> callbacks) throws IOException {
        if (Files.exists(path, new LinkOption[0]) && !Files.isRegularFile(path, new LinkOption[0])) {
            throw new IOException("Path must be a regular file");
        }
        final Path thePath = path.toAbsolutePath();
        Path theParentPath = thePath.getParent();
        RegisteredPath rp = this.registeredPaths.get(theParentPath);
        if (rp == null) {
            rp = new RegisteredPath();
            rp.path = theParentPath;
        }
        rp.recursive = false;
        rp.suspended = false;
        DirectoryStream.Filter<Path> filefilter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) throws IOException {
                return Files.isSameFile(thePath, entry);
            }
        };
        rp.addFilterCallback(filefilter, callbacks);
        if (this.logger != null) {
            this.logger.log(1051, thePath);
        }
        this.register(theParentPath, rp);
        this.registeredPaths.put(theParentPath, rp);
        return rp;
    }

    public synchronized RegisteredPath addPathMonitor(Path path, DirectoryStream.Filter<Path> filter, boolean recursive, List<FileEventCallback> callbacks) throws IOException {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new IOException("Path must be a directory: " + path);
        }
        Path thePath = path.toAbsolutePath();
        RegisteredPath rp = this.registeredPaths.get(thePath);
        if (rp == null) {
            rp = new RegisteredPath();
            rp.path = thePath;
        }
        rp.recursive = recursive;
        rp.suspended = false;
        rp.addFilterCallback(filter, callbacks);
        if (this.logger != null) {
            this.logger.log(1051, thePath);
        }
        if (recursive) {
            this.registerAll(thePath, rp);
        } else {
            this.register(thePath, rp);
        }
        this.registeredPaths.put(thePath, rp);
        return rp;
    }

    public void halt() {
        this.running = false;
        this.interrupt();
        try {
            this.watcher.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void registerAll(Path start, final RegisteredPath rp) throws IOException {
        Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                FileEventCursor.this.register(dir, rp);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    void register(Path dir, RegisteredPath rp) throws IOException {
        WatchKey key = dir.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        this.keys.put(key, rp);
    }

    final void invokeCallbacks(List<FileEventCallback> callbacks) {
        if (callbacks != null) {
            for (FileEventCallback cb : callbacks) {
                try {
                    Method m;
                    Object[] parameters;
                    Class[] parameterTypes;
                    Class<?> c = cb.getClazz().getClass();
                    if (c == null) continue;
                    if (cb.getParameters() != null) {
                        parameterTypes = new Class[cb.getParameters().length];
                        parameters = new Object[cb.getParameters().length];
                        for (int i = 0; i < cb.getParameters().length; ++i) {
                            parameterTypes[i] = cb.getParameters()[i].getClass();
                            parameters[i] = cb.getParameters()[i];
                        }
                    } else {
                        parameterTypes = null;
                        parameters = new Object[]{};
                    }
                    if ((m = c.getMethod(cb.getMethod(), parameterTypes)) == null) continue;
                    m.invoke(cb.getClazz(), parameters);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    if (this.logger == null) continue;
                    this.logger.logException(e, 9001, "No such method: " + e.getLocalizedMessage());
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                    if (this.logger == null) continue;
                    this.logger.logException(e, 9001, "Invocation Target: " + e.getLocalizedMessage());
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    if (this.logger == null) continue;
                    this.logger.logException(e, 9001, "Illegal Access" + e.getLocalizedMessage());
                }
            }
        } else if (this.logger != null) {
            this.logger.log(9003, "Invoke callback but nothing declared");
        }
    }

    class FilterCallbackPair {
        DirectoryStream.Filter<Path> filter;
        List<FileEventCallback> callbacks;

        FilterCallbackPair() {
        }
    }

    public class RegisteredPath {
        boolean suspended = false;
        Path path;
        boolean recursive;
        List<FilterCallbackPair> filterCallbacks = new ArrayList<FilterCallbackPair>();

        public void setSuspended(boolean state) {
            this.suspended = state;
        }

        public boolean isSuspended() {
            return this.suspended;
        }

        protected void addFilterCallback(DirectoryStream.Filter<Path> filter, List<FileEventCallback> callbacks) {
            FilterCallbackPair fc = new FilterCallbackPair();
            fc.filter = filter;
            fc.callbacks = callbacks;
            this.filterCallbacks.add(fc);
        }

        protected boolean evaluatePath(Path totalPath) {
            boolean fired = false;
            for (FilterCallbackPair fc : this.filterCallbacks) {
                boolean found;
                block6: {
                    if (fc.filter != null) {
                        try {
                            if (fc.filter.accept(totalPath)) {
                                found = true;
                                break block6;
                            }
                            found = false;
                        }
                        catch (IOException e) {
                            found = false;
                        }
                    } else {
                        found = true;
                    }
                }
                if (!FileEventCursor.this.running || !found || fc.callbacks == null || this.suspended) continue;
                this.changedPath(fc.callbacks);
                fired = true;
            }
            return fired;
        }

        protected void changedPath(List<FileEventCallback> callbackToFire) {
            FileEventCursor.this.invokeCallbacks(callbackToFire);
        }
    }
}

